define(
    [
        'module',
        'underscore',
        'views/Base',
        'util/login_page',
        'contrib/text!./FirstTime.html'
    ],
    function(module, _, BaseView, LoginUtils, template) {
        return BaseView.extend({
            moduleId: module.id,
            template: template,
            attributes: {
                style: 'display: none'
            },
            initialize: function () {
                BaseView.prototype.initialize.apply(this, arguments);
                var message = _('If you installed this instance, use the username and password you created at installation.').t() + '\n'
                    + _('Otherwise, use the username and password that your Splunk administrator gave you.').t() + '\n'
                    + _('If you\'ve forgotten your username or password, please contact your Splunk administrator.').t();
                
                this.loginPasswordHint = this.model.web.entry.content.get('loginPasswordHint') || _('The password you created when you installed this instance').t();
                this.firstTimeMessageText = LoginUtils.getFirstTimeLoginMessage(
                    message,
                    this.model.web.entry.content.get('firstTimeLoginMessageOption'),
                    this.model.web.entry.content.get('firstTimeLoginMessage')
                );
            },
            show: function() {
                if (this.easing) {
                    return;
                }
                this.easing = true;
                setTimeout(function() {
                    this.$el.slideDown({
                        duration: '200',
                        easing: 'linear',
                        complete: function() {
                            delete this.easing;
                        }.bind(this)
                    });
                }.bind(this), 1000);
            },
            render: function () {
                this.$el.html(this.compiledTemplate({
                    loginPasswordHint: this.loginPasswordHint,
                    firstTimeMessageText: this.firstTimeMessageText
                }));
                return this;
            }
        });
    }
);
