/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll.slices;

import com.splunk.roll.slices.Slices;
import com.splunk.util.Tuple;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class SlicesDatUtil {
    private static Pattern SPACES_RE = Pattern.compile("\\s+");

    public static Tuple<List<String>, List<List<Long>>> parse(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String ignoreHeader = reader.readLine();
        List<String> fieldPositions = SlicesDatUtil.parseFieldPositions(SlicesDatUtil.readFieldLines(reader));
        List<List<Long>> values = SlicesDatUtil.parseFieldValues(reader);
        return Tuple.create(fieldPositions, values);
    }

    private static String readFieldLines(BufferedReader reader) throws IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        while ((s = reader.readLine()) != null && !s.trim().equals("")) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static List<String> parseFieldPositions(String fieldLines) throws IOException {
        String fieldLine;
        LinkedList<String> fieldNames = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(fieldLines));
        while ((fieldLine = reader.readLine()) != null) {
            String[] split = fieldLine.split(":");
            long fieldIndex = Long.parseLong(split[0]);
            String fieldName = split[1].trim();
            fieldNames.addLast(fieldName);
        }
        return fieldNames;
    }

    private static List<List<Long>> parseFieldValues(BufferedReader reader) throws IOException {
        String s;
        ArrayList<List<Long>> values = new ArrayList<List<Long>>();
        while ((s = reader.readLine()) != null) {
            int indexOfComma = s.indexOf(":");
            String fields = s.substring(indexOfComma + 1);
            String[] digits = SPACES_RE.split(fields.trim());
            ArrayList<Long> ds = new ArrayList<Long>(digits.length);
            for (int i = 0; i < digits.length; ++i) {
                ds.add(Long.parseLong(digits[i].trim()));
            }
            values.add(ds);
        }
        return values;
    }

    public static String toSliceManifestContent(List<String> fields, long[][] values) {
        if (fields.size() != values.length) {
            throw new IllegalArgumentException("there must be as many field names as columns in the value matrix");
        }
        return "header\n" + SlicesDatUtil.fieldRows(fields) + "\n" + SlicesDatUtil.valueTable(values);
    }

    private static String fieldRows(List<String> fields) {
        StringBuilder sb = new StringBuilder();
        int fieldIndex = 0;
        for (String fieldName : fields) {
            sb.append(fieldIndex++ + ": " + fieldName + "\n");
        }
        return sb.toString();
    }

    private static String valueTable(long[][] values) {
        StringBuilder sb = new StringBuilder();
        int matrixDepth = values[0].length;
        for (int i = 0; i < matrixDepth; ++i) {
            sb.append("000" + i + ":");
            for (long[] valuez : values) {
                sb.append(" ");
                sb.append(valuez[i]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static Slices getSlices(InputStream sliceMetadata) throws IOException {
        return new Slices(SlicesDatUtil.parse(sliceMetadata));
    }
}

