/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.nscache;

import com.splunk.nscache.INode;
import com.splunk.nscache.INodeDirectory;
import com.splunk.util.StrUtil;
import java.lang.reflect.Method;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class INodeSymlink
extends INode {
    private static Logger gLogger = Logger.getLogger(INodeSymlink.class);
    byte[] symlink;

    public INodeSymlink(String parentPath, String name, long mtime, long atime, String group, String owner, long length, short permission, String symlink) {
        super(parentPath, name, mtime, atime, group, owner, length, permission);
        this.symlink = symlink.getBytes(StrUtil.UTF8);
    }

    public INodeSymlink(INodeDirectory parent, FileStatus stat) {
        super(parent, stat);
        this.symlink = this.getSymlink(stat).toString().getBytes(StrUtil.UTF8);
    }

    @Override
    public INode.INodeType getType() {
        return INode.INodeType.SYMLINK;
    }

    public String getSymlink() {
        return new String(this.symlink, StrUtil.UTF8);
    }

    @Override
    public FileStatus getFileStatus() {
        FileStatus stat = super.getFileStatus();
        this.setSymlink(stat);
        return stat;
    }

    public static boolean isSymlink(FileStatus stat) {
        try {
            Method m = stat.getClass().getDeclaredMethod("isSymlink", new Class[0]);
            Boolean b = (Boolean)m.invoke((Object)stat, new Object[0]);
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Path getSymlink(FileStatus stat) {
        if (!INodeSymlink.isSymlink(stat)) {
            throw new RuntimeException("FileStatus is not a symlink. stat=[" + stat + "]");
        }
        try {
            Method m = stat.getClass().getDeclaredMethod("getSymlink", new Class[0]);
            return (Path)m.invoke((Object)stat, new Object[0]);
        }
        catch (Exception e) {
            gLogger.warn((Object)("Failed to call getSymlink for stat=[" + stat + "]"), (Throwable)e);
            throw new RuntimeException("Failed to get symlink value for stat=[" + stat + "]", e);
        }
    }

    public void setSymlink(FileStatus stat) {
        if (!INodeSymlink.isSymlink(stat)) {
            throw new RuntimeException("FileStatus is not a symlink. stat=[" + stat + "]");
        }
        try {
            Method m = stat.getClass().getDeclaredMethod("setSymlink", Path.class);
            m.invoke((Object)stat, stat.getPath());
        }
        catch (Exception e) {
            gLogger.warn((Object)("Failed to call setSymlink method for stat=[" + stat + "]"), (Throwable)e);
            throw new RuntimeException("Failed to set symlink value for stat=[" + stat + "]", e);
        }
    }
}

