/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import com.splunk.mr.SplunkMR;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class GetsSplunkManifest {
    private static Logger gLogger = Logger.getLogger(GetsSplunkManifest.class);
    private File splunkHome;

    public GetsSplunkManifest(File splunkHome) {
        this.splunkHome = splunkHome;
    }

    public InputStream getSplunkManifestFileInputStream() {
        try {
            return new FileInputStream(this.getLastModifiedManifestFile());
        }
        catch (FileNotFoundException e) {
            throw new ManifestFileNotExists(e);
        }
    }

    public File getLastModifiedManifestFile() {
        try {
            return this.doGetLastModifiedManifestFile();
        }
        catch (ManifestFileNotExists mf) {
            throw mf;
        }
        catch (Exception e) {
            throw new ManifestFileNotExists(e);
        }
    }

    private File doGetLastModifiedManifestFile() {
        List<File> manifestFiles = this.getSplunkManifestFiles();
        this.throwIfNoManifestFile(manifestFiles);
        File latestModifiedManifestFile = this.getLatestModifiedFile(manifestFiles);
        if (manifestFiles.size() > 1) {
            gLogger.info((Object)("Discovered more than one manifest file. Using the last modified one: " + latestModifiedManifestFile.getAbsolutePath()));
        }
        return latestModifiedManifestFile;
    }

    public List<File> getSplunkManifestFiles() {
        return Arrays.asList(this.splunkHome.listFiles(new SplunkManifestFileFilter()));
    }

    private void throwIfNoManifestFile(List<File> manifestFiles) {
        if (manifestFiles.isEmpty()) {
            throw new ManifestFileNotExists("No manifest file was found in SPLUNK_HOME: " + this.splunkHome.getAbsolutePath() + ". Either get a manifest file or set: vix." + SplunkMR.CONF_SETUP_PACKAGE + " to an absolute path of a hunk.tgz package");
        }
    }

    private File getLatestModifiedFile(List<File> manifestFiles) {
        File latest = manifestFiles.get(0);
        for (File f : manifestFiles) {
            if (latest.lastModified() >= f.lastModified()) continue;
            latest = f;
        }
        return latest;
    }

    public File getSplunkManifestBaseFile() {
        return this.splunkHome.getParentFile();
    }

    public static class ManifestFileNotExists
    extends RuntimeException {
        public ManifestFileNotExists(Exception e) {
            super(e);
        }

        public ManifestFileNotExists(String msg) {
            super(msg);
        }
    }

    private static class SplunkManifestFileFilter
    implements FileFilter {
        private SplunkManifestFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            if (!filename.endsWith("-manifest")) {
                return false;
            }
            return SplunkMR.isSupportedProductName(SplunkMR.getProductName(filename));
        }
    }
}

