/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datamodel;

import com.splunk.datamodel.DataModelBuckets;
import com.splunk.datamodel.DataModelCreator;
import com.splunk.fs.FSUtil;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.sdk.SplunkMiniSDK;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class DataModelBucket {
    private static Logger gLogger = Logger.getLogger(DataModelBucket.class);
    private FileSystem fs;
    private Configuration conf;
    private String indexName;
    private String bucketId;
    private String bucketKey;
    private Map<String, FileStatus> cache = new HashMap<String, FileStatus>();
    private Path stagingDir;
    private Path dataModelDir;
    private SplunkMiniSDK sdk;
    private BucketMetadata _bucketMetadata;
    private DataModelBuckets buckets;

    public DataModelBucket(FileSystem fs, Configuration conf, String indexName, String bucketId, boolean writeToDM, DataModelBuckets dmbuckets) throws FileNotFoundException, IOException {
        this.fs = fs;
        this.conf = conf;
        this.indexName = indexName;
        this.bucketId = bucketId;
        this.bucketKey = indexName + "+" + bucketId;
        this.sdk = SplunkMiniSDK.createForSearch(conf);
        this.stagingDir = DataModelCreator.getDataModelStagingDir(conf, indexName, bucketId);
        this.dataModelDir = DataModelCreator.getDataModelDir(conf, indexName, bucketId);
        if (!fs.exists(this.dataModelDir)) {
            fs.mkdirs(this.dataModelDir);
        }
        this._bucketMetadata = new BucketMetadata();
        this.buckets = dmbuckets;
        this.populateLookupCache(indexName, bucketId);
    }

    private void populateLookupCache(String indexName, String bucketId) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode queryNode = objectMapper.createObjectNode();
        queryNode.put("index", indexName);
        queryNode.put("bucketId", bucketId);
        try {
            SplunkMiniSDK.SplunkResponse sr = this.sdk.get("/servicesNS/nobody/search/storage/collections/data/hunk_dma_" + this.conf.get(SplunkMR.CONF_DATAMODEL_APP_AND_DMNAME), "query", queryNode.toString());
            ArrayNode resultsNode = (ArrayNode)sr.raw();
            for (ObjectNode node : resultsNode) {
                FileStatus fileStatus = this.getFileStatus(node);
                this.cache.put(this.dataModelDir + "/" + node.get("path").getTextValue(), fileStatus);
            }
        }
        catch (SplunkMiniSDK.SplunkResponseException sre) {
            gLogger.error((Object)"Exception caught while populating lookup cache from KV Store collection.", (Throwable)sre);
        }
    }

    public void finalizeDataModelFile() throws FileNotFoundException, IOException {
        long latestTime;
        long earliestTime;
        gLogger.debug((Object)("finalizing data model file for index=" + this.indexName + " bucket_id=" + this.bucketId));
        if (!this.fs.exists(this.stagingDir)) {
            gLogger.warn((Object)("Cannot find staging dir: " + this.stagingDir.toUri().getPath()));
            return;
        }
        FileStatus[] stats = this.fs.listStatus(this.stagingDir);
        if (stats == null || stats.length == 0) {
            gLogger.info((Object)("Staging dir is empty. stagingDir=" + this.stagingDir.toUri().getPath()));
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode fileDetailsNode = objectMapper.createArrayNode();
        Map<String, Object> searchInfo = VirtualIndex.getSearchInfo(this.conf);
        try {
            earliestTime = (long)Double.parseDouble(searchInfo.get("_search_et").toString());
            latestTime = (long)Double.parseDouble(searchInfo.get("_search_lt").toString());
        }
        catch (Exception e) {
            gLogger.warn((Object)("Exception caught while converting " + searchInfo.get("_search_et") + ", " + searchInfo.get("_search_lt") + " to Long values setting to default values OL and " + Long.MAX_VALUE));
            earliestTime = 0L;
            latestTime = Long.MAX_VALUE;
        }
        for (FileStatus stat : stats) {
            ObjectNode dataNode = objectMapper.createObjectNode();
            String path = this.trimBucketBasePath(new Path(this.dataModelDir, stat.getPath().getName()));
            dataNode.put("_key", this.indexName + "_" + this.bucketId + "_" + path);
            dataNode.put("index", this.indexName);
            dataNode.put("bucketId", this.bucketId);
            dataNode.put("path", path);
            dataNode.put("length", stat.getLen());
            dataNode.put("replication", (int)stat.getReplication());
            dataNode.put("blockSize", stat.getBlockSize());
            dataNode.put("mtime", stat.getModificationTime());
            dataNode.put("atime", stat.getAccessTime());
            dataNode.put("permission", String.valueOf(stat.getPermission().toShort()));
            dataNode.put("owner", stat.getOwner());
            dataNode.put("group", stat.getGroup());
            dataNode.put("summaryId", SplunkMR.getSummaryId(this.conf, "summary_id"));
            dataNode.put("earliestTime", earliestTime);
            dataNode.put("latestTime", latestTime);
            fileDetailsNode.add((JsonNode)dataNode);
        }
        this.finalize(stats);
        if (this._bucketMetadata.initialized) {
            this.buckets.updateSummaryStats(this.bucketKey, this._bucketMetadata.getBucketMetadataMap());
        }
        try {
            this.sdk.postJSON("/servicesNS/nobody/search/storage/collections/data/hunk_dma_" + this.conf.get(SplunkMR.CONF_DATAMODEL_APP_AND_DMNAME) + "/batch_save", fileDetailsNode.toString());
        }
        catch (Exception exc) {
            gLogger.error((Object)"Exception caught while trying to update dma collection!!", (Throwable)exc);
            return;
        }
    }

    private void finalize(FileStatus[] stagingFstats) throws IOException {
        for (FileStatus fstat : stagingFstats) {
            Path dest;
            block10: {
                Path file;
                block7: {
                    block8: {
                        block9: {
                            file = fstat.getPath();
                            dest = new Path(this.dataModelDir, file.getName());
                            if (!this.fs.exists(file)) break block7;
                            if (gLogger.isDebugEnabled()) {
                                gLogger.debug((Object)("Staging Acceleration File Information::" + this.fs.listStatus(file)[0].toString()));
                            }
                            if (this.fs.exists(dest)) {
                                FSUtil.MatchResult mr = FSUtil.checkSumsMatch(this.fs, file, dest);
                                if (mr == FSUtil.MatchResult.FALSE) {
                                    gLogger.warn((Object)("Existing acceleration file differs from staging, existing file will be replaced. final=" + dest.toUri().getPath()));
                                } else if (mr == FSUtil.MatchResult.NO_CHECKSUM) {
                                    gLogger.warn((Object)("Unable to determine if acceleration file differs from staging as checksum is not implemented for this FileSystem, existing file will be replaced. final=" + dest.toUri().getPath()));
                                }
                                this.fs.delete(dest);
                            }
                            if (this.fs.exists(dest)) break block8;
                            if (!this.fs.rename(file, dest)) break block9;
                            if (gLogger.isDebugEnabled()) {
                                gLogger.debug((Object)("Finalized a staging file. staging=" + file.toUri().getPath() + ", final=" + dest.toUri().getPath()));
                            }
                            this._bucketMetadata.update(this.fs.getFileStatus(dest));
                            break block10;
                        }
                        throw new IOException("Failed to move staging file to summary index dir. src=" + file.toUri().getPath() + ", dest=" + dest.toUri().getPath());
                    }
                    if (!gLogger.isDebugEnabled()) break block10;
                    gLogger.debug((Object)("Acceleration file File exists, not updating. final=" + dest.toUri().getPath()));
                    break block10;
                }
                gLogger.warn((Object)("Cannot find a staging file: " + file.toUri().getPath()));
                continue;
            }
            FileStatus status = this.fs.listStatus(dest)[0];
            gLogger.info((Object)("File Details::" + status.getModificationTime() + ", " + status.getBlockSize() + ", " + status.getPath() + ", " + status.getLen()));
        }
        this._bucketMetadata.setComplete();
    }

    public void updateOrigDataSizeMap(FileStatus origFile, long et, long lt) {
        try {
            gLogger.debug((Object)("updating size map for: file=" + origFile.getPath() + " et=" + et + " lt=" + lt + " indexName=" + this.indexName + " bucketKey=" + this.bucketKey));
            Path dataModelPath = DataModelCreator.getDataModelFile(this.conf, this.indexName, this.bucketId, et, lt, origFile.getPath());
            this._bucketMetadata.updateSizeMap(dataModelPath.toString(), origFile.getLen());
        }
        catch (Exception e) {
            gLogger.error((Object)("Failed to update size map: " + e.getMessage()));
        }
    }

    public FileStatus retrieveFromCache(Path originalFile, long earliestTime, long latestTime) {
        Path dataModelFilePath = DataModelCreator.getDataModelFile(this.conf, this.indexName, this.bucketId, earliestTime, latestTime, originalFile);
        return this.cache.get(dataModelFilePath.toString());
    }

    private String trimBucketBasePath(Path file) {
        String p = file.toUri().getPath().substring(this.dataModelDir.toUri().getPath().length());
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        return p;
    }

    private FileStatus getFileStatus(ObjectNode node) {
        Path path = new Path(DataModelCreator.getDataModelDir(this.conf, this.indexName, this.bucketId), node.get("path").getTextValue());
        long length = node.get("length").getLongValue();
        int replication = node.get("replication").getIntValue();
        long blockSize = node.get("blockSize").getLongValue();
        long mtime = node.get("mtime").getLongValue();
        long atime = node.get("atime").getLongValue();
        FsPermission permission = FsPermission.createImmutable((short)Short.parseShort(node.get("permission").getTextValue()));
        String owner = node.get("owner").getTextValue();
        String group = node.get("group").getTextValue();
        return new FileStatus(length, false, replication, blockSize, mtime, atime, permission, owner, group, path);
    }

    public void setBucketMetadata(Map<String, String> bucketInfo) {
        if (bucketInfo == null || !this._bucketMetadata.isInitialized()) {
            gLogger.debug((Object)("No data exists or metadata has already been loaded: bucketKey=" + this.bucketKey));
            return;
        }
        this._bucketMetadata.setBucketMetadata(bucketInfo);
    }

    public class BucketMetadata {
        private Map<String, Long> origDataSizes = new HashMap<String, Long>();
        private boolean initialized;
        private long bucket_size = 0L;
        private String bucket_path = "N/A";
        private boolean summary_complete = false;
        private long summary_size = 0L;
        private String summary_path;
        private long bucket_et;
        private long bucket_lt;

        public BucketMetadata() {
            this.summary_path = DataModelBucket.this.dataModelDir.toString();
            this.bucket_et = -1L;
            this.bucket_lt = -1L;
            this.initialized = false;
        }

        public void update(FileStatus fstat) throws IOException {
            String[] parts;
            String path = fstat.getPath().toUri().getPath();
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Updating Bucket Metadata: filepath=" + path));
            }
            if ((parts = FilenameUtils.getName((String)path).split("_", 4)).length != 4) {
                throw new RuntimeException("Failed to parse data model summary file name. Expected at least 4 parts delimited by underscore, got " + parts.length + "parts. file=" + path);
            }
            long earliestTime = Long.parseLong(parts[1]);
            long latestTime = Long.parseLong(parts[2]);
            if (!this.initialized) {
                gLogger.info((Object)"Attempting to load bucket metadata from cache");
                DataModelBucket.this.buckets.loadBucketMetadata(DataModelBucket.this.bucketKey);
                this.bucket_et = earliestTime;
                this.bucket_lt = latestTime;
                this.initialized = true;
            } else {
                if (this.bucket_et > earliestTime) {
                    this.bucket_et = earliestTime;
                }
                if (this.bucket_lt < latestTime) {
                    this.bucket_lt = latestTime;
                }
            }
            Long size = this.origDataSizes.get(path);
            if (size == null) {
                gLogger.error((Object)("Unable to get the size of the original file for DMA file " + path));
            } else {
                this.bucket_size += size.longValue();
            }
            this.summary_size += fstat.getLen();
        }

        public void setComplete() {
            this.summary_complete = true;
        }

        public void updateSizeMap(String dmaFilePath, long origSize) {
            this.origDataSizes.put(dmaFilePath, origSize);
            gLogger.debug((Object)("updated orig size mapping path=" + dmaFilePath + " size=" + origSize));
        }

        public void setBucketMetadata(Map<String, String> bucketInfo) {
            this.bucket_path = bucketInfo.get("bucket_path");
            this.bucket_et = Long.parseLong(bucketInfo.get("bucket_et"));
            this.bucket_lt = Long.parseLong(bucketInfo.get("bucket_lt"));
            this.bucket_size = Long.parseLong(bucketInfo.get("bucket_size"));
            this.summary_complete = Boolean.parseBoolean(bucketInfo.get("summary_complete"));
            this.summary_size = Long.parseLong(bucketInfo.get("summary_size"));
            this.summary_path = bucketInfo.get("summary_path");
            gLogger.debug((Object)("Set BucketMetadata for bucket_path=" + this.bucket_path + " bucket_et=" + this.bucket_et + "bucket_lt=" + this.bucket_lt + "bucket_size=" + this.bucket_size + " summary_complete=" + this.summary_complete + " summary_size=" + this.summary_size + " summary_path=" + this.summary_path));
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public Map<String, String> getBucketMetadataMap() {
            HashMap<String, String> bmap = new HashMap<String, String>();
            bmap.put("bucket_path", this.bucket_path);
            bmap.put("bucket_et", Long.toString(this.bucket_et));
            bmap.put("bucket_lt", Long.toString(this.bucket_lt));
            bmap.put("bucket_size", Long.toString(this.bucket_size));
            bmap.put("summary_complete", Boolean.toString(this.summary_complete));
            bmap.put("summary_size", Long.toString(this.summary_size));
            bmap.put("summary_path", this.summary_path);
            return bmap;
        }
    }
}

