/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.ast.nodes.commands.JobPartitionerCommand;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.RdInCommand;
import com.splunk.commons.ast.nodes.commands.RdOutCommand;
import com.splunk.commons.ast.nodes.commands.UnionCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.search.HostPort;
import com.splunk.commons.util.RDPartition;
import com.splunk.commons.visitors.CommandRebuilder;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.df.search.DFSExecutionState;
import com.splunk.df.search.DFSPhaseFacilitator;
import com.splunk.df.search.DFSSidGenerator;
import com.splunk.df.search.FSHJobsMapInfo;
import com.splunk.df.util.DFSVisitorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PartitionExtractionVisitor
extends CommandRebuilder {
    static final Logger logger = Logger.getLogger(PartitionExtractionVisitor.class);
    private CommandNode splunkSHJob;
    private CommandNode dfsJob;
    private ArrayList<CommandNode> rdinJobs;
    private ArrayList<CommandNode> internalJobs;
    private DFSSidGenerator dfsSidGenerator;
    private boolean inFSHState;
    private boolean inLocalState;
    private HashMap<String, DFSPhaseFacilitator> inFlightScaledPhaseGenerationMap = null;
    private DFSExecutionState currentExecutionState;
    private FSHJobsMapInfo fshJobsMapInfo;
    private final boolean fshSidGeneration;

    public PartitionExtractionVisitor(DFSSidGenerator dfsSidGenerator, HashMap<String, DFSPhaseFacilitator> inFlightScaledPhaseGenerationMap, FSHJobsMapInfo fshJobsMapInfo, boolean fshSidGeneration) {
        this.dfsSidGenerator = dfsSidGenerator;
        this.rdinJobs = new ArrayList();
        this.internalJobs = new ArrayList();
        this.inFSHState = false;
        this.inLocalState = false;
        this.currentExecutionState = DFSExecutionState.UNKNOWN;
        this.inFlightScaledPhaseGenerationMap = inFlightScaledPhaseGenerationMap;
        this.fshJobsMapInfo = fshJobsMapInfo;
        this.fshSidGeneration = fshSidGeneration;
    }

    public ArrayList<CommandNode> getSplunkRemoteJobs() {
        return this.internalJobs;
    }

    public FSHJobsMapInfo getFshJobsMapInfo() {
        return this.fshJobsMapInfo;
    }

    public ArrayList<CommandNode> getRdinJobs() {
        return this.rdinJobs;
    }

    public CommandNode getDFSJob() {
        return this.dfsJob;
    }

    public CommandNode getSplunkSHJob() {
        return this.splunkSHJob;
    }

    public boolean isLocalExecution() {
        return this.inLocalState;
    }

    public boolean isFSHExecution() {
        return this.inFSHState;
    }

    public DFSExecutionState getCurrentDFSExecutionState() {
        if (this.inLocalState && this.inFSHState) {
            this.currentExecutionState = DFSExecutionState.MIXED_MODE;
        }
        if (!this.inLocalState && this.inFSHState) {
            this.currentExecutionState = DFSExecutionState.FEDERATED_ONLY;
        }
        if (this.inLocalState && !this.inFSHState) {
            this.currentExecutionState = DFSExecutionState.LOCAL_ONLY;
        }
        return this.currentExecutionState;
    }

    public CommandNode visit(CommandNode node) {
        SplFormatter splFormatter = new SplFormatter();
        logger.debug((Object)("Input string to JobPartitionVisitor :" + (String)node.accept((NodeVisitor)splFormatter)));
        CommandNode[] currentNode = node.getSources();
        if (node.getSources().length != 0) {
            for (int i = 0; i < currentNode.length; ++i) {
                this.visit(currentNode[i]);
            }
        }
        CommandNode processedNode = this.processNode(node);
        return processedNode;
    }

    private CommandNode processNode(CommandNode node) {
        if (node.getCommandName().equalsIgnoreCase("jobpartition")) {
            DFSVisitorUtil.JobStatus jobState = DFSVisitorUtil.JobStatus.valueOf(((JobPartitionerCommand)node).getJobPartitionName());
            if (jobState.equals((Object)DFSVisitorUtil.JobStatus.GENERATING_STATE)) {
                HostPort hp = new HostPort("127.0.0.1", 8080);
                HostPort[] hostPorts = new HostPort[]{hp};
                FieldNode[] byFields = ((JobPartitionerCommand)node).getByFields();
                if (byFields == null) {
                    RdOutCommand rdout = new RdOutCommand(node.getSource(), hostPorts, RDPartition.VirtualPartitioning);
                    this.internalJobs.add((CommandNode)rdout);
                } else {
                    System.out.println("do have byfields.");
                    RdOutCommand rdout = new RdOutCommand(node.getSource(), hostPorts, byFields, RDPartition.Hash);
                    this.internalJobs.add((CommandNode)rdout);
                }
                this.inLocalState = true;
            } else if (jobState.equals((Object)DFSVisitorUtil.JobStatus.FSH_STATE)) {
                logger.debug((Object)("Caught the FSH State also node ->" + node.getSource().getCommandName()));
                this.inFSHState = true;
            } else if (jobState.equals((Object)DFSVisitorUtil.JobStatus.DFS_STATE)) {
                this.dfsJob = this.extractJob(node, node.getSource(), DFSVisitorUtil.JobStatus.DFS_STATE).getSource();
                if (this.rdinJobs.isEmpty() && !this.inFSHState) {
                    this.rdinJobs.add(this.dfsJob);
                }
            } else if (jobState.equals((Object)DFSVisitorUtil.JobStatus.SPLUNK_SH_STATE)) {
                this.splunkSHJob = this.extractJob(node, node.getSource(), DFSVisitorUtil.JobStatus.SPLUNK_SH_STATE).getSource();
            }
        }
        logger.debug((Object)"Returning from processNode");
        return node;
    }

    private CommandNode extractJob(CommandNode parent, CommandNode child, DFSVisitorUtil.JobStatus hint) {
        logger.debug((Object)"=======================================================================================");
        logger.debug((Object)("####### Inside extractJob parent -->" + parent.getCommandName() + " child ====>" + child.getCommandName() + " hint ==>" + hint.toString()));
        if (parent.getCommandName().equalsIgnoreCase("jobpartition")) {
            logger.debug((Object)("parent is jobpartition with state" + ((JobPartitionerCommand)parent).getJobPartitionName()));
            logger.debug((Object)("The child's parent command===>" + child.getSources()[0].getCommandName() + " number of source" + child.getSources().length));
        }
        if (child.getCommandName().equalsIgnoreCase("jobpartition")) {
            logger.debug((Object)("child is jobpartition with state" + ((JobPartitionerCommand)child).getJobPartitionName()));
        }
        logger.debug((Object)"=======================================================================================");
        if (child.getCommandName().equalsIgnoreCase("jobpartition")) {
            logger.debug((Object)("Found jobpartition command with type" + ((JobPartitionerCommand)child).getJobPartitionName()));
            String sid = "";
            switch (hint) {
                case SPLUNK_SH_STATE: {
                    sid = this.dfsSidGenerator.getBaseSid();
                    break;
                }
                case DFS_STATE: {
                    sid = this.dfsSidGenerator.getNextSid(this.fshSidGeneration);
                    logger.debug((Object)("PartitionExecutor --> IN DFS_STATE Value of SID -->" + sid));
                    break;
                }
                case GENERATING_STATE: 
                case FSH_STATE: 
                case UNDEFINED_STATE: {
                    sid = "shouldneverhappen:)";
                    assert (false);
                    break;
                }
            }
            assert (!sid.equalsIgnoreCase(""));
            RdInCommand rd = new RdInCommand(sid, true);
            if (hint == DFSVisitorUtil.JobStatus.DFS_STATE && this.inFSHState) {
                FromCommand tempFrom = (FromCommand)child.getSource();
                String dataSet = tempFrom.getDataset().getName();
                Object sidList = null;
                logger.info((Object)String.format("Dataset Name=%s", dataSet));
                if (this.inFlightScaledPhaseGenerationMap == null) {
                    logger.error((Object)"The inFlightScaledPhaseGenerationMap is null.");
                }
                if (this.inFlightScaledPhaseGenerationMap != null) {
                    for (Map.Entry<String, DFSPhaseFacilitator> myentry : this.inFlightScaledPhaseGenerationMap.entrySet()) {
                        logger.info((Object)("in the map --> dataset -->" + myentry.getKey()));
                    }
                }
                if (this.inFlightScaledPhaseGenerationMap != null && this.inFlightScaledPhaseGenerationMap.containsKey(dataSet)) {
                    if (!this.inFlightScaledPhaseGenerationMap.containsKey(dataSet)) {
                        throw new IllegalArgumentException(String.format("Dataset %s does not exist", dataSet));
                    }
                    DFSPhaseFacilitator targetFacilitator = this.inFlightScaledPhaseGenerationMap.get(dataSet);
                    ArrayList<CommandNode> fshSearches = new ArrayList<CommandNode>();
                    for (int i = 0; i < targetFacilitator.getRemoteSearchCommandNode().size(); ++i) {
                        fshSearches.add(targetFacilitator.getRemoteSearchCommandNode().get(i));
                    }
                    ArrayList<String> scaledFshSidToSendList = targetFacilitator.getFSHScaledToSendRemoteSidList();
                    ArrayList<String> remoteSearchInfoSidList = targetFacilitator.getFSHRemoteSidList();
                    ArrayList<String> scaledFshSidist = targetFacilitator.getFSHScaledSidList();
                    String triggerBaseSid = targetFacilitator.getFSHBaseTriggerSid();
                    this.dfsSidGenerator.syncFSHSidList(sid, scaledFshSidToSendList, scaledFshSidist);
                    this.fshJobsMapInfo.addToFSHJobsMap(dataSet, triggerBaseSid, scaledFshSidToSendList, remoteSearchInfoSidList, fshSearches);
                    CommandNode toAdd = targetFacilitator.getDFSPhase();
                    CommandNode updatedNode = parent.setSource(toAdd);
                    return updatedNode;
                }
                sid = this.dfsSidGenerator.addUpdateFSHSid(sid);
                rd = new RdInCommand(sid, true);
                this.fshJobsMapInfo.addToFSHJobsMap(dataSet, sid, child.getSource());
            }
            return parent.setSource(DFSVisitorUtil.rebuild((CommandNode)rd));
        }
        CommandNode passThroughNode = child;
        CommandNode[] currentNode = child.getSources();
        int numSources = child.getSources().length;
        if (numSources >= 2) {
            CommandNode updatedChild = this.dispatchMultiSourcedCommand(child);
            return parent.setSource(DFSVisitorUtil.rebuild(updatedChild));
        }
        passThroughNode = this.extractJob(child, currentNode[0], hint);
        return parent.setSource(DFSVisitorUtil.rebuild(passThroughNode));
    }

    private CommandNode dispatchMultiSourcedCommand(CommandNode child) {
        CommandNode updatedNode = null;
        switch (child.getCommandName()) {
            case "join": {
                updatedNode = this.extractJoin((JoinCommand)child);
                break;
            }
            case "union": {
                updatedNode = this.extractUnion((UnionCommand)child);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported command" + child.getCommandName());
            }
        }
        return updatedNode;
    }

    private CommandNode extractJoin(JoinCommand child) {
        CommandNode lhs = child.getSources()[0];
        CommandNode rhs = child.getSources()[1];
        JobPartitionerCommand jpc_lhs = new JobPartitionerCommand(lhs, "DFS_STATE");
        JobPartitionerCommand jpc_rhs = new JobPartitionerCommand(rhs, "DFS_STATE");
        if (this.inFlightScaledPhaseGenerationMap == null) {
            // empty if block
        }
        FSHJobsMapInfo lhsFhsJobsMapInfo = new FSHJobsMapInfo();
        PartitionExtractionVisitor leftVisitor = new PartitionExtractionVisitor(this.dfsSidGenerator, this.inFlightScaledPhaseGenerationMap, lhsFhsJobsMapInfo, this.fshSidGeneration);
        jpc_lhs.accept((NodeVisitor)leftVisitor);
        FSHJobsMapInfo rhsFhsJobsMapInfo = new FSHJobsMapInfo();
        PartitionExtractionVisitor rightVisitor = new PartitionExtractionVisitor(this.dfsSidGenerator, this.inFlightScaledPhaseGenerationMap, rhsFhsJobsMapInfo, this.fshSidGeneration);
        jpc_rhs.accept((NodeVisitor)rightVisitor);
        if (leftVisitor.isFSHExecution()) {
            this.inFSHState = true;
            this.fshJobsMapInfo.mergeToMap(lhsFhsJobsMapInfo);
        }
        if (leftVisitor.isLocalExecution()) {
            this.inLocalState = true;
            this.rdinJobs.addAll(leftVisitor.getRdinJobs());
        }
        if (rightVisitor.isFSHExecution()) {
            this.inFSHState = true;
            this.fshJobsMapInfo.mergeToMap(rhsFhsJobsMapInfo);
        }
        if (rightVisitor.isLocalExecution()) {
            this.inLocalState = true;
            this.rdinJobs.addAll(rightVisitor.getRdinJobs());
        }
        return child.setSources(new CommandNode[]{leftVisitor.getDFSJob(), rightVisitor.getDFSJob()});
    }

    private CommandNode extractUnion(UnionCommand child) {
        CommandNode[] children = new CommandNode[child.getSources().length];
        JobPartitionerCommand[] jpcs = new JobPartitionerCommand[children.length];
        PartitionExtractionVisitor[] partitionVisitors = new PartitionExtractionVisitor[children.length];
        FSHJobsMapInfo[] fshJobsMapInfos = new FSHJobsMapInfo[children.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = child.getSources()[i];
            jpcs[i] = new JobPartitionerCommand(children[i], "DFS_STATE");
            fshJobsMapInfos[i] = new FSHJobsMapInfo();
            partitionVisitors[i] = new PartitionExtractionVisitor(this.dfsSidGenerator, this.inFlightScaledPhaseGenerationMap, fshJobsMapInfos[i], this.fshSidGeneration);
            jpcs[i].accept((NodeVisitor)partitionVisitors[i]);
        }
        CommandNode[] updatedChildren = new CommandNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            updatedChildren[i] = partitionVisitors[i].getDFSJob();
            this.rdinJobs.addAll(partitionVisitors[i].getRdinJobs());
            if (partitionVisitors[i].isLocalExecution()) {
                this.inLocalState = true;
            }
            if (!partitionVisitors[i].isFSHExecution()) continue;
            this.inFSHState = true;
            this.fshJobsMapInfo.mergeToMap(fshJobsMapInfos[i]);
        }
        return child.setSources(updatedChildren);
    }
}

