/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.HeadCommand;
import com.splunk.commons.ast.nodes.commands.WhereCommand;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FunctionValidationVisitor
extends NodeVisitor<Object> {
    static final Logger logger = Logger.getLogger(FunctionValidationVisitor.class);
    private Map<String, Boolean> supportedFunction = FunctionValidationVisitor.initializeSupportedFunction();
    public static final String CURLY_BRACKET_NOT_SUPPORTED = "The \"eval\" command does not support curly brackets in Data Fabric Search.";

    public Object visit(Node node) {
        return null;
    }

    public Object visit(CommandNode node) {
        this.checkElements((Node[])node.getSources());
        return null;
    }

    public Object visit(WhereCommand node) {
        if (node.getPredicate() != null) {
            node.getPredicate().getNode().accept((NodeVisitor)this);
        }
        node.getSource().accept((NodeVisitor)this);
        return null;
    }

    public Object visit(HeadCommand node) {
        if (node.getPredicate() != null) {
            node.getPredicate().getNode().accept((NodeVisitor)this);
        }
        node.getSource().accept((NodeVisitor)this);
        return null;
    }

    public Object visit(EvalCommand node) {
        if (node.getAssignments() != null) {
            this.checkElements((Node[])node.getAssignments());
        }
        node.getSource().accept((NodeVisitor)this);
        return null;
    }

    public Object visit(FunctionNode node) {
        if (!this.supportedFunction.containsKey(node.getFunctionName())) {
            throw new UnsupportedOperationException(String.format("Function '%s' is not supported.", node.getFunctionName()));
        }
        this.checkElements(node.getArguments());
        return null;
    }

    public Object visit(FieldNode node) {
        if (node.getSource() != null) {
            node.getSource().getNode().accept((NodeVisitor)this);
        }
        return null;
    }

    public Object visit(ComparisonNode node) {
        node.getLhs().accept((NodeVisitor)this);
        node.getRhs().accept((NodeVisitor)this);
        return null;
    }

    public Object visit(AssignmentNode node) {
        if (node.getBracketIndex() >= 0) {
            throw new UnsupportedOperationException(CURLY_BRACKET_NOT_SUPPORTED);
        }
        if (node.getExpression() != null) {
            node.getExpression().accept((NodeVisitor)this);
        }
        return null;
    }

    private void checkElements(Node[] args) {
        this.checkElements(Arrays.asList(args));
    }

    protected <T extends Node> Object checkElements(List<T> args) {
        for (int i = 0; i < args.size(); ++i) {
            ((Node)args.get(i)).accept((NodeVisitor)this);
        }
        return null;
    }

    private static Map<String, Boolean> initializeSupportedFunction() {
        HashMap<String, Boolean> supportedFunction = new HashMap<String, Boolean>();
        supportedFunction.put("+", true);
        supportedFunction.put("-", true);
        supportedFunction.put("*", true);
        supportedFunction.put("/", true);
        supportedFunction.put("%", true);
        supportedFunction.put(".", true);
        supportedFunction.put("AND", true);
        supportedFunction.put("OR", true);
        supportedFunction.put("XOR", true);
        supportedFunction.put("NOT", true);
        supportedFunction.put("like", true);
        supportedFunction.put("len", true);
        supportedFunction.put("lower", true);
        supportedFunction.put("substr", true);
        supportedFunction.put("upper", true);
        supportedFunction.put("urldecode", true);
        supportedFunction.put("case", true);
        supportedFunction.put("cidrmatch", true);
        supportedFunction.put("coalesce", true);
        supportedFunction.put("if", true);
        supportedFunction.put("in", true);
        supportedFunction.put("match", true);
        supportedFunction.put("nullif", true);
        supportedFunction.put("null", true);
        supportedFunction.put("searchmatch", true);
        supportedFunction.put("validate", true);
        supportedFunction.put("abs", true);
        supportedFunction.put("round", true);
        supportedFunction.put("sqrt", true);
        supportedFunction.put("floor", true);
        supportedFunction.put("ceiling", true);
        supportedFunction.put("ceil", true);
        supportedFunction.put("log", true);
        supportedFunction.put("exp", true);
        supportedFunction.put("ln", true);
        supportedFunction.put("pi", true);
        supportedFunction.put("pow", true);
        supportedFunction.put("exact", true);
        supportedFunction.put("split", true);
        supportedFunction.put("isbool", true);
        supportedFunction.put("isint", true);
        supportedFunction.put("isnotnull", true);
        supportedFunction.put("isnull", true);
        supportedFunction.put("isnum", true);
        supportedFunction.put("isstr", true);
        supportedFunction.put("typeof", true);
        supportedFunction.put("tostring", true);
        supportedFunction.put("tonumber", true);
        return supportedFunction;
    }

    public Map<String, Boolean> getSupportedFunction() {
        return this.supportedFunction;
    }
}

