/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.FromCommand;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.df.search.DFSSupportedProcessors;
import com.splunk.df.util.DFSException;

public class DFSJobExtractorVisitor
extends NodeVisitor<Object> {
    private boolean inBranch;
    private boolean dfsCompatible;
    private Object requiredFieldsAndProperties;

    DFSJobExtractorVisitor(boolean inBranch) {
        this.inBranch = inBranch;
    }

    DFSJobExtractorVisitor() {
    }

    public boolean isDFSCompatible() {
        return this.dfsCompatible;
    }

    public Object visit(Node node) {
        return null;
    }

    public Object visit(CommandNode node) {
        CommandNode[] sources;
        String commandName = node.getCommandName();
        for (CommandNode sourceNode : sources = node.getSources()) {
            if (node.getSources().length > 1 && commandName == "dfsjob") {
                throw new DFSException("Unsupported usage: 'dfsjob' cannot be used as a subsearch");
            }
            if (node.getSources().length > 1 && commandName != "dfsjob") {
                DFSJobExtractorVisitor visitor = new DFSJobExtractorVisitor(true);
                sourceNode.accept((NodeVisitor)visitor);
                if (visitor.isDFSCompatible()) continue;
                return null;
            }
            sourceNode.accept((NodeVisitor)this);
            if (this.dfsCompatible) continue;
            if (node.getCommandName() == "dfsjob") {
                throw new DFSException("Unsupported usage: 'dfsjob' cannot be used as a subsearch");
            }
            return null;
        }
        this.dfsCompatible = this.isDFSCompatible(node);
        if (this.inBranch) {
            return null;
        }
        if (node.isGenerating()) {
            return null;
        }
        return null;
    }

    private boolean isDFSCompatible(CommandNode node) {
        boolean foundDFSSupportedCommand = false;
        if (DFSSupportedProcessors.getInstance().isProcessorSupported(node.getCommandName())) {
            if (node.getCommandName() == "dedup") {
                // empty if block
            }
            if (node instanceof FromCommand) {
                FromCommand fromCommand = (FromCommand)node;
                boolean bl = foundDFSSupportedCommand = fromCommand.getDataset().getKind() == "federated";
            }
        }
        if (foundDFSSupportedCommand) {
            return false;
        }
        return node.getCommandType() == CommandType.SP_STREAM || node.getCommandType() == CommandType.SP_EVENTS;
    }
}

