/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.serdes.fieldCompressed.util;

import com.splunk.df.serdes.fieldCompressed.util.EncodingStringCache;
import com.splunk.df.serdes.fieldCompressed.util.ReadableThresholdStringCache;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class DataUtil {
    private static final byte STRING_FIELD = 0;
    private static final byte ID_FIELD = 1;

    public static long readBase128(InputStream in) throws IOException {
        long x;
        int shiftBits;
        long result;
        block5: {
            result = 0L;
            shiftBits = 0;
            do {
                if ((x = (long)in.read()) < 0L) {
                    throw new EOFException();
                }
                if (x < 128L) break block5;
                result |= x - 128L << shiftBits;
            } while ((shiftBits = (int)((short)(shiftBits + 7))) < 64);
            throw new RuntimeException("Base128 overflow shiftBits=" + shiftBits);
        }
        if (shiftBits == 0) {
            result = x;
        } else {
            if (x >= 1L << 64 - shiftBits) {
                throw new RuntimeException("Base128 overflow x=" + x + ", shiftBits=" + shiftBits + ", result=" + result);
            }
            result |= x << shiftBits;
        }
        return result;
    }

    public static void writeBase128(OutputStream out, int v) throws IOException {
        DataUtil.writeBase128(out, (long)v & 0xFFFFFFFFFFFFFFFFL);
    }

    public static void writeBase128(OutputStream out, long v) throws IOException {
        if (v > -1L && v < 128L) {
            out.write((int)v);
            return;
        }
        do {
            out.write((byte)(v & 0x7FL | 0x80L));
        } while ((v >>>= 7) >= 128L);
        out.write((byte)v);
    }

    public static void readFully(InputStream in, byte[] bytes) throws IOException {
        DataUtil.readFully(in, bytes, 0, bytes.length);
    }

    public static void readFully(InputStream in, byte[] bytes, int off, int len) throws IOException {
        int tmp;
        if (len == 0) {
            return;
        }
        if (len + off > bytes.length) {
            throw new IllegalArgumentException("len + off > buffer.length, (" + len + "+" + off + ") > " + bytes.length);
        }
        for (int r = in.read(bytes, off, len); r < len; r += tmp) {
            if (r < 0) {
                throw new EOFException();
            }
            tmp = in.read(bytes, off + r, len - r);
            if (tmp >= 0) continue;
            throw new EOFException();
        }
    }

    public static void writeString(OutputStream out, byte[] data) throws IOException {
        DataUtil.writeBase128(out, data.length);
        out.write(data);
    }

    public static void writeString(OutputStream out, String data) throws IOException {
        if (null == data) {
            DataUtil.writeString(out, new byte[0]);
        }
        DataUtil.writeString(out, data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] readStringAsBytes(InputStream in) throws IOException {
        int size = (int)DataUtil.readBase128(in);
        byte[] data = new byte[size];
        DataUtil.readFully(in, data);
        return data;
    }

    public static String readString(InputStream in) throws IOException {
        return new String(DataUtil.readStringAsBytes(in), StandardCharsets.UTF_8);
    }

    public static void writeStringList(List<String> fields, OutputStream out, EncodingStringCache cache) throws IOException {
        DataUtil.writeBase128(out, fields.size());
        for (String f : fields) {
            Integer id = cache.getId(f);
            if (null == id) {
                out.write(0);
                DataUtil.writeString(out, f);
                continue;
            }
            out.write(1);
            DataUtil.writeBase128(out, id);
        }
    }

    public static void readStringList(List<String> destination, InputStream in, ReadableThresholdStringCache cache) throws IOException {
        int numFields = (int)DataUtil.readBase128(in);
        for (int i = 0; i < numFields; ++i) {
            byte type = (byte)in.read();
            String val = null;
            if (type == 1) {
                int id = (int)DataUtil.readBase128(in);
                val = cache.getText(id);
            } else {
                val = DataUtil.readString(in);
            }
            destination.add(val);
        }
    }
}

