/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.BaseAggregateValue;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ThresholdAggregateValue
extends BaseAggregateValue {
    private static final long serialVersionUID = 1L;
    static final Logger logger = Logger.getLogger(ThresholdAggregateValue.class);
    private Object val = null;
    private THRESHOLD_FUNCTION thresholdFunction;

    private ThresholdAggregateValue(THRESHOLD_FUNCTION thresholdFunction) {
        this.thresholdFunction = thresholdFunction;
    }

    private ThresholdAggregateValue(Object val, THRESHOLD_FUNCTION function) {
        this.thresholdFunction = function;
        this.val = val;
    }

    public static ThresholdAggregateValue getInstance(THRESHOLD_FUNCTION thresholdFunction) {
        return new ThresholdAggregateValue(thresholdFunction);
    }

    @Override
    public AggregateValue accumulate(Object item) {
        if (this.val == null) {
            this.val = item;
        } else {
            this.compareAndSet(item);
        }
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        assert (aggregateValue instanceof ThresholdAggregateValue);
        Object item = aggregateValue.getValue();
        this.compareAndSet(item);
        return this;
    }

    private void compareAndSet(Object item) {
        int result = 0;
        if (null == this.val || this.val.toString().isEmpty()) {
            this.val = item;
        } else if (null != item && !item.toString().isEmpty()) {
            try {
                result = new BigDecimal(this.val.toString()).compareTo(new BigDecimal(item.toString()));
                this.val = this.thresholdFunction == THRESHOLD_FUNCTION.MIN ? (result < 0 ? this.val : item) : (result > 0 ? this.val : item);
            }
            catch (NumberFormatException e) {
                result = this.val.toString().compareTo(item.toString());
                this.val = this.thresholdFunction == THRESHOLD_FUNCTION.MIN ? (result < 0 ? this.val : item) : (result > 0 ? this.val : item);
            }
        }
    }

    @Override
    public Object getValue() {
        return this.val;
    }

    public static void write(OutputStream os, ThresholdAggregateValue aggrVal) throws IOException {
        if (aggrVal.val == null) {
            Utils.write(os, 0);
        } else {
            Utils.write(os, 1);
        }
        if (aggrVal.val != null) {
            Utils.write(os, aggrVal.val.toString());
        }
        if (aggrVal.thresholdFunction == null) {
            Utils.write(os, 0);
        } else {
            Utils.write(os, 1);
        }
        if (aggrVal.thresholdFunction != null) {
            Utils.write(os, aggrVal.thresholdFunction.ordinal());
        }
    }

    public static ThresholdAggregateValue read(InputStream is) throws IOException {
        boolean isFuncPresent;
        boolean isValPresent = Utils.readInt(is) == 1;
        String val = null;
        if (isValPresent) {
            val = Utils.readString(is);
        }
        THRESHOLD_FUNCTION func = null;
        boolean bl = isFuncPresent = Utils.readInt(is) == 1;
        if (isFuncPresent) {
            int funcType = Utils.readInt(is);
            if (funcType == THRESHOLD_FUNCTION.MAX.ordinal()) {
                func = THRESHOLD_FUNCTION.MAX;
            } else if (funcType == THRESHOLD_FUNCTION.MIN.ordinal()) {
                func = THRESHOLD_FUNCTION.MIN;
            } else {
                throw new RuntimeException(String.format("%d func type not supported", funcType));
            }
        }
        return new ThresholdAggregateValue(val, func);
    }

    public static enum THRESHOLD_FUNCTION {
        MIN,
        MAX;

    }
}

