/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.BaseAggregateValue;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CountAndSumAggregateValue
extends BaseAggregateValue {
    private static final long serialVersionUID = 1L;
    private Long count = 0L;
    private Double sum = 0.0;

    public CountAndSumAggregateValue() {
    }

    CountAndSumAggregateValue(long count, double sum) {
        this.count = count;
        this.sum = sum;
    }

    @Override
    public AggregateValue accumulate(Object item) {
        assert (item instanceof Pair);
        Pair ctSumPair = (Pair)item;
        this.count = this.count + (Long)ctSumPair.first();
        this.sum = this.sum + (Double)ctSumPair.second();
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        assert (aggregateValue instanceof CountAndSumAggregateValue);
        Pair ctSumPair = (Pair)aggregateValue.getValue();
        this.count = this.count + (Long)ctSumPair.first();
        this.sum = this.sum + (Double)ctSumPair.second();
        return this;
    }

    @Override
    public Object getValue() {
        return new Pair<Long, Double>(this.count, this.sum);
    }

    public static void write(OutputStream os, CountAndSumAggregateValue val) throws IOException {
        Pair pair = (Pair)val.getValue();
        long count = (Long)pair.first();
        double sum = (Double)pair.second();
        Utils.write(os, count);
        Utils.write(os, sum);
    }

    public static CountAndSumAggregateValue read(InputStream is) throws IOException {
        long count = Utils.readLong(is);
        double sum = Utils.readDouble(is);
        return new CountAndSumAggregateValue(count, sum);
    }
}

