/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.commands.JoinCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.PercentageAggregateNode;
import com.splunk.commons.ast.nodes.expressions.SparklineAggregateNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.Reducer;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.SplunkConfExtractor;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.objects.SearchObject;
import com.splunk.df.search.compute.objects._Long;
import com.splunk.df.search.compute.objects._String;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.Aggregator;
import com.splunk.df.search.compute.transformers.AggregatorFactory;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.search.compute.transformers.FieldExtractorFactory;
import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.DistinctCountAggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.SparklineAggregateValue;
import com.splunk.df.util.MultiValueFieldParser;
import com.splunk.df.util.StatsAggregateNode;
import com.splunk.df.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import scala.Tuple2;

public class StatsTransformer
implements Transformer,
ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(StatsTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        return StatsTransformer._transform(ctx, dd, (StatsCommand)qcmd);
    }

    private static HashSet<SearchResult.FieldMeta> getFields(FieldNode[] fieldNodes) {
        if (fieldNodes == null) {
            return new HashSet<SearchResult.FieldMeta>();
        }
        HashSet<SearchResult.FieldMeta> fields = new HashSet<SearchResult.FieldMeta>();
        for (int i = 0; i < fieldNodes.length; ++i) {
            FieldNode fn = fieldNodes[i];
            String field = fn.getFieldName();
            fields.add(SearchResult.FieldMeta.newFieldMeta(field));
        }
        return fields;
    }

    private static void contextIfy(Aggregator aggregator, AggregateNode aggregateNode, HashMap<SearchResult.FieldMeta, Object> context) {
        AggregateFunction aggregateFunction = aggregateNode.getFunction();
        switch (aggregateFunction) {
            case SPARKLINE: {
                SparklineAggregateNode node = (SparklineAggregateNode)aggregateNode;
                _String searchObjectAggFunction = new _String(node.getSparklineAggregateFunction().toString());
                _String searchObjectTimeInterval = new _String(node.getTimeSpan().toString());
                aggregator.addToComputeContext(AGGREGATOR_FUNCTION, searchObjectAggFunction);
                aggregator.addToComputeContext(SPARKLINE_INTERVAL, searchObjectTimeInterval);
                break;
            }
            case EXACTPERC_X: 
            case PERC_X: 
            case UPPERPERC_X: {
                SparklineAggregateNode node = (PercentageAggregateNode)aggregateNode;
                _Long searchObject = new _Long(Long.valueOf(node.getPercentage()));
                aggregator.addToComputeContext(PERC_VALUE, searchObject);
                break;
            }
        }
        for (Map.Entry<SearchResult.FieldMeta, Object> entry : context.entrySet()) {
            aggregator.addToComputeContext(entry.getKey(), new _String(entry.getValue().toString()));
        }
    }

    private static StatsAggrInfos getAggregates(StatsCommand cmd, HashMap<SearchResult.FieldMeta, Object> statsExecutorContext) {
        List aggrNodes = cmd.getAggregates();
        ArrayList<StatsAggrInfo> statsAggrNodes = new ArrayList<StatsAggrInfo>(aggrNodes.size());
        boolean containsWC = false;
        for (int i = 0; i < aggrNodes.size(); ++i) {
            StatsAggregateNode aggrNode = new StatsAggregateNode((AggregateNode)aggrNodes.get(i), ((AggregateNode)aggrNodes.get(i)).getAsName());
            AggregateFunction aggregateFunction = aggrNode.getFunction();
            Aggregator aggregator = AggregatorFactory.getInstance().getAggregator(aggregateFunction);
            StatsTransformer.contextIfy(aggregator, aggrNode.getAggregateNode(), statsExecutorContext);
            SearchResult.FieldMeta fieldName = null;
            if (aggrNode.getField() != null) {
                fieldName = aggrNode.getFieldName();
            } else {
                fieldName = aggrNode.getAsName();
                logger.debug((Object)String.format("could not find field for aggregator node: %s hence using as-name: %s", aggrNode.getDefaultName(), fieldName));
            }
            if (fieldName == null) {
                throw new RuntimeException(String.format("could not find field name in the aggregate node: %s", aggrNode.getDefaultName()));
            }
            boolean containsWCLoc = fieldName.fieldName().contains("*");
            StatsAggrInfo info = new StatsAggrInfo(aggrNode, aggregator, containsWCLoc);
            if (containsWCLoc) {
                containsWC = true;
            }
            statsAggrNodes.add(info);
        }
        return new StatsAggrInfos(statsAggrNodes, containsWC);
    }

    private static SearchResult.FieldMeta[] mergeFields(SearchResult lhs, SearchResult rhs) {
        SearchResult.FieldMeta[] lhsFieldNames = lhs.getFieldNames();
        SearchResult.FieldMeta[] rhsFieldNames = rhs.getFieldNames();
        ArrayList<SearchResult.FieldMeta> filtered = new ArrayList<SearchResult.FieldMeta>(rhsFieldNames.length);
        int rhsLen = rhsFieldNames.length;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> lhsData = lhs.getDataMap();
        for (int i = 0; i < rhsLen; ++i) {
            SearchResult.FieldMeta rhsFieldName = rhsFieldNames[i];
            if (lhsData.containsKey(rhsFieldName)) continue;
            filtered.add(rhsFieldName);
        }
        int filteredLen = filtered.size();
        int lhsLen = lhsFieldNames.length;
        SearchResult.FieldMeta[] ret = new SearchResult.FieldMeta[lhsLen + filteredLen];
        System.arraycopy(lhsFieldNames, 0, ret, 0, lhsLen);
        for (int i = 0; i < filteredLen; ++i) {
            ret[lhsLen + i] = (SearchResult.FieldMeta)filtered.get(i);
        }
        return ret;
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, StatsCommand statsCmd) {
        HashMap<SearchResult.FieldMeta, Object> statsExecutorContext = SplunkConfExtractor.extract(ctx);
        DistributedDataset outputdd = dd;
        CommandNode sourceCmd = statsCmd.getSource();
        boolean executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal((CommandNode)statsCmd, sourceCmd);
        ctx.addContext("retain.multi.value.fields", true);
        Double sriStartTime = (Double)ctx.get(ComputeEngineConstants.SRI_START_TIME.toString());
        Double sriEndTime = (Double)ctx.get(ComputeEngineConstants.SRI_END_TIME.toString());
        if (sriStartTime == null || sriEndTime == null) {
            logger.debug((Object)"Query range: all time selected");
        } else {
            logger.debug((Object)("Query range: startTime: " + sriStartTime + "; endTime: " + sriEndTime));
        }
        if (executeExternal) {
            logger.info((Object)("Stats transformer: looks like no reporting command is present in upstream command list: " + sourceCmd.getCommandName() + ", hence triggering base transformer to read the initial srs"));
            StatsCommand customCommand = statsCmd;
            if (BaseTransformerFactory.getInstance().isPreStaged(ctx)) {
                customCommand = statsCmd.convertToPrestats(sourceCmd);
            }
            if ((outputdd = BaseTransformerFactory.getInstance().transform(outputdd, (CommandNode)customCommand, ctx)).fieldExtractionHint().equals((Object)FieldExtractor.ExtractionHint.UNKNOWN)) {
                outputdd = outputdd.setExtractionHint(FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED);
                logger.debug((Object)"changing the extraction hint to precomputed and prestaged since stats transformer triggered the base transformer");
            }
        } else {
            logger.info((Object)("Stats transformer: reporting command found upstream: " + sourceCmd.getCommandName() + ", hence running the parent transformers"));
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(sourceCmd);
            outputdd = t.transform(dd, sourceCmd, false, ctx);
        }
        if (outputdd.fieldExtractionHint().equals((Object)FieldExtractor.ExtractionHint.UNKNOWN)) {
            outputdd = outputdd.setExtractionHint(FieldExtractor.ExtractionHint.NOT_PRECOMPUTED);
            logger.debug((Object)"Changing the extraction hint to non precomputed since stats transformer did not trigger base transformer");
        } else if (statsCmd.isPreComputed()) {
            outputdd = outputdd.setExtractionHint(FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED);
        }
        ctx.addContext("command.node", statsCmd);
        ctx.removeContext("retain.multi.value.fields");
        final FieldExtractor.ExtractionHint fieldExtractionHint = outputdd.fieldExtractionHint();
        List groupByList = statsCmd.getByFields();
        IGroupBy[] groupByFields = null;
        if (groupByList != null) {
            groupByFields = groupByList.toArray(new IGroupBy[0]);
        }
        final FieldNode[] byfields = groupByFields == null ? null : (FieldNode[])Arrays.copyOf(groupByFields, groupByFields.length, FieldNode[].class);
        int byfieldslen = 0;
        if (byfields != null) {
            byfieldslen = byfields.length;
        }
        final SearchResult.FieldMeta[] fieldsMeta = new SearchResult.FieldMeta[byfieldslen];
        for (int i = 0; i < byfieldslen; ++i) {
            fieldsMeta[i] = SearchResult.FieldMeta.newFieldMeta(byfields[i].getFieldName());
        }
        final HashSet<SearchResult.FieldMeta> reducedByFields = StatsTransformer.getFields(byfields);
        final StatsAggrInfos aggrNodes = StatsTransformer.getAggregates(statsCmd, statsExecutorContext);
        int numFields = byfieldslen + aggrNodes.size();
        ctx.addContext("numfields", numFields);
        boolean postJoin = false;
        if (statsCmd.getSource() instanceof JoinCommand) {
            postJoin = true;
        }
        final boolean finalPostJoin = postJoin;
        DistributedDataset reducedd = outputdd.transform(new Reducer(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean limitResultset() {
                return fieldExtractionHint == FieldExtractor.ExtractionHint.NOT_PRECOMPUTED && aggrNodes.infos().size() == 1 && aggrNodes.infos().get(0).node().getFunction().equals((Object)AggregateFunction.LIST);
            }

            @Override
            public boolean metadataRequired() {
                boolean result = false;
                for (StatsAggrInfo aggregateNode : aggrNodes.infos()) {
                    if (!(aggregateNode.node().getAggregateNode() instanceof SparklineAggregateNode)) continue;
                    result = true;
                    break;
                }
                return result;
            }

            @Override
            public SearchResult reduce(SearchResult lhs, SearchResult rhs) {
                SearchResult.FieldMeta[] fieldNames = StatsTransformer.mergeFields(lhs, rhs);
                int totalSize = fieldNames.length;
                SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = lhs.getDataMap();
                Object[] fieldValues = new Object[totalSize];
                for (int i = 0; i < totalSize; ++i) {
                    Object rhsFieldValue;
                    SearchResult.FieldMeta asName = fieldNames[i];
                    Aggregator aggregator = null;
                    AggregateValue lhsVal = null;
                    AggregateValue rhsVal = null;
                    Object lhsFieldValue = lhs.getFieldValue(asName);
                    if (lhsFieldValue != null) {
                        Pair computeIntermediateLhs = (Pair)lhsFieldValue;
                        aggregator = (Aggregator)computeIntermediateLhs.first();
                        lhsVal = (AggregateValue)computeIntermediateLhs.second();
                    }
                    if ((rhsFieldValue = rhs.getFieldValue(asName)) != null) {
                        Pair computeIntermediateRhs = (Pair)rhsFieldValue;
                        if (aggregator == null) {
                            aggregator = (Aggregator)computeIntermediateRhs.first();
                        }
                        rhsVal = (AggregateValue)computeIntermediateRhs.second();
                    }
                    Pair computeIntermediateRet = StatsTransformer.computeIntermediate(aggregator, lhsVal, rhsVal);
                    fieldValues[i] = computeIntermediateRet;
                    data.put(asName, computeIntermediateRet);
                }
                SearchResult ret = SearchResultFactory.getInstance().createSearchResult(data, fieldNames, fieldValues);
                return ret;
            }

            @Override
            public List<Pair<SearchResult, SearchResult>> splits(SearchResult sr) {
                List splits = StatsTransformer.createSplits(sr, aggrNodes, byfields, fieldsMeta, fieldExtractionHint);
                return splits;
            }

            @Override
            public Iterator<Tuple2<SearchResult.FieldMeta, SearchResult>> gatherMetadataOnReducedData(SearchResult key, SearchResult value) {
                SearchResult.FieldMeta[] valFields = value.getFieldNames();
                int valLen = valFields.length;
                ArrayList<Tuple2> results = new ArrayList<Tuple2>();
                for (int i = 0; i < valLen; ++i) {
                    SparklineAggregateValue sparklineAggregateValue;
                    TreeMap slValues;
                    Object valVal = value.getFieldValues()[i];
                    Pair intermediate = (Pair)valVal;
                    if (!(intermediate.second() instanceof SparklineAggregateValue) || (slValues = (TreeMap)(sparklineAggregateValue = (SparklineAggregateValue)intermediate.second()).getValue()).isEmpty()) continue;
                    results.add(new Tuple2((Object)ComputeEngineConstants.EARLIEST_TIME_SEEN, (Object)SearchResultFactory.getInstance().createSearchResult(ComputeEngineConstants.EARLIEST_TIME_SEEN, slValues.firstEntry().getKey())));
                    results.add(new Tuple2((Object)ComputeEngineConstants.LATEST_TIME_SEEN, (Object)SearchResultFactory.getInstance().createSearchResult(ComputeEngineConstants.LATEST_TIME_SEEN, slValues.lastEntry().getKey())));
                }
                return results.iterator();
            }

            @Override
            public SearchResult finalizeMetadata(SearchResult sr1, SearchResult sr2) {
                SearchResult result = SearchResultFactory.getInstance().emptyResult();
                if (sr1.containsField(ComputeEngineConstants.EARLIEST_TIME_SEEN)) {
                    result = (Long)sr1.getFieldValue(ComputeEngineConstants.EARLIEST_TIME_SEEN) <= (Long)sr2.getFieldValue(ComputeEngineConstants.EARLIEST_TIME_SEEN) ? sr1 : sr2;
                } else if (sr1.containsField(ComputeEngineConstants.LATEST_TIME_SEEN)) {
                    result = (Long)sr1.getFieldValue(ComputeEngineConstants.LATEST_TIME_SEEN) >= (Long)sr2.getFieldValue(ComputeEngineConstants.LATEST_TIME_SEEN) ? sr1 : sr2;
                }
                return result;
            }

            @Override
            public SearchResult merge(SearchResult key, SearchResult value, Map<SearchResult.FieldMeta, SearchObject> context) {
                SearchResult.FieldMeta[] keyFields = key.getFieldNames();
                Object[] keyVals = key.getFieldValues();
                int keyLen = keyFields.length;
                SearchResult.SRHashMap<SearchResult.FieldMeta, Object> retData = key.getDataMap();
                SearchResult.FieldMeta[] valFields = value.getFieldNames();
                Object[] valVals = value.getFieldValues();
                int valLen = valFields.length;
                int retLen = keyLen + valLen;
                SearchResult.FieldMeta[] retFields = new SearchResult.FieldMeta[retLen];
                Object[] retVals = new Object[retLen];
                System.arraycopy(keyFields, 0, retFields, 0, keyLen);
                System.arraycopy(keyVals, 0, retVals, 0, keyLen);
                ArrayList<SearchResult.FieldMeta> mvFieldsList = new ArrayList<SearchResult.FieldMeta>();
                ArrayList<String> mvValuesList = new ArrayList<String>();
                for (int i = 0; i < valLen; ++i) {
                    SearchResult.FieldMeta valField = valFields[i];
                    Object valVal = valVals[i];
                    if (valVal == null) {
                        retData.put(valField, null);
                        retFields[keyLen + i] = valField;
                        retVals[keyLen + i] = null;
                        continue;
                    }
                    Pair intermediate = (Pair)valVal;
                    Aggregator aggregator = (Aggregator)intermediate.first();
                    AggregateValue intermediateVal = (AggregateValue)intermediate.second();
                    for (Map.Entry<SearchResult.FieldMeta, SearchObject> entry : context.entrySet()) {
                        aggregator.addToComputeContext(entry.getKey(), entry.getValue());
                    }
                    Object aggrValue = null;
                    try {
                        aggrValue = StatsTransformer.combineIntermediate(aggregator, intermediateVal);
                    }
                    catch (Exception entry) {
                        // empty catch block
                    }
                    if (aggrValue instanceof String[]) {
                        Object[] aggrValueStrArray = (String[])aggrValue;
                        StringBuilder sb = new StringBuilder();
                        for (String string : aggrValueStrArray) {
                            sb.append("$");
                            sb.append(string.replace("$", "$$"));
                            sb.append("$;");
                        }
                        if (sb.length() > 0) {
                            mvValuesList.add(sb.substring(0, sb.length() - 1));
                            mvFieldsList.add(valField.prepend("__mv_"));
                        } else {
                            mvValuesList.add(sb.toString());
                            mvFieldsList.add(valField.prepend("__mv_"));
                        }
                        aggrValue = aggrValueStrArray.length == 0 ? null : Arrays.toString(aggrValueStrArray);
                    }
                    if (aggrValue == null && byfields == null) continue;
                    retData.put(valField, aggrValue);
                    retFields[keyLen + i] = valField;
                    retVals[keyLen + i] = aggrValue;
                }
                if (mvFieldsList.size() > 0) {
                    ArrayList<SearchResult.FieldMeta> retFieldsList = new ArrayList<SearchResult.FieldMeta>();
                    retFieldsList.addAll(Arrays.asList(retFields));
                    ArrayList<Object> retValsList = new ArrayList<Object>();
                    retValsList.addAll(Arrays.asList(retVals));
                    for (int i = 0; i < mvFieldsList.size(); ++i) {
                        retFieldsList.add((SearchResult.FieldMeta)mvFieldsList.get(i));
                        retValsList.add(mvValuesList.get(i));
                        retData.put((SearchResult.FieldMeta)mvFieldsList.get(i), mvValuesList.get(i));
                    }
                    retFields = retFieldsList.toArray(new SearchResult.FieldMeta[0]);
                    retVals = retValsList.toArray();
                }
                SearchResult ret = SearchResultFactory.getInstance().createSearchResult(retData, retFields, retVals);
                return ret;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }

            @Override
            public HashSet<SearchResult.FieldMeta> reduceByFields() {
                return reducedByFields;
            }

            @Override
            public boolean postJoin() {
                return finalPostJoin;
            }

            @Override
            public Pair<SearchResult, SearchResult> downProcess(SearchResult keySr, SearchResult valSr) {
                SearchResult newKeySr = SearchResultFactory.getInstance().removeIntermediaries(keySr);
                SearchResult.FieldMeta[] valFields = valSr.getFieldNames();
                int valSize = valFields.length;
                Object[] valVals = valSr.getFieldValues();
                SearchResult.SRHashMap<SearchResult.FieldMeta, Object> downValData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(valSize * 2);
                SearchResult.FieldMeta[] newValFields = new SearchResult.FieldMeta[valSize];
                Object[] newValVals = new Object[valSize];
                for (int i = 0; i < valSize; ++i) {
                    SearchResult.FieldMeta valField = valFields[i];
                    Pair<Aggregator, AggregateValue> valVal = valVals[i];
                    Pair<Aggregator, AggregateValue> newValVal = valVal;
                    if (newValVal instanceof Pair) {
                        Pair<Aggregator, AggregateValue> newAggrVal;
                        Pair aggrVal = valVal;
                        Aggregator aggr = (Aggregator)aggrVal.first();
                        AggregateValue val = (AggregateValue)aggrVal.second();
                        val = val.floor();
                        newValVal = newAggrVal = new Pair<Aggregator, AggregateValue>(aggr, val);
                    }
                    newValFields[i] = valField;
                    newValVals[i] = newValVal;
                    downValData.put(valField, newValVal);
                }
                SearchResult newValSr = SearchResultFactory.getInstance().createSearchResult(downValData, newValFields, newValVals);
                return new Pair<SearchResult, SearchResult>(newKeySr, newValSr);
            }

            @Override
            public boolean downReduce() {
                ArrayList<StatsAggrInfo> infos = aggrNodes.infos();
                int size = infos.size();
                for (int i = 0; i < size; ++i) {
                    StatsAggrInfo statsAggrInfo = infos.get(i);
                    AggregateFunction func = statsAggrInfo.node().getFunction();
                    if (!StatsTransformer.requiresDownProcessing(func)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String desc() {
                return "statsTransformerReduceProcessing";
            }
        });
        String sid = (String)ctx.get("sid");
        if (StatsTransformer.emptyByFields(byfields) && !StatsTransformer.emptyAggrs(aggrNodes)) {
            ArrayList<String> aggrNames = StatsTransformer.getAggrNames(aggrNodes);
            logger.info((Object)String.format("Will retrieve a single search result since there are no byfields for this search: %s, dag executed: \n%s", sid, reducedd.toString()));
            Iterator<SearchResult> srsIter = reducedd.retrieve();
            ArrayList<SearchResult> srs = new ArrayList<SearchResult>();
            while (srsIter.hasNext()) {
                SearchResult sr = srsIter.next();
                srs.add(sr);
            }
            if (srs.isEmpty()) {
                srs = new ArrayList();
                int size = aggrNames.size();
                SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[size];
                Object[] vals = new Object[size];
                for (int i = 0; i < size; ++i) {
                    fields[i] = SearchResult.FieldMeta.newFieldMeta(aggrNames.get(i));
                    vals[i] = 0L;
                }
                SearchResult sr = SearchResultFactory.getInstance().createSearchResult(fields, vals);
                srs.add(sr);
                logger.info((Object)String.format("constructed a dummy search result since no result could be retrieved, most probably no event in the index or for the given et-lt", new Object[0]));
            }
            reducedd = reducedd.resetSearchResults(srs, srs.size());
        } else {
            logger.info((Object)String.format("stats with by-fields: sid: %s, by-fields: %s", sid, StatsTransformer.printByFields(byfields)));
        }
        return reducedd;
    }

    private static String printByFields(FieldNode[] byFields) {
        if (byFields == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < byFields.length; ++i) {
            FieldNode field = byFields[i];
            sb.append(field.getFieldName());
            if (i >= byFields.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private static ArrayList<String> getAggrNames(StatsAggrInfos aggrNodes) {
        ArrayList<String> aggrNames = new ArrayList<String>();
        int size = aggrNodes.size();
        for (int i = 0; i < size; ++i) {
            AggregateNode aggr = aggrNodes.infos().get(i).node().getAggregateNode();
            String aggrName = aggr.getAsName();
            if (aggrName == null) {
                aggrName = aggr.getDefaultName();
            }
            aggrNames.add(aggrName);
        }
        return aggrNames;
    }

    private static boolean emptyByFields(FieldNode[] byfields) {
        return byfields == null || byfields.length == 0;
    }

    private static boolean emptyAggrs(StatsAggrInfos aggrNodes) {
        return aggrNodes == null || aggrNodes.size() == 0;
    }

    private static Object combineIntermediate(Aggregator aggregator, AggregateValue intermediateVal) {
        return aggregator.finalize(intermediateVal);
    }

    private static Pair<Aggregator, AggregateValue> computeIntermediate(Aggregator aggregator, AggregateValue lhsVal, AggregateValue rhsVal) {
        if (aggregator == null) {
            return null;
        }
        if (lhsVal == null) {
            return new Pair<Aggregator, AggregateValue>(aggregator, rhsVal);
        }
        if (rhsVal == null) {
            return new Pair<Aggregator, AggregateValue>(aggregator, lhsVal);
        }
        return new Pair<Aggregator, AggregateValue>(aggregator, aggregator.aggregate(lhsVal, rhsVal));
    }

    private static StatsAggrInfo createNewAggregateNode(StatsAggregateNode aggrNode, SearchResult.FieldMeta field, SearchResult.FieldMeta asName, Aggregator aggregator) {
        FieldNode fieldNode = new FieldNode(field.fieldName());
        SearchResult.FieldMeta as = asName;
        if (aggrNode.getFunction() == AggregateFunction.SPARKLINE) {
            SparklineAggregateNode an = (SparklineAggregateNode)aggrNode.getAggregateNode();
            if (asName == null) {
                as = SearchResult.FieldMeta.newFieldMeta(SparklineAggregateNode.createDefaultName((AggregateFunction)an.getSparklineAggregateFunction(), (FieldNode)fieldNode, (String)an.getTimeSpan().toString()));
            }
            return new StatsAggrInfo(new StatsAggregateNode((AggregateNode)new SparklineAggregateNode(an.getSparklineAggregateFunction(), fieldNode, an.getTimeSpan().toString(), as.fieldName()), aggrNode.getWcAsName()), aggregator, true);
        }
        if (aggrNode.getFunction() == AggregateFunction.EXACTPERC_X || aggrNode.getFunction() == AggregateFunction.UPPERPERC_X || aggrNode.getFunction() == AggregateFunction.PERC_X) {
            PercentageAggregateNode an = (PercentageAggregateNode)aggrNode.getAggregateNode();
            if (asName == null) {
                as = SearchResult.FieldMeta.newFieldMeta(PercentageAggregateNode.createDefaultName((AggregateFunction)an.getFunction(), (FieldNode)fieldNode, (int)an.getPercentage()));
            }
            return new StatsAggrInfo(new StatsAggregateNode((AggregateNode)new PercentageAggregateNode(an.getFunction(), fieldNode, as.fieldName(), an.getPercentage()), aggrNode.getWcAsName()), aggregator, true);
        }
        AggregateNode an = aggrNode.getAggregateNode();
        if (asName == null) {
            as = SearchResult.FieldMeta.newFieldMeta(AggregateNode.createDefaultName((AggregateFunction)an.getFunction(), (FieldNode)fieldNode));
        }
        return new StatsAggrInfo(new StatsAggregateNode(new AggregateNode(aggrNode.getFunction(), fieldNode, as.fieldName()), aggrNode.getWcAsName()), aggregator, true);
    }

    private static List<Pair<SearchResult, SearchResult>> createSplits(SearchResult sr, StatsAggrInfos aggrNodes, FieldNode[] byfields, SearchResult.FieldMeta[] fieldsMeta, FieldExtractor.ExtractionHint fieldExtractionHint) {
        ArrayList<StatsAggrInfo> newAggrNodes;
        ArrayList<SearchResult> keySrList = new ArrayList<SearchResult>(1);
        ArrayList<Pair<SearchResult, SearchResult>> retList = new ArrayList<Pair<SearchResult, SearchResult>>(1);
        ArrayList<SearchResult.FieldMeta> keyFieldNames = new ArrayList<SearchResult.FieldMeta>();
        if (byfields != null) {
            int byFieldsLen = byfields.length;
            int initialCapacity = (int)((double)byFieldsLen / 0.75 + 2.0);
            SearchResult.SRHashMap<SearchResult.FieldMeta, Object> keySrData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(initialCapacity);
            boolean containMultiVal = false;
            keyFieldNames = new ArrayList(byFieldsLen);
            ArrayList<Object> keyFieldValues = new ArrayList<Object>(byFieldsLen);
            for (int i = 0; i < byFieldsLen; ++i) {
                SearchResult.FieldMeta fieldName = fieldsMeta[i];
                Object val = sr.getFieldValue(fieldName);
                if (val == null) {
                    Pair<Object, Object> ret = new Pair<Object, Object>(null, null);
                    retList.add(ret);
                    return retList;
                }
                int isMultiVal = 0;
                SearchResult.FieldMeta mvFieldName = fieldName.getMvName();
                Object mvFieldValue = null;
                if (val instanceof String[]) {
                    isMultiVal = 1;
                    mvFieldValue = sr.getFieldValue(mvFieldName);
                } else if (sr.containsField(mvFieldName) && (mvFieldValue = sr.getFieldValue(mvFieldName)) != null && mvFieldValue.toString().length() > 0) {
                    isMultiVal = 1;
                }
                if (isMultiVal != 0) {
                    containMultiVal = true;
                    String[] mvVal = MultiValueFieldParser.parse(mvFieldValue.toString());
                    keyFieldValues.add(mvVal);
                    keyFieldNames.add(fieldName);
                    continue;
                }
                keySrData.put(fieldName, val);
                keyFieldNames.add(fieldName);
                keyFieldValues.add(val);
            }
            if (containMultiVal) {
                ArrayList<ArrayList<Object>> keyFieldValuesList = StatsTransformer.getKeyFieldValuelist(keyFieldValues);
                for (int i = 0; i < keyFieldValuesList.size(); ++i) {
                    ArrayList<Object> keyFieldVal = keyFieldValuesList.get(i);
                    SearchResult.SRHashMap<SearchResult.FieldMeta, Object> curKeySrData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(initialCapacity);
                    for (int j = 0; j < keyFieldVal.size(); ++j) {
                        curKeySrData.put(keyFieldNames.get(j), keyFieldVal.get(j));
                    }
                    keySrList.add(SearchResultFactory.getInstance().createSearchResult(curKeySrData, keyFieldNames, keyFieldVal));
                }
            } else {
                keySrList.add(SearchResultFactory.getInstance().createSearchResult(keySrData, keyFieldNames, keyFieldValues));
            }
            if (byFieldsLen != 0) {
                boolean isShortCircuit = true;
                for (int i = 0; i < keySrList.size(); ++i) {
                    if (SearchResultFactory.getInstance().containsOnlyNullVals((SearchResult)keySrList.get(i))) continue;
                    isShortCircuit = false;
                }
                if (isShortCircuit) {
                    return retList;
                }
            }
        }
        if (aggrNodes.containsWC()) {
            SearchResult.FieldMeta[] tmpFlds = sr.getFieldNames();
            ArrayList<SearchResult.FieldMeta> retFieldsList = new ArrayList<SearchResult.FieldMeta>(tmpFlds.length);
            for (SearchResult.FieldMeta fieldMeta : tmpFlds) {
                if (keyFieldNames.contains(fieldMeta) || fieldMeta.fieldName().startsWith("__mv_")) continue;
                retFieldsList.add(fieldMeta);
            }
            SearchResult.FieldMeta[] retFlds = retFieldsList.toArray(new SearchResult.FieldMeta[0]);
            int aggrNodesLen = aggrNodes.size();
            int newAggrNodesLen = aggrNodesLen * retFlds.length;
            newAggrNodes = new ArrayList(newAggrNodesLen);
            HashMap<String, String> wcMapping = new HashMap<String, String>(retFlds.length);
            for (int i = 0; i < aggrNodesLen; ++i) {
                StatsAggrInfo info = aggrNodes.infos().get(i);
                StatsAggregateNode aggrNode = info.node();
                if (aggrNode.getField() == null || !info.containsWildCard()) {
                    newAggrNodes.add(info);
                    continue;
                }
                String aggrNodeFieldName = aggrNode.getField().getFieldName();
                TermMatcher fromName = new TermMatcher(aggrNodeFieldName);
                for (int f = 0; f < retFlds.length; ++f) {
                    SearchResult.FieldMeta field = retFlds[f];
                    if (fieldExtractionHint == FieldExtractor.ExtractionHint.PRECOMPUTED_PRE_STAGED) {
                        boolean hasPrefix = true;
                        int fieldpos = -1;
                        if (field.fieldName().startsWith("__mv_psrsvd_")) {
                            fieldpos = field.fieldName().indexOf(95, "__mv_".length() + "psrsvd_".length());
                        } else if (field.fieldName().startsWith("__mv_")) {
                            fieldpos = field.fieldName().indexOf(95, "__mv_".length());
                        } else if (field.fieldName().startsWith("psrsvd_")) {
                            fieldpos = field.fieldName().indexOf(95, "psrsvd_".length());
                        } else {
                            hasPrefix = false;
                        }
                        if (hasPrefix) {
                            if (fieldpos == -1 || fieldpos + 1 >= field.fieldName().length()) continue;
                            field = field.reset(field.fieldName().substring(fieldpos + 1));
                        }
                    }
                    if (!fromName.match(field.fieldName())) continue;
                    StatsAggrInfo newAggrNode = null;
                    if (aggrNode.hasDefaultAsName()) {
                        newAggrNode = StatsTransformer.createNewAggregateNode(aggrNode, field, null, info.aggregator());
                    } else {
                        String[] toParts;
                        TermMatcher toName = new TermMatcher(aggrNode.getAsName().fieldName());
                        String[] fromParts = Utils.getNonEmpty(fromName.parts());
                        if (fromParts.length != (toParts = Utils.getNonEmpty(toName.parts())).length) {
                            throw new IllegalArgumentException("Wildcard mismatch '" + aggrNodeFieldName + "' as '" + aggrNode.getAsName() + "'.");
                        }
                        String toField = StringUtils.replaceEach((String)field.fieldName(), (String[])fromParts, (String[])toParts);
                        newAggrNode = StatsTransformer.createNewAggregateNode(aggrNode, field, SearchResult.FieldMeta.newFieldMeta(toField), info.aggregator());
                    }
                    if (wcMapping.containsKey(newAggrNode.node().getDefaultName())) continue;
                    newAggrNodes.add(newAggrNode);
                    wcMapping.put(newAggrNode.node().getDefaultName(), field.fieldName());
                }
            }
        } else {
            newAggrNodes = aggrNodes.infos();
        }
        int newAggrNodesLen = newAggrNodes.size();
        for (int k = 0; k < keySrList.size(); ++k) {
            for (int i = 0; i < newAggrNodesLen; ++i) {
                Object computedValue;
                FunctionNode evalFunc;
                StatsAggrInfo info = newAggrNodes.get(i);
                Aggregator aggregator = info.aggregator();
                StatsAggregateNode aggrNode = info.node();
                SearchResult.FieldMeta asName = aggrNode.getAsName();
                SearchResult.FieldMeta fieldName = aggrNode.getFieldName();
                if (fieldName == null && (evalFunc = aggrNode.getAggregateNode().getEvalFunc()) != null) {
                    fieldName = SearchResult.FieldMeta.newFieldMeta(evalFunc.toString());
                }
                if ((computedValue = StatsTransformer.computeValues(sr, aggrNode.getAggregateNode(), aggregator, fieldName, fieldExtractionHint)) == null) continue;
                if (computedValue instanceof List) {
                    List intermediateAndValPairs = (List)computedValue;
                    int size = intermediateAndValPairs.size();
                    for (int j = 0; j < size; ++j) {
                        Pair intermediateAndValPair = (Pair)intermediateAndValPairs.get(j);
                        Pair aggrValPair = (Pair)intermediateAndValPair.second();
                        Object intermediary = intermediateAndValPair.first();
                        SearchResult aggrKeySr = (SearchResult)keySrList.get(k);
                        if (fieldName != null && intermediary != null) {
                            aggrKeySr = SearchResultFactory.getInstance().appendToSearchResult((SearchResult)keySrList.get(k), fieldName.setIsIntermediary(true), intermediary);
                        }
                        SearchResult aggrValSr = SearchResultFactory.getInstance().createSearchResult(asName, aggrValPair);
                        retList.add(new Pair<SearchResult, SearchResult>(aggrKeySr, aggrValSr));
                    }
                    continue;
                }
                Pair value = (Pair)computedValue;
                Pair aggrValPair = (Pair)value.second();
                SearchResult aggrValSr = SearchResultFactory.getInstance().createSearchResult(asName, aggrValPair);
                retList.add(new Pair(keySrList.get(k), aggrValSr));
            }
        }
        return retList;
    }

    private static ArrayList<ArrayList<Object>> getKeyFieldValuelist(ArrayList<Object> keyFieldValues) {
        ArrayList<ArrayList<Object>> resultList = new ArrayList<ArrayList<Object>>();
        resultList.add(new ArrayList());
        for (int i = 0; i < keyFieldValues.size(); ++i) {
            Object val = keyFieldValues.get(i);
            Object[] arr = null;
            arr = !(val instanceof String[]) ? new Object[]{val} : (Object[])val;
            ArrayList curResultList = new ArrayList();
            for (int j = 0; j < arr.length; ++j) {
                for (int k = 0; k < resultList.size(); ++k) {
                    ArrayList<Object> tmp = new ArrayList<Object>((Collection)resultList.get(k));
                    tmp.add(arr[j]);
                    curResultList.add(tmp);
                }
            }
            resultList = curResultList;
        }
        return resultList;
    }

    private static boolean requiresDownProcessing(AggregateFunction func) {
        return Utils.requireDownProcessing(func);
    }

    private static Object computeValues(SearchResult sr, AggregateNode aggrNode, Aggregator aggregator, SearchResult.FieldMeta field, FieldExtractor.ExtractionHint fieldExtractionHint) {
        AggregateFunction aggregateFunction = aggrNode.getFunction();
        FieldExtractor fieldExtractor = FieldExtractorFactory.getInstance().getFieldExtractor(aggregateFunction);
        Object extract = fieldExtractor.extract(sr, aggrNode, field, fieldExtractionHint);
        if (extract == null) {
            return null;
        }
        if (StatsTransformer.requiresDownProcessing(aggregateFunction) && extract instanceof Collection) {
            Collection extracts = (Collection)extract;
            ArrayList<Pair<Object, Pair<Aggregator, AggregateValue>>> ret = new ArrayList<Pair<Object, Pair<Aggregator, AggregateValue>>>(extracts.size() + 1);
            for (Object extractObj : extracts) {
                AggregateValue aggregateValue = aggregator.getSeed();
                Pair<Aggregator, AggregateValue> aggrVal = new Pair<Aggregator, AggregateValue>(aggregator, aggregator.aggregate(aggregateValue, extractObj));
                Pair pair = new Pair(extractObj, aggrVal);
                ret.add(pair);
            }
            if (ret.size() == 0 && (aggregateFunction == AggregateFunction.DC || aggregateFunction == AggregateFunction.DISTINCT_COUNT)) {
                Pair<Aggregator, DistinctCountAggregateValue> aggrVal = new Pair<Aggregator, DistinctCountAggregateValue>(aggregator, new DistinctCountAggregateValue(0L));
                ret.add(new Pair<Object, Pair<Aggregator, DistinctCountAggregateValue>>(null, aggrVal));
            }
            return ret;
        }
        AggregateValue aggregateValue = aggregator.getSeed();
        Pair<Aggregator, AggregateValue> aggrVal = new Pair<Aggregator, AggregateValue>(aggregator, aggregator.aggregate(aggregateValue, extract));
        Pair<Object, Pair<Aggregator, AggregateValue>> pair = new Pair<Object, Pair<Aggregator, AggregateValue>>(null, aggrVal);
        return pair;
    }

    @Override
    public String name() {
        return "StatsTransformer";
    }

    private static class StatsAggrInfos
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ArrayList<StatsAggrInfo> infos;
        private boolean containsWC;

        StatsAggrInfos(ArrayList<StatsAggrInfo> infos, boolean containsWC) {
            this.infos = infos;
            this.containsWC = containsWC;
        }

        public ArrayList<StatsAggrInfo> infos() {
            return this.infos;
        }

        public boolean containsWC() {
            return this.containsWC;
        }

        public int size() {
            return this.infos.size();
        }
    }

    private static class StatsAggrInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final StatsAggregateNode node;
        private final Aggregator aggregator;
        private boolean containsWildCard = false;

        StatsAggrInfo(StatsAggregateNode node, Aggregator aggregator, boolean containsWildCard) {
            this.node = node;
            this.aggregator = aggregator;
            this.containsWildCard = containsWildCard;
        }

        public StatsAggregateNode node() {
            return this.node;
        }

        public boolean containsWildCard() {
            return this.containsWildCard;
        }

        public Aggregator aggregator() {
            return this.aggregator;
        }

        public String toString() {
            return String.format("node: %s, aggregator: %s, contains wildcard: %b", this.node.toString(), this.aggregator.toString(), this.containsWildCard);
        }
    }
}

