/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers;

import com.splunk.commons.Row;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.NullNode;
import com.splunk.commons.visitors.ExpressionEvaluator;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.MapPartitioner;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.BaseTransformerFactory;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.util.MultiValueFieldParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class EvalTransformer
implements Transformer {
    static final Logger logger = Logger.getLogger(EvalTransformer.class);

    @Override
    public DistributedDataset transform(DistributedDataset dd, CommandNode qcmd, boolean streaming, ComputeEngineContext ctx) {
        return EvalTransformer._transform(ctx, dd, (EvalCommand)qcmd, streaming);
    }

    private static DistributedDataset _transform(ComputeEngineContext ctx, DistributedDataset dd, EvalCommand evalCmd, final boolean streaming) {
        boolean executeExternal;
        DistributedDataset outputdd = dd;
        CommandNode srcCmd = evalCmd.getSource();
        boolean bl = executeExternal = !BaseTransformerFactory.getInstance().canExecuteExternal((CommandNode)evalCmd, srcCmd);
        if (executeExternal) {
            logger.debug((Object)"Will execute base transformer to input create dataset");
            outputdd = BaseTransformerFactory.getInstance().transform(outputdd, (CommandNode)evalCmd, ctx);
        } else {
            String cmdName = srcCmd.getCommandName();
            Transformer t = ((TransformerRegistry)ctx.get("dfs.dataset.transformer.registry")).getTransformer(srcCmd);
            outputdd = t.transform(outputdd, srcCmd, streaming, ctx);
            logger.debug((Object)String.format("Will apply eval expression processing on output of %s transformer", cmdName));
        }
        final AssignmentNode[] assignmentNodes = evalCmd.getAssignments();
        final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
        MapPartitioner evalExpression = new MapPartitioner(){
            private static final long serialVersionUID = 1L;

            @Override
            public Iterator<SearchResult> mapPartitions(int partitionId, Iterator<SearchResult> iterator) {
                LinkedList<SearchResult> fifo = new LinkedList<SearchResult>();
                while (iterator.hasNext()) {
                    SearchResult searchResult = iterator.next();
                    Row row = this.convert(searchResult);
                    ArrayList<SearchResult.FieldMeta> names = new ArrayList<SearchResult.FieldMeta>();
                    for (SearchResult.FieldMeta fieldMeta2 : searchResult.getFieldNames()) {
                        Object multiValueFieldValue;
                        names.add(fieldMeta2);
                        if (!row.containsKey("__mv_" + fieldMeta2) && row.get(fieldMeta2.toString()) instanceof Object[] || !((multiValueFieldValue = row.get("__mv_" + fieldMeta2)) instanceof String) || multiValueFieldValue.equals("")) continue;
                        row.put(fieldMeta2.toString(), (Object)MultiValueFieldParser.parse(multiValueFieldValue.toString()));
                    }
                    for (SearchResult.FieldMeta fieldMeta3 : assignmentNodes) {
                        SearchResult.FieldMeta hiddenFieldMeta;
                        Object fieldValue;
                        String fieldName = fieldMeta3.getFieldName();
                        if (fieldMeta3.getExpression() instanceof NullNode) {
                            fieldValue = row.containsKey("__mv_" + fieldName) ? "" : null;
                        } else {
                            try {
                                fieldValue = expressionEvaluator.evaluate((Node)fieldMeta3.getExpression(), row);
                            }
                            catch (Exception e) {
                                logger.debug((Object)e.getMessage());
                                fieldValue = null;
                            }
                            if (fieldValue == null && row.containsKey(fieldName)) {
                                fieldValue = "";
                                if (row.containsKey("__mv_" + fieldName)) {
                                    row.put("__mv_" + fieldName, (Object)"");
                                }
                            }
                        }
                        if (row.containsKey(fieldName)) {
                            if (fieldValue == null) {
                                names.removeIf(fieldMeta -> fieldMeta.fieldName().equals(fieldName));
                            } else if (fieldValue instanceof Object[]) {
                                hiddenFieldMeta = SearchResult.FieldMeta.newFieldMeta("__mv_" + fieldName);
                                if (!names.contains(hiddenFieldMeta)) {
                                    names.add(hiddenFieldMeta);
                                }
                                row.put(hiddenFieldMeta.fieldName(), (Object)Expression.string((String)this.encode((Object[])fieldValue)));
                            }
                        } else if (fieldValue != null) {
                            names.add(SearchResult.FieldMeta.newFieldMeta(fieldName));
                            if (fieldValue instanceof Object[]) {
                                hiddenFieldMeta = SearchResult.FieldMeta.newFieldMeta("__mv_" + fieldName);
                                if (!names.contains(hiddenFieldMeta)) {
                                    names.add(hiddenFieldMeta);
                                }
                                row.put(hiddenFieldMeta.fieldName(), (Object)Expression.string((String)this.encode((Object[])fieldValue)));
                            }
                        }
                        row.put(fieldName, fieldValue);
                    }
                    fifo.add(this.convert(row, this.normalize(names)));
                }
                return fifo.iterator();
            }

            @Override
            public boolean repartition() {
                return !streaming;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.UNKNOWN;
            }

            private Row convert(SearchResult searchResult) {
                return new Row(SearchResultFactory.convert(searchResult.getDataMap()));
            }

            private SearchResult convert(Row row, List<SearchResult.FieldMeta> names) {
                ArrayList<Pair<SearchResult.FieldMeta, Object>> field = new ArrayList<Pair<SearchResult.FieldMeta, Object>>();
                for (SearchResult.FieldMeta fieldMeta : names) {
                    field.add(new Pair<SearchResult.FieldMeta, Object>(fieldMeta, row.get(fieldMeta.fieldName())));
                }
                return SearchResultFactory.getInstance().createSearchResult(field);
            }

            private String encode(Object[] fieldValue) {
                StringBuffer encodedValue = new StringBuffer();
                String delimiter = "";
                String enclosure = "$";
                String escape = "$";
                for (Object value : fieldValue) {
                    StringBuffer formattedValue = new StringBuffer(value.toString().replace(enclosure, escape + enclosure));
                    formattedValue.insert(0, enclosure).append(enclosure);
                    formattedValue.insert(0, delimiter);
                    encodedValue.append(formattedValue);
                    delimiter = ";";
                }
                return encodedValue.toString();
            }

            private ArrayList<SearchResult.FieldMeta> normalize(ArrayList<SearchResult.FieldMeta> names) {
                ArrayList<SearchResult.FieldMeta> normalizedNames = new ArrayList<SearchResult.FieldMeta>();
                HashMap hiddenNames = new HashMap();
                names.forEach(name -> {
                    if (name.fieldName().startsWith("__mv_")) {
                        hiddenNames.put(name.fieldName(), name);
                    } else {
                        normalizedNames.add((SearchResult.FieldMeta)name);
                    }
                });
                names.forEach(name -> {
                    if (hiddenNames.containsKey("__mv_" + name.fieldName())) {
                        normalizedNames.add((SearchResult.FieldMeta)hiddenNames.remove("__mv_" + name.fieldName()));
                    }
                });
                return normalizedNames;
            }

            @Override
            public String desc() {
                return "evalTransformerProjection";
            }
        };
        outputdd = outputdd.transform(evalExpression);
        return outputdd;
    }

    @Override
    public String name() {
        return "EvalTransformer";
    }
}

