/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.splunkcompute.MapPartitionFunction;
import com.splunk.df.search.compute.splunkcompute.PartitionedDataset;
import com.splunk.df.search.compute.splunkcompute.PartitionedDatasetFactory;
import com.splunk.df.search.compute.splunkcompute.SearchResultComparator;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkReducer;
import com.splunk.df.util.Utils;
import java.util.Iterator;
import java.util.Random;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SplunkComputeTestDriver {
    static Logger logger = null;

    public static void main(String[] args) {
        int len = args.length;
        int numPars = 8;
        int parSize = 100000;
        int cardinality = 850000;
        int numCores = 4;
        boolean asc = false;
        long limit = 10L;
        if (len >= 1) {
            try {
                numPars = Integer.valueOf(args[0]);
            }
            catch (Throwable t) {
                System.out.println(String.format("num pars: could not parse: %s to int", args[0]));
            }
        }
        if (len >= 2) {
            try {
                parSize = Integer.valueOf(args[1]);
            }
            catch (Throwable t) {
                System.out.println(String.format("par size: could not parse: %s to int", args[1]));
            }
        }
        if (len >= 3) {
            try {
                cardinality = Integer.valueOf(args[2]);
            }
            catch (Throwable t) {
                System.out.println(String.format("cardinality: could not parse: %s to int", args[2]));
            }
        }
        if (len >= 4) {
            try {
                numCores = Integer.valueOf(args[3]);
            }
            catch (Throwable t) {
                System.out.println(String.format("num cores: could not parse: %s to int", args[3]));
            }
        }
        if (len >= 5) {
            try {
                asc = Boolean.valueOf(args[4]);
            }
            catch (Throwable t) {
                System.out.println(String.format("sort asc: could not parse %s to boolean", args[4]));
            }
        }
        if (len >= 6) {
            try {
                limit = Long.valueOf(args[5]);
            }
            catch (Throwable t) {
                System.out.println(String.format("limit: could not parse %s to long", args[5]));
            }
        }
        System.out.println(String.format("num pars: %d, par size: %d, cardinality: %d, num cores: %d, sort asc: %b, limit: %d", numPars, parSize, cardinality, numCores, asc, limit));
        long start = System.currentTimeMillis();
        PartitionedDataset pd = PartitionedDatasetFactory.getInstance().getNewPartitionedDataset(".", numCores, "test1");
        pd = pd.repartition(numPars);
        System.out.println(String.format("number of partitions: %d", pd.numPartitions()));
        final SearchResult.FieldMeta parIdField = SearchResult.FieldMeta.newFieldMeta("parId");
        final SearchResult.FieldMeta recIdField = SearchResult.FieldMeta.newFieldMeta("recId");
        final SearchResult.FieldMeta dataField = SearchResult.FieldMeta.newFieldMeta("data");
        final SearchResult.FieldMeta timeField = SearchResult.FieldMeta.newFieldMeta("_time");
        final int tempParSize = parSize;
        final int tempCardinality = cardinality;
        pd = pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(final int partitionId, Iterator<SplunkRecord> srs) {
                return new Iterator<SplunkRecord>(){
                    int numRecs;
                    {
                        this.numRecs = tempParSize;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.numRecs > 0;
                    }

                    @Override
                    public SplunkRecord next() {
                        SearchResult.FieldMeta[] fieldNames = new SearchResult.FieldMeta[4];
                        Object[] fieldValues = new Object[4];
                        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>();
                        Integer parIdVal = partitionId;
                        Integer recIdVal = this.numRecs;
                        StringBuilder sb = new StringBuilder();
                        sb.append("data from par id: ").append(partitionId).append(", rec id: ").append(recIdVal);
                        String dataVal = sb.toString();
                        int random = new Random().nextInt(tempCardinality);
                        Integer timeVal = random;
                        fieldNames[0] = parIdField;
                        fieldValues[0] = parIdVal;
                        data.put(parIdField, parIdVal);
                        fieldNames[1] = recIdField;
                        fieldValues[1] = recIdVal;
                        data.put(recIdField, recIdVal);
                        fieldNames[2] = dataField;
                        fieldValues[2] = dataVal;
                        data.put(dataField, dataVal);
                        fieldValues[3] = timeField;
                        fieldValues[3] = timeVal;
                        data.put(timeField, timeVal);
                        SearchResult sr = SearchResultFactory.getInstance().createSearchResult(data, fieldNames, fieldValues);
                        --this.numRecs;
                        return new SplunkRecord(sr);
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("test event generator lambda"));
            }
        }, "dataGenerated");
        final SearchResult.FieldMeta countField = SearchResult.FieldMeta.newFieldMeta("count");
        pd = pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> srs) {
                return new Iterator<SplunkRecord>(){

                    @Override
                    public boolean hasNext() {
                        return srs.hasNext();
                    }

                    @Override
                    public SplunkRecord next() {
                        SplunkRecord rec = (SplunkRecord)srs.next();
                        SearchResult sr = rec.getVal();
                        SearchResult keySr = SearchResultFactory.getInstance().createSearchResult(timeField, sr.getFieldValue(timeField));
                        SearchResult valSr = SearchResultFactory.getInstance().createSearchResult(countField, 1L);
                        return new SplunkKVRecord(keySr, valSr);
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("test kv event conversion lambda"));
            }
        }, "convertToKV");
        pd = pd.reduceByKey(new SplunkReducer(){

            @Override
            public SearchResult reduce(SearchResult lhs, SearchResult rhs) {
                long lhsCount = (Long)lhs.getFieldValue(countField);
                long rhsCount = (Long)rhs.getFieldValue(countField);
                return SearchResultFactory.getInstance().createSearchResult(countField, lhsCount + rhsCount);
            }
        }, "testReduced", false);
        pd = pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> kvSrs) {
                return new Iterator<SplunkRecord>(){

                    @Override
                    public boolean hasNext() {
                        return kvSrs.hasNext();
                    }

                    @Override
                    public SplunkRecord next() {
                        SplunkKVRecord rec = (SplunkKVRecord)kvSrs.next();
                        SearchResult key = rec.getKey();
                        SearchResult value = rec.getVal();
                        return new SplunkRecord(SearchResultFactory.getInstance().merge(key, value));
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("test kv to v merge lambda"));
            }
        }, "mergedPostReduce");
        pd = pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> srs) {
                return new Iterator<SplunkRecord>(){

                    @Override
                    public boolean hasNext() {
                        return srs.hasNext();
                    }

                    @Override
                    public SplunkRecord next() {
                        SplunkRecord rec = (SplunkRecord)srs.next();
                        SearchResult sr = rec.getVal();
                        long count = (Long)sr.getFieldValue(countField);
                        SearchResult key = SearchResultFactory.getInstance().createSearchResult(countField, count);
                        return new SplunkKVRecord(key, sr);
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("test sort kv generator lambda"));
            }
        }, "sortKVGenerated");
        SearchResult.FieldMeta[] sortFields = new SearchResult.FieldMeta[]{countField};
        boolean[] sortOrders = new boolean[]{asc};
        pd = pd.sortByKey(new SearchResultComparator(sortFields, sortOrders), "testSorted");
        pd = pd.mapPartitions(new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, final Iterator<SplunkRecord> kvSrs) {
                return new Iterator<SplunkRecord>(){

                    @Override
                    public boolean hasNext() {
                        return kvSrs.hasNext();
                    }

                    @Override
                    public SplunkRecord next() {
                        SplunkKVRecord kvSr = (SplunkKVRecord)kvSrs.next();
                        SearchResult key = kvSr.getKey();
                        SearchResult val = kvSr.getVal();
                        return new SplunkRecord(SearchResultFactory.getInstance().merge(key, val));
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("test post sort kv merge to v lambda"));
            }
        }, "mergedPostSort");
        Iterator<SplunkRecord> results = pd.iterator(limit);
        long count = 0L;
        while (results.hasNext()) {
            SplunkRecord sr = results.next();
            System.out.println(String.format("final result: %s", sr.toString()));
            ++count;
        }
        System.out.println(String.format("total time for execution: %d millis, number of results: %d", System.currentTimeMillis() - start, count));
        PartitionedDatasetFactory.getInstance().close();
    }

    static {
        PropertyConfigurator.configure((String)(System.getenv("SPARK_HOME") + "/conf/log4j.properties"));
        logger = Logger.getLogger(SplunkComputeTestDriver.class);
    }
}

