/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.df.search.compute.ComputeEngine;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.ExecutionHints;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.splunkcompute.PartitionedDatasetFactory;
import com.splunk.df.search.compute.splunkcompute.SplunkComputeDataset;
import com.splunk.df.search.compute.splunkcompute.SplunkComputeExecutionHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SplunkComputeEngine
implements ComputeEngine {
    static final Logger logger = Logger.getLogger(SplunkComputeEngine.class);
    private ComputeEngineContext ctx;
    private ArrayList<SplunkComputeDataset> rootScds = new ArrayList();
    private int numCores;
    private boolean isClosed = false;

    private static void registerTransformers(ComputeEngineContext ctx) {
        TransformerRegistry tr = (TransformerRegistry)ctx.get("dfs.dataset.transformer.registry");
        if (tr == null) {
            tr = new TransformerRegistry();
            ctx.addContext("dfs.dataset.transformer.registry", tr);
        }
        tr.registerTransformer("stats", SplunkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.StatsTransformer"));
        tr.registerTransformer("sort", SplunkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.SortTransformer"));
        tr.registerTransformer("head", SplunkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.HeadTransformer"));
        tr.registerTransformer("fields", SplunkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.FieldsTransformer"));
        tr.registerTransformer("table", SplunkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.TableTransformer"));
        tr.registerTransformer("unknown", SplunkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.ExternalTransformerImpl"));
        tr.registerTransformer("noop", SplunkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.NoopTransformer"));
        tr.registerTransformer("rename", SplunkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.RenameTransformer"));
        tr.registerTransformer("where", SplunkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.WhereTransformer"));
        tr.registerTransformer("eval", SplunkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.EvalTransformer"));
    }

    private static Transformer createTransformer(ComputeEngineContext ctx, String clazz) {
        try {
            Transformer transformer = (Transformer)Class.forName(clazz).newInstance();
            logger.debug((Object)("Created transformer: " + clazz));
            return transformer;
        }
        catch (Throwable t) {
            logger.error((Object)("Could not create trasformer: " + clazz), t);
            throw new RuntimeException("could not create distributed dataset transformer", t);
        }
    }

    @Override
    public void close() throws IOException {
        PartitionedDatasetFactory.getInstance().close();
        this.isClosed = true;
    }

    @Override
    public DistributedDataset executeBatchSearch(DistributedDataset start, CommandNode query) {
        String cmdName = query.getCommandName();
        logger.info((Object)String.format("executing batch search with starting command name: %s", cmdName));
        Transformer t = ((TransformerRegistry)this.ctx.get("dfs.dataset.transformer.registry")).getTransformer(query);
        if (t == null) {
            logger.error((Object)("could not find transformer for command: " + cmdName));
            throw new RuntimeException("could not find transformer for command: " + cmdName);
        }
        logger.info((Object)("Found transformer: " + t.name()));
        start = t.transform(start, query, true, this.ctx);
        return start;
    }

    @Override
    public DistributedDataset executeBatchSearch(CommandNode query) {
        logger.info((Object)String.format("splunk compute engine: executing batch search with query: %s", query.accept((NodeVisitor)new SplFormatter())));
        SplunkComputeDataset scd = new SplunkComputeDataset(this, this.ctx);
        this.rootScds.add(scd);
        return this.executeBatchSearch(scd, query);
    }

    @Override
    public void setContext(ComputeEngineContext ctx) {
        this.ctx = ctx;
        this.numCores = (Integer)ctx.get("numCores");
        ExecutionHints seh = this.getExecutionHints(ctx);
        ctx.addContext("execution.hints", seh);
        SplunkComputeEngine.registerTransformers(ctx);
        logger.info((Object)"registered all transformers");
    }

    @Override
    public DistributedDataset emptyDataset() {
        SplunkComputeDataset scd = new SplunkComputeDataset(this, this.ctx);
        this.rootScds.add(scd);
        return scd;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public List<String> updateWorkers(int requested) {
        throw new RuntimeException("splunk compute engine: unsupported operation");
    }

    @Override
    public void printWorkerDetails() {
    }

    @Override
    public void unconstrainedParallelism(boolean unconstrained) {
    }

    @Override
    public int numActiveWorkers() {
        return 1;
    }

    @Override
    public void setCurrentJobDescription(String desc) {
    }

    @Override
    public ExecutionHints getExecutionHints(ComputeEngineContext ctx) {
        int dfcMemoryMbs = (Integer)ctx.get("driver.memory.mbs");
        int dfcCores = (Integer)ctx.get("driver.cores");
        SplunkComputeExecutionHints seh = new SplunkComputeExecutionHints(dfcMemoryMbs, dfcCores);
        return seh;
    }

    @Override
    public int coresPerWorker() {
        return this.numCores;
    }

    @Override
    public ComputeEngineContext getContext() {
        return this.ctx;
    }
}

