/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.splunkcompute.Partitioner;
import com.splunk.df.search.compute.splunkcompute.SplunkComparator;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;
import java.util.List;

public class RangePartitioner
implements Partitioner {
    private final List<SplunkRecord> ranges;
    private final SplunkComparator comparator;

    RangePartitioner(SplunkComparator comparator, List<SplunkRecord> ranges) {
        this.ranges = ranges;
        this.comparator = comparator;
    }

    @Override
    public int partition(SplunkRecord sr) {
        SplunkKVRecord kvSr = (SplunkKVRecord)sr;
        int size = this.ranges.size();
        int parId = -1;
        for (int i = 0; i < size; ++i) {
            SplunkKVRecord range = (SplunkKVRecord)this.ranges.get(i);
            if (this.comparator.compare(range, kvSr) <= 0) continue;
            parId = i;
            break;
        }
        if (parId < 0) {
            parId = size;
        }
        return parId;
    }
}

