/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.splunkcompute.Flushable;
import com.splunk.df.search.compute.splunkcompute.MapPartitionFunction;
import com.splunk.df.search.compute.splunkcompute.Serdes;
import com.splunk.df.search.compute.splunkcompute.SerdesFactory;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkReducer;
import com.splunk.df.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class Partition
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(Partition.class);
    private final int partitionId;
    private final MapPartitionFunction transformFunc;
    private String datasetUUID;
    private final String workDir;
    private LinkedBlockingDeque<Pair<File, Flushable>> tempFlushables = new LinkedBlockingDeque();
    private Integer tempFileIdx = 0;
    private final String tempFileNamePrefix;
    private static Serdes serdes = SerdesFactory.getInstance().getSerdes();

    public Partition(String workDir, String datasetUUID, int partitionId) {
        this(workDir, datasetUUID, partitionId, new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                return srs;
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("empty lambda"));
            }
        });
    }

    protected String getWorkDir() {
        return this.workDir;
    }

    protected String getDatasetUUID() {
        return this.datasetUUID;
    }

    public void setUUID(String datasetUUID) {
        this.datasetUUID = datasetUUID;
    }

    public MapPartitionFunction transformFunc() {
        return this.transformFunc;
    }

    public Partition merge(Partition partition) {
        final MapPartitionFunction rhs = partition.transformFunc();
        return new Partition(this.workDir, this.datasetUUID, this.partitionId, new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                SplunkRecord sr;
                Iterator<SplunkRecord> lhsSrs = Partition.this.transformFunc.call(partitionId, srs);
                Iterator<SplunkRecord> rhsSrs = rhs.call(partitionId, srs);
                ArrayList<SplunkRecord> ret = new ArrayList<SplunkRecord>();
                while (lhsSrs.hasNext()) {
                    sr = lhsSrs.next();
                    ret.add(sr);
                }
                while (rhsSrs.hasNext()) {
                    sr = rhsSrs.next();
                    ret.add(sr);
                }
                return ret.iterator();
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("partition merge lambda"));
            }
        });
    }

    public Partition(String workDir, String datasetUUID, int partitionId, MapPartitionFunction transformFunc) {
        this.partitionId = partitionId;
        this.transformFunc = transformFunc;
        this.datasetUUID = datasetUUID;
        this.workDir = workDir;
        this.tempFileNamePrefix = this.getTempFilePrefix();
    }

    private String getTempFilePrefix() {
        return String.format("%s/%s_%d_%d", this.workDir, this.datasetUUID, System.currentTimeMillis(), this.partitionId);
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Partition mapPartition(final MapPartitionFunction transformFunc) {
        final MapPartitionFunction source = this.transformFunc;
        return new Partition(this.workDir, this.datasetUUID, this.partitionId, new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> srs) {
                Iterator<SplunkRecord> input = source.call(partitionId, srs);
                return transformFunc.call(partitionId, input);
            }

            @Override
            public String desc() {
                return String.format("stitch lambda %s: source: %s, executing: %s, partition: %d", Utils.toString(new Throwable("stiching lambda")), source.desc(), transformFunc.desc(), Partition.this.partitionId);
            }
        });
    }

    public Partition setPartitionId(int parId) {
        return new Partition(this.workDir, this.datasetUUID, parId, this.transformFunc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void temp(Iterator<SplunkRecord> srs) {
        try {
            Pair<File, Flushable> fileFlushable = this.tempFlushables.pollFirst(10L, TimeUnit.MILLISECONDS);
            if (fileFlushable == null) {
                int index;
                Integer n = this.tempFileIdx;
                synchronized (n) {
                    Integer n2 = this.tempFileIdx;
                    Integer n3 = this.tempFileIdx = Integer.valueOf(this.tempFileIdx + 1);
                    index = this.tempFileIdx;
                }
                String tempFileName = String.format("%s_%d.partition", this.tempFileNamePrefix, index);
                File tempFile = new File(tempFileName);
                int tries = 0;
                while (!tempFile.createNewFile()) {
                    if (++tries > 10) {
                        throw new RuntimeException(String.format("max attempts to create file exceeded: %s - attempts: %d", tempFileName, tries));
                    }
                    tempFileName = String.format("%s_%d", tempFileName, tries);
                }
                tempFile.deleteOnExit();
                FileOutputStream os = new FileOutputStream(tempFile);
                Flushable flushable = serdes.createWriter(os);
                fileFlushable = new Pair<File, Flushable>(tempFile, flushable);
            }
            Flushable flushable = fileFlushable.second();
            serdes.write(flushable, srs);
            while (!this.tempFlushables.offerLast(fileFlushable)) {
                Utils.sleep(10L);
            }
        }
        catch (Throwable t) {
            logger.error((Object)String.format("could not temp partition: %d, reason: %s", this.partitionId, t.getMessage()), t);
            throw new RuntimeException(t);
        }
    }

    protected Iterator<SplunkRecord> readFromTemp() {
        if (this.tempFlushables.isEmpty()) {
            return new ArrayList().iterator();
        }
        final Iterator<Pair<File, Flushable>> fileFlushables = this.tempFlushables.iterator();
        return new Iterator<SplunkRecord>(){
            private Iterator<SplunkRecord> srses = new ArrayList().iterator();
            private File tempFile;

            @Override
            public boolean hasNext() {
                if (this.srses.hasNext()) {
                    return true;
                }
                try {
                    while (fileFlushables.hasNext()) {
                        Pair fileFlushable = (Pair)fileFlushables.next();
                        Flushable flushable = (Flushable)fileFlushable.second();
                        if (!flushable.ended()) {
                            serdes.end(flushable);
                            flushable.flush();
                            flushable.end();
                        }
                        this.tempFile = (File)fileFlushable.first();
                        FileInputStream is = new FileInputStream(this.tempFile);
                        this.srses = serdes.read(flushable, is);
                        if (!this.srses.hasNext()) continue;
                        return true;
                    }
                    return false;
                }
                catch (Throwable t) {
                    logger.info((Object)String.format("could not read partition: %d from temp, reason: %s", Partition.this.partitionId, t.getMessage()), t);
                    throw new RuntimeException(t);
                }
            }

            @Override
            public SplunkRecord next() {
                return this.srses.next();
            }
        };
    }

    public Partition reduceByKey(final SplunkReducer reducer) {
        final MapPartitionFunction source = this.transformFunc();
        return new Partition(this.getWorkDir(), this.getDatasetUUID(), this.partitionId(), new MapPartitionFunction(){

            @Override
            public Iterator<SplunkRecord> call(int partitionId, Iterator<SplunkRecord> kvSrs) {
                Iterator<SplunkRecord> input = source.call(partitionId, new ArrayList().iterator());
                HashMap<SearchResult, SearchResult> reducedSrs = new HashMap<SearchResult, SearchResult>();
                while (input.hasNext()) {
                    SplunkRecord sr = input.next();
                    if (!(sr instanceof SplunkKVRecord)) {
                        throw new RuntimeException(String.format("for reduce by key operation the splunk record needs to be converted to splunk kv record", sr.toString()));
                    }
                    SplunkKVRecord kvSr = (SplunkKVRecord)sr;
                    SearchResult key = kvSr.getKey();
                    SearchResult val = kvSr.getVal();
                    SearchResult calcVal = (SearchResult)reducedSrs.get(key);
                    if (calcVal != null) {
                        calcVal = reducer.reduce(val, calcVal);
                        reducedSrs.put(key, calcVal);
                        continue;
                    }
                    reducedSrs.put(key, val);
                }
                final Iterator entries = reducedSrs.entrySet().iterator();
                return new Iterator<SplunkRecord>(){

                    @Override
                    public boolean hasNext() {
                        return entries.hasNext();
                    }

                    @Override
                    public SplunkRecord next() {
                        Map.Entry entry = (Map.Entry)entries.next();
                        return new SplunkKVRecord((SearchResult)entry.getKey(), (SearchResult)entry.getValue());
                    }
                };
            }

            @Override
            public String desc() {
                return Utils.toString(new Throwable("reduce by key lambda"));
            }
        });
    }

    public Iterator<SplunkRecord> iterator() {
        return this.transformFunc.call(this.partitionId, new ArrayList().iterator());
    }
}

