/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.spark.KryoRegisteredClassHolder;
import com.splunk.df.search.compute.splunkcompute.Flushable;
import com.splunk.df.search.compute.splunkcompute.Serdes;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class KryoSerdes
implements Serdes {
    static final Logger logger = Logger.getLogger(KryoSerdes.class);

    @Override
    public void write(Flushable flushable, Iterator<SplunkRecord> srs) throws IOException {
        Pair kryoOutput = (Pair)flushable.source();
        Output output = (Output)kryoOutput.second();
        Kryo kryo = (Kryo)kryoOutput.first();
        while (srs.hasNext()) {
            SplunkRecord sr = srs.next();
            kryo.writeClassAndObject(output, (Object)sr);
        }
    }

    @Override
    public Iterator<SplunkRecord> read(Flushable flushable, InputStream is) throws IOException {
        final Input input = new Input((InputStream)new BufferedInputStream(is));
        Pair source = (Pair)flushable.source();
        final Kryo kryo = (Kryo)source.first();
        return new Iterator<SplunkRecord>(){
            private SplunkRecord sr;
            private boolean eof = false;

            @Override
            public boolean hasNext() {
                if (this.sr != null) {
                    return true;
                }
                if (this.eof) {
                    return false;
                }
                Object obj = kryo.readClassAndObject(input);
                if (obj instanceof EndOfFile) {
                    this.eof = true;
                    return false;
                }
                this.sr = (SplunkRecord)obj;
                return true;
            }

            @Override
            public SplunkRecord next() {
                if (this.sr == null && !this.hasNext()) {
                    logger.error((Object)String.format("no records available in temp", new Object[0]));
                    throw new RuntimeException(String.format("no records available in temp", new Object[0]));
                }
                SplunkRecord ret = this.sr;
                this.sr = null;
                return ret;
            }
        };
    }

    @Override
    public void end(Flushable flushable) {
        Pair kryoOutput = (Pair)flushable.source();
        Output output = (Output)kryoOutput.second();
        Kryo kryo = (Kryo)kryoOutput.first();
        kryo.writeClassAndObject(output, (Object)new EndOfFile());
    }

    @Override
    public Flushable createWriter(OutputStream os) {
        final BufferedOutputStream bos = new BufferedOutputStream(os);
        final Output output = new Output((OutputStream)bos);
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.setCopyReferences(false);
        kryo.setRegistrationRequired(true);
        String extraClassesToRegisterWithKryo = System.getProperty("DFC_EXTRA_KRYO_CLASSES");
        if (extraClassesToRegisterWithKryo == null) {
            extraClassesToRegisterWithKryo = "";
        }
        for (Class c : KryoRegisteredClassHolder.getClasses(extraClassesToRegisterWithKryo)) {
            kryo.register(c);
        }
        kryo.register(EndOfFile.class);
        kryo.register(SplunkRecord.class);
        kryo.register(SplunkKVRecord.class);
        final Pair<Kryo, Output> kryoOutput = new Pair<Kryo, Output>(kryo, output);
        return new Flushable(){
            boolean ended = false;

            @Override
            public void flush() throws IOException {
                output.flush();
                bos.flush();
            }

            @Override
            public Object source() {
                return kryoOutput;
            }

            @Override
            public void end() {
                this.ended = true;
            }

            @Override
            public boolean ended() {
                return this.ended;
            }
        };
    }

    public static void main(String[] args) {
        SearchResult.FieldMeta keyFld1 = SearchResult.FieldMeta.newFieldMeta("KeyField1");
        String keyVal1 = "KeyVal1";
        SearchResult.FieldMeta keyFld2 = SearchResult.FieldMeta.newFieldMeta("KeyField2");
        Integer keyVal2 = 10;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> keyData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>();
        SearchResult.FieldMeta[] keyFields = new SearchResult.FieldMeta[2];
        Object[] keyVals = new Object[2];
        keyFields[0] = keyFld1;
        keyFields[1] = keyFld2;
        keyVals[0] = keyVal1;
        keyVals[1] = keyVal2;
        keyData.put(keyFld1, keyVal1);
        keyData.put(keyFld2, keyVal2);
        SearchResult keySr = SearchResultFactory.getInstance().createSearchResult(keyData, keyFields, keyVals);
        SearchResult.FieldMeta valFld1 = SearchResult.FieldMeta.newFieldMeta("ValueField1");
        String valVal1 = "ValVal1";
        SearchResult.FieldMeta valFld2 = SearchResult.FieldMeta.newFieldMeta("ValField2");
        Integer valVal2 = 20;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> valData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>();
        SearchResult.FieldMeta[] valFields = new SearchResult.FieldMeta[2];
        Object[] valVals = new Object[2];
        valFields[0] = valFld1;
        valFields[1] = valFld2;
        valVals[0] = valVal1;
        valVals[1] = valVal2;
        valData.put(valFld1, valVal1);
        valData.put(valFld2, valVal2);
        SearchResult valSr = SearchResultFactory.getInstance().createSearchResult(valData, valFields, valVals);
        ArrayList<SplunkKVRecord> kvSrs = new ArrayList<SplunkKVRecord>();
        SplunkKVRecord kvSr = new SplunkKVRecord(keySr, valSr);
        kvSrs.add(kvSr);
        keyFld1 = SearchResult.FieldMeta.newFieldMeta("KeyField1_1");
        keyVal1 = "KeyVal1_1";
        keyFld2 = SearchResult.FieldMeta.newFieldMeta("KeyField2_1");
        keyVal2 = 30;
        keyData = new SearchResult.SRHashMap();
        keyFields = new SearchResult.FieldMeta[2];
        keyVals = new Object[2];
        keyFields[0] = keyFld1;
        keyFields[1] = keyFld2;
        keyVals[0] = keyVal1;
        keyVals[1] = keyVal2;
        keyData.put(keyFld1, keyVal1);
        keyData.put(keyFld2, keyVal2);
        keySr = SearchResultFactory.getInstance().createSearchResult(keyData, keyFields, keyVals);
        valFld1 = SearchResult.FieldMeta.newFieldMeta("ValueField1");
        valVal1 = "ValVal1";
        valFld2 = SearchResult.FieldMeta.newFieldMeta("ValField2");
        valVal2 = 40;
        valData = new SearchResult.SRHashMap();
        valFields = new SearchResult.FieldMeta[2];
        valVals = new Object[2];
        valFields[0] = valFld1;
        valFields[1] = valFld2;
        valVals[0] = valVal1;
        valVals[1] = valVal2;
        valData.put(valFld1, valVal1);
        valData.put(valFld2, valVal2);
        valSr = SearchResultFactory.getInstance().createSearchResult(valData, valFields, valVals);
        kvSr = new SplunkKVRecord(keySr, valSr);
        kvSrs.add(kvSr);
        try {
            KryoSerdes serdes = new KryoSerdes();
            File file = File.createTempFile("test", ".kryo");
            FileOutputStream bos = new FileOutputStream(file);
            Flushable flushable = serdes.createWriter(bos);
            serdes.write(flushable, kvSrs.iterator());
            serdes.end(flushable);
            flushable.flush();
            FileInputStream is = new FileInputStream(file);
            Iterator<SplunkRecord> readKvSrs = serdes.read(flushable, is);
            while (readKvSrs.hasNext()) {
                SplunkRecord readKvSr = readKvSrs.next();
                System.out.println(String.format("read kv srs: %s", readKvSr));
            }
            file.deleteOnExit();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static class EndOfFile
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private EndOfFile() {
        }
    }
}

