/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.splunkcompute;

import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.splunkcompute.Flushable;
import com.splunk.df.search.compute.splunkcompute.Serdes;
import com.splunk.df.search.compute.splunkcompute.SplunkKVRecord;
import com.splunk.df.search.compute.splunkcompute.SplunkRecord;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class JavaSerdes
implements Serdes {
    static final Logger logger = Logger.getLogger(JavaSerdes.class);

    @Override
    public void write(Flushable flushable, Iterator<SplunkRecord> srs) throws IOException {
        ObjectOutputStream oos = (ObjectOutputStream)flushable.source();
        while (srs.hasNext()) {
            SplunkRecord sr = srs.next();
            oos.writeObject(sr);
        }
    }

    @Override
    public Iterator<SplunkRecord> read(Flushable flushable, InputStream is) throws IOException {
        final ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
        return new Iterator<SplunkRecord>(){
            SplunkRecord sr;
            boolean eof = false;

            @Override
            public boolean hasNext() {
                try {
                    if (this.sr != null) {
                        return true;
                    }
                    if (this.eof) {
                        return false;
                    }
                    Object rec = ois.readObject();
                    if (rec instanceof EndOfFile) {
                        this.eof = true;
                        return false;
                    }
                    this.sr = (SplunkRecord)rec;
                    return true;
                }
                catch (Throwable t) {
                    logger.info((Object)String.format("could not read records frm temp file, reason: %s", t.getMessage()));
                    throw new RuntimeException(t);
                }
            }

            @Override
            public SplunkRecord next() {
                if (this.sr == null && !this.hasNext()) {
                    logger.error((Object)String.format("no records available in temp", new Object[0]));
                    throw new RuntimeException(String.format("no records available in temp", new Object[0]));
                }
                SplunkRecord ret = this.sr;
                this.sr = null;
                return ret;
            }
        };
    }

    @Override
    public void end(Flushable flushable) throws IOException {
        ObjectOutputStream oos = (ObjectOutputStream)flushable.source();
        oos.writeObject(new EndOfFile());
    }

    @Override
    public Flushable createWriter(OutputStream os) {
        try {
            final ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(os));
            return new Flushable(){
                boolean ended = false;

                @Override
                public void flush() throws IOException {
                    if (this.ended) {
                        return;
                    }
                    oos.flush();
                }

                @Override
                public Object source() {
                    return oos;
                }

                @Override
                public void end() {
                    this.ended = true;
                }

                @Override
                public boolean ended() {
                    return this.ended;
                }
            };
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public static void main(String[] args) {
        SearchResult.FieldMeta keyFld1 = SearchResult.FieldMeta.newFieldMeta("KeyField1");
        String keyVal1 = "KeyVal1";
        SearchResult.FieldMeta keyFld2 = SearchResult.FieldMeta.newFieldMeta("KeyField2");
        Integer keyVal2 = 10;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> keyData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>();
        SearchResult.FieldMeta[] keyFields = new SearchResult.FieldMeta[2];
        Object[] keyVals = new Object[2];
        keyFields[0] = keyFld1;
        keyFields[1] = keyFld2;
        keyVals[0] = keyVal1;
        keyVals[1] = keyVal2;
        keyData.put(keyFld1, keyVal1);
        keyData.put(keyFld2, keyVal2);
        SearchResult keySr = SearchResultFactory.getInstance().createSearchResult(keyData, keyFields, keyVals);
        SearchResult.FieldMeta valFld1 = SearchResult.FieldMeta.newFieldMeta("ValueField1");
        String valVal1 = "ValVal1";
        SearchResult.FieldMeta valFld2 = SearchResult.FieldMeta.newFieldMeta("ValField2");
        Integer valVal2 = 20;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> valData = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>();
        SearchResult.FieldMeta[] valFields = new SearchResult.FieldMeta[2];
        Object[] valVals = new Object[2];
        valFields[0] = valFld1;
        valFields[1] = valFld2;
        valVals[0] = valVal1;
        valVals[1] = valVal2;
        valData.put(valFld1, valVal1);
        valData.put(valFld2, valVal2);
        SearchResult valSr = SearchResultFactory.getInstance().createSearchResult(valData, valFields, valVals);
        ArrayList<SplunkKVRecord> kvSrs = new ArrayList<SplunkKVRecord>();
        SplunkKVRecord kvSr = new SplunkKVRecord(keySr, valSr);
        kvSrs.add(kvSr);
        keyFld1 = SearchResult.FieldMeta.newFieldMeta("KeyField1_1");
        keyVal1 = "KeyVal1_1";
        keyFld2 = SearchResult.FieldMeta.newFieldMeta("KeyField2_1");
        keyVal2 = 30;
        keyData = new SearchResult.SRHashMap();
        keyFields = new SearchResult.FieldMeta[2];
        keyVals = new Object[2];
        keyFields[0] = keyFld1;
        keyFields[1] = keyFld2;
        keyVals[0] = keyVal1;
        keyVals[1] = keyVal2;
        keyData.put(keyFld1, keyVal1);
        keyData.put(keyFld2, keyVal2);
        keySr = SearchResultFactory.getInstance().createSearchResult(keyData, keyFields, keyVals);
        valFld1 = SearchResult.FieldMeta.newFieldMeta("ValueField1");
        valVal1 = "ValVal1";
        valFld2 = SearchResult.FieldMeta.newFieldMeta("ValField2");
        valVal2 = 40;
        valData = new SearchResult.SRHashMap();
        valFields = new SearchResult.FieldMeta[2];
        valVals = new Object[2];
        valFields[0] = valFld1;
        valFields[1] = valFld2;
        valVals[0] = valVal1;
        valVals[1] = valVal2;
        valData.put(valFld1, valVal1);
        valData.put(valFld2, valVal2);
        valSr = SearchResultFactory.getInstance().createSearchResult(valData, valFields, valVals);
        kvSr = new SplunkKVRecord(keySr, valSr);
        kvSrs.add(kvSr);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JavaSerdes sd = new JavaSerdes();
            Flushable flushable = sd.createWriter(baos);
            sd.write(flushable, kvSrs.iterator());
            sd.end(flushable);
            flushable.flush();
            byte[] serData = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serData);
            Iterator<SplunkRecord> srsIter = sd.read(flushable, bais);
            while (srsIter.hasNext()) {
                SplunkKVRecord locKvSr = (SplunkKVRecord)srsIter.next();
                System.out.println(String.format("deser key: %s, value: %s", locKvSr.getKey().toString(), locKvSr.getVal().toString()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static class EndOfFile
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private EndOfFile() {
        }
    }
}

