/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.spark;

import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ExecutionHints;
import org.apache.log4j.Logger;

public class SparkExecutionHints
implements ExecutionHints,
ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(SparkExecutionHints.class);
    private final double dfcExecutorMemMbs;
    private final double dfcDriverMemMbs;
    private final int dfcNumCores;
    private final double dfcCoresPerExecutor;
    private final double factor;
    private final long maxReducePartitionSize;

    public SparkExecutionHints(double dfcExecutorMemMbs, double dfcDriverMemMbs, int dfcNumCores, double dfcCoresPerExecutor, long maxReducePartitionSize) {
        this.dfcExecutorMemMbs = dfcExecutorMemMbs;
        this.dfcDriverMemMbs = dfcDriverMemMbs;
        this.dfcNumCores = dfcNumCores;
        this.dfcCoresPerExecutor = dfcCoresPerExecutor;
        this.factor = dfcExecutorMemMbs / 12288.0 * (4.0 / dfcCoresPerExecutor);
        this.maxReducePartitionSize = maxReducePartitionSize;
    }

    protected String getEnv(String name) {
        return System.getenv(name);
    }

    public long getMaxReducePartitionSize() {
        long parSize = this.maxReducePartitionSize;
        String parSizeStr = this.getEnv("MAX_REDUCE_PARTITION_SIZE");
        if (parSizeStr != null && !parSizeStr.trim().isEmpty()) {
            parSize = Long.valueOf(parSizeStr);
            logger.info((Object)String.format("Getting maximum reduce partition size from env variables: MAX_REDUCE_PARTITION_SIZE=%d", parSize));
        }
        logger.info((Object)String.format("Max overall reduce partition size capped at: %d", parSize));
        return parSize;
    }

    private static int getShrinkRatio() {
        int ratio = 1;
        String ratioStr = System.getenv("DFS_PARTITION_SHRINK_RATIO_FOR_INTERMEDIARIES");
        if (ratioStr != null) {
            try {
                ratio = Integer.valueOf(ratioStr);
                logger.info((Object)String.format("changed default shrink ratio to: %d based on envvar", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s value: %s into int", "DFS_PARTITION_SHRINK_RATIO_FOR_INTERMEDIARIES", ratioStr));
            }
        }
        logger.info((Object)String.format("setting partition shrink ratio for absorbing intermediaries: %s", ratio));
        return ratio;
    }

    private long getAllowedRecsCount(long recsCount) {
        long max = this.maxRecords();
        if (max < recsCount) {
            logger.warn((Object)String.format("max number of records to be processed in compute: %d, total number of records: %d - rest of the records might be read and ignored if there are not enough tasks available", max, recsCount));
        }
        long ret = Math.min(recsCount, max);
        return ret;
    }

    @Override
    public int reducePartitionCount(long recsCount, int numFields) {
        recsCount = this.getAllowedRecsCount(recsCount);
        int shrinkRatio = 1;
        if (numFields <= 1) {
            numFields = 1;
            shrinkRatio = SparkExecutionHints.getShrinkRatio();
            logger.info((Object)String.format("will be using shrink ratio of: %d since there are no by-fields", shrinkRatio));
        }
        int reduceParSize = this.maxPartitionSize(numFields);
        int numPars = (int)(recsCount / (long)(reduceParSize /= shrinkRatio));
        ++numPars;
        numPars = Math.max(1, numPars);
        this.checkAllowedPartitions(numPars);
        logger.info((Object)String.format("Record count: %d, reduce partition count: %d, reduce par size: %d, cores per exec: %.2f, executor memory in mbs: %.2f, num fields: %d, shrink ratio: %d, max possible par size: %d", recsCount, numPars, reduceParSize, this.dfcCoresPerExecutor, this.dfcExecutorMemMbs, numFields, shrinkRatio, (int)this.getMaxReducePartitionSize()));
        return numPars;
    }

    private void checkAllowedPartitions(int numPars) {
        boolean check = true;
        String checkStr = System.getenv("DFS_CHECK_MAX_PARS_FOR_DRIVER");
        boolean updatedByEnvVar = false;
        if (checkStr != null && !checkStr.trim().isEmpty()) {
            try {
                check = Boolean.valueOf(checkStr);
                updatedByEnvVar = true;
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse check allowed max partitions on driver envvar to boolean: %s", checkStr));
            }
        }
        logger.info((Object)String.format("check allowed max partitions on driver: %b, updated through envvar: %b", check, updatedByEnvVar));
        if (!check) {
            return;
        }
        int maxPars = (int)(300000.0 * (this.dfcDriverMemMbs / 4096.0));
        if (numPars > (maxPars = Math.max(this.dfcNumCores, maxPars))) {
            throw new RuntimeException(String.format("maximum tasks which can be executed by this driver with mem: %.2f mbs is: %d, while the requested partitions: %d, pls increase driver memory", this.dfcDriverMemMbs, maxPars, numPars));
        }
    }

    private static double getSortParRatioToReduce() {
        double ratio = 1.0;
        String ratioStr = System.getenv("SORT_PARTITION_TO_REDUCE_RATIO");
        if (ratioStr != null) {
            try {
                ratio = Double.valueOf(ratioStr);
                logger.info((Object)String.format("sort partition ratio to reduce overridden by envvar: %.2f", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse sort partition ratio to reduce: %s as double", ratioStr));
            }
        }
        logger.info((Object)String.format("sort partition to reduce partition to be used: %.2f", ratio));
        return ratio;
    }

    @Override
    public int sortPartitionCount(long recsCount, int numfields) {
        int numPars = (int)((double)this.reducePartitionCount(recsCount, numfields) * SparkExecutionHints.getSortParRatioToReduce());
        numPars = Math.max(this.dfcNumCores, numPars);
        this.checkAllowedPartitions(numPars);
        logger.info((Object)String.format("sort partition count set to: %d", numPars));
        return numPars;
    }

    @Override
    public int lightJoinPartitionCount(long recsCount, int numfields) {
        int numPars = this.reducePartitionCount(recsCount, numfields) * 50;
        this.checkAllowedPartitions(numPars);
        numPars = Math.max(this.dfcNumCores, numPars);
        return numPars;
    }

    @Override
    public int joinPartitionCount(long recsCount, int numfields) {
        int numPars = this.reducePartitionCount(recsCount, numfields) * 50;
        this.checkAllowedPartitions(numPars);
        numPars = Math.max(this.dfcNumCores, numPars);
        return numPars;
    }

    @Override
    public int defaultPartitionCount(long recsCount, int numFields) {
        return this.reducePartitionCount(recsCount, numFields);
    }

    @Override
    public int maxPartitionSize(int numFields) {
        double parSizeDbl = 150000.0;
        double numFieldsDbl = numFields;
        double fieldFactor = 2.0 / numFieldsDbl;
        int parSize = (int)(parSizeDbl * this.factor * fieldFactor);
        long maxPossibleParSize = this.getMaxReducePartitionSize();
        parSize = Math.min(parSize, (int)maxPossibleParSize);
        logger.info((Object)String.format("par size: %d, max possible partition size: %d, num fields: %d, default num fields: %d", parSize, maxPossibleParSize, numFields, 2));
        return parSize;
    }

    @Override
    public long maxRecords() {
        long max = 1410065408L;
        String maxStr = System.getenv("DFS_MAX_RECORDS_COUNT");
        boolean setViaEnvvar = false;
        if (maxStr != null && !maxStr.trim().isEmpty()) {
            try {
                max = Long.valueOf(maxStr);
                setViaEnvvar = true;
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse max records count to long: %s", maxStr));
            }
        }
        logger.info((Object)String.format("max computable records count set to: %d via envvar: %b", max, setViaEnvvar));
        return max;
    }
}

