/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.spark;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import com.splunk.df.search.compute.ComputeEngine;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.ExecutionHints;
import com.splunk.df.search.compute.Transformer;
import com.splunk.df.search.compute.TransformerRegistry;
import com.splunk.df.search.compute.spark.SparkComputeEngineConstants;
import com.splunk.df.search.compute.spark.SparkDistributedDataset;
import com.splunk.df.search.compute.spark.SparkExecutionHints;
import com.splunk.df.search.compute.spark.SparkUtils;
import com.splunk.df.util.Utils;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;

public class SparkComputeEngine
implements ComputeEngine,
SparkComputeEngineConstants {
    static final Logger logger = Logger.getLogger(SparkComputeEngine.class);
    private JavaSparkContext jsc;
    private ComputeEngineContext ctx;
    private boolean unconstrainedParallelism = false;
    private int coresPerWorker;
    private static Integer executorsAlreadyRequested = 0;

    private static void registerTransformers(ComputeEngineContext ctx) {
        TransformerRegistry tr = (TransformerRegistry)ctx.get("dfs.dataset.transformer.registry");
        if (tr == null) {
            tr = new TransformerRegistry();
            ctx.addContext("dfs.dataset.transformer.registry", tr);
        }
        tr.registerTransformer("stats", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.StatsTransformer"));
        tr.registerTransformer("sort", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.SortTransformer"));
        tr.registerTransformer("head", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.HeadTransformer"));
        tr.registerTransformer("join", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.JoinTransformer"));
        tr.registerTransformer("fields", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.FieldsTransformer"));
        tr.registerTransformer("reverse", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.ReverseTransformer"));
        tr.registerTransformer("table", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.TableTransformer"));
        tr.registerTransformer("tail", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.TailTransformer"));
        tr.registerTransformer("unknown", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.ExternalTransformerImpl"));
        tr.registerTransformer("union", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.UnionTransformer"));
        tr.registerTransformer("dedup", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.DedupTransformer"));
        tr.registerTransformer("noop", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.NoopTransformer"));
        tr.registerTransformer("rename", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.RenameTransformer"));
        tr.registerTransformer("where", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.WhereTransformer"));
        tr.registerTransformer("eval", SparkComputeEngine.createTransformer(ctx, "com.splunk.df.search.compute.transformers.EvalTransformer"));
    }

    private static Transformer createTransformer(ComputeEngineContext ctx, String clazz) {
        try {
            Transformer transformer = (Transformer)Class.forName(clazz).newInstance();
            logger.debug((Object)("Created transformer: " + clazz));
            return transformer;
        }
        catch (Throwable t) {
            logger.error((Object)("Could not create trasformer: " + clazz), t);
            throw new RuntimeException("could not create distributed dataset transformer", t);
        }
    }

    @Override
    public void close() {
        logger.debug((Object)"Closing spark compute engine");
        this.jsc.close();
    }

    @Override
    public DistributedDataset executeBatchSearch(DistributedDataset dd, CommandNode query) {
        String cmdName = query.getCommandName();
        logger.debug((Object)("Executing batch search with starting command name: " + cmdName));
        Transformer t = ((TransformerRegistry)this.ctx.get("dfs.dataset.transformer.registry")).getTransformer(query);
        if (t == null) {
            logger.error((Object)("Could not find transformer for command: " + cmdName));
            throw new RuntimeException("could not find transformer for command: " + cmdName);
        }
        logger.debug((Object)("Found transformer: " + t.name()));
        dd = t.transform(dd, query, true, this.ctx);
        return dd;
    }

    @Override
    public void setContext(ComputeEngineContext ctx) {
        this.ctx = ctx;
        ExecutionHints seh = this.getExecutionHints(ctx);
        ctx.addContext("execution.hints", seh);
        this.jsc = (JavaSparkContext)ctx.get("java.spark.context");
        SparkComputeEngine.checkVersion(this.jsc);
        SparkComputeEngine.registerTransformers(ctx);
        SparkComputeEngine.registerExecutionListener(this.jsc.sc(), this);
        logger.debug((Object)"Registered all transformers");
    }

    private static void registerExecutionListener(final SparkContext sc, final SparkComputeEngine sce) {
        sc.addSparkListener((SparkListenerInterface)new SparkListener(){

            public void onApplicationEnd(SparkListenerApplicationEnd event) {
            }

            public void onApplicationStart(SparkListenerApplicationStart event) {
            }

            public void onBlockManagerAdded(SparkListenerBlockManagerAdded event) {
            }

            public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved event) {
            }

            public void onBlockUpdated(SparkListenerBlockUpdated event) {
            }

            public void onEnvironmentUpdate(SparkListenerEnvironmentUpdate event) {
            }

            public void onExecutorAdded(SparkListenerExecutorAdded event) {
            }

            public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate event) {
            }

            public void onExecutorRemoved(SparkListenerExecutorRemoved event) {
            }

            public void onJobEnd(SparkListenerJobEnd event) {
                logger.debug((Object)String.format("Spark job ended: id: %d, details: %s", event.jobId(), event.toString()));
            }

            public void onJobStart(SparkListenerJobStart event) {
                logger.debug((Object)String.format("Spark job started: id: %d, details: %s", event.jobId(), event.toString()));
            }

            public void onStageCompleted(SparkListenerStageCompleted event) {
                logger.debug((Object)String.format("Spark job stage completed: stage id: %d, stage name: %s, num tasks: %d, status: %s", event.stageInfo().stageId(), event.stageInfo().name(), event.stageInfo().numTasks(), event.stageInfo().getStatusString()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onStageSubmitted(SparkListenerStageSubmitted event) {
                logger.debug((Object)String.format("Spark job stage submitted: stage id: %d, stage name: %s, num tasks: %d, properties: %s, stage info details: \nTHIS IS NOT AN ERROR, IT IS A STACK TRACE OF THE DAG-NODE BEING EXECUTED AS PART OF THIS STAGE!!!!! >>>>>\n%s\n<<<<<", event.stageInfo().stageId(), event.stageInfo().name(), event.stageInfo().numTasks(), event.properties().toString(), event.stageInfo().details()));
                if (Utils.isDfsElasticModeEnabled()) {
                    int numTasks = event.stageInfo().numTasks();
                    int constraint = Utils.getTasksPerCore() * sce.coresPerWorker();
                    if (sce.unconstrainedParallelism) {
                        constraint = 1;
                        logger.info((Object)String.format("in unconstrained parallelism mode hence num tasks is same as num executors: %d", numTasks));
                        sce.unconstrainedParallelism(false);
                    } else {
                        logger.debug((Object)String.format("in constrained parallelism mode hence num executors will %d times less than num tasks", constraint));
                    }
                    int requiredExecutors = numTasks / constraint;
                    if (requiredExecutors <= 0) {
                        return;
                    }
                    if (requiredExecutors <= executorsAlreadyRequested) {
                        logger.info((Object)String.format("required executors is less than or equal to what is already requested: required: %d, already requested: %d", requiredExecutors, executorsAlreadyRequested));
                        return;
                    }
                    Integer n = executorsAlreadyRequested;
                    synchronized (n) {
                        if (requiredExecutors <= executorsAlreadyRequested) {
                            logger.info((Object)String.format("required executors just requested: required: %d, already requested: %d", requiredExecutors, executorsAlreadyRequested));
                            return;
                        }
                        executorsAlreadyRequested = executorsAlreadyRequested + (requiredExecutors -= executorsAlreadyRequested.intValue());
                        logger.info((Object)String.format("requesting additional executors: %d tasks, stage name: %s, stage id: %d, requested executors: %d, total requested till now: %d", numTasks, event.stageInfo().name(), event.stageInfo().stageId(), requiredExecutors, executorsAlreadyRequested));
                        SparkUtils.updateExecutors(sc, requiredExecutors);
                    }
                }
            }

            public void onTaskEnd(SparkListenerTaskEnd event) {
            }

            public void onTaskGettingResult(SparkListenerTaskGettingResult event) {
            }

            public void onTaskStart(SparkListenerTaskStart event) {
            }

            public void onUnpersistRDD(SparkListenerUnpersistRDD event) {
            }
        });
    }

    private static void checkVersion(JavaSparkContext ctx) {
        String version = ctx.version();
        for (int i = 0; i < supportedVersions.length; ++i) {
            String ver = supportedVersions[i];
            if (!ver.trim().equalsIgnoreCase(version)) continue;
            return;
        }
        throw new RuntimeException(String.format("Unsupported spark core version: %s", version));
    }

    @Override
    public DistributedDataset emptyDataset() {
        return new SparkDistributedDataset(this, this.ctx, this.jsc);
    }

    @Override
    public DistributedDataset executeBatchSearch(CommandNode query) {
        logger.info((Object)String.format("Spark compute engine: executing batch search with query: %s", query.accept((NodeVisitor)new SplFormatter())));
        SparkDistributedDataset dd = new SparkDistributedDataset(this, this.ctx, this.jsc);
        return this.executeBatchSearch(dd, query);
    }

    public void finalize() {
        logger.debug((Object)String.format("Compute engine objct is destroyed", new Object[0]));
    }

    @Override
    public boolean isClosed() {
        return this.jsc.sc().isStopped();
    }

    @Override
    public List<String> updateWorkers(int requested) {
        return SparkUtils.updateExecutors(this.jsc.sc(), requested);
    }

    @Override
    public void printWorkerDetails() {
        SparkUtils.printExecutorDetails(this.jsc.sc());
    }

    @Override
    public void unconstrainedParallelism(boolean unconstrained) {
        this.unconstrainedParallelism = unconstrained;
    }

    @Override
    public int numActiveWorkers() {
        return SparkUtils.numExecutors(this.jsc.sc());
    }

    @Override
    public void setCurrentJobDescription(String desc) {
        this.jsc.sc().setJobDescription(desc);
    }

    @Override
    public ExecutionHints getExecutionHints(ComputeEngineContext ctx) {
        int coresPerExecutor;
        int dfcExecutorMemMbs = (Integer)ctx.get("executor.memory.mbs");
        int dfcDriverMemMbs = (Integer)ctx.get("driver.memory.mbs");
        int numCores = (Integer)ctx.get("numCores");
        this.coresPerWorker = coresPerExecutor = ((Integer)ctx.get("cores.per.executor")).intValue();
        long maxReducePartitionSize = (Long)ctx.getOrDefault("MAX_REDUCE_PARTITION_SIZE", 500000L);
        SparkExecutionHints seh = new SparkExecutionHints(dfcExecutorMemMbs, dfcDriverMemMbs, numCores, coresPerExecutor, maxReducePartitionSize);
        return seh;
    }

    @Override
    public int coresPerWorker() {
        return this.coresPerWorker;
    }

    @Override
    public ComputeEngineContext getContext() {
        return this.ctx;
    }
}

