/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.container.felix;

import com.splunk.df.search.compute.container.SoftContainerService;
import com.splunk.df.search.compute.files.DistributedFilesMgrFactory;
import com.splunk.df.search.compute.sdk.ExternalTransformer;
import com.splunk.df.search.compute.transformers.ExternalCommandMetadataRegistry;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.felix.framework.Felix;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.util.tracker.ServiceTracker;

public class FelixSoftContainerService
implements SoftContainerService {
    private static final Logger logger = Logger.getLogger(FelixSoftContainerService.class);
    private HashMap<String, ExternalTransformer> transformers = new HashMap();
    private Felix f;

    public FelixSoftContainerService() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org.osgi.framework.system.packages.extra", String.format("%s; version=1.0.0", "com.splunk.df.search.compute.sdk"));
        map.put("org.osgi.framework.storage.clean", "onFirstInit");
        LinkedList list = new LinkedList();
        map.put("felix.systembundle.activators", list);
        map.put("ds.showtrace", "true");
        map.put("ds.showerrors", "true");
        this.f = new Felix(map);
        try {
            this.f.init();
            this.f.start();
            logger.info((Object)String.format("Felix soft container: started external search transformer soft container", new Object[0]));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @Override
    public ExternalTransformer getTransformer(ExternalCommandMetadataRegistry.ExternalCommandMetadata meta, boolean worker) {
        try {
            String etClass = meta.getClassName();
            ExternalTransformer et = this.transformers.get(etClass);
            if (et != null) {
                return et;
            }
            logger.debug((Object)String.format("Felix soft container: could not find transformer: %s in cache, hence constructing", etClass));
            if (worker) {
                String libName = meta.getLibFileName();
                String workerLibPath = DistributedFilesMgrFactory.getManager().getFilePath(libName);
                meta.setLibFilePath(workerLibPath);
                logger.debug((Object)String.format("Felix soft container: worker lib path used for transformer-> %s: %s", etClass, workerLibPath));
            } else {
                logger.debug((Object)String.format("Felix soft container: master lib path used for transformer-> %s: %s", etClass, meta.getLibFilePath()));
            }
            String jarPath = meta.getLibFilePath();
            String jarUri = "file://" + jarPath;
            logger.debug((Object)String.format("Felix soft container:  jar uri: %s", jarUri));
            Bundle b = this.f.getBundleContext().installBundle(jarUri);
            b.start();
            logger.debug((Object)String.format("Felix soft container: bundle started: %s, location: %s, bundle context: %s", b, b.getLocation(), b.getBundleContext()));
            ServiceTracker st = new ServiceTracker(b.getBundleContext(), etClass, null);
            st.open();
            logger.debug((Object)String.format("Felix soft container: opened service tracker on bundle: %s, class: %s", b.getLocation(), etClass));
            et = (ExternalTransformer)st.getService();
            this.transformers.put(etClass, et);
            logger.debug((Object)String.format("Felix soft container: external transformer handle created: jar: %s, et name: %s, et class: %s", jarPath, et.getName(), et.getClass().getName()));
            return et;
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Felix soft container: error creating transformer: %s from %s", meta.getClassName(), meta.getLibFilePath()), t);
            throw new RuntimeException(t);
        }
    }

    @Override
    public void stopService() {
        try {
            this.f.stop();
            this.f.waitForStop(0L);
            logger.info((Object)String.format("Felix soft container: container stopped", new Object[0]));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void finalize() {
        this.stopService();
    }
}

