/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.SplunkReleaseVersion;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.json.JSONObject;

public class SplunkSearchEndpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String provider = "splunk";
    private String host;
    private int port;
    private String user;
    private String password;
    private String splToExecute;
    private String app;
    private SplunkReleaseVersion version;

    public SplunkSearchEndpoint(JSONObject metaInfo) {
        String hostport = metaInfo.getString("hostport");
        String[] tokens = hostport.split(":");
        this.host = tokens[0];
        this.port = Integer.valueOf(tokens[1]);
        this.user = metaInfo.getString("username");
        this.password = metaInfo.getString("password");
        this.splToExecute = metaInfo.getString("spl");
        this.version = null;
    }

    public SplunkSearchEndpoint(String host, int port, String user, String password) {
        this(host, port, user, password, "search");
    }

    public SplunkSearchEndpoint(String host, int port, String user, String password, String app) {
        this(host, port, user, password, null, null, app);
    }

    public SplunkSearchEndpoint(String host, int port, String user, String password, String spl, SplunkReleaseVersion version) {
        this(host, port, user, password, spl, version, "search");
    }

    public SplunkSearchEndpoint(String host, int port, String user, String password, String spl, SplunkReleaseVersion version, String app) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.splToExecute = spl;
        this.version = version;
        this.app = app;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProvider() {
        return provider;
    }

    public String getSPL() {
        return this.splToExecute;
    }

    public String getApp() {
        return this.app;
    }

    public SplunkReleaseVersion getVersion() {
        return this.version;
    }

    public String toString() {
        return String.format("Splunk search endpoint: %s:%s@%s:%d -> \"%s\"", this.user, this.password, this.host, this.port, this.splToExecute);
    }

    public static void write(OutputStream os, SplunkSearchEndpoint se) throws IOException {
        Utils.write(os, se.host);
        Utils.write(os, se.port);
        Utils.write(os, se.user);
        Utils.write(os, se.password);
        if (se.splToExecute == null) {
            Utils.write(os, 1);
            SearchResultFactory.writeNullValue(os);
        } else {
            Utils.write(os, 0);
            Utils.write(os, se.splToExecute);
        }
        Utils.write(os, se.app);
        if (se.version == null) {
            Utils.write(os, 1);
            SearchResultFactory.writeNullValue(os);
        } else {
            Utils.write(os, 0);
            SplunkReleaseVersion.write(os, se.version);
        }
    }

    public static SplunkSearchEndpoint read(InputStream is) throws IOException {
        String dsHost = Utils.readString(is);
        int dsPort = Utils.readInt(is);
        String dsUser = Utils.readString(is);
        String dsPassword = Utils.readString(is);
        int isNull = Utils.readInt(is);
        String dsSplToExecute = isNull == 1 ? null : Utils.readString(is);
        String dsApp = Utils.readString(is);
        isNull = Utils.readInt(is);
        SplunkReleaseVersion dsVersion = isNull == 1 ? null : SplunkReleaseVersion.read(is);
        return new SplunkSearchEndpoint(dsHost, dsPort, dsUser, dsPassword, dsSplToExecute, dsVersion, dsApp);
    }
}

