/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.MapPartitioner;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.log4j.Logger;

@Deprecated
public class SearchResultsReceiver
implements Iterator<SearchResult>,
ComputeEngineConstants,
Closeable {
    static final Logger logger = Logger.getLogger(SearchResultsReceiver.class);
    private LinkedBlockingDeque<SearchResult> srcache = new LinkedBlockingDeque(500);
    private static ExecutorService executorService;
    private ParInfo[] parinfos;
    private int numpars;
    private String host = null;
    private int startedPort = -1;
    private boolean[] shutdown = new boolean[1];
    private String sid;
    private Thread srreceiver;
    private Thread srreader;
    private Thread srtransmitter;
    private DistributedDataset transferdd;
    private static final int MAX_PORT = 65535;
    private static final int LAST_RESERVED_PORT = 1023;
    private SearchResult nextsr;

    private static Pair<ServerSocketChannel, Integer> bindWithRetries(String host, int startPort, int portCount) throws IOException {
        int maxPort = startPort + portCount;
        if (portCount == 0 || maxPort > 65535) {
            maxPort = 65535;
        }
        for (int portNum = startPort; portNum <= maxPort; ++portNum) {
            InetSocketAddress serverSocketAddr = new InetSocketAddress(host, portNum);
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            try {
                serverSocketChannel.bind(serverSocketAddr);
                logger.info((Object)String.format("Start receiver port on %d", portNum));
                return new Pair<ServerSocketChannel, Integer>(serverSocketChannel, portNum);
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("Could not start receiver port on %d, reason=%s", portNum, t.getMessage()));
                if (portCount != 0 || portNum != 65535) continue;
                portNum = 1023;
                maxPort = startPort;
                continue;
            }
        }
        throw new DFSException(logger, String.format("Could not find available receiver port", new Object[0]));
    }

    public SearchResultsReceiver(final String sid, int numCores, int port, int portCount, DistributedDataset dd) throws IOException {
        this.shutdown[0] = false;
        this.sid = sid;
        executorService = Executors.newFixedThreadPool(numCores);
        this.numpars = dd.partitions();
        logger.info((Object)String.format("Number of partitions to retrieve search results from: %d", this.numpars));
        this.parinfos = new ParInfo[this.numpars];
        for (int i = 0; i < this.numpars; ++i) {
            this.parinfos[i] = new ParInfo();
        }
        final Selector selector = Selector.open();
        this.host = Utils.getIpFromSplunkHostnameEnv();
        Pair<ServerSocketChannel, Integer> socPort = SearchResultsReceiver.bindWithRetries(this.host, port, portCount);
        final ServerSocketChannel serverSocketChannel = socPort.first();
        serverSocketChannel.configureBlocking(false);
        int ops = serverSocketChannel.validOps();
        final File chunkFileDir = new File(String.format("%s/%s", System.getenv("DFS_HOME"), "dfstmp"));
        if (!chunkFileDir.exists()) {
            chunkFileDir.mkdir();
            logger.info((Object)String.format("Temp chunk directory not found hence created: %s", chunkFileDir.getAbsolutePath()));
        }
        logger.info((Object)String.format("Chunk temp file directory path: %s", chunkFileDir.getAbsolutePath()));
        serverSocketChannel.register(selector, ops, null);
        this.startedPort = socPort.second();
        logger.info((Object)String.format("Set started port: %d, sid: %s", this.startedPort, sid));
        this.srreceiver = new Thread(new DFCRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            protected void runInternal() throws Exception {
                try {
                    numsenders = 0;
                    block6: while (true) {
                        if ((ready = selector.select(1000L)) <= 0 && !SearchResultsReceiver.access$000(SearchResultsReceiver.this)[0]) {
                            continue;
                        }
                        if (SearchResultsReceiver.access$000(SearchResultsReceiver.this)[0]) {
                            try {
                                serverSocketChannel.close();
                                SearchResultsReceiver.logger.debug((Object)String.format("Closed receiver since shutdown requested: %s", new Object[]{sid}));
                            }
                            catch (Throwable t) {
                                SearchResultsReceiver.logger.error((Object)String.format("Error closing receiver channel: %s", new Object[]{sid}));
                            }
                            SearchResultsReceiver.logger.info((Object)String.format("Shutting down receiver for sid: %s since all partitions read", new Object[]{sid}));
                            break;
                        }
                        clientKeys = selector.selectedKeys();
                        clientKeysIter = clientKeys.iterator();
                        error = new Throwable[1];
                        while (true) {
                            if (clientKeysIter.hasNext()) ** break;
                            continue block6;
                            if (error[0] != null) {
                                throw error[0];
                            }
                            clientKey = clientKeysIter.next();
                            clientKeysIter.remove();
                            if (!clientKey.isValid()) {
                                SearchResultsReceiver.logger.warn((Object)String.format("Ignoring channel key since it is not valid: %s", new Object[]{sid}));
                                continue;
                            }
                            if (clientKey.isAcceptable()) {
                                clientSocketChannel = serverSocketChannel.accept();
                                clientSocketChannel.configureBlocking(false);
                                clientSocketChannel.register(selector, 1);
                                SearchResultsReceiver.logger.info((Object)String.format("Sender connection accepted from ip: %s, sender seq id: %d", new Object[]{clientSocketChannel.getRemoteAddress().toString(), ++numsenders}));
                                continue;
                            }
                            if (!clientKey.isReadable()) continue;
                            clientSocketChannel = (SocketChannel)clientKey.channel();
                            intbuff = ByteBuffer.allocate(4);
                            SearchResultsReceiver.access$100(clientSocketChannel, intbuff, sid, SearchResultsReceiver.access$000(SearchResultsReceiver.this));
                            parid = intbuff.getInt(0);
                            intbuff.clear();
                            SearchResultsReceiver.access$100(clientSocketChannel, intbuff, sid, SearchResultsReceiver.access$000(SearchResultsReceiver.this));
                            chunkid = intbuff.getInt(0);
                            intbuff.clear();
                            SearchResultsReceiver.access$100(clientSocketChannel, intbuff, sid, SearchResultsReceiver.access$000(SearchResultsReceiver.this));
                            lastchunkint = intbuff.getInt(0);
                            lastchunk = lastchunkint > 0;
                            intbuff.clear();
                            SearchResultsReceiver.access$100(clientSocketChannel, intbuff, sid, SearchResultsReceiver.access$000(SearchResultsReceiver.this));
                            payloadSize = intbuff.getInt(0);
                            intbuff.clear();
                            payloadBuff = ByteBuffer.allocate(payloadSize);
                            SearchResultsReceiver.access$100(clientSocketChannel, payloadBuff, sid, SearchResultsReceiver.access$000(SearchResultsReceiver.this));
                            intbuff.putInt(1);
                            SearchResultsReceiver.access$200(clientSocketChannel, intbuff);
                            intbuff.clear();
                            payload = payloadBuff.array();
                            SearchResultsReceiver.access$500().execute(new DFCRunnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                protected void runInternal() throws Exception {
                                    try {
                                        ParInfo parinfo;
                                        String chunkfile = SearchResultsReceiver.this.getChunkFileName(sid, parid, chunkid);
                                        File cf = new File(chunkFileDir, chunkfile);
                                        if (cf.exists()) {
                                            cf.delete();
                                        }
                                        FileOutputStream fos = new FileOutputStream(cf);
                                        fos.write(payload);
                                        fos.flush();
                                        fos.close();
                                        ParInfo parInfo = parinfo = SearchResultsReceiver.this.parinfos[parid];
                                        synchronized (parInfo) {
                                            parinfo.receivedChunk();
                                            if (lastchunk) {
                                                parinfo.receivedLastChunk();
                                                logger.debug((Object)String.format("Received and written last chunk for par id: %d, sid: %s", parid, sid));
                                            }
                                            parinfo.notify();
                                        }
                                    }
                                    catch (Throwable t) {
                                        error[0] = t;
                                        logger.error((Object)String.format("Error occurred while writing chunk: %d, parid: %d, sid: %s", chunkid, parid, sid), t);
                                    }
                                }
                            });
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    try {
                        SearchResultsReceiver.logger.error((Object)String.format("Error: %s", new Object[]{t}));
                        if (!SearchResultsReceiver.access$000(SearchResultsReceiver.this)[0]) {
                            throw new RuntimeException(t);
                        }
                        SearchResultsReceiver.logger.error((Object)String.format("Not raising alert since shutdown requested: %s, but receiver received some traffic on the wire: %s", new Object[]{sid, t.getMessage()}));
                    }
                    catch (Throwable var16_18) {
                        serverSocketChannel.close();
                        SearchResultsReceiver.logger.error((Object)String.format("Closing receiver nio server socket channel: %s", new Object[]{sid}));
                        throw var16_18;
                    }
                    serverSocketChannel.close();
                    SearchResultsReceiver.logger.error((Object)String.format("Closing receiver nio server socket channel: %s", new Object[]{sid}));
                }
                serverSocketChannel.close();
                SearchResultsReceiver.logger.error((Object)String.format("Closing receiver nio server socket channel: %s", new Object[]{sid}));
                SearchResultsReceiver.logger.info((Object)String.format("Chunked search results over nio server receiver thread completed: %s", new Object[]{sid}));
            }
        });
        this.srreader = new Thread(new DFCRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runInternal() throws Exception {
                int currpar = 0;
                int chunkidtoprocess = 0;
                while (true) {
                    ParInfo parinfo;
                    if (SearchResultsReceiver.this.shutdown[0]) {
                        logger.info((Object)String.format("Stopped reading srs from chunk files: %s, since shutdown requested", sid));
                        break;
                    }
                    if (currpar >= SearchResultsReceiver.this.numpars) {
                        logger.info((Object)String.format("Number of partitions read: %d, total number of partitions: %d, hence the entire distributed dataset is read", currpar, SearchResultsReceiver.this.numpars));
                        break;
                    }
                    ParInfo parInfo = parinfo = SearchResultsReceiver.this.parinfos[currpar];
                    synchronized (parInfo) {
                        if (parinfo.isParRead() && parinfo.nextChunkToRead() < 0) {
                            logger.info((Object)String.format("Finished reading partition chunks from disk and pushed to sr cache: %d for sid: %s", currpar, sid));
                            ++currpar;
                            continue;
                        }
                        chunkidtoprocess = parinfo.nextChunkToRead();
                        if (chunkidtoprocess < 0) {
                            parinfo.wait(10L);
                            continue;
                        }
                    }
                    logger.info((Object)String.format("About to read chunk file to return search results to caller: chunk id: %d, par id: %d, sid: %s", chunkidtoprocess, currpar, sid));
                    String chunkFile = SearchResultsReceiver.this.getChunkFilePath(sid, currpar, chunkidtoprocess);
                    File cf = new File(chunkFile);
                    logger.info((Object)String.format("About to read chunk file: %s", cf.getAbsolutePath()));
                    BufferedReader chunkfilereader = new BufferedReader(new InputStreamReader(new FileInputStream(cf)));
                    Iterator srs = SearchResultsReceiver.getSearchResults(chunkfilereader);
                    while (srs.hasNext()) {
                        SearchResult sr = (SearchResult)srs.next();
                        while (!SearchResultsReceiver.this.srcache.offer(sr, 10L, TimeUnit.MILLISECONDS)) {
                            if (!SearchResultsReceiver.this.shutdown[0]) continue;
                            logger.error((Object)String.format("Aborting pushing to cache since shutdown requested: %s", sid));
                            throw new RuntimeException(String.format("Aborting pushing to cache since shutdown requested: %s", sid));
                        }
                    }
                    cf.delete();
                    logger.info((Object)String.format("Deleted chunk file after reading: %s", cf.getAbsolutePath()));
                    parinfo.processedChunk();
                    logger.info((Object)String.format("Processed chunk: %d, parid: %d, sid: %s", chunkidtoprocess, currpar, sid));
                }
                logger.info((Object)String.format("Chunk search results reader from disk thread completed: %s", sid));
            }
        });
        this.transferdd = SearchResultsReceiver.createTransferSrsDD(dd, this.host, port, sid, this.shutdown);
        this.srtransmitter = new Thread(new DFCRunnable(){

            @Override
            protected void runInternal() throws Exception {
                logger.debug((Object)String.format("About to transfer srs to the receiver: %s", sid));
                SearchResultsReceiver.this.transferdd.count();
                logger.info((Object)String.format("Worker to receiver search results transmitter thread completed: %s", sid));
            }
        });
        this.srreceiver.start();
        this.srreader.start();
        this.srtransmitter.start();
    }

    private static SearchResult.FieldMeta[] getUniqueFields(SearchResult.FieldMeta[] fields) {
        HashSet<SearchResult.FieldMeta> unique = new HashSet<SearchResult.FieldMeta>();
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            unique.add(fields[i]);
        }
        SearchResult.FieldMeta[] uniqueflds = new SearchResult.FieldMeta[unique.size()];
        return unique.toArray(uniqueflds);
    }

    private static DistributedDataset createTransferSrsDD(DistributedDataset dd, final String receiverHost, final int receiverPort, final String sid, final boolean[] shutdown) {
        DistributedDataset ret = dd.transform(new MapPartitioner(){
            private static final long serialVersionUID = 1L;

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public Iterator<SearchResult> mapPartitions(int parid, Iterator<SearchResult> srs) {
                SocketChannel clientChannel = null;
                try {
                    InetSocketAddress serverAddr = new InetSocketAddress(receiverHost, receiverPort);
                    clientChannel = SocketChannel.open(serverAddr);
                    logger.info((Object)String.format("Connected to search results receiver: host: %s, port: %d", receiverHost, receiverPort));
                    int chunkCounter = 0;
                    ArrayList<SearchResult> chunkSrs = new ArrayList<SearchResult>(100000);
                    SearchResult.FieldMeta[] fields = null;
                    int chunkid = 0;
                    boolean lastchunk = false;
                    boolean first = false;
                    while (srs.hasNext()) {
                        SearchResult sr = srs.next();
                        chunkSrs.add(sr);
                        ++chunkCounter;
                        if (!first) {
                            fields = SearchResultsReceiver.getUniqueFields(sr.getFieldNames());
                            first = true;
                        }
                        if (chunkCounter < 100000) continue;
                        SearchResultsReceiver.writePayload(clientChannel, fields, chunkSrs, parid, chunkid, lastchunk, sid, shutdown);
                        ++chunkid;
                        chunkCounter = 0;
                        chunkSrs.clear();
                    }
                    SearchResultsReceiver.writePayload(clientChannel, fields, chunkSrs, parid, chunkid, true, sid, shutdown);
                }
                catch (Throwable t) {
                    logger.error((Object)String.format("Error processing sid: %s, par id: %d", sid, parid), t);
                    throw new RuntimeException(t);
                }
                logger.info((Object)String.format("Transferred all search results in partition: %s, sid: %s", parid, sid));
                return new ArrayList().iterator();
            }

            @Override
            public String desc() {
                return "searchResultsReceiverGetResults";
            }
        });
        return ret;
    }

    private static void write(SocketChannel channel, ByteBuffer buff) throws IOException {
        buff.rewind();
        while (buff.remaining() > 0) {
            channel.write(buff);
        }
        buff.rewind();
    }

    private static void writePayload(SocketChannel channel, SearchResult.FieldMeta[] fields, List<SearchResult> srs, int parid, int chunkid, boolean lastchunk, String sid, boolean[] shutdown) throws IOException {
        ByteBuffer intbuff = ByteBuffer.allocate(4).putInt(parid);
        SearchResultsReceiver.write(channel, intbuff);
        intbuff.clear();
        intbuff.putInt(chunkid);
        SearchResultsReceiver.write(channel, intbuff);
        intbuff.clear();
        int lastChunkInt = lastchunk ? 1 : 0;
        intbuff.putInt(lastChunkInt);
        SearchResultsReceiver.write(channel, intbuff);
        intbuff.clear();
        byte[] payload = SearchResultsReceiver.getChunkPayload(fields, srs);
        int payloadSize = payload.length;
        intbuff.putInt(payloadSize);
        ByteBuffer payloadBuff = ByteBuffer.wrap(payload);
        SearchResultsReceiver.write(channel, intbuff);
        intbuff.clear();
        SearchResultsReceiver.write(channel, payloadBuff);
        SearchResultsReceiver.read(channel, intbuff, sid, shutdown);
        intbuff.getInt(0);
        intbuff.clear();
    }

    private static Object[] getFieldValues(SearchResult.FieldMeta[] fields, SearchResult sr) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = sr.getDataMap();
        int len = fields.length;
        Object[] values = new Object[len];
        for (int i = 0; i < len; ++i) {
            SearchResult.FieldMeta field = fields[i];
            Object val = ((HashMap)data).get(field);
            values[i] = val;
        }
        return values;
    }

    private static String[] convert(SearchResult.FieldMeta[] fields) {
        String[] strFields = new String[fields.length];
        for (int i = 0; i < strFields.length; ++i) {
            strFields[i] = fields[i].fieldName();
        }
        return strFields;
    }

    private static byte[] getChunkPayload(SearchResult.FieldMeta[] fields, List<SearchResult> srs) throws IOException {
        Iterator<SearchResult> srsi = srs.iterator();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter bsw = new OutputStreamWriter(baos);
        CSVPrinter csvp = CSVFormat.DEFAULT.withHeader(SearchResultsReceiver.convert(fields)).print((Appendable)bsw);
        while (srsi.hasNext()) {
            SearchResult sr = srsi.next();
            Object[] vals = SearchResultsReceiver.getFieldValues(fields, sr);
            csvp.printRecord(vals);
        }
        csvp.flush();
        return baos.toByteArray();
    }

    private String getChunkFilePath(String sid, int parid, int chunkid) {
        String chunkFile = this.getChunkFileName(sid, parid, chunkid);
        String chunkDir = this.getChunkFileDir();
        String path = String.format("%s/%s", chunkDir, chunkFile);
        return path;
    }

    private String getChunkFileDir() {
        return String.format("%s/%s", System.getenv("DFS_HOME"), "dfstmp");
    }

    private String getChunkFileName(String sid, int parid, int chunkid) {
        return String.format("%s__%d__%d.%s", sid, parid, chunkid, "chunk");
    }

    private static void read(SocketChannel channel, ByteBuffer buff, String sid, boolean[] shutdown) throws IOException {
        buff.rewind();
        while (buff.remaining() > 0) {
            channel.read(buff);
            if (!shutdown[0]) continue;
            logger.error((Object)String.format("Aborting reading all search results since shutdown requested: %s", sid));
            throw new RuntimeException(String.format("Aborting reading due to shutdown: %s", sid));
        }
        buff.rewind();
    }

    private static Iterator<SearchResult> getSearchResults(Reader r) throws IOException {
        final CSVParser parser = new CSVParser(r, CSVFormat.DEFAULT);
        final Iterator recs = parser.iterator();
        if (!recs.hasNext()) {
            return new ArrayList().iterator();
        }
        CSVRecord header = (CSVRecord)recs.next();
        final SearchResult.FieldMeta[] fields = SearchResultsReceiver.getFields(header);
        Iterator<SearchResult> isr = new Iterator<SearchResult>(){
            SearchResult nextsr;

            @Override
            public boolean hasNext() {
                SearchResult sr;
                if (this.nextsr != null) {
                    return true;
                }
                if (!recs.hasNext()) {
                    try {
                        parser.close();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                    return false;
                }
                CSVRecord rec = (CSVRecord)recs.next();
                this.nextsr = sr = SearchResultFactory.getInstance().createSearchResult(fields, rec);
                return true;
            }

            @Override
            public SearchResult next() {
                SearchResult tempsr = this.nextsr;
                this.nextsr = null;
                return tempsr;
            }

            @Override
            public void remove() {
            }
        };
        return isr;
    }

    private static SearchResult.FieldMeta[] getFields(CSVRecord rec) {
        int size = rec.size();
        SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[size];
        for (int i = 0; i < size; ++i) {
            fields[i] = SearchResult.FieldMeta.newFieldMeta(rec.get(i));
        }
        return fields;
    }

    private static boolean allPartitionsRead(ParInfo[] parinfos) {
        for (ParInfo parinfo : parinfos) {
            if (parinfo.isParRead()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.nextsr != null) {
            return true;
        }
        do {
            try {
                this.nextsr = this.srcache.poll(10L, TimeUnit.MILLISECONDS);
                if (this.nextsr != null) {
                    return true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        } while (!SearchResultsReceiver.allPartitionsRead(this.parinfos));
        this.shutdown[0] = true;
        logger.info((Object)String.format("Retrieved all srs from cache and shutdown of all threads requested: %s", this.sid));
        return false;
    }

    @Override
    public SearchResult next() {
        SearchResult ret = this.nextsr;
        this.nextsr = null;
        return ret;
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() throws IOException {
        try {
            this.shutdown[0] = true;
            logger.info((Object)String.format("Will wait for all the threads to complete: %s", this.sid));
            this.srreceiver.join();
            this.srreader.join();
            this.srtransmitter.join();
            logger.info((Object)String.format("All threads completed: %s", this.sid));
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error while waiting for threads to complete: %s", t.getMessage()));
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error finalizing search results receiver: %s, sid: %s", t.getMessage(), this.sid));
        }
    }

    static /* synthetic */ void access$100(SocketChannel x0, ByteBuffer x1, String x2, boolean[] x3) throws IOException {
        SearchResultsReceiver.read(x0, x1, x2, x3);
    }

    static /* synthetic */ void access$200(SocketChannel x0, ByteBuffer x1) throws IOException {
        SearchResultsReceiver.write(x0, x1);
    }

    static /* synthetic */ ExecutorService access$500() {
        return executorService;
    }

    private static class ParInfo {
        private boolean ended = false;
        private int chunksreceived = 0;
        private int chunksprocessed = 0;

        ParInfo() {
        }

        public boolean isParRead() {
            if (!this.ended) {
                return false;
            }
            return this.chunksreceived <= this.chunksprocessed;
        }

        void receivedChunk() {
            ++this.chunksreceived;
        }

        void receivedLastChunk() {
            this.ended = true;
        }

        void processedChunk() {
            ++this.chunksprocessed;
        }

        int nextChunkToRead() {
            if (this.chunksreceived <= this.chunksprocessed) {
                return -1;
            }
            return this.chunksprocessed;
        }
    }
}

