/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.search.HostPort;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.NIOSearchResultsReceiverManager;
import com.splunk.df.search.compute.ComputeEngine;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.MapPartitioner;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.security.SSLConfig;
import com.splunk.df.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ReceiversDDFactory
implements DFSSearchConstants,
ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(ReceiversDDFactory.class);

    public static Pair<DistributedDataset, List<HostPort>> createReceiversDD(DistributedDataset root, int startPort, int portCount, int numPars, int keyStoreProviderPort, String host, int numCores, boolean isFSHExecution, int numCoresPerExecutor, int numExecutors, ComputeEngine engine, long estimatedEventCount, boolean lowLatencyMode, int dfcDriverCores, int dfwToDfcAuthRetryTimes, int rdinServerSocketBacklogSize) {
        long start = System.currentTimeMillis();
        long dfcStartTimeMillis = Long.valueOf(System.getProperty("DFC_START_TIME_MILLIS"));
        long dfcLaunchTimeMillis = Long.valueOf(System.getProperty("DFC_LAUNCH_TIME_MILLIS"));
        long durationSinceStart = start - dfcStartTimeMillis;
        long durationSinceLaunch = start - dfcLaunchTimeMillis;
        String message = String.format("rdin -> pars: %d, event count: %d since DFM's dispatcher: %d millis, since DFC start: %d millis", numPars, estimatedEventCount, durationSinceLaunch, durationSinceStart);
        engine.setCurrentJobDescription(message);
        logger.info((Object)message);
        DistributedDataset placeholdersdd = root;
        boolean repartition = false;
        logger.info((Object)String.format("DFS worker info before construction of receivers dd ->", new Object[0]));
        logger.info((Object)String.format("number of workers before constructing receivers: %d", engine.numActiveWorkers()));
        if (!Utils.isFastStartup()) {
            List<SearchResult> placeholders = ReceiversDDFactory.getReceiverPlaceholders(startPort, numPars, numCores);
            placeholdersdd = placeholdersdd.resetSearchResults(placeholders, placeholders.size());
            if (placeholders.size() < numPars) {
                repartition = true;
                logger.info((Object)String.format("placeholders size: %d, num pars: %d - hence partition count of dd will be increased to num pars: %d", placeholders.size(), numPars, numPars));
            }
        } else {
            if (!lowLatencyMode) {
                int tasksPerCore = Utils.getTasksPerCore();
                logger.info((Object)String.format("fast mode execution - will use the num pars: %d or num cores: %d * tasks per core: %d whichever is higher", numPars, numCores, tasksPerCore));
                numPars = Math.max(numCores * tasksPerCore, numPars);
            }
            repartition = true;
        }
        if (repartition) {
            int oldPars = placeholdersdd.partitions();
            placeholdersdd = placeholdersdd.repartition(numPars);
            logger.info((Object)String.format("repartitioned placeholders dd from: %d, to: %d", oldPars, placeholdersdd.partitions()));
        }
        logger.info((Object)String.format("constructed placeholders dataset with %d partitions", placeholdersdd.partitions()));
        DistributedDataset receiversdd = ReceiversDDFactory.getReceiversDD(placeholdersdd, startPort, portCount, keyStoreProviderPort, Utils.getLocalHostAddress(), SSLConfig.getInstance().getTlsProtocol(), isFSHExecution, numCoresPerExecutor, lowLatencyMode, dfcDriverCores, dfwToDfcAuthRetryTimes, rdinServerSocketBacklogSize);
        receiversdd = receiversdd.cacheDisk();
        if (logger.isDebugEnabled()) {
            long numReceivers = receiversdd.count();
            logger.info((Object)String.format("number of rdin receivers: %d, number of partitions: %d", numReceivers, receiversdd.partitions()));
        }
        List<HostPort> hostPorts = ReceiversDDFactory.getHostPorts(receiversdd, numCores);
        logger.info((Object)String.format("time taken to read the host ports {%s}, is %d millis; total host ports: %d", hostPorts.toString(), System.currentTimeMillis() - start, hostPorts.size()));
        logger.info((Object)String.format("number of workers post construction of receivers: %d", engine.numActiveWorkers()));
        return new Pair<DistributedDataset, List<HostPort>>(receiversdd, hostPorts);
    }

    private static List<HostPort> getHostPorts(DistributedDataset receiversdd, int numCores) {
        try {
            int fetchPars = receiversdd.partitions();
            if (fetchPars > numCores) {
                fetchPars = numCores;
            }
            receiversdd = receiversdd.repartition(fetchPars);
            Iterator<SearchResult> srs = receiversdd.retrieve();
            HashSet<HostPort> hostPorts = new HashSet<HostPort>();
            while (srs.hasNext()) {
                SearchResult sr = srs.next();
                if (sr.isEmpty()) continue;
                String host = sr.getDataMap().get(DFC_RECEIVER_HOST).toString();
                int port = Integer.valueOf(sr.getDataMap().get(DFC_RECEIVER_PORT).toString());
                HostPort hp = new HostPort(host, port);
                hostPorts.add(hp);
            }
            return new ArrayList<HostPort>(hostPorts);
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error creating receivers for rdins: %s", t.getMessage()), t);
            throw new RuntimeException(String.format("error creating receivers for rdin: %s", t.getMessage()), t);
        }
    }

    private static List<SearchResult> getReceiverPlaceholders(int port, int numPars, int numCores) {
        int boost = Utils.getTasksPerCore();
        int numHolders = numCores * boost;
        ArrayList<SearchResult> placeholders = new ArrayList<SearchResult>(numHolders);
        for (int i = 0; i < numHolders; ++i) {
            SearchResult portSr = SearchResultFactory.getInstance().createSearchResult(DFS_PORT, port);
            placeholders.add(portSr);
        }
        logger.info((Object)String.format("number of placeholders created: %d, number of partitons: %d", placeholders.size(), numPars));
        return placeholders;
    }

    public static boolean enableIpToQFTracking() {
        boolean enable = false;
        String enableStr = System.getenv("DFS_RECORD_IP_QF_MAPPING");
        if (enableStr != null) {
            try {
                enable = Boolean.valueOf(enableStr);
                logger.info((Object)String.format("enable tracking of QF ip addresses overridden via envvar: %s: %b", "DFS_RECORD_IP_QF_MAPPING", enable));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s envvar value %s to boolean", "DFS_RECORD_IP_QF_MAPPING", enableStr));
            }
        }
        logger.info((Object)String.format("using enable tracking of QF ip addresses: %b", enable));
        return enable;
    }

    private static int getNumChunksPerConn12gExecutor() {
        int numChunks = 3;
        String numChunksStr = System.getenv("NUM_CHUNKS_PER_CONN_12G_EXEC");
        if (numChunksStr != null) {
            try {
                numChunks = Integer.parseInt(numChunksStr);
                logger.info((Object)String.format("number of simultaneously processed remote connection chunks for 12g dfs worker set through envvar: %d", numChunks));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s envvar not set properly, it should be an int, but the value is: %s", "NUM_CHUNKS_PER_CONN_12G_EXEC", numChunksStr));
            }
        }
        logger.info((Object)String.format("number of rdin chunks per remote connections processed simultaneously: %d", numChunks));
        return numChunks;
    }

    private static int getMaxNumChunksPerConn() {
        int maxChunks = 3;
        String maxChunksStr = System.getenv("MAX_NUM_CHUNKS_PER_CONN");
        if (maxChunksStr != null) {
            try {
                maxChunks = Integer.parseInt(maxChunksStr);
                logger.info((Object)String.format("max chunks per remote connections set to: %d through envar", maxChunks));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s envvar not set properly, needs to be an int - but the value is: %s", "MAX_NUM_CHUNKS_PER_CONN", maxChunksStr));
            }
        }
        return maxChunks;
    }

    private static int getSearchResultQSize12gExecutor() {
        int qSize = 500;
        String qSizeStr = System.getenv("SEARCH_RESULT_QUEUE_SIZE_12G_EXEC");
        if (qSizeStr != null) {
            try {
                qSize = Integer.parseInt(qSizeStr);
                logger.info((Object)String.format("rdin search result queue size for 12g worker set through envvar: %d", qSize));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s envvar not set properly, should be an int but is set to: %s", "SEARCH_RESULT_QUEUE_SIZE_12G_EXEC", qSizeStr));
            }
        }
        logger.info((Object)String.format("rdin search result queue size set to: %d", qSize));
        return qSize;
    }

    private static int getCoreBoostForChunkParsing() {
        int coreBoost = 1;
        String coreBoostStr = System.getenv("DFS_CORE_BOOST_FOR_CHUNK_PARSING");
        if (coreBoostStr != null) {
            try {
                coreBoost = Integer.parseInt(coreBoostStr);
                logger.info((Object)String.format("core boost to increase chunk parsing speed on the dfs workers but would also lead to increased gc pressures: %d", coreBoost));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s envvar incorrectly set, it needs to be an int but the value is: %s", "DFS_CORE_BOOST_FOR_CHUNK_PARSING", coreBoostStr));
            }
        }
        logger.info((Object)String.format("core boost set to: %d, which increases the size of the thread pool to proces the rdin chunks from remote connections", coreBoost));
        return coreBoost;
    }

    private static int getMaxSearchQueueSize() {
        int maxSize = 500;
        String maxSizeStr = System.getenv("MAX_SEARCH_RESULT_QUEUE_SIZE");
        if (maxSizeStr != null) {
            try {
                maxSize = Integer.parseInt(maxSizeStr);
                logger.info((Object)String.format("max size of search results queue on the dfs workers set to: %d through envvar", maxSize));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s envvar not set properly, it needs to be an int but set to: %s", "MAX_SEARCH_RESULT_QUEUE_SIZE", maxSizeStr));
            }
        }
        return maxSize;
    }

    private static int getMaxPartialExecutionTimeouts() {
        int max = 5;
        String maxStr = System.getenv("DFS_MAX_PARTIAL_EXECUTION_TIMEOUTS");
        boolean setViaEnvvar = false;
        if (maxStr != null && !maxStr.trim().isEmpty()) {
            try {
                max = Integer.valueOf(maxStr);
                setViaEnvvar = true;
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse max partial execution timeouts: %s", maxStr));
            }
        }
        logger.info((Object)String.format("max partital execution timeouts set to: %d, via envvar: %b", max, setViaEnvvar));
        return max;
    }

    private static int blockQueryFinished() {
        int block = -1;
        String blockStr = System.getenv("DFS_BLOCK_QUERY_FINISHED_COMMIT");
        boolean setViaEnvvar = false;
        if (blockStr != null && !blockStr.trim().isEmpty()) {
            try {
                block = Integer.valueOf(blockStr);
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s to int block query finished value", blockStr));
            }
        }
        logger.info((Object)String.format("block query finished commit set to: %d, based on envvar: %b", block, setViaEnvvar));
        return block;
    }

    private static DistributedDataset getReceiversDD(DistributedDataset placeholdersdd, final int receiverPort, final int receiverPortCount, final int keyStoreProviderPort, final String keyStoreHost, final String tlsProtocol, final boolean isFSHExecution, int numCoresPerExecutor, boolean lowLatencyMode, int dfcDriverCores, int dfwToDfcAuthRetryTimes, int rdinServerSocketBacklogSize) {
        int numChunksPerConn12gExec = ReceiversDDFactory.getNumChunksPerConn12gExecutor();
        int maxNumChunks = ReceiversDDFactory.getMaxNumChunksPerConn();
        int searchResultQSize12gExec = ReceiversDDFactory.getSearchResultQSize12gExecutor();
        int maxSrQSize = ReceiversDDFactory.getMaxSearchQueueSize();
        int coreBoost = ReceiversDDFactory.getCoreBoostForChunkParsing();
        int maxPartialExecutionTimeouts = ReceiversDDFactory.getMaxPartialExecutionTimeouts();
        int blockQFC = ReceiversDDFactory.blockQueryFinished();
        boolean enableIpToQFTracking = ReceiversDDFactory.enableIpToQFTracking();
        final HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("NUM_CHUNKS_PER_CONN_12G_EXEC", numChunksPerConn12gExec);
        params.put("MAX_NUM_CHUNKS_PER_CONN", maxNumChunks);
        params.put("SEARCH_RESULT_QUEUE_SIZE_12G_EXEC", searchResultQSize12gExec);
        params.put("MAX_SEARCH_RESULT_QUEUE_SIZE", maxSrQSize);
        params.put("DFS_CORE_BOOST_FOR_CHUNK_PARSING", coreBoost);
        params.put("DFS_MAX_PARTIAL_EXECUTION_TIMEOUTS", maxPartialExecutionTimeouts);
        params.put("DFW_TO_DFC_AUTH_RETRY_TIMES", dfwToDfcAuthRetryTimes);
        params.put("RDIN_SERVER_SOCKET_BACKLOG_SIZE", rdinServerSocketBacklogSize);
        params.put("DFS_BLOCK_QUERY_FINISHED_COMMIT", blockQFC);
        params.put("DFS_RECORD_IP_QF_MAPPING", enableIpToQFTracking ? 1 : 0);
        int numCoresForParsing = numCoresPerExecutor;
        if (lowLatencyMode) {
            numCoresForParsing = dfcDriverCores;
            logger.info((Object)String.format("dfc executing in low latency mode hence will use all driver cores for rdin chunk processing: %d", numCoresForParsing));
        }
        final int numCoresForParsingTemp = numCoresForParsing;
        DistributedDataset receiversDD = placeholdersdd.transform(new MapPartitioner(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }

            @Override
            public Iterator<SearchResult> mapPartitions(int parid, Iterator<SearchResult> srs) {
                SearchResult hostPort = NIOSearchResultsReceiverManager.getInstance().getReceiverPort(receiverPort, receiverPortCount, keyStoreProviderPort, keyStoreHost, tlsProtocol, isFSHExecution, numCoresForParsingTemp, params);
                ArrayList<SearchResult> hostPorts = new ArrayList<SearchResult>(2);
                hostPorts.add(hostPort);
                return hostPorts.iterator();
            }

            @Override
            public String desc() {
                return "receiversDdFactoryReturnNIOReceiverHostPorts";
            }
        });
        return receiversDD;
    }
}

