/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.FSHMetricsInfo;
import com.splunk.df.search.FSHMetricsInfoList;
import com.splunk.df.search.RemoteSearchInfo;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.security.NIOTls;
import com.splunk.df.util.DFSLogger;
import com.splunk.df.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterInputStream;
import javax.net.ssl.SSLEngine;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.spark.SparkEnv;

public class NIOSearchResultsReceiverManager
implements DFSSearchConstants,
ComputeEngineConstants {
    private boolean doesFshExecutionExist = false;
    private boolean allQueriesFinished = false;
    static final Logger logger = DFSLogger.getLogger(NIOSearchResultsReceiverManager.class);
    private Throwable failure;
    static NIOSearchResultsReceiverManager singleton = new NIOSearchResultsReceiverManager();
    private Object lock = new Object();
    private Selector selector = null;
    private int boundPort = -1;
    private SearchResult hostPort = null;
    private int blockQFC = -1;
    private boolean enableIpToQFTracking = false;
    private final HashMap<String, Boolean> ipToQfMapping = new HashMap();
    private HashMap<String, RemoteSearchState> remoteSearchStatusMap = new HashMap();
    private SearchResult lastSri = SearchResultFactory.getInstance().emptyResult();
    private ExecutorService executorService;
    private ExecutorService qfExecutorService;
    private LinkedBlockingDeque<SearchResultChunk> cache;
    private static String currentHostIP;
    private static int maxPartialExecutionTimeouts;
    private boolean rdoutTimeoutHappened = false;
    private int numPartialTimeouts = 0;
    private static boolean logFileRead;
    private static String logFileReadLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorDetailsForSearch(String sid, Throwable t) {
        this.failure = t;
        RemoteSearchState rss = this.remoteSearchStatusMap.get(sid);
        if (rss == null) {
            HashMap<String, RemoteSearchState> hashMap = this.remoteSearchStatusMap;
            synchronized (hashMap) {
                rss = this.remoteSearchStatusMap.get(sid);
                if (rss == null) {
                    rss = new RemoteSearchState();
                    this.remoteSearchStatusMap.put(sid, rss);
                    logger.info((Object)String.format("Added remote fsh search info for sid: %s", sid));
                }
            }
        }
        rss.setFshMetricsStatus(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFSHMetrics(String sid, FSHMetricsInfo fshMetricsInfo) {
        RemoteSearchState rss = this.remoteSearchStatusMap.get(sid);
        if (rss == null) {
            HashMap<String, RemoteSearchState> hashMap = this.remoteSearchStatusMap;
            synchronized (hashMap) {
                rss = this.remoteSearchStatusMap.get(sid);
                if (rss == null) {
                    rss = new RemoteSearchState();
                    this.remoteSearchStatusMap.put(sid, rss);
                    logger.info((Object)String.format("Added remote search info for sid: %s", sid));
                }
            }
        }
        rss.updateFshMetrics(fshMetricsInfo);
        logger.debug((Object)("Set in NIO ==> " + fshMetricsInfo.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaitForFSHMetrics(String currentSid, boolean waitForFSH, boolean hasFSHConfigArrived) {
        RemoteSearchState rss = this.remoteSearchStatusMap.get(currentSid);
        if (rss == null) {
            HashMap<String, RemoteSearchState> hashMap = this.remoteSearchStatusMap;
            synchronized (hashMap) {
                rss = this.remoteSearchStatusMap.get(currentSid);
                if (rss == null) {
                    rss = new RemoteSearchState();
                    this.remoteSearchStatusMap.put(currentSid, rss);
                    logger.info((Object)String.format("Added remote search info for sid: %s", currentSid));
                }
            }
        }
        rss.setFshMetricsStatus(waitForFSH, hasFSHConfigArrived);
    }

    private static long totalMemoryMbs() {
        return Runtime.getRuntime().maxMemory() / 0x100000L;
    }

    private static int getNumChunksPerConn12gExec(HashMap<String, Integer> params) {
        int numChunks = 3;
        if (params.containsKey("NUM_CHUNKS_PER_CONN_12G_EXEC")) {
            numChunks = params.get("NUM_CHUNKS_PER_CONN_12G_EXEC");
            logger.info((Object)String.format("overriding the number of concurrent chunks to be processed per remote connection due to params input from the dfc: %d", numChunks));
        }
        logger.info((Object)String.format("number of chunks to be processed from the same remote connection simultaneously: %d", numChunks));
        return numChunks;
    }

    private static int getNumChunksAllowedPerConnection(HashMap<String, Integer> params) {
        double totalMemMbs = NIOSearchResultsReceiverManager.totalMemoryMbs();
        double base = 12288.0;
        double ratio = totalMemMbs / base;
        double numChunksPerConn12gExec = NIOSearchResultsReceiverManager.getNumChunksPerConn12gExec(params);
        int numChunks = (int)Math.max(1.0, numChunksPerConn12gExec * ratio);
        int maxChunks = params.get("MAX_NUM_CHUNKS_PER_CONN");
        numChunks = Math.min(numChunks, maxChunks);
        logger.info((Object)String.format("Num chunks per rdout connection set to: %d, total memory: %d, base memory: %d", numChunks, (int)totalMemMbs, (int)base));
        return numChunks;
    }

    private static int getSearchResultQSize12gExec(HashMap<String, Integer> params) {
        int qSize = 500;
        if (params.containsKey("SEARCH_RESULT_QUEUE_SIZE_12G_EXEC")) {
            qSize = params.get("SEARCH_RESULT_QUEUE_SIZE_12G_EXEC");
            logger.info((Object)String.format("search results queue size has been overridden by DFC params: %d", qSize));
        }
        logger.info((Object)String.format("search results queue size on the rdin receiver capped at: %d", qSize));
        return qSize;
    }

    private static int srCacheSize(HashMap<String, Integer> params) {
        double totalMemMbs = NIOSearchResultsReceiverManager.totalMemoryMbs();
        double base = 12288.0;
        double ratio = totalMemMbs / base;
        double searResQSize = NIOSearchResultsReceiverManager.getSearchResultQSize12gExec(params);
        int cacheSize = (int)Math.max(10000.0, searResQSize * ratio);
        int maxSize = params.get("MAX_SEARCH_RESULT_QUEUE_SIZE");
        cacheSize = Math.min(cacheSize, maxSize);
        logger.info((Object)String.format("SR cache size set to: %d, total memory: %d, base memory: %d", cacheSize, (int)totalMemMbs, (int)base));
        return cacheSize;
    }

    public static NIOSearchResultsReceiverManager getInstance() {
        return singleton;
    }

    private NIOSearchResultsReceiverManager() {
    }

    private static boolean queryFinished(SearchResult sri) {
        return "1".equals(sri.getDataMap().get(REMOTE_SEARCH_QUERY_FINISHED).toString().trim());
    }

    private static SearchResult createHostPort(int boundPort) {
        String host = currentHostIP;
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(4);
        data.put(DFC_RECEIVER_HOST, host);
        data.put(DFC_RECEIVER_PORT, boundPort);
        SearchResult.FieldMeta[] fieldnames = new SearchResult.FieldMeta[]{DFC_RECEIVER_HOST, DFC_RECEIVER_PORT};
        Object[] values = new Object[]{host, boundPort};
        SearchResult hostport = SearchResultFactory.getInstance().createSearchResult(data, fieldnames, values);
        return hostport;
    }

    private Pair<ByteBuffer, ByteBuffer> read(SocketChannel socketChannel, SSLEngine sslEngine, ByteBuffer buff, ByteBuffer peerNetBuffer, ByteBuffer remainingAppBuffer) throws IOException {
        try {
            Pair<ByteBuffer, ByteBuffer> remainingBuffers = NIOTls.read(socketChannel, sslEngine, buff, peerNetBuffer, remainingAppBuffer);
            return remainingBuffers;
        }
        catch (Exception ex) {
            logger.warn((Object)String.format("read issue: %s", ex.toString()), (Throwable)ex);
            return null;
        }
    }

    private static int getCoreBoost(HashMap<String, Integer> params) {
        int coreBoost = 1;
        if (params.containsKey("DFS_CORE_BOOST_FOR_CHUNK_PARSING")) {
            coreBoost = params.get("DFS_CORE_BOOST_FOR_CHUNK_PARSING");
            logger.info((Object)String.format("core boost set to: %d based on params", coreBoost));
        }
        logger.info((Object)String.format("core boost set to: %d", coreBoost));
        return coreBoost;
    }

    public boolean isReceiverStarted() {
        return this.hostPort != null;
    }

    private static int getMaxPartialExecutionTimeout(HashMap<String, Integer> params) {
        if (params.containsKey("DFS_MAX_PARTIAL_EXECUTION_TIMEOUTS")) {
            int timeouts = params.get("DFS_MAX_PARTIAL_EXECUTION_TIMEOUTS");
            return timeouts;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResult getReceiverPort(int startPort, int portCount, int keyStoreProviderPort, String keyStoreHost, String tlsProtocol, boolean isFSHExecution, int numCoresForParsing, HashMap<String, Integer> params) {
        if (this.hostPort != null) {
            return this.hostPort;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.hostPort != null) {
                return this.hostPort;
            }
            int lmaxPartialExecutionTimeouts = NIOSearchResultsReceiverManager.getMaxPartialExecutionTimeout(params);
            if (lmaxPartialExecutionTimeouts > 0) {
                maxPartialExecutionTimeouts = lmaxPartialExecutionTimeouts;
            }
            this.blockQFC = params.get("DFS_BLOCK_QUERY_FINISHED_COMMIT");
            this.cache = new LinkedBlockingDeque(NIOSearchResultsReceiverManager.srCacheSize(params));
            int parsingCores = numCoresForParsing * NIOSearchResultsReceiverManager.getCoreBoost(params);
            parsingCores = Math.max(parsingCores, 2);
            logger.info((Object)String.format("number of cores assigned to parsing rdin chunks: %d", parsingCores));
            this.executorService = Executors.newFixedThreadPool(parsingCores);
            this.qfExecutorService = Executors.newFixedThreadPool(parsingCores);
            if (!this.doesFshExecutionExist) {
                this.doesFshExecutionExist = isFSHExecution;
            }
            try {
                boolean isTlsEnabled;
                boolean isTlsEnabledLocal = false;
                if (keyStoreProviderPort > 0) {
                    isTlsEnabledLocal = true;
                }
                if (isTlsEnabled = isTlsEnabledLocal) {
                    NIOTls.createSSLConfigInfo(keyStoreProviderPort, keyStoreHost, tlsProtocol, params);
                }
                this.selector = Selector.open();
                int rdinServerSocketBacklogSize = params.get("RDIN_SERVER_SOCKET_BACKLOG_SIZE");
                this.enableIpToQFTracking = params.get("DFS_RECORD_IP_QF_MAPPING") == 1;
                logger.debug((Object)String.format("Rdin server backlog size set to %d", rdinServerSocketBacklogSize));
                Pair<ServerSocketChannel, Integer> socPort = NIOTls.bindWithRetries(currentHostIP, startPort, portCount, rdinServerSocketBacklogSize);
                final ServerSocketChannel serverSocketChannel = socPort.first();
                serverSocketChannel.configureBlocking(false);
                int ops = serverSocketChannel.validOps();
                serverSocketChannel.register(this.selector, ops, null);
                this.boundPort = socPort.second();
                this.hostPort = NIOSearchResultsReceiverManager.createHostPort(this.boundPort);
                final int maxChunks = NIOSearchResultsReceiverManager.getNumChunksAllowedPerConnection(params);
                this.executorService.execute(new DFCRunnable(true){

                    /*
                     * Exception decompiling
                     */
                    @Override
                    protected void runInternal() throws Exception {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                });
            }
            catch (Throwable t) {
                logger.error((Object)String.format("Error creating nio receiver: %s", t.getMessage()), t);
                throw new RuntimeException(String.format("could not create nio receiver: %s", t.getMessage()), t);
            }
        }
        return this.hostPort;
    }

    private static String remoteSids(RemoteSearchInfo[] searchInfos) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < searchInfos.length; ++i) {
            RemoteSearchInfo rsi = searchInfos[i];
            sb.append(rsi.sid());
            if (i >= searchInfos.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public boolean areRemoteConnectionsCreated(RemoteSearchInfo[] searchInfos, HashMap<String, RemoteSearchState> remoteSearchMetadataMap) {
        return searchInfos.length <= this.remoteSearchStatusMap.size();
    }

    public boolean isExecutionFinished(RemoteSearchInfo[] searchInfos, HashMap<String, RemoteSearchState> remoteSearchMetadataMap) {
        int size = remoteSearchMetadataMap.size();
        if (searchInfos.length > size) {
            return false;
        }
        return this.isQueryFinished(searchInfos, remoteSearchMetadataMap) && this.isFshMetricsDone(searchInfos, remoteSearchMetadataMap);
    }

    private boolean isFshMetricsDone(RemoteSearchInfo[] searchInfos, HashMap<String, RemoteSearchState> remoteSearchMetadataMap) {
        for (RemoteSearchInfo rsi : searchInfos) {
            String sid = rsi.sid();
            RemoteSearchState rss = remoteSearchMetadataMap.get(sid);
            if (rss == null) {
                return false;
            }
            if (rss.hasFshMetricsArrived()) continue;
            return false;
        }
        return true;
    }

    private boolean isQueryFinished(RemoteSearchInfo[] searchInfos, HashMap<String, RemoteSearchState> remoteSearchMetadataMap) {
        if (this.allQueriesFinished) {
            return true;
        }
        for (RemoteSearchInfo rsi : searchInfos) {
            String sid = rsi.sid();
            int numPeers = rsi.numPeers();
            RemoteSearchState rss = remoteSearchMetadataMap.get(sid);
            if (rss != null && rss.isQueryFinished(numPeers)) continue;
            return false;
        }
        this.allQueriesFinished = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResultChunk getNextSearchResultChunk(RemoteSearchInfo[] remoteSearchInfos, boolean waitForRsi, long rdoutTimeoutMillis, boolean abortOnRdoutTimeout, boolean partialExecution, long partialExecutionTimeout) {
        if (this.boundPort < 0) {
            return null;
        }
        if (this.rdoutTimeoutHappened) {
            return null;
        }
        boolean queryFinished = this.isExecutionFinished(remoteSearchInfos, this.remoteSearchStatusMap);
        long start = System.currentTimeMillis();
        if (this.areRemoteConnectionsCreated(remoteSearchInfos, this.remoteSearchStatusMap) && partialExecution && this.numPartialTimeouts > maxPartialExecutionTimeouts) {
            return null;
        }
        while (true) {
            long elapsed = System.currentTimeMillis() - start;
            if (partialExecution) {
                if (elapsed > partialExecutionTimeout && this.areRemoteConnectionsCreated(remoteSearchInfos, this.remoteSearchStatusMap)) {
                    ++this.numPartialTimeouts;
                    return null;
                }
            } else if (elapsed > rdoutTimeoutMillis) {
                if (abortOnRdoutTimeout) {
                    logger.error((Object)String.format("Aborting search since rd out did not send any results for a long time: %d millis, which exceeded timeout: %d secs, expected sids: %s", elapsed, rdoutTimeoutMillis, NIOSearchResultsReceiverManager.remoteSids(remoteSearchInfos)));
                    throw new RuntimeException(String.format("waited for rdout to send search results for a long time, bailing out after %d millis, sid: %s", elapsed, NIOSearchResultsReceiverManager.remoteSids(remoteSearchInfos)));
                }
                this.rdoutTimeoutHappened = true;
                return null;
            }
            if (this.remoteSearchStatusMap.isEmpty()) {
                if (!waitForRsi) {
                    return null;
                }
                HashMap<String, RemoteSearchState> hashMap = this.remoteSearchStatusMap;
                synchronized (hashMap) {
                    try {
                        this.remoteSearchStatusMap.wait(100L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (this.failure != null) {
                throw new RuntimeException(String.format("remote search failed: sids: %s, reason: %s", NIOSearchResultsReceiverManager.remoteSids(remoteSearchInfos), this.failure.getMessage()), this.failure);
            }
            LinkedBlockingDeque<SearchResultChunk> srcache = this.cache;
            if (this.cache.isEmpty() && queryFinished) {
                return null;
            }
            try {
                SearchResultChunk chunk = srcache.poll(100L, TimeUnit.MILLISECONDS);
                if (chunk != null && chunk.hasNext()) {
                    start = System.currentTimeMillis();
                    if (this.numPartialTimeouts > 0) {
                        this.numPartialTimeouts = 0;
                    }
                    return chunk;
                }
            }
            catch (Throwable t) {
                logger.error((Object)String.format("Error reading search result from cache: %s", t.getMessage()), t);
                continue;
            }
            if (queryFinished) {
                return null;
            }
            if (!this.isExecutionFinished(remoteSearchInfos, this.remoteSearchStatusMap)) continue;
            queryFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getLogContentAsCompressedByteArray() {
        if (logFileRead) {
            return null;
        }
        byte[] content = null;
        String string = logFileReadLock;
        synchronized (string) {
            if (logFileRead) {
                return null;
            }
            try {
                File logFile = Utils.getSparkExecutorLogFile();
                FileInputStream is = new FileInputStream(logFile);
                DeflaterInputStream dis = new DeflaterInputStream(is);
                content = IOUtils.toByteArray((InputStream)dis);
                logFileRead = true;
            }
            catch (Throwable t) {
                logger.error((Object)String.format("Could not read log file: reason: %s", t.getMessage()));
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResult getLatestSRI(RemoteSearchInfo[] remoteSearchInfos, SearchResult sr, long rdoutTimeoutMillis, boolean abortOnRdoutTimeout) {
        byte[] logFileContent;
        SearchResultChunk chunk;
        long unreadRecs = 0L;
        while ((chunk = this.getNextSearchResultChunk(remoteSearchInfos, false, rdoutTimeoutMillis, abortOnRdoutTimeout, false, -1L)) != null) {
            unreadRecs += (long)chunk.size();
        }
        if (unreadRecs > 0L) {
            // empty if block
        }
        SearchResult sri = SearchResultFactory.getInstance().cloneSearchResult(this.lastSri);
        sri.getDataMap().put(RDIN_NUM_UNREAD_SRS, unreadRecs);
        int lnumPartialTimeouts = this.numPartialTimeouts;
        this.numPartialTimeouts = 0;
        if (lnumPartialTimeouts > 0) {
            sri.getDataMap().put(RDIN_PARTIAL_EXECUTION_TIMEOUTS, lnumPartialTimeouts);
            sri.getDataMap().put(RDIN_PARTIAL_EXECUTION_TIMEOUTS_EXECUTOR, currentHostIP);
        }
        ArrayList<FSHMetricsInfo> fshMetricsInfoArrayList = new ArrayList<FSHMetricsInfo>();
        for (int i = 0; i < remoteSearchInfos.length; ++i) {
            RemoteSearchState rss = this.remoteSearchStatusMap.get(remoteSearchInfos[i].getSidForFSHMetrics());
            if (rss != null) {
                FSHMetricsInfo fshMetricsInfo;
                if (!remoteSearchInfos[i].isScaledFSH() && !remoteSearchInfos[i].isFSH() || (fshMetricsInfo = rss.getFshMetricsInfo()) == null) continue;
                fshMetricsInfoArrayList.add(fshMetricsInfo);
                HashMap<String, RemoteSearchState> hashMap = this.remoteSearchStatusMap;
                synchronized (hashMap) {
                    rss = this.remoteSearchStatusMap.get(remoteSearchInfos[i].sid());
                    if (rss.getFshMetricsInfo() != null) {
                        rss.updateFshMetrics(null);
                    }
                    continue;
                }
            }
            logger.warn((Object)"RemoteSearchState was null");
        }
        if (fshMetricsInfoArrayList.size() > 0) {
            FSHMetricsInfoList fshMetricsInfoList = new FSHMetricsInfoList(fshMetricsInfoArrayList);
            sri.getDataMap().put(FSH_REMOTE_METRICS, fshMetricsInfoList);
            if (logger.isDebugEnabled()) {
                // empty if block
            }
        }
        if ((logFileContent = NIOSearchResultsReceiverManager.getLogContentAsCompressedByteArray()) != null) {
            String recvHost = (String)sr.getFieldValue(DFC_RECEIVER_HOST);
            sri.getDataMap().put(DFC_RECEIVER_HOST, recvHost);
            String executorLog = recvHost + "-exec-" + SparkEnv.get().executorId() + ".log";
            sri.getDataMap().put(DFC_EXECUTOR_LOG, executorLog);
            sri.getDataMap().put(SearchResult.FieldMeta.newFieldMeta(executorLog), logFileContent);
        }
        if (this.enableIpToQFTracking && !this.ipToQfMapping.isEmpty()) {
            HashMap<String, Boolean> hashMap = this.ipToQfMapping;
            synchronized (hashMap) {
                if (!this.ipToQfMapping.isEmpty()) {
                    HashMap<String, Boolean> ipToQFMap = new HashMap<String, Boolean>();
                    ipToQFMap.putAll(this.ipToQfMapping);
                    String recvHost = (String)sr.getFieldValue(DFC_RECEIVER_HOST);
                    String hostKey = recvHost + "-exec-" + SparkEnv.get().executorId();
                    sri.getDataMap().put(DFS_IP_QF_MAPPING_HOSTKEY_FIELD, hostKey);
                    sri.getDataMap().put(DFS_RECORD_IP_QF_MAPPING_FIELD, ipToQFMap);
                    this.ipToQfMapping.clear();
                }
            }
        }
        return sri;
    }

    static /* synthetic */ Selector access$000(NIOSearchResultsReceiverManager x0) {
        return x0.selector;
    }

    static /* synthetic */ ExecutorService access$100(NIOSearchResultsReceiverManager x0) {
        return x0.executorService;
    }

    static /* synthetic */ Pair access$400(NIOSearchResultsReceiverManager x0, SocketChannel x1, SSLEngine x2, ByteBuffer x3, ByteBuffer x4, ByteBuffer x5) throws IOException {
        return x0.read(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ int access$1300(NIOSearchResultsReceiverManager x0) {
        return x0.boundPort;
    }

    static {
        logger.info((Object)"Data Fabric Search (DFS) Version: 1.1.1");
        logger.info((Object)String.format("Created instance of receiver manager", new Object[0]));
        currentHostIP = Utils.getIpFromEnv("SPARK_LOCAL_IP", true);
        maxPartialExecutionTimeouts = 5;
        logFileRead = false;
        logFileReadLock = new String();
    }

    public static class SearchResultChunk {
        private final SearchResult[] srs;
        private int idx = 0;
        private final int size;

        private SearchResultChunk(SearchResult[] srs, int size) {
            this.srs = srs;
            this.size = size;
        }

        public int size() {
            return this.size;
        }

        public SearchResult next() {
            if (this.idx >= this.size) {
                return null;
            }
            SearchResult ret = this.srs[this.idx];
            ++this.idx;
            return ret;
        }

        public boolean hasNext() {
            return this.idx < this.size;
        }
    }

    private static class RemoteSearchState {
        private int queryFinishedCount = 0;
        private FSHMetricsInfo fshMetricsInfo = null;
        private boolean waitForFSHMetrics = false;
        private boolean fshMetrichasArrived = true;

        RemoteSearchState() {
        }

        public void incrementQueryFinishedCount() {
            ++this.queryFinishedCount;
        }

        public boolean isQueryFinished(int numIndexers) {
            return this.queryFinishedCount >= numIndexers;
        }

        public void updateFshMetrics(FSHMetricsInfo fshMetricsInfo) {
            this.fshMetricsInfo = fshMetricsInfo;
            this.waitForFSHMetrics = false;
            this.fshMetrichasArrived = true;
        }

        public FSHMetricsInfo getFshMetricsInfo() {
            return this.fshMetricsInfo;
        }

        public void setFshMetricsStatus(boolean waitNow, boolean hasArrived) {
            this.waitForFSHMetrics = waitNow;
            this.fshMetrichasArrived = hasArrived;
        }

        public boolean hasFshMetricsArrived() {
            if (this.waitForFSHMetrics) {
                return false;
            }
            return this.fshMetrichasArrived;
        }
    }
}

