/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.Args;
import com.splunk.Event;
import com.splunk.Job;
import com.splunk.JobArgs;
import com.splunk.JobCollection;
import com.splunk.RequestMessage;
import com.splunk.ResponseMessage;
import com.splunk.ResultsReaderXml;
import com.splunk.SSLSecurityProtocol;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import com.splunk.commons.search.HostPort;
import com.splunk.df.search.FSHSplunkExecutionType;
import com.splunk.df.search.NIOSearchResultsReceiverManager;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SplunkSearchEndpoint;
import com.splunk.df.search.compute.sdk.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class FSHSplunkConnectionHandler
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(FSHSplunkConnectionHandler.class);
    private static long conCounter = 1L;
    private static HashMap<String, SplunkConnectionHandler> connectionHandlerMap = new HashMap();

    public static String getVersion(String conId) {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(conId);
        if (connectionHandler == null) {
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", conId));
        }
        return connectionHandler.getRemoteVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNewConnection(SplunkSearchEndpoint sse, long fshMetaPhaseExecTimeout) {
        HashMap<String, SplunkConnectionHandler> hashMap = connectionHandlerMap;
        synchronized (hashMap) {
            String connectionId = String.format("Connection_%d", conCounter);
            SplunkConnectionHandler connectionHandler = new SplunkConnectionHandler(sse, fshMetaPhaseExecTimeout);
            ++conCounter;
            connectionHandlerMap.put(connectionId, connectionHandler);
            return connectionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupConnection(String connectionId) {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(connectionId);
        if (connectionHandler == null) {
            logger.error((Object)("Connection id " + connectionId + " nonexistant i cleanup"));
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", connectionId));
        }
        HashMap<String, SplunkConnectionHandler> hashMap = connectionHandlerMap;
        synchronized (hashMap) {
            if (connectionHandler.close()) {
                connectionHandlerMap.remove(connectionId);
                logger.info((Object)"All connections are done, so removing from the connection map");
            }
        }
    }

    public static Pair<String, Job> triggerPartitionedQuery(String fshRemoteSid, String originalUser, String conId, String searchToExecute, List<HostPort> toSendIP) {
        logger.info((Object)"Entering triggerPartitionedQuery");
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(conId);
        if (connectionHandler == null) {
            logger.error((Object)("Connection id " + conId + " nonexistent  triggerPartitionedQuery"));
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", conId));
        }
        return connectionHandler.triggerPartitionedQuery(fshRemoteSid, originalUser, searchToExecute, toSendIP);
    }

    public static Pair<String, Job> triggerPartitionedQueryForQuake(String fshRemoteSid, String originalUser, String conId, String searchToExecute, List<HostPort> toSendIP) {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(conId);
        if (connectionHandler == null) {
            logger.error((Object)("Connection id " + conId + " nonexistent  triggerPartitionedQuery"));
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", conId));
        }
        return connectionHandler.triggerPartitionedQueryForQuake(fshRemoteSid, originalUser, searchToExecute, toSendIP);
    }

    public static Pair<Integer, Job> triggerScaledQuery(String fshRemoteSid, String originalUser, String conId, String searchToExecute, String fshSearchInfo) {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(conId);
        if (connectionHandler == null) {
            logger.error((Object)("Connection id " + conId + " nonexistent for triggerScaledQuery"));
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", conId));
        }
        return connectionHandler.triggerScaledQuery(fshRemoteSid, originalUser, searchToExecute, fshSearchInfo);
    }

    public static Pair<String, Job> triggerNonPartitionedQuery(String fshRemoteSid, String conId, String searchToExecute) {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(conId);
        if (connectionHandler == null) {
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", conId));
        }
        return connectionHandler.triggerNonPartitionedQuery(fshRemoteSid, searchToExecute);
    }

    public static int getChunkSize(String connectionId) {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(connectionId);
        if (connectionHandler == null) {
            logger.error((Object)("Connection id " + connectionId + " nonexistant i getChunkSize"));
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", connectionId));
        }
        return connectionHandler.getChunkSize();
    }

    public static String getAST(String connectionId, String search) throws Exception {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(connectionId);
        if (connectionHandler == null) {
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", connectionId));
        }
        return connectionHandler.getAST(search);
    }

    public static Long getEstimatedEventCount(String connectionId, String searchForEstimation) throws Exception {
        SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(connectionId);
        if (connectionHandler == null) {
            throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", connectionId));
        }
        return connectionHandler.getEstimatedEventCount(searchForEstimation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getFSHMetrics(String connectionId, long[] scanCount, long[] eventCount, long[] resultCount, double[] duration, String[] errorMessages) {
        HashMap<String, SplunkConnectionHandler> hashMap = connectionHandlerMap;
        synchronized (hashMap) {
            SplunkConnectionHandler connectionHandler = connectionHandlerMap.get(connectionId);
            if (connectionHandler == null) {
                throw new IllegalArgumentException(String.format("Incorrect connection id=%s requested for Splunk FSH execution", connectionId));
            }
            connectionHandler.getFSHMetrics(scanCount, eventCount, resultCount, duration, errorMessages);
        }
    }

    private static class SplunkConnectionHandler {
        private final String user;
        private final String password;
        private final String host;
        private final String app;
        private final int port;
        private String queryToFire;
        private Service service;
        private Integer numberOfConnections;
        private String sidUsedToTrigger;
        private long fshMetaPhaseExecTimeout;

        SplunkConnectionHandler(SplunkSearchEndpoint sse, long fshMetaPhaseExecTimeout) {
            this.user = sse.getUser();
            this.password = sse.getPassword();
            this.queryToFire = sse.getSPL();
            this.host = sse.getHost();
            this.port = sse.getPort();
            this.service = null;
            this.numberOfConnections = 0;
            this.app = sse.getApp();
            this.fshMetaPhaseExecTimeout = fshMetaPhaseExecTimeout;
        }

        private void connect() {
            ServiceArgs serviceArgs = new ServiceArgs();
            serviceArgs.setUsername(this.user);
            serviceArgs.setPassword(this.password);
            serviceArgs.setHost(this.host);
            serviceArgs.setPort(this.port);
            serviceArgs.setApp(this.app);
            serviceArgs.setSSLSecurityProtocol(SSLSecurityProtocol.TLSv1_2);
            this.service = Service.connect((Map)serviceArgs);
        }

        public String getRemoteVersion() {
            if (this.service == null) {
                this.connect();
            }
            return this.service.version;
        }

        public int getChunkSize() {
            return 50000;
        }

        private Pair<String, Job> triggerNonPartitionedQuery(String fshRemoteSid, String searchToExecute) {
            if (this.service == null) {
                this.connect();
            }
            Integer n = this.numberOfConnections;
            Integer n2 = this.numberOfConnections = Integer.valueOf(this.numberOfConnections + 1);
            JobCollection jobs = this.service.getJobs();
            JobArgs jobArgs = new JobArgs();
            if (fshRemoteSid != null) {
                jobArgs.setId(fshRemoteSid);
            }
            jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
            jobArgs.setMaximumCount(Integer.MAX_VALUE);
            jobArgs.setAutoCancel(0);
            this.queryToFire = searchToExecute;
            Job job = jobs.create(this.queryToFire, jobArgs);
            this.sidUsedToTrigger = fshRemoteSid;
            logger.info((Object)String.format("Triggering non-partitioned search on remote SH=%s port=%d user=%s password=***** search=%s sid=%s", this.host, this.port, this.user, this.queryToFire, this.sidUsedToTrigger));
            return new Pair<String, Job>(this.sidUsedToTrigger, job);
        }

        private Pair<String, Job> triggerPartitionedQuery(String fshRemoteSid, String originalUser, String searchToExecute, List<HostPort> toIpList) {
            if (this.service == null) {
                this.connect();
            }
            Integer n = this.numberOfConnections;
            Integer n2 = this.numberOfConnections = Integer.valueOf(this.numberOfConnections + 1);
            JobCollection jobs = this.service.getJobs();
            JobArgs jobArgs = new JobArgs();
            jobArgs.setId(fshRemoteSid);
            jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
            jobArgs.setMaximumCount(Integer.MAX_VALUE);
            jobArgs.setAutoCancel(0);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < toIpList.size(); ++i) {
                sb.append(toIpList.get(i).toString());
                if (i == toIpList.size() - 1) continue;
                sb.append(",");
            }
            String workerlist = sb.toString();
            jobArgs.put((Object)"workers", (Object)workerlist);
            jobArgs.put((Object)"partition_method", (Object)"vpc");
            jobArgs.put((Object)"original_user", (Object)originalUser);
            Job job = jobs.create(searchToExecute, jobArgs);
            this.sidUsedToTrigger = fshRemoteSid;
            logger.info((Object)String.format("Triggering partitioned search on remote SH=%s port=%d user=%s password=***** search=%s sid=%s", this.host, this.port, this.user, searchToExecute, this.sidUsedToTrigger));
            return new Pair<String, Job>(this.sidUsedToTrigger, job);
        }

        private Pair<String, Job> triggerPartitionedQueryForQuake(String fshRemoteSid, String originalUser, String searchToExecute, List<HostPort> toIpList) {
            if (this.service == null) {
                this.connect();
            }
            Integer n = this.numberOfConnections;
            Integer n2 = this.numberOfConnections = Integer.valueOf(this.numberOfConnections + 1);
            JobCollection jobs = this.service.getJobs();
            JobArgs jobArgs = new JobArgs();
            if (fshRemoteSid != null) {
                jobArgs.setId(fshRemoteSid);
            }
            jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
            jobArgs.setMaximumCount(Integer.MAX_VALUE);
            jobArgs.setAutoCancel(0);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < toIpList.size(); ++i) {
                sb.append(toIpList.get(i).toString());
                if (i == toIpList.size() - 1) continue;
                sb.append(",");
            }
            String workerlist = sb.toString();
            jobArgs.put((Object)"fshExecution", (Object)"enabled");
            jobArgs.put((Object)"fshExecutionType", (Object)FSHSplunkExecutionType.SH.name().toLowerCase());
            jobArgs.put((Object)"dfsWorkers", (Object)workerlist);
            jobArgs.put((Object)"partition_method", (Object)"vpc");
            jobArgs.put((Object)"original_user", (Object)originalUser);
            Job job = jobs.create(searchToExecute, jobArgs);
            this.sidUsedToTrigger = fshRemoteSid;
            logger.info((Object)String.format("Triggering partitioned search on remote SH=%s port=%d user=%s password=***** search=%s sid=%s", this.host, this.port, this.user, searchToExecute, this.sidUsedToTrigger));
            return new Pair<String, Job>(this.sidUsedToTrigger, job);
        }

        private Pair<Integer, Job> triggerScaledQuery(String fshRemoteSid, String originalUser, String searchToExecute, String fshSearchInfo) {
            if (this.service == null) {
                this.connect();
            }
            Integer n = this.numberOfConnections;
            Integer n2 = this.numberOfConnections = Integer.valueOf(this.numberOfConnections + 1);
            JobCollection jobs = this.service.getJobs();
            JobArgs jobArgs = new JobArgs();
            logger.info((Object)("The fsh sid being set is " + fshRemoteSid));
            if (fshRemoteSid != null) {
                jobArgs.setId(fshRemoteSid);
            }
            jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
            jobArgs.setMaximumCount(Integer.MAX_VALUE);
            jobArgs.setAutoCancel(0);
            jobArgs.put((Object)"fshExecution", (Object)"enabled");
            jobArgs.put((Object)"fshExecutionType", (Object)FSHSplunkExecutionType.FABRIC.name().toLowerCase());
            jobArgs.put((Object)"fshScaledInfo", (Object)fshSearchInfo);
            jobArgs.put((Object)"original_user", (Object)originalUser);
            Job job = jobs.create(searchToExecute, jobArgs);
            this.sidUsedToTrigger = fshRemoteSid;
            logger.info((Object)String.format("Triggering scaled federated search on remote SH=%s port=%d user=%s password=***** search=%s sid=%s", this.host, this.port, this.user, searchToExecute, this.sidUsedToTrigger));
            Integer numpeer = 0;
            long start = System.currentTimeMillis();
            try {
                do {
                    long elapsedTime;
                    if ((elapsedTime = System.currentTimeMillis() - start) >= this.fshMetaPhaseExecTimeout * 1000L) {
                        throw new RuntimeException(String.format("Timed out after %d seconds while trying to fetch the number of peers for sid", this.fshMetaPhaseExecTimeout, fshRemoteSid));
                    }
                    JSONObject myjobstatus = this.getJOB(fshRemoteSid);
                    numpeer = myjobstatus.getJSONArray("entry").getJSONObject(0).getJSONObject("content").getJSONArray("searchProviders").length();
                    Thread.sleep(10L);
                } while (numpeer == 0);
            }
            catch (InterruptedException e) {
                logger.error((Object)String.format("%s", e.toString()));
            }
            catch (IOException io) {
                logger.error((Object)String.format("%s", io.toString()));
            }
            return new Pair<Integer, Job>(numpeer, job);
        }

        public JSONObject getJOB(String sid) throws IOException {
            StringBuilder sb = new StringBuilder();
            Args args = new Args("output_mode", (Object)"json");
            sb.append(String.format("search/jobs/%s?%s", sid, Args.encode((Map)args)));
            RequestMessage request = new RequestMessage("GET");
            request.getHeader().put("Content-Type", "application/x-www-form-urlencoded");
            ResponseMessage response = this.service.send(sb.toString(), request);
            return new JSONObject(this.inputStreamToString(response.getContent()));
        }

        private void waitForJobToGetReady(Job currentJob, String currentSid) {
            boolean[] abort = new boolean[1];
            long start = System.currentTimeMillis();
            try {
                while (!currentJob.isReady()) {
                    long elapsed;
                    block6: {
                        logger.debug((Object)("Job is not ready yet, time elapsed" + (System.currentTimeMillis() - start)));
                        try {
                            if (currentJob.isFailed()) {
                                abort[0] = true;
                                throw new RuntimeException(String.format("search job failed for sid: %s", currentSid));
                            }
                            Thread.sleep(10L);
                        }
                        catch (Throwable t) {
                            if (!abort[0]) break block6;
                            throw new RuntimeException(String.format("aborting search since search failed: %s", currentSid));
                        }
                    }
                    if ((elapsed = System.currentTimeMillis() - start) <= 600000L) continue;
                    RuntimeException re = new RuntimeException(String.format("search job did not report as ready within timeout limits: sid: %s, elapsed: %d millis", currentSid, elapsed));
                    NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(currentSid, re);
                    throw re;
                }
            }
            catch (Throwable t) {
                return;
            }
            logger.info((Object)String.format("Splunk search:%s, ready to return results.", currentSid));
        }

        public String getAST(String search) throws Exception {
            JSONObject param = new JSONObject();
            param.put("spl", (Object)search);
            JSONArray array = new JSONArray();
            array.put((Object)new JSONObject().put("name", (Object)"inline_savedsearch"));
            array.put((Object)new JSONObject().put("name", (Object)"inline_datamodel"));
            array.put((Object)new JSONObject().put("name", (Object)"expand_search"));
            array.put((Object)new JSONObject().put("name", (Object)"inline_from"));
            array.put((Object)new JSONObject().put("name", (Object)"enable_dfs"));
            param.put("actions", (Object)array);
            RequestMessage request = new RequestMessage("POST");
            request.getHeader().put("Content-Type", "application/x-www-form-urlencoded");
            request.setContent(param.toString());
            ResponseMessage response = this.service.send("search/ast", request);
            return this.inputStreamToString(response.getContent());
        }

        private String inputStreamToString(InputStream stream) throws IOException {
            String tmp;
            StringBuilder b = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((tmp = reader.readLine()) != null) {
                b.append(tmp + "\n");
            }
            return b.toString();
        }

        public Long getEstimatedEventCount(String searchForEstimation) throws Exception {
            Event event;
            if (this.service == null) {
                this.connect();
            }
            JobCollection jobs = this.service.getJobs();
            JobArgs jobArgs = new JobArgs();
            jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
            jobArgs.setMaximumCount(Integer.MAX_VALUE);
            jobArgs.setAutoCancel(0);
            Long estimatedEventCount = 0L;
            Job job = jobs.create(searchForEstimation, jobArgs);
            String sid = job.getSid();
            logger.info((Object)String.format("Triggering estimation search on remote SH=%s port=%d user=%s password=***** search=%s sid=%s", this.host, this.port, this.user, searchForEstimation, sid));
            long start = System.currentTimeMillis();
            while (!job.isDone()) {
                try {
                    logger.debug((Object)("Event estimation count is not ready yet, time elapsed: " + (System.currentTimeMillis() - start)));
                    long elapsed = System.currentTimeMillis() - start;
                    if (elapsed > this.fshMetaPhaseExecTimeout * 1000L) {
                        logger.error((Object)String.format("Event estimation count could not be completed for sid: %s, elapsed: %d millis", sid, elapsed));
                        RuntimeException re = new RuntimeException(String.format("Event estimation count could not be completed for sid: %s, elapsed: %d millis", sid, elapsed));
                        NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(sid, re);
                        throw re;
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            InputStream resultsNormalSearch = job.getResults();
            ResultsReaderXml resultsReaderNormalSearch = new ResultsReaderXml(resultsNormalSearch);
            while ((event = resultsReaderNormalSearch.getNextEvent()) != null) {
                for (String key : event.keySet()) {
                    if (!key.equalsIgnoreCase("count")) continue;
                    estimatedEventCount = estimatedEventCount + Long.parseLong((String)event.get(key));
                }
            }
            return estimatedEventCount;
        }

        public boolean close() {
            Integer n = this.numberOfConnections;
            Integer n2 = this.numberOfConnections = Integer.valueOf(this.numberOfConnections - 1);
            if (this.numberOfConnections == 0) {
                this.service.logout();
                return true;
            }
            if (this.numberOfConnections < 0) {
                throw new IllegalStateException("Trying to close an already closed connection");
            }
            return false;
        }

        public void getFSHMetrics(long[] scanCount, long[] eventCount, long[] resultCount, double[] duration, String[] error) {
            try {
                JSONObject currentJobStatus = this.getJOB(this.sidUsedToTrigger).getJSONArray("entry").getJSONObject(0).getJSONObject("content");
                scanCount[0] = currentJobStatus.getLong("scanCount");
                eventCount[0] = currentJobStatus.getLong("eventCount");
                resultCount[0] = currentJobStatus.getLong("resultCount");
                duration[0] = currentJobStatus.getDouble("runDuration");
                JSONArray messages = currentJobStatus.getJSONArray("messages");
                if (messages != null && messages.length() > 0) {
                    for (int i = 0; i < messages.length(); ++i) {
                        JSONObject message = messages.getJSONObject(i);
                        if (message == null || !message.getString("type").equals("ERROR")) continue;
                        error[0] = error[0] + "[ERROR]" + message.getString("text") + "\n";
                    }
                }
                logger.info((Object)String.format("scancount=%d eventCount=%d resultCount=%d duration=%f error=%s", scanCount[0], eventCount[0], resultCount[0], duration[0], error[0]));
            }
            catch (IOException e) {
                logger.error((Object)String.format("%s", e.toString()));
            }
        }
    }
}

