/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.json.JSONObject;

public class FSHMetricsInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String remoteSid;
    private long scanCount;
    private long eventCount;
    private long resultCount;
    private double duration;
    private String query;
    private String dataSetName;
    private String deploymentName;
    private String serviceAccount;
    private String serviceAccountProvider;
    private boolean success;
    private boolean isScaledFSH;

    public FSHMetricsInfo(String sid, String dataSetName, String deploymentName, String serviceAccount, String serviceAccountProvider, String query, long eventCount, long resultCount, long scanCount, double duration, boolean success) {
        this.remoteSid = sid;
        this.scanCount = scanCount;
        this.eventCount = eventCount;
        this.resultCount = resultCount;
        this.duration = duration;
        this.dataSetName = dataSetName;
        this.deploymentName = deploymentName;
        this.serviceAccount = serviceAccount;
        this.serviceAccountProvider = serviceAccountProvider;
        this.query = query;
        this.success = success;
        this.isScaledFSH = false;
    }

    public FSHMetricsInfo(String sid, String dataSetName, String deploymentName, String serviceAccount, String serviceAccountProvider, String query, long eventCount, long resultCount, long scanCount, double duration, boolean success, boolean isScaledFSH) {
        this.remoteSid = sid;
        this.scanCount = scanCount;
        this.eventCount = eventCount;
        this.resultCount = resultCount;
        this.duration = duration;
        this.dataSetName = dataSetName;
        this.deploymentName = deploymentName;
        this.serviceAccount = serviceAccount;
        this.serviceAccountProvider = serviceAccountProvider;
        this.query = query;
        this.success = success;
        this.isScaledFSH = isScaledFSH;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getQuery() {
        return this.query;
    }

    public long getScanCount() {
        return this.scanCount;
    }

    public long getEventCount() {
        return this.eventCount;
    }

    public double getDuration() {
        return this.duration;
    }

    public long getResultCount() {
        return this.resultCount;
    }

    public String getRemoteSid() {
        return this.remoteSid;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getServiceAccountProvider() {
        return this.serviceAccountProvider;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public boolean isFshMetricsScaled() {
        return this.isScaledFSH;
    }

    public JSONObject toJson() {
        JSONObject fshMetric = new JSONObject();
        fshMetric.put("remoteSid", (Object)this.remoteSid);
        fshMetric.put("datasetName", (Object)this.dataSetName);
        fshMetric.put("deploymentName", (Object)this.deploymentName);
        fshMetric.put("serviceAccount", (Object)this.serviceAccount);
        fshMetric.put("serviceAccountProvider", (Object)this.serviceAccountProvider);
        fshMetric.put("remoteFSHSearch", (Object)this.query);
        fshMetric.put("remoteEventCount", this.eventCount);
        if (!this.isScaledFSH) {
            fshMetric.put("remoteResultCount", this.resultCount);
        }
        fshMetric.put("remoteScanCount", this.scanCount);
        fshMetric.put("remoteDuration", this.duration);
        fshMetric.put("executionSuccess", this.success);
        return fshMetric;
    }

    public String toString() {
        if (this.isScaledFSH) {
            return String.format("Remote Deployment Info: deploymentName=%s datasetName=%s remoteSearch=%s %s.serviceAccount=%s remoteSid=%s remoteEvent=%d remoteScanCount=%d duration=%f", this.deploymentName, this.dataSetName, this.query, this.serviceAccountProvider, this.serviceAccount, this.remoteSid, this.eventCount, this.scanCount, this.duration);
        }
        return String.format("Remote Deployment Info: deploymentName=%s datasetName=%s remoteSearch=%s %s.serviceAccount=%s remoteSid=%s remoteEvent=%d remoteScanCount=%d remoteResultCount=%d duration=%f", this.deploymentName, this.dataSetName, this.query, this.serviceAccountProvider, this.serviceAccount, this.remoteSid, this.eventCount, this.scanCount, this.resultCount, this.duration);
    }

    public static void write(OutputStream os, FSHMetricsInfo fshMetricsInfo) throws IOException {
        Utils.write(os, fshMetricsInfo.remoteSid);
        Utils.write(os, fshMetricsInfo.scanCount);
        Utils.write(os, fshMetricsInfo.eventCount);
        Utils.write(os, fshMetricsInfo.resultCount);
        Utils.write(os, fshMetricsInfo.duration);
        Utils.write(os, fshMetricsInfo.query);
        Utils.write(os, fshMetricsInfo.dataSetName);
        Utils.write(os, fshMetricsInfo.deploymentName);
        Utils.write(os, fshMetricsInfo.serviceAccount);
        Utils.write(os, fshMetricsInfo.serviceAccountProvider);
        Utils.write(os, fshMetricsInfo.success);
        Utils.write(os, fshMetricsInfo.isScaledFSH);
    }

    public static FSHMetricsInfo read(InputStream is) throws IOException {
        String dsRemoteSid = Utils.readString(is);
        long dsScanCount = Utils.readLong(is);
        long dsEventCount = Utils.readLong(is);
        long dsResultCount = Utils.readLong(is);
        double dsduration = Utils.readDouble(is);
        String dsQuery = Utils.readString(is);
        String dsDatasetName = Utils.readString(is);
        String dsDeploymentName = Utils.readString(is);
        String dsServiceAccount = Utils.readString(is);
        String dsServiceAccountProvider = Utils.readString(is);
        boolean dsSuccess = Utils.readBoolean(is);
        boolean dsisScaledFSH = Utils.readBoolean(is);
        return new FSHMetricsInfo(dsRemoteSid, dsDatasetName, dsDeploymentName, dsServiceAccount, dsServiceAccountProvider, dsQuery, dsEventCount, dsResultCount, dsScanCount, dsduration, dsSuccess, dsisScaledFSH);
    }
}

