/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.SplunkSearchResultsIterator;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.sdk.Pair;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

@Deprecated
public class DFSEventReceiverManager
implements DFSSearchConstants {
    static final Logger logger = Logger.getLogger(DFSEventReceiverManager.class);
    private static final int CHUNK_CACHE_MAX_SIZE = 50000;
    private static DFSEventReceiverManager singleton = null;
    private HashMap<String, DFSEventReceivers> receiverMap = new HashMap();
    private ScheduledExecutorService ses = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    private static Integer lastBoundPort;

    private DFSEventReceiverManager() {
    }

    public static DFSEventReceiverManager getInstance() {
        return singleton;
    }

    public void stopReceiver(String remoteSid, int port) {
        DFSEventReceivers receivers = this.receiverMap.get(remoteSid);
        if (receivers == null) {
            logger.error((Object)("no receivers found for sid: " + remoteSid));
            return;
        }
        receivers.stopReceiving(port);
    }

    private static ServerSocket startReceiver(int startPort) {
        long start = System.currentTimeMillis();
        Integer n = lastBoundPort;
        synchronized (n) {
            if (lastBoundPort > 0) {
                startPort = lastBoundPort + 1;
            }
            while (true) {
                try {
                    ServerSocket ss = new ServerSocket(startPort);
                    lastBoundPort = startPort;
                    return ss;
                }
                catch (Throwable t) {
                    logger.error((Object)String.format("could not bind to port: %d, will try with: %d", startPort, startPort + 1));
                    ++startPort;
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addListener(final String remoteSid, int numberOfIndexers, int startPort) {
        DFSEventReceivers receivers;
        final ServerSocket ss = DFSEventReceiverManager.startReceiver(startPort);
        final int port = ss.getLocalPort();
        HashMap<String, DFSEventReceivers> hashMap = this.receiverMap;
        synchronized (hashMap) {
            receivers = this.receiverMap.get(remoteSid);
            if (receivers == null) {
                receivers = new DFSEventReceivers(remoteSid);
                this.receiverMap.put(remoteSid, receivers);
            }
            receivers.updateFinalCount(numberOfIndexers);
        }
        DFSEventReceiver recv = receivers.addReceiver(ss);
        final DFSEventReceivers tempRecvs = receivers;
        final LinkedBlockingDeque<SearchResult> chunkCache = receivers.getSrCache();
        this.ses.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    Socket tempS;
                    while ((tempS = ss.accept()) != null) {
                        final Socket s = tempS;
                        DFSEventReceiverManager.this.ses.schedule(new DFCRunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void runInternal() throws Exception {
                                String senderHost = s.getInetAddress().getHostName();
                                int senderPort = s.getPort();
                                logger.info((Object)("connected to sender: host: " + senderHost + ", port: " + senderPort));
                                InputStream iStream = null;
                                try {
                                    BufferedReader br = new BufferedReader(new InputStreamReader(s.getInputStream()));
                                    Pair<SearchResult, Iterator<SearchResult>> srisrs = SplunkSearchResultsIterator.iterator(br);
                                    SearchResult sri = srisrs.first();
                                    Iterator<SearchResult> srs = srisrs.second();
                                    while (srs.hasNext()) {
                                        SearchResult sr = srs.next();
                                        while (!chunkCache.offer(sr, 1000L, TimeUnit.MILLISECONDS)) {
                                        }
                                    }
                                    boolean queryFinished = false;
                                    queryFinished = tempRecvs.updateSri(sri);
                                    logger.info((Object)("all events read from sender host: " + senderHost + " port -->" + senderPort));
                                }
                                catch (Throwable t) {
                                    logger.error((Object)("error while reading from sender: " + s.getRemoteSocketAddress()), t);
                                }
                                finally {
                                    if (iStream != null) {
                                        try {
                                            iStream.close();
                                            logger.info((Object)("closed reader for sender: " + s.getRemoteSocketAddress()));
                                        }
                                        catch (Throwable t) {
                                            logger.error((Object)"error while closing sender reader", t);
                                        }
                                    }
                                    try {
                                        s.close();
                                    }
                                    catch (Throwable t) {
                                        logger.error((Object)"error while closing socket", t);
                                    }
                                }
                            }
                        }, 0L, TimeUnit.SECONDS);
                    }
                }
                catch (Throwable t) {
                    DFSEventReceiverManager.this.stopReceiver(remoteSid, port);
                }
            }
        }, 0L, TimeUnit.SECONDS);
        return port;
    }

    public SearchResult getUpdatedSri(String remoteSid) {
        DFSEventReceivers receivers = this.receiverMap.get(remoteSid);
        if (receivers == null) {
            throw new RuntimeException(String.format("receivers for found for remote sid: %s", remoteSid));
        }
        return receivers.getSRI();
    }

    public SearchResult getNextSearchResult(String remoteSid) {
        DFSEventReceivers receivers = this.receiverMap.get(remoteSid);
        if (receivers == null) {
            logger.error((Object)("Receivers not found for remoteSid==>" + remoteSid));
            return null;
        }
        LinkedBlockingDeque<SearchResult> srCache = receivers.getSrCache();
        if (srCache == null) {
            throw new RuntimeException(String.format("chunk cache not found for remote sid: %s", remoteSid));
        }
        SearchResult sr = null;
        boolean queryFinished = false;
        try {
            long lastAlert = System.currentTimeMillis();
            while ((sr = srCache.poll(10L, TimeUnit.MILLISECONDS)) == null) {
                long curr;
                long elapsed;
                if (queryFinished) {
                    receivers.shutdown();
                    break;
                }
                SearchResult sri = receivers.getUpdatedSri();
                if (sri == null || (queryFinished = ((Boolean)sri.getFieldValue(REMOTE_SEARCH_QUERY_FINISHED)).booleanValue()) || (elapsed = (curr = System.currentTimeMillis()) - lastAlert) <= 10000L) continue;
                logger.error((Object)String.format("!!!! query finished not received, cache is empty even after %d millis; will wait: remote sid: %s", elapsed, remoteSid));
                lastAlert = curr;
            }
        }
        catch (Throwable t) {
            logger.error((Object)String.format("error occurred while reading events from cache: %s", t.getMessage()), t);
            throw new RuntimeException(t);
        }
        return sr;
    }

    static {
        singleton = new DFSEventReceiverManager();
        lastBoundPort = -1;
    }

    static class DFSEventReceivers {
        private final Object lock;
        private LinkedBlockingDeque<SearchResult> srCache;
        private SearchResult latestSRIForReceiver;
        private ArrayList<DFSEventReceiver> receivers;
        private long startTime;
        private String remoteSid;
        private int finishedCount;
        private int currentCount;
        private String currentHost;
        private int currentPort;
        private String[] fieldNames;
        private Object[] values;
        HashMap<String, Object> data = new HashMap();

        DFSEventReceivers(String remoteSid) {
            this.remoteSid = remoteSid;
            this.srCache = new LinkedBlockingDeque(50000);
            this.receivers = new ArrayList();
            this.startTime = System.currentTimeMillis();
            this.lock = new Object();
            this.finishedCount = 0;
            this.currentCount = 0;
            this.currentHost = "";
            this.currentPort = -1;
            this.values = new Object[2];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            ArrayList<DFSEventReceiver> arrayList = this.receivers;
            synchronized (arrayList) {
                for (DFSEventReceiver rec : this.receivers) {
                    try {
                        rec.close();
                    }
                    catch (Throwable t) {
                        logger.error((Object)String.format("error closing receiver: %s", rec.toString()));
                    }
                }
            }
        }

        public void updateFinalCount(int numberOfSplunkPeers) {
            this.finishedCount += numberOfSplunkPeers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateSri(SearchResult sri) {
            boolean queryFinished = "1".equals(sri.getDataMap().get(DFSSearchConstants.REMOTE_SEARCH_QUERY_FINISHED).toString().trim());
            Object object = this.lock;
            synchronized (object) {
                if (queryFinished) {
                    ++this.currentCount;
                }
                if (this.finishedCount <= this.currentCount) {
                    sri.updateField(DFSSearchConstants.REMOTE_SEARCH_QUERY_FINISHED, true);
                } else {
                    sri.updateField(DFSSearchConstants.REMOTE_SEARCH_QUERY_FINISHED, false);
                }
                this.latestSRIForReceiver = sri;
            }
            return queryFinished;
        }

        long getStartTime() {
            return this.startTime;
        }

        int getNoOfReceivers() {
            return this.receivers.size();
        }

        LinkedBlockingDeque<SearchResult> getSrCache() {
            return this.srCache;
        }

        SearchResult getUpdatedSri() {
            return this.latestSRIForReceiver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DFSEventReceiver addReceiver(ServerSocket ss) {
            DFSEventReceiver recv = new DFSEventReceiver(this.remoteSid, ss);
            ArrayList<DFSEventReceiver> arrayList = this.receivers;
            synchronized (arrayList) {
                this.receivers.add(recv);
            }
            return recv;
        }

        void removeReceiver(DFSEventReceiver recv) {
            recv.close();
            this.receivers.remove(recv);
        }

        public boolean isEmpty() {
            return this.receivers.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopReceiving(int port) {
            ArrayList<DFSEventReceiver> arrayList = this.receivers;
            synchronized (arrayList) {
                for (DFSEventReceiver receiver : this.receivers) {
                    if (receiver.port != port) continue;
                    receiver.close();
                    this.receivers.remove(receiver);
                    break;
                }
            }
        }

        public SearchResult getSRI() {
            return this.latestSRIForReceiver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addHostPort(String currentHost, int port) {
            Object object = this.lock;
            synchronized (object) {
                if (this.currentPort == -1) {
                    this.currentPort = port;
                    this.currentHost = currentHost;
                    this.values[0] = currentHost + ":" + Integer.toString(this.currentPort);
                    logger.info((Object)("Adding host port -->" + this.values[0]));
                    this.data.put(this.fieldNames[0], this.values[0]);
                } else {
                    assert (this.currentPort == port);
                    assert (this.currentHost.equalsIgnoreCase(currentHost));
                }
            }
        }
    }

    private static class DFSEventReceiver {
        private ServerSocket ss;
        private int port;
        private String remoteSid;

        DFSEventReceiver(String remoteSid, ServerSocket ss) {
            this.remoteSid = remoteSid;
            this.ss = ss;
            this.port = ss.getLocalPort();
        }

        public String toString() {
            return String.format("receiver: %s, %d", this.remoteSid, this.port);
        }

        void close() {
            if (this.ss == null) {
                return;
            }
            try {
                this.ss.close();
                this.ss = null;
            }
            catch (Throwable t) {
                logger.error((Object)"could not close server socket", t);
            }
        }
    }
}

