/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.NIOSearchResultsReceiverManager;
import com.splunk.df.search.RemoteSearchInfo;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.MapPartitioner;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BaseInputDDFactory
implements DFSSearchConstants,
ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(BaseInputDDFactory.class);
    private static boolean abortOnRdoutTimeout = false;

    private static long getRdinSampleSize() {
        long sample = 10L;
        String sampleStr = System.getenv("DFS_RDIN_SAMPLE_SIZE");
        boolean setViaEnvvar = false;
        if (sampleStr != null && !sampleStr.trim().isEmpty()) {
            try {
                sample = Long.valueOf(sampleStr);
                setViaEnvvar = true;
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse rdin sample size to long: %s", sampleStr));
            }
        }
        logger.info((Object)String.format("rdin sample size set to: %d, via envvar ? :%b", sample, setViaEnvvar));
        return sample;
    }

    private static long getPartialExecutionTimeout() {
        long timeout = 30L;
        String timeoutStr = System.getenv("DFS_PARTIAL_EXECUTION_TIMEOUT_SECS");
        boolean setViaEnvvar = false;
        if (timeoutStr != null && !timeoutStr.trim().isEmpty()) {
            try {
                timeout = Long.parseLong(timeoutStr);
                setViaEnvvar = true;
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse partial execution timeout to long: %s", timeoutStr));
            }
        }
        logger.info((Object)String.format("set partial execution timeout to: %d secs, based on envvar: %b", timeout, setViaEnvvar));
        return timeout;
    }

    public static DistributedDataset createInputDD(DistributedDataset receiversDD, final RemoteSearchInfo[] remoteSearchInfos, final long parSize, ComputeEngineContext ctx) {
        logger.info((Object)String.format("Base rdin dd partition size: %d", parSize));
        long timeout = 30000L;
        if (ctx.hasContext("DFS_REMOTE_SEARCH_TIMEOUT_SECS")) {
            timeout = (Long)ctx.get("DFS_REMOTE_SEARCH_TIMEOUT_SECS") * 1000L;
        }
        boolean partialExecution = false;
        long partialExecutionTimeout = -1L;
        if (ctx.hasContext("DFS_PARTIAL_EXECUTION")) {
            partialExecution = true;
            partialExecutionTimeout = BaseInputDDFactory.getPartialExecutionTimeout() * 1000L;
        }
        final long rdoutTimeoutMillis = timeout;
        final boolean finalPartialExecution = partialExecution;
        final long finalPartialExecutionTimeout = partialExecutionTimeout;
        DistributedDataset srDD = receiversDD.transform(new MapPartitioner(){
            private static final long serialVersionUID = 1L;

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.UNKNOWN;
            }

            @Override
            public Iterator<SearchResult> mapPartitions(int parid, Iterator<SearchResult> srs) {
                final SearchResult.SRContext parCtx = new SearchResult.SRContext(-1);
                return new Iterator<SearchResult>(){
                    NIOSearchResultsReceiverManager.SearchResultChunk chunk = null;
                    long srReturnedSoFar = 0L;

                    @Override
                    public boolean hasNext() {
                        if (!NIOSearchResultsReceiverManager.getInstance().isReceiverStarted()) {
                            return false;
                        }
                        if (this.chunk != null && this.chunk.hasNext()) {
                            return true;
                        }
                        if (parCtx.getSrsInPartition() > parSize || this.srReturnedSoFar > parSize) {
                            return false;
                        }
                        this.chunk = NIOSearchResultsReceiverManager.getInstance().getNextSearchResultChunk(remoteSearchInfos, true, rdoutTimeoutMillis, abortOnRdoutTimeout, finalPartialExecution, finalPartialExecutionTimeout);
                        if (this.chunk != null && this.chunk.hasNext()) {
                            return true;
                        }
                        if (logger.isDebugEnabled()) {
                            // empty if block
                        }
                        return false;
                    }

                    @Override
                    public SearchResult next() {
                        SearchResult ret = this.chunk.next();
                        ret.setContext(parCtx);
                        ++this.srReturnedSoFar;
                        return ret;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public String desc() {
                return "baseInputDdReadFromNIOReciever";
            }
        });
        if (remoteSearchInfos.length > 1) {
            srDD = srDD.cacheDisk();
            logger.info((Object)String.format("Since number of remote searches > 1: %d - the dd is cached (disk) for per remote sid filtration", remoteSearchInfos.length));
        } else {
            logger.info((Object)String.format("Since number of remote searches < 2: %d the dd is NOT cached for per remote sid filtration", remoteSearchInfos.length));
        }
        String cacheBaseDDStr = System.getenv("DFC_CACHE_BASE_DD");
        if (cacheBaseDDStr != null && Boolean.valueOf(cacheBaseDDStr).booleanValue()) {
            long start = System.currentTimeMillis();
            if (remoteSearchInfos.length == 1) {
                srDD = srDD.cacheDisk();
                logger.info((Object)String.format("as instructed by envvar - caching the base dd for read stats even though it is a single sourced dag", new Object[0]));
            }
            long count = srDD.count();
            long elapsed = System.currentTimeMillis() - start;
            logger.info((Object)String.format("number of records read by base dd: %d, total time: %d millis, recs read per millis: %d", count, elapsed, count / elapsed));
            try {
                List<SearchResult> sample = srDD.retrieve((int)BaseInputDDFactory.getRdinSampleSize());
                logger.info((Object)String.format("sample records received by base dd: ", new Object[0]));
                for (SearchResult sr : sample) {
                    logger.info((Object)String.format("sample based dd record: %s", sr.toString()));
                }
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("error fetching sample records from rdin dataset: %s", t.getMessage()));
            }
        }
        logger.info((Object)String.format("Number of partitions of rdin dataset: %d", srDD.partitions()));
        DistributedDataset sriDD = receiversDD.transform(new MapPartitioner(){
            private static final long serialVersionUID = 1L;

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }

            @Override
            public Iterator<SearchResult> mapPartitions(int parid, Iterator<SearchResult> srs) {
                if (!NIOSearchResultsReceiverManager.getInstance().isReceiverStarted()) {
                    return new ArrayList().iterator();
                }
                if (!srs.hasNext()) {
                    logger.warn((Object)String.format("receiversdd should have at least one host port control record within a partition: par id%d", parid));
                    return new ArrayList().iterator();
                }
                SearchResult sr = srs.next();
                ArrayList<SearchResult> sris = new ArrayList<SearchResult>(3);
                SearchResult sri = NIOSearchResultsReceiverManager.getInstance().getLatestSRI(remoteSearchInfos, sr, rdoutTimeoutMillis, abortOnRdoutTimeout);
                if (sri != null) {
                    sris.add(sri);
                }
                return sris.iterator();
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public String desc() {
                return "basedInputDdGetSriFromNIOReceiver";
            }
        });
        int currPars = sriDD.partitions();
        int compactPars = BaseInputDDFactory.compactSriPartitions(currPars);
        if (compactPars < currPars) {
            sriDD = sriDD.repartition(compactPars);
            logger.info((Object)String.format("repartitioning sri dd to: %d partitions for faster retrieval, not coalescing to avoid moving tasks", compactPars));
        }
        srDD = srDD.setSriDD(sriDD);
        logger.info((Object)String.format("Number of partitions in sriDD: %d, and number of pars in receivers dd: %d", sriDD.partitions(), srDD.partitions()));
        return srDD;
    }

    private static int compactSriPartitions(int pars) {
        int maxPars = 100;
        String maxParsStr = System.getenv("DFS_MAX_SRI_PARTITION_COUNT");
        boolean setViaEnvvar = false;
        if (maxParsStr != null && !maxParsStr.trim().isEmpty()) {
            try {
                maxPars = Integer.valueOf(maxParsStr);
                setViaEnvvar = true;
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse %s to int - sri max partitions", maxParsStr));
            }
        }
        int ret = maxPars;
        ret = Math.max(1, ret);
        logger.info((Object)String.format("max sri pars set to: %d, by envvar: %b", ret, setViaEnvvar));
        return ret;
    }

    static {
        String temp = System.getenv("DFS_ABORT_ON_RDOUT_TIMEOUT");
        if (temp != null) {
            abortOnRdoutTimeout = Boolean.parseBoolean(temp);
            logger.info((Object)String.format("abort search on rdout timeout set to: %b based on envvar", abortOnRdoutTimeout));
        } else {
            logger.info((Object)String.format("abort search on rdout timeout: %b", abortOnRdoutTimeout));
        }
    }
}

