/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.plus.annotation;

import java.util.HashMap;
import org.sparkproject.jetty.plus.annotation.RunAs;
import org.sparkproject.jetty.servlet.ServletHolder;
import org.sparkproject.jetty.util.log.Log;
import org.sparkproject.jetty.util.log.Logger;

public class RunAsCollection {
    private static final Logger LOG = Log.getLogger(RunAsCollection.class);
    public static final String RUNAS_COLLECTION = "org.sparkproject.jetty.runAsCollection";
    private HashMap<String, RunAs> _runAsMap = new HashMap();

    public void add(RunAs runAs) {
        if (runAs == null || runAs.getTargetClassName() == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding run-as for class=" + runAs.getTargetClassName(), new Object[0]);
        }
        this._runAsMap.put(runAs.getTargetClassName(), runAs);
    }

    public RunAs getRunAs(Object o) {
        if (o == null) {
            return null;
        }
        return this._runAsMap.get(o.getClass().getCanonicalName());
    }

    public void setRunAs(Object o) {
        if (o == null) {
            return;
        }
        if (!ServletHolder.class.isAssignableFrom(o.getClass())) {
            return;
        }
        RunAs runAs = this._runAsMap.get(o.getClass().getName());
        if (runAs == null) {
            return;
        }
        runAs.setRunAs((ServletHolder)o);
    }
}

