/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.util.concurrent.CompletableFuture;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.shuffle.ExternalBlockStoreClient;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001}4Qa\u0003\u0007\u0001\u001dQA\u0001\"\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!\u0011\u0005A!A!\u0002\u0013Q\u0003\"B\"\u0001\t\u0003!\u0005b\u0002'\u0001\u0005\u0004%I!\u0014\u0005\u0007;\u0002\u0001\u000b\u0011\u0002(\t\ry\u0003A\u0011\u0001\b`\u0011\u00191\u0007\u0001\"\u0001\u000fO\n\u0019\u0002j\\:u\u0019>\u001c\u0017\r\u001c#je6\u000bg.Y4fe*\u0011QBD\u0001\bgR|'/Y4f\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7c\u0001\u0001\u00167A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u0010\u000e\u0003uQ!A\b\b\u0002\u0011%tG/\u001a:oC2L!\u0001I\u000f\u0003\u000f1{wmZ5oO\u00061b-\u001e;ve\u0016,\u00050Z2vi&|gnQ8oi\u0016DHo\u0001\u0001\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019:\u0012AC2p]\u000e,(O]3oi&\u0011\u0001&\n\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011bY1dQ\u0016\u001c\u0016N_3\u0011\u0005YY\u0013B\u0001\u0017\u0018\u0005\rIe\u000e^\u0001\u0019Kb$XM\u001d8bY\ncwnY6Ti>\u0014Xm\u00117jK:$\bCA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u001d\u0019\b.\u001e4gY\u0016T!a\r\b\u0002\u000f9,Go^8sW&\u0011Q\u0007\r\u0002\u0019\u000bb$XM\u001d8bY\ncwnY6Ti>\u0014Xm\u00117jK:$\u0018\u0001\u00025pgR\u0004\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e\u0018\u001b\u0005Y$B\u0001\u001f#\u0003\u0019a$o\\8u}%\u0011ahF\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?/\u0005QR\r\u001f;fe:\fGn\u00155vM\u001adWmU3sm&\u001cW\rU8si\u00061A(\u001b8jiz\"b!R$I\u0013*[\u0005C\u0001$\u0001\u001b\u0005a\u0001\"B\u0011\u0007\u0001\u0004\u0019\u0003\"B\u0015\u0007\u0001\u0004Q\u0003\"B\u0017\u0007\u0001\u0004q\u0003\"\u0002\u001c\u0007\u0001\u00049\u0004\"\u0002\"\u0007\u0001\u0004Q\u0013AG3yK\u000e,Ho\u001c:JIR{Gj\\2bY\u0012K'o]\"bG\",W#\u0001(\u0011\t=CvGW\u0007\u0002!*\u0011\u0011KU\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003'R\u000baaY8n[>t'BA+W\u0003\u00199wn\\4mK*\tq+A\u0002d_6L!!\u0017)\u0003\u000b\r\u000b7\r[3\u0011\u0007YYv'\u0003\u0002]/\t)\u0011I\u001d:bs\u0006YR\r_3dkR|'/\u00133U_2{7-\u00197ESJ\u001c8)Y2iK\u0002\nacZ3u\u0007\u0006\u001c\u0007.\u001a3I_N$Hj\\2bY\u0012K'o\u001d\u000b\u0002AB!\u0011\rZ\u001c[\u001b\u0005\u0011'BA2\u0018\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003K\n\u00141!T1q\u0003A9W\r\u001e%pgRdunY1m\t&\u00148\u000f\u0006\u0002i{R\u0011\u0011\u000e\u001c\t\u0003-)L!a[\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006[*\u0001\rA\\\u0001\tG\u0006dGNY1dWB!ac\\9j\u0013\t\u0001xCA\u0005Gk:\u001cG/[8ocA\u0019!/^<\u000e\u0003MT!\u0001^\f\u0002\tU$\u0018\u000e\\\u0005\u0003mN\u00141\u0001\u0016:z!\u0011AHp\u000e.\u000e\u0003eT!\u0001\u001e>\u000b\u0003m\fAA[1wC&\u0011Q-\u001f\u0005\u0006}*\u0001\rAW\u0001\fKb,7-\u001e;pe&#7\u000f")
public class HostLocalDirManager
implements Logging {
    private final ExternalBlockStoreClient externalBlockStoreClient;
    private final String host;
    private final int externalShuffleServicePort;
    private final Cache<String, String[]> executorIdToLocalDirsCache;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Cache<String, String[]> executorIdToLocalDirsCache() {
        return this.executorIdToLocalDirsCache;
    }

    public Map<String, String[]> getCachedHostLocalDirs() {
        Cache<String, String[]> cache = this.executorIdToLocalDirsCache();
        synchronized (cache) {
            Map map = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.executorIdToLocalDirsCache().asMap()).asScala();
            return map;
        }
    }

    public void getHostLocalDirs(String[] executorIds, Function1<Try<java.util.Map<String, String[]>>, BoxedUnit> callback) {
        CompletableFuture hostLocalDirsCompletable = new CompletableFuture();
        this.externalBlockStoreClient.getHostLocalDirs(this.host, this.externalShuffleServicePort, executorIds, hostLocalDirsCompletable);
        hostLocalDirsCompletable.whenComplete((hostLocalDirs, throwable) -> {
            if (hostLocalDirs != null) {
                callback.apply((Object)new Success(hostLocalDirs));
                Cache<String, String[]> cache = this.executorIdToLocalDirsCache();
                synchronized (cache) {
                    this.executorIdToLocalDirsCache().putAll(hostLocalDirs);
                }
            } else {
                callback.apply((Object)new Failure(throwable));
            }
        });
    }

    public HostLocalDirManager(ExecutionContext futureExecutionContext, int cacheSize, ExternalBlockStoreClient externalBlockStoreClient, String host, int externalShuffleServicePort) {
        this.externalBlockStoreClient = externalBlockStoreClient;
        this.host = host;
        this.externalShuffleServicePort = externalShuffleServicePort;
        Logging.$init$(this);
        this.executorIdToLocalDirsCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
    }
}

