/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t5d!\u0002\u0015*\u0001-\n\u0004\u0002\u0003 \u0001\u0005\u0003\u0007I\u0011\u0001!\t\u0011\u001d\u0003!\u00111A\u0005\u0002!C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006K!\u0011\u0005\t\u001f\u0002\u0011\t\u0019!C\u0001\u0001\"A\u0001\u000b\u0001BA\u0002\u0013\u0005\u0011\u000b\u0003\u0005T\u0001\t\u0005\t\u0015)\u0003B\u0011!!\u0006A!A!\u0002\u0013)\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u000bu\u0003A\u0011\u00010\t\u000f\u0015\u0004!\u0019!C\u0001M\"1!\u000e\u0001Q\u0001\n\u001dDQa\u001b\u0001\u0005\u00021DQA\u001f\u0001\u0005\u0002mDQ! \u0001\u0005\u0002yDq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011\u0011\n\u0001\u0005\u0002\u0005=\u0005bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!a-\u0001\t\u0003\t)\fC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAr\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003A\u0011B!\u0005\u0001#\u0003%\tAa\u0005\t\u000f\t%\u0002\u0001\"\u0001\u0003,!9!1\b\u0001\u0005\u0002\tu\u0002b\u0002B \u0001\u0011%!\u0011I\u0004\t\u0005\u001bJ\u0003\u0012A\u0016\u0003P\u00199\u0001&\u000bE\u0001W\tE\u0003BB/#\t\u0003\u0011\u0019\u0006C\u0005\u0003V\t\u0012\r\u0011\"\u0001\u0003X!A!q\r\u0012!\u0002\u0013\u0011I\u0006C\u0005\u0003j\t\u0012\r\u0011\"\u0001\u0003X!A!1\u000e\u0012!\u0002\u0013\u0011IF\u0001\nCY>\u001c7.T1oC\u001e,'/T1ti\u0016\u0014(B\u0001\u0016,\u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001L\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\n\u0004\u0001IB\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g\r\u0005\u0002:y5\t!H\u0003\u0002<W\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002>u\t9Aj\\4hS:<\u0017A\u00043sSZ,'/\u00128ea>Lg\u000e^\u0002\u0001+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#,\u0003\r\u0011\boY\u0005\u0003\r\u000e\u0013aB\u00159d\u000b:$\u0007o\\5oiJ+g-\u0001\nee&4XM]#oIB|\u0017N\u001c;`I\u0015\fHCA%M!\t\u0019$*\u0003\u0002Li\t!QK\\5u\u0011\u001di%!!AA\u0002\u0005\u000b1\u0001\u001f\u00132\u0003=!'/\u001b<fe\u0016sG\r]8j]R\u0004\u0013a\u00063sSZ,'\u000fS3beR\u0014W-\u0019;F]\u0012\u0004v.\u001b8u\u0003m!'/\u001b<fe\"+\u0017M\u001d;cK\u0006$XI\u001c3Q_&tGo\u0018\u0013fcR\u0011\u0011J\u0015\u0005\b\u001b\u0016\t\t\u00111\u0001B\u0003a!'/\u001b<fe\"+\u0017M\u001d;cK\u0006$XI\u001c3Q_&tG\u000fI\u0001\u0005G>tg\r\u0005\u0002W/6\t1&\u0003\u0002YW\tI1\u000b]1sW\u000e{gNZ\u0001\tSN$%/\u001b<feB\u00111gW\u0005\u00039R\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0006?\u0006\u00147\r\u001a\t\u0003A\u0002i\u0011!\u000b\u0005\u0006}%\u0001\r!\u0011\u0005\u0006\u001f&\u0001\r!\u0011\u0005\u0006)&\u0001\r!\u0016\u0005\u00063&\u0001\rAW\u0001\bi&lWm\\;u+\u00059\u0007C\u0001\"i\u0013\tI7I\u0001\u0006Sa\u000e$\u0016.\\3pkR\f\u0001\u0002^5nK>,H\u000fI\u0001\u000fe\u0016lwN^3Fq\u0016\u001cW\u000f^8s)\tIU\u000eC\u0003o\u0019\u0001\u0007q.\u0001\u0004fq\u0016\u001c\u0017\n\u001a\t\u0003a^t!!];\u0011\u0005I$T\"A:\u000b\u0005Q|\u0014A\u0002\u001fs_>$h(\u0003\u0002wi\u00051\u0001K]3eK\u001aL!\u0001_=\u0003\rM#(/\u001b8h\u0015\t1H'A\nsK6|g/Z#yK\u000e,Ho\u001c:Bgft7\r\u0006\u0002Jy\")a.\u0004a\u0001_\u0006!\"/Z4jgR,'O\u00117pG.l\u0015M\\1hKJ$2b`A\u0003\u0003\u0013\t\u0019\"!\b\u0002\"A\u0019\u0001-!\u0001\n\u0007\u0005\r\u0011F\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\t\r\u0005\u001da\u00021\u0001\u0000\u0003\tIG\rC\u0004\u0002\f9\u0001\r!!\u0004\u0002\u00131|7-\u00197ESJ\u001c\b\u0003B\u001a\u0002\u0010=L1!!\u00055\u0005\u0015\t%O]1z\u0011\u001d\t)B\u0004a\u0001\u0003/\t\u0001#\\1y\u001f:DU-\u00199NK6\u001c\u0016N_3\u0011\u0007M\nI\"C\u0002\u0002\u001cQ\u0012A\u0001T8oO\"9\u0011q\u0004\bA\u0002\u0005]\u0011!E7bq>3g\rS3ba6+WnU5{K\"1\u00111\u0005\bA\u0002\u0005\u000bQb\u001d7bm\u0016,e\u000e\u001a9pS:$\u0018aD;qI\u0006$XM\u00117pG.LeNZ8\u0015\u0017i\u000bI#!\f\u00028\u0005\u0005\u0013Q\t\u0005\u0007\u0003Wy\u0001\u0019A@\u0002\u001d\tdwnY6NC:\fw-\u001a:JI\"9\u0011qF\bA\u0002\u0005E\u0012a\u00022m_\u000e\\\u0017\n\u001a\t\u0004A\u0006M\u0012bAA\u001bS\t9!\t\\8dW&#\u0007bBA\u001d\u001f\u0001\u0007\u00111H\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u0004A\u0006u\u0012bAA S\ta1\u000b^8sC\u001e,G*\u001a<fY\"9\u00111I\bA\u0002\u0005]\u0011aB7f[NK'0\u001a\u0005\b\u0003\u000fz\u0001\u0019AA\f\u0003!!\u0017n]6TSj,\u0017\u0001D4fi2{7-\u0019;j_:\u001cH\u0003BA'\u0003?\u0002R!a\u0014\u0002Z}tA!!\u0015\u0002V9\u0019!/a\u0015\n\u0003UJ1!a\u00165\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0017\u0002^\t\u00191+Z9\u000b\u0007\u0005]C\u0007C\u0004\u00020A\u0001\r!!\r\u0002+\u001d,G\u000fT8dCRLwN\\:B]\u0012\u001cF/\u0019;vgR1\u0011QMAE\u0003\u0017\u0003RaMA4\u0003WJ1!!\u001b5\u0005\u0019y\u0005\u000f^5p]B!\u0011QNAB\u001d\u0011\ty'a \u000f\t\u0005E\u0014Q\u0010\b\u0005\u0003g\nYH\u0004\u0003\u0002v\u0005edb\u0001:\u0002x%\t\u0001'\u0003\u0002/_%\u0011A&L\u0005\u0003U-J1!!!*\u0003Q\u0011En\\2l\u001b\u0006t\u0017mZ3s\u001b\u0016\u001c8/Y4fg&!\u0011QQAD\u0005]\u0011En\\2l\u0019>\u001c\u0017\r^5p]N\fe\u000eZ*uCR,8OC\u0002\u0002\u0002&Bq!a\f\u0012\u0001\u0004\t\t\u0004\u0003\u0004\u0002\u000eF\u0001\ra\\\u0001\u000ee\u0016\fX/Z:uKJDun\u001d;\u0015\t\u0005E\u0015q\u0013\t\u0007\u0003\u001f\n\u0019*!\u0014\n\t\u0005U\u0015Q\f\u0002\u000b\u0013:$W\r_3e'\u0016\f\bbBAM%\u0001\u0007\u00111T\u0001\tE2|7m[%egB)1'a\u0004\u00022\u0005A1m\u001c8uC&t7\u000fF\u0002[\u0003CCq!a\f\u0014\u0001\u0004\t\t$\u0001\u0005hKR\u0004V-\u001a:t)\u0011\ti%a*\t\r\u0005-B\u00031\u0001\u0000\u0003Y9W\r^#yK\u000e,Ho\u001c:F]\u0012\u0004x.\u001b8u%\u00164G\u0003BAW\u0003_\u0003BaMA4\u0003\"1\u0011\u0011W\u000bA\u0002=\f!\"\u001a=fGV$xN]%e\u0003-\u0011X-\\8wK\ncwnY6\u0015\u0007%\u000b9\fC\u0004\u00020Y\u0001\r!!\r\u0002\u0013I,Wn\u001c<f%\u0012$G#B%\u0002>\u0006\u001d\u0007bBA`/\u0001\u0007\u0011\u0011Y\u0001\u0006e\u0012$\u0017\n\u001a\t\u0004g\u0005\r\u0017bAAci\t\u0019\u0011J\u001c;\t\r\u0005%w\u00031\u0001[\u0003!\u0011Gn\\2lS:<\u0017!\u0004:f[>4Xm\u00155vM\u001adW\rF\u0003J\u0003\u001f\f\u0019\u000eC\u0004\u0002Rb\u0001\r!!1\u0002\u0013MDWO\u001a4mK&#\u0007BBAe1\u0001\u0007!,A\bsK6|g/\u001a\"s_\u0006$7-Y:u)\u001dI\u0015\u0011\\Ao\u0003CDq!a7\u001a\u0001\u0004\t9\"A\u0006ce>\fGmY1ti&#\u0007BBAp3\u0001\u0007!,\u0001\tsK6|g/\u001a$s_6l\u0015m\u001d;fe\"1\u0011\u0011Z\rA\u0002i\u000bqbZ3u\u001b\u0016lwN]=Ti\u0006$Xo]\u000b\u0003\u0003O\u0004b\u0001]Au\u007f\u00065\u0018bAAvs\n\u0019Q*\u00199\u0011\u000fM\ny/a\u0006\u0002\u0018%\u0019\u0011\u0011\u001f\u001b\u0003\rQ+\b\u000f\\33\u0003A9W\r^*u_J\fw-Z*uCR,8/\u0006\u0002\u0002xB)1'a\u0004\u0002zB\u0019\u0001-a?\n\u0007\u0005u\u0018FA\u0007Ti>\u0014\u0018mZ3Ti\u0006$Xo]\u0001\u000fO\u0016$(\t\\8dWN#\u0018\r^;t)\u0019\u0011\u0019Aa\u0003\u0003\u000eA1\u0001/!;\u0000\u0005\u000b\u00012\u0001\u0019B\u0004\u0013\r\u0011I!\u000b\u0002\f\u00052|7m[*uCR,8\u000fC\u0004\u00020q\u0001\r!!\r\t\u0011\t=A\u0004%AA\u0002i\u000b\u0011\"Y:l'2\fg/Z:\u00021\u001d,GO\u00117pG.\u001cF/\u0019;vg\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0016)\u001a!La\u0006,\u0005\te\u0001\u0003\u0002B\u000e\u0005Ki!A!\b\u000b\t\t}!\u0011E\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\t5\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005O\u0011iBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1cZ3u\u001b\u0006$8\r[5oO\ncwnY6JIN$bA!\f\u00030\te\u0002CBA(\u00033\n\t\u0004C\u0004\u00032y\u0001\rAa\r\u0002\r\u0019LG\u000e^3s!\u0019\u0019$QGA\u00195&\u0019!q\u0007\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004B\u0002B\b=\u0001\u0007!,\u0001\u0003ti>\u0004H#A%\u0002\tQ,G\u000e\u001c\u000b\u0004\u0013\n\r\u0003b\u0002B#A\u0001\u0007!qI\u0001\b[\u0016\u001c8/Y4f!\r\u0019$\u0011J\u0005\u0004\u0005\u0017\"$aA!os\u0006\u0011\"\t\\8dW6\u000bg.Y4fe6\u000b7\u000f^3s!\t\u0001'e\u0005\u0002#eQ\u0011!qJ\u0001\u0015\tJKe+\u0012*`\u000b:#\u0005kT%O)~s\u0015)T#\u0016\u0005\te\u0003\u0003\u0002B.\u0005Kj!A!\u0018\u000b\t\t}#\u0011M\u0001\u0005Y\u0006twM\u0003\u0002\u0003d\u0005!!.\u0019<b\u0013\rA(QL\u0001\u0016\tJKe+\u0012*`\u000b:#\u0005kT%O)~s\u0015)T#!\u0003y!%+\u0013,F%~CU)\u0011*U\u0005\u0016\u000bEkX#O\tB{\u0015J\u0014+`\u001d\u0006kU)A\u0010E%&3VIU0I\u000b\u0006\u0013FKQ#B)~+e\n\u0012)P\u0013:#vLT!N\u000b\u0002\u0002")
public class BlockManagerMaster
implements Logging {
    private RpcEndpointRef driverEndpoint;
    private RpcEndpointRef driverHeartbeatEndPoint;
    private final boolean isDriver;
    private final RpcTimeout timeout;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String DRIVER_HEARTBEAT_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_HEARTBEAT_ENDPOINT_NAME();
    }

    public static String DRIVER_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public RpcEndpointRef driverHeartbeatEndPoint() {
        return this.driverHeartbeatEndPoint;
    }

    public void driverHeartbeatEndPoint_$eq(RpcEndpointRef x$1) {
        this.driverHeartbeatEndPoint = x$1;
    }

    public RpcTimeout timeout() {
        return this.timeout;
    }

    public void removeExecutor(String execId) {
        this.tell(new BlockManagerMessages.RemoveExecutor(execId));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Removed ").append(execId).append(" successfully in removeExecutor").toString());
    }

    public void removeExecutorAsync(String execId) {
        this.driverEndpoint().ask(new BlockManagerMessages.RemoveExecutor(execId), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Removal of executor ").append(execId).append(" requested").toString());
    }

    public BlockManagerId registerBlockManager(BlockManagerId id, String[] localDirs, long maxOnHeapMemSize, long maxOffHeapMemSize, RpcEndpointRef slaveEndpoint) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Registering BlockManager ").append(id).toString());
        BlockManagerId updatedId = (BlockManagerId)this.driverEndpoint().askSync(new BlockManagerMessages.RegisterBlockManager(id, localDirs, maxOnHeapMemSize, maxOffHeapMemSize, slaveEndpoint), ClassTag$.MODULE$.apply(BlockManagerId.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Registered BlockManager ").append(updatedId).toString());
        return updatedId;
    }

    public boolean updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        boolean res = BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(new BlockManagerMessages.UpdateBlockInfo(blockManagerId, blockId, storageLevel, memSize, diskSize), ClassTag$.MODULE$.Boolean()));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Updated info of block ").append(blockId).toString());
        return res;
    }

    public Seq<BlockManagerId> getLocations(BlockId blockId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocations(blockId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<BlockManagerMessages.BlockLocationsAndStatus> getLocationsAndStatus(BlockId blockId, String requesterHost) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsAndStatus(blockId, requesterHost), ClassTag$.MODULE$.apply(Option.class));
    }

    public IndexedSeq<Seq<BlockManagerId>> getLocations(BlockId[] blockIds) {
        return (IndexedSeq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsMultipleBlockIds(blockIds), ClassTag$.MODULE$.apply(IndexedSeq.class));
    }

    public boolean contains(BlockId blockId) {
        return !this.getLocations(blockId).isEmpty();
    }

    public Seq<BlockManagerId> getPeers(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetPeers(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<RpcEndpointRef> getExecutorEndpointRef(String executorId) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetExecutorEndpointRef(executorId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void removeBlock(BlockId blockId) {
        this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean());
    }

    public void removeRdd(int rddId, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveRdd(rddId), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Failed to remove RDD ").append(rddId$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            this.timeout().awaitResult(future);
        }
    }

    public void removeShuffle(int shuffleId, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveShuffle(shuffleId), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Failed to remove shuffle ").append(shuffleId$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            this.timeout().awaitResult(future);
        }
    }

    public void removeBroadcast(long broadcastId, boolean removeFromMaster, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromMaster), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Failed to remove broadcast ").append(broadcastId$1).append(" with removeFromMaster = ").append(removeFromMaster$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            this.timeout().awaitResult(future);
        }
    }

    public Map<BlockManagerId, Tuple2<Object, Object>> getMemoryStatus() {
        if (this.driverEndpoint() == null) {
            return Predef$.MODULE$.Map().empty();
        }
        return (Map)this.driverEndpoint().askSync(BlockManagerMessages$GetMemoryStatus$.MODULE$, ClassTag$.MODULE$.apply(Map.class));
    }

    public StorageStatus[] getStorageStatus() {
        if (this.driverEndpoint() == null) {
            return (StorageStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StorageStatus.class));
        }
        return (StorageStatus[])this.driverEndpoint().askSync(BlockManagerMessages$GetStorageStatus$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(StorageStatus.class)));
    }

    public Map<BlockManagerId, BlockStatus> getBlockStatus(BlockId blockId, boolean askSlaves) {
        BlockManagerMessages.GetBlockStatus msg = new BlockManagerMessages.GetBlockStatus(blockId, askSlaves);
        Map response = (Map)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Map.class));
        Tuple2 tuple2 = response.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Iterable blockManagerIds = (scala.collection.immutable.Iterable)tuple2._1();
        scala.collection.immutable.Iterable futures = (scala.collection.immutable.Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)blockManagerIds, (Object)futures);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Iterable blockManagerIds2 = (scala.collection.immutable.Iterable)tuple23._1();
        scala.collection.immutable.Iterable futures2 = (scala.collection.immutable.Iterable)tuple23._2();
        ExecutionContextExecutor sameThread = ThreadUtils$.MODULE$.sameThread();
        CanBuildFrom cbf = (CanBuildFrom)Predef$.MODULE$.implicitly((Object)Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable blockStatus = (scala.collection.immutable.Iterable)this.timeout().awaitResult(Future$.MODULE$.sequence((TraversableOnce)futures2, cbf, (ExecutionContext)ThreadUtils$.MODULE$.sameThread()));
        if (blockStatus == null) {
            throw new SparkException(new StringBuilder(50).append("BlockManager returned null for BlockStatus query: ").append(blockId).toString());
        }
        return ((TraversableOnce)((TraversableLike)blockManagerIds2.zip((GenIterable)blockStatus, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
            Option status = (Option)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(status.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)blockManagerId, s)));
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public boolean getBlockStatus$default$2() {
        return true;
    }

    public Seq<BlockId> getMatchingBlockIds(Function1<BlockId, Object> filter, boolean askSlaves) {
        BlockManagerMessages.GetMatchingBlockIds msg = new BlockManagerMessages.GetMatchingBlockIds(filter, askSlaves);
        Future future = (Future)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Future.class));
        return (Seq)this.timeout().awaitResult(future);
    }

    public void stop() {
        block2: {
            if (this.driverEndpoint() == null || !this.isDriver) break block2;
            this.tell(BlockManagerMessages$StopBlockManagerMaster$.MODULE$);
            this.driverEndpoint_$eq(null);
            if (BoxesRunTime.unboxToBoolean(this.driverHeartbeatEndPoint().askSync(BlockManagerMessages$StopBlockManagerMaster$.MODULE$, ClassTag$.MODULE$.Boolean()))) {
                this.driverHeartbeatEndPoint_$eq(null);
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to stop BlockManagerMasterHeartbeatEndpoint");
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BlockManagerMaster stopped");
        }
    }

    private void tell(Object message) {
        if (!BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(message, ClassTag$.MODULE$.Boolean()))) {
            throw new SparkException("BlockManagerMasterEndpoint returned false, expected true.");
        }
    }

    public BlockManagerMaster(RpcEndpointRef driverEndpoint, RpcEndpointRef driverHeartbeatEndPoint, SparkConf conf, boolean isDriver) {
        this.driverEndpoint = driverEndpoint;
        this.driverHeartbeatEndPoint = driverHeartbeatEndPoint;
        this.isDriver = isDriver;
        Logging.$init$(this);
        this.timeout = RpcUtils$.MODULE$.askRpcTimeout(conf);
    }
}

