/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.Serializable;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.InboxMessage;
import org.apache.spark.rpc.netty.NettyRpcCallContext;
import org.apache.spark.rpc.netty.OnStart$;
import org.apache.spark.rpc.netty.OnStop$;
import org.apache.spark.rpc.netty.OneWayMessage;
import org.apache.spark.rpc.netty.RemoteProcessConnected;
import org.apache.spark.rpc.netty.RemoteProcessConnectionError;
import org.apache.spark.rpc.netty.RemoteProcessDisconnected;
import org.apache.spark.rpc.netty.RpcMessage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005}b!B\f\u0019\u0001a\u0011\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011A\u0019\t\u0011u\u0002!\u0011!Q\u0001\nIB\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u0001\")Q\t\u0001C\u0001\r\"91\n\u0001b\u0001\n#a\u0005B\u0002-\u0001A\u0003%Q\nC\u0004h\u0001\u0001\u0007I\u0011\u00025\t\u000f1\u0004\u0001\u0019!C\u0005[\"11\u000f\u0001Q!\n%Dq!\u001e\u0001A\u0002\u0013%\u0001\u000eC\u0004w\u0001\u0001\u0007I\u0011B<\t\re\u0004\u0001\u0015)\u0003j\u0011\u001dY\b\u00011A\u0005\nqD\u0011\"!\u0001\u0001\u0001\u0004%I!a\u0001\t\u000f\u0005\u001d\u0001\u0001)Q\u0005{\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u0019\t)\u0003\u0001C\u0001Q\"9\u0011q\u0005\u0001\u0005\u0012\u0005%\u0002bBA\u0017\u0001\u0011%\u0011q\u0006\u0002\u0006\u0013:\u0014w\u000e\u001f\u0006\u00033i\tQA\\3uifT!a\u0007\u000f\u0002\u0007I\u00048M\u0003\u0002\u001e=\u0005)1\u000f]1sW*\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h'\r\u00011%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)jS\"A\u0016\u000b\u00051b\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00059Z#a\u0002'pO\u001eLgnZ\u0001\rK:$\u0007o\\5oi:\u000bW.Z\u0002\u0001+\u0005\u0011\u0004CA\u001a;\u001d\t!\u0004\b\u0005\u00026K5\taG\u0003\u00028a\u00051AH]8pizJ!!O\u0013\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003s\u0015\nQ\"\u001a8ea>Lg\u000e\u001e(b[\u0016\u0004\u0013\u0001C3oIB|\u0017N\u001c;\u0016\u0003\u0001\u0003\"!\u0011\"\u000e\u0003iI!a\u0011\u000e\u0003\u0017I\u00038-\u00128ea>Lg\u000e^\u0001\nK:$\u0007o\\5oi\u0002\na\u0001P5oSRtDcA$J\u0015B\u0011\u0001\nA\u0007\u00021!)q&\u0002a\u0001e!)a(\u0002a\u0001\u0001\u0006AQ.Z:tC\u001e,7/F\u0001N!\rq5+V\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0005kRLGNC\u0001S\u0003\u0011Q\u0017M^1\n\u0005Q{%A\u0003'j].,G\rT5tiB\u0011\u0001JV\u0005\u0003/b\u0011A\"\u00138c_blUm]:bO\u0016\f\u0011\"\\3tg\u0006<Wm\u001d\u0011)\t\u001dQF-\u001a\t\u00037\nl\u0011\u0001\u0018\u0006\u0003;z\u000b!bY8oGV\u0014(/\u001a8u\u0015\ty\u0006-\u0001\u0006b]:|G/\u0019;j_:T\u0011!Y\u0001\u0006U\u00064\u0018\r_\u0005\u0003Gr\u0013\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0003\u0019\fA\u0001\u001e5jg\u000691\u000f^8qa\u0016$W#A5\u0011\u0005\u0011R\u0017BA6&\u0005\u001d\u0011un\u001c7fC:\f1b\u001d;paB,Gm\u0018\u0013fcR\u0011a.\u001d\t\u0003I=L!\u0001]\u0013\u0003\tUs\u0017\u000e\u001e\u0005\be&\t\t\u00111\u0001j\u0003\rAH%M\u0001\tgR|\u0007\u000f]3eA!\"!B\u00173f\u0003A)g.\u00192mK\u000e{gnY;se\u0016tG/\u0001\u000bf]\u0006\u0014G.Z\"p]\u000e,(O]3oi~#S-\u001d\u000b\u0003]bDqA\u001d\u0007\u0002\u0002\u0003\u0007\u0011.A\tf]\u0006\u0014G.Z\"p]\u000e,(O]3oi\u0002BC!\u0004.eK\u0006\u0001b.^7BGRLg/\u001a+ie\u0016\fGm]\u000b\u0002{B\u0011AE`\u0005\u0003\u007f\u0016\u00121!\u00138u\u0003QqW/\\!di&4X\r\u00165sK\u0006$7o\u0018\u0013fcR\u0019a.!\u0002\t\u000fI|\u0011\u0011!a\u0001{\u0006\tb.^7BGRLg/\u001a+ie\u0016\fGm\u001d\u0011)\tAQF-Z\u0001\baJ|7-Z:t)\rq\u0017q\u0002\u0005\b\u0003#\t\u0002\u0019AA\n\u0003)!\u0017n\u001d9bi\u000eDWM\u001d\t\u0004\u0011\u0006U\u0011bAA\f1\tQA)[:qCR\u001c\u0007.\u001a:\u0002\tA|7\u000f\u001e\u000b\u0004]\u0006u\u0001BBA\u0010%\u0001\u0007Q+A\u0004nKN\u001c\u0018mZ3\u0002\tM$x\u000e\u001d\u000b\u0002]\u00069\u0011n]#naRL\u0018AB8o\tJ|\u0007\u000fF\u0002o\u0003WAa!a\b\u0016\u0001\u0004)\u0016AC:bM\u0016d\u0017pQ1mYR!\u0011\u0011GA\u001f)\rq\u00171\u0007\u0005\t\u0003k1B\u00111\u0001\u00028\u00051\u0011m\u0019;j_:\u0004B\u0001JA\u001d]&\u0019\u00111H\u0013\u0003\u0011q\u0012\u0017P\\1nKzBQA\u0010\fA\u0002\u0001\u0003")
public class Inbox
implements Logging {
    private final String endpointName;
    private final RpcEndpoint endpoint;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void process(Dispatcher dispatcher) {
        ObjectRef message;
        block10: {
            message = ObjectRef.create(null);
            Inbox inbox = this;
            synchronized (inbox) {
                block9: {
                    if (!this.enableConcurrent() && this.numActiveThreads() != 0) break block9;
                    message.elem = this.messages().poll();
                    if ((InboxMessage)message.elem == null) break block9;
                    this.numActiveThreads_$eq(this.numActiveThreads() + 1);
                    break block10;
                }
                return;
            }
        }
        while (true) {
            this.safelyCall(this.endpoint(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                InboxMessage inboxMessage = (InboxMessage)message$1.elem;
                if (inboxMessage instanceof RpcMessage) {
                    BoxedUnit boxedUnit;
                    RpcMessage rpcMessage = (RpcMessage)inboxMessage;
                    RpcAddress _sender = rpcMessage.senderAddress();
                    Object content = rpcMessage.content();
                    NettyRpcCallContext context = rpcMessage.context();
                    try {
                        boxedUnit = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                            throw new SparkException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                        });
                    }
                    catch (Throwable e) {
                        context.sendFailure(e);
                        throw e;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (inboxMessage instanceof OneWayMessage) {
                    OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
                    RpcAddress _sender = oneWayMessage.senderAddress();
                    Object content = oneWayMessage.content();
                    BoxedUnit boxedUnit = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                        throw new SparkException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                    });
                } else if (OnStart$.MODULE$.equals(inboxMessage)) {
                    BoxedUnit boxedUnit;
                    this.endpoint().onStart();
                    if (!(this.endpoint() instanceof ThreadSafeRpcEndpoint)) {
                        Inbox inbox = this;
                        synchronized (inbox) {
                            if (!this.stopped()) {
                                this.enableConcurrent_$eq(true);
                            }
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else if (OnStop$.MODULE$.equals(inboxMessage)) {
                    int n;
                    Inbox inbox = this;
                    synchronized (inbox) {
                        n = this.numActiveThreads();
                    }
                    int activeThreads = n;
                    Predef$.MODULE$.assert(activeThreads == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("There should be only a single active thread but found ").append(activeThreads).append(" threads.").toString());
                    dispatcher.removeRpcEndpointRef(this.endpoint());
                    this.endpoint().onStop();
                    Predef$.MODULE$.assert(this.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "OnStop should be the last message");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessConnected) {
                    RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
                    this.endpoint().onConnected(remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessDisconnected) {
                    RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
                    this.endpoint().onDisconnected(remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessConnectionError) {
                    RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
                    Throwable cause = remoteProcessConnectionError.cause();
                    RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
                    this.endpoint().onNetworkError(cause, remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)inboxMessage);
                }
            });
            Inbox inbox = this;
            synchronized (inbox) {
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
            }
        }
    }

    public void post(InboxMessage message) {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (this.stopped()) {
                this.onDrop(message);
                object = BoxedUnit.UNIT;
            } else {
                this.messages().add(message);
                object = BoxesRunTime.boxToBoolean((boolean)false);
            }
        }
    }

    public void stop() {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                object = BoxesRunTime.boxToBoolean((boolean)this.messages().add(OnStop$.MODULE$));
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.messages().isEmpty();
    }

    public void onDrop(InboxMessage message) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Drop ").append(message).append(" because endpoint ").append(this.endpointName()).append(" is stopped").toString());
    }

    private void safelyCall(RpcEndpoint endpoint, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                try {
                    endpoint.onError(e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable3) {
                    BoxedUnit boxedUnit2;
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (!option2.isEmpty()) {
                        Throwable ee = (Throwable)option2.get();
                        if (this.stopped()) {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable3;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit4 = boxedUnit;
            }
            throw throwable;
        }
    }

    public Inbox(String endpointName, RpcEndpoint endpoint) {
        this.endpointName = endpointName;
        this.endpoint = endpoint;
        Logging.$init$(this);
        this.messages = new LinkedList();
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        Inbox inbox = this;
        synchronized (inbox) {
            this.messages().add(OnStart$.MODULE$);
        }
    }
}

