/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics.sink;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.metrics.sink.Sink;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q4Q\u0001G\r\u0001;\rB\u0001B\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\ts\u0001\u0011\t\u0011)A\u0005c!A!\b\u0001BC\u0002\u0013\u00051\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003=\u0011!1\u0005A!A!\u0002\u00139\u0005\"B&\u0001\t\u0003a\u0005bB)\u0001\u0005\u0004%\tA\u0015\u0005\u0007-\u0002\u0001\u000b\u0011B*\t\u000f]\u0003!\u0019!C\u00011\"1q\f\u0001Q\u0001\neCq\u0001\u0019\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004b\u0001\u0001\u0006I!\u0017\u0005\bE\u0002\u0011\r\u0011\"\u0001Y\u0011\u0019\u0019\u0007\u0001)A\u00053\"9A\r\u0001b\u0001\n\u0003\u0011\u0006BB3\u0001A\u0003%1\u000bC\u0004g\u0001\t\u0007I\u0011A4\t\r9\u0004\u0001\u0015!\u0003i\u0011\u001dy\u0007A1A\u0005\u0002ADa\u0001\u001e\u0001!\u0002\u0013\t\b\"B;\u0001\t\u00032\b\"\u0002>\u0001\t\u00032\b\"B>\u0001\t\u00032(aC\"p]N|G.Z*j].T!AG\u000e\u0002\tMLgn\u001b\u0006\u00039u\tq!\\3ue&\u001c7O\u0003\u0002\u001f?\u0005)1\u000f]1sW*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-bS\"A\r\n\u00055J\"\u0001B*j].\f\u0001\u0002\u001d:pa\u0016\u0014H/_\u0002\u0001+\u0005\t\u0004C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011)H/\u001b7\u000b\u0003Y\nAA[1wC&\u0011\u0001h\r\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u00039s_B,'\u000f^=!\u0003!\u0011XmZ5tiJLX#\u0001\u001f\u0011\u0005u\u001aU\"\u0001 \u000b\u0005qy$B\u0001!B\u0003!\u0019w\u000eZ1iC2,'\"\u0001\"\u0002\u0007\r|W.\u0003\u0002E}\tqQ*\u001a;sS\u000e\u0014VmZ5tiJL\u0018!\u0003:fO&\u001cHO]=!\u0003-\u0019XmY;sSRLXj\u001a:\u0011\u0005!KU\"A\u000f\n\u0005)k\"aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0002\rqJg.\u001b;?)\u0011iej\u0014)\u0011\u0005-\u0002\u0001\"\u0002\u0018\u0007\u0001\u0004\t\u0004\"\u0002\u001e\u0007\u0001\u0004a\u0004\"\u0002$\u0007\u0001\u00049\u0015AF\"P\u001dN{E*R0E\u000b\u001a\u000bU\u000b\u0014+`!\u0016\u0013\u0016j\u0014#\u0016\u0003M\u0003\"!\n+\n\u0005U3#aA%oi\u000692i\u0014(T\u001f2+u\fR#G\u0003VcEk\u0018)F%&{E\tI\u0001\u0015\u0007>s5k\u0014'F?\u0012+e)Q+M)~+f*\u0013+\u0016\u0003e\u0003\"AW/\u000e\u0003mS!\u0001X\u001b\u0002\t1\fgnZ\u0005\u0003=n\u0013aa\u0015;sS:<\u0017!F\"P\u001dN{E*R0E\u000b\u001a\u000bU\u000b\u0014+`+:KE\u000bI\u0001\u0013\u0007>s5k\u0014'F?.+\u0015l\u0018)F%&{E)A\nD\u001f:\u001bv\nT#`\u0017\u0016Kv\fU#S\u0013>#\u0005%\u0001\tD\u001f:\u001bv\nT#`\u0017\u0016Kv,\u0016(J)\u0006\t2i\u0014(T\u001f2+ulS#Z?Vs\u0015\n\u0016\u0011\u0002\u0015A|G\u000e\u001c)fe&|G-A\u0006q_2d\u0007+\u001a:j_\u0012\u0004\u0013\u0001\u00039pY2,f.\u001b;\u0016\u0003!\u0004\"!\u001b7\u000e\u0003)T!a[\u001a\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002nU\nAA+[7f+:LG/A\u0005q_2dWK\\5uA\u0005A!/\u001a9peR,'/F\u0001r!\ti$/\u0003\u0002t}\ty1i\u001c8t_2,'+\u001a9peR,'/A\u0005sKB|'\u000f^3sA\u0005)1\u000f^1siR\tq\u000f\u0005\u0002&q&\u0011\u0011P\n\u0002\u0005+:LG/\u0001\u0003ti>\u0004\u0018A\u0002:fa>\u0014H\u000f")
public class ConsoleSink
implements Sink {
    private final Properties property;
    private final MetricRegistry registry;
    private final int CONSOLE_DEFAULT_PERIOD;
    private final String CONSOLE_DEFAULT_UNIT;
    private final String CONSOLE_KEY_PERIOD;
    private final String CONSOLE_KEY_UNIT;
    private final int pollPeriod;
    private final TimeUnit pollUnit;
    private final ConsoleReporter reporter;

    public Properties property() {
        return this.property;
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public int CONSOLE_DEFAULT_PERIOD() {
        return this.CONSOLE_DEFAULT_PERIOD;
    }

    public String CONSOLE_DEFAULT_UNIT() {
        return this.CONSOLE_DEFAULT_UNIT;
    }

    public String CONSOLE_KEY_PERIOD() {
        return this.CONSOLE_KEY_PERIOD;
    }

    public String CONSOLE_KEY_UNIT() {
        return this.CONSOLE_KEY_UNIT;
    }

    public int pollPeriod() {
        return this.pollPeriod;
    }

    public TimeUnit pollUnit() {
        return this.pollUnit;
    }

    public ConsoleReporter reporter() {
        return this.reporter;
    }

    @Override
    public void start() {
        this.reporter().start((long)this.pollPeriod(), this.pollUnit());
    }

    @Override
    public void stop() {
        this.reporter().stop();
    }

    @Override
    public void report() {
        this.reporter().report();
    }

    public ConsoleSink(Properties property, MetricRegistry registry, SecurityManager securityMgr) {
        TimeUnit timeUnit;
        int n;
        this.property = property;
        this.registry = registry;
        this.CONSOLE_DEFAULT_PERIOD = 10;
        this.CONSOLE_DEFAULT_UNIT = "SECONDS";
        this.CONSOLE_KEY_PERIOD = "period";
        this.CONSOLE_KEY_UNIT = "unit";
        Option option = Option$.MODULE$.apply((Object)property.getProperty(this.CONSOLE_KEY_PERIOD()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            n = new StringOps(Predef$.MODULE$.augmentString(s)).toInt();
        } else if (None$.MODULE$.equals(option)) {
            n = this.CONSOLE_DEFAULT_PERIOD();
        } else {
            throw new MatchError((Object)option);
        }
        this.pollPeriod = n;
        Option option2 = Option$.MODULE$.apply((Object)property.getProperty(this.CONSOLE_KEY_UNIT()));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String s = (String)some.value();
            timeUnit = TimeUnit.valueOf(s.toUpperCase(Locale.ROOT));
        } else if (None$.MODULE$.equals(option2)) {
            timeUnit = TimeUnit.valueOf(this.CONSOLE_DEFAULT_UNIT());
        } else {
            throw new MatchError((Object)option2);
        }
        this.pollUnit = timeUnit;
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(this.pollUnit(), this.pollPeriod());
        this.reporter = ConsoleReporter.forRegistry((MetricRegistry)registry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build();
    }
}

