/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.DriverDescription;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.StandaloneResourceUtils$;
import org.apache.spark.deploy.master.DriverState$;
import org.apache.spark.deploy.worker.CommandUtils$;
import org.apache.spark.deploy.worker.DriverRunner$;
import org.apache.spark.deploy.worker.ProcessBuilderLike;
import org.apache.spark.deploy.worker.ProcessBuilderLike$;
import org.apache.spark.deploy.worker.Sleeper;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Worker$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.io.Files;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5e!\u0002\u001b6\u0001]z\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011I\u0003!Q1A\u0005\u0002MC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\tA\u0002\u0011)\u0019!C\u0001C\"A!\u000e\u0001B\u0001B\u0003%!\r\u0003\u0005l\u0001\t\u0015\r\u0011\"\u0001b\u0011!a\u0007A!A!\u0002\u0013\u0011\u0007\u0002C7\u0001\u0005\u000b\u0007I\u0011\u00018\t\u0011M\u0004!\u0011!Q\u0001\n=D\u0001B\u000e\u0001\u0003\u0006\u0004%\t\u0001\u001e\u0005\tw\u0002\u0011\t\u0011)A\u0005k\"AA\u0010\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005~\u0001\t\u0005\t\u0015!\u0003U\u0011!q\bA!b\u0001\n\u0003y\bBCA\u0004\u0001\t\u0005\t\u0015!\u0003\u0002\u0002!Q\u0011\u0011\u0002\u0001\u0003\u0006\u0004%\t!a\u0003\t\u0015\u0005}\u0001A!A!\u0002\u0013\ti\u0001C\u0004\u0002\"\u0001!\t!a\t\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005u\u0002\"CA)\u0001\u0001\u0007I\u0011BA*\u0011!\ty\u0006\u0001Q!\n\u0005}\u0002\"CA5\u0001\u0001\u0007I\u0011BA6\u0011%\t\u0019\b\u0001a\u0001\n\u0013\t)\b\u0003\u0005\u0002z\u0001\u0001\u000b\u0015BA7\u0011)\ti\b\u0001a\u0001\n\u0003)\u0014q\u0010\u0005\u000b\u0003S\u0003\u0001\u0019!C\u0001k\u0005-\u0006\u0002CAX\u0001\u0001\u0006K!!!\t\u0015\u0005M\u0006\u00011A\u0005\u0002U\n)\f\u0003\u0006\u0002L\u0002\u0001\r\u0011\"\u00016\u0003\u001bD\u0001\"!5\u0001A\u0003&\u0011q\u0017\u0005\n\u0003+\u0004!\u0019!C\u0005\u0003/D\u0001\"a8\u0001A\u0003%\u0011\u0011\u001c\u0005\b\u0003C\u0004A\u0011AAr\u0011\u001d\t)\u0010\u0001C\u0001\u0003oD\u0011Ba\u0001\u0001\u0001\u0004%IA!\u0002\t\u0013\t\u001d\u0001\u00011A\u0005\n\t%\u0001\u0002\u0003B\u0007\u0001\u0001\u0006K!!;\t\u0013\t=\u0001\u00011A\u0005\n\tE\u0001\"\u0003B\u000e\u0001\u0001\u0007I\u0011\u0002B\u000f\u0011!\u0011I\u0002\u0001Q!\n\tM\u0001\u0002\u0003B\u0011\u0001\u0011\u0005QGa\t\t\u0011\t\u0015\u0002\u0001\"\u00016\u0005GAqAa\n\u0001\t\u0013\u0011I\u0003C\u0004\u0003,\u0001!IA!\f\t\u0011\tM\u0002\u0001\"\u00016\u0005kAqA!\u0010\u0001\t\u0013\u0011y\u0004\u0003\u0005\u0003T\u0001!\t!\u000eB+\u000f)\u0011i'NA\u0001\u0012\u00039$q\u000e\u0004\niU\n\t\u0011#\u00018\u0005cBq!!\t2\t\u0003\u0011\u0019\bC\u0005\u0003vE\n\n\u0011\"\u0001\u0003x\taAI]5wKJ\u0014VO\u001c8fe*\u0011agN\u0001\u0007o>\u00148.\u001a:\u000b\u0005aJ\u0014A\u00023fa2|\u0017P\u0003\u0002;w\u0005)1\u000f]1sW*\u0011A(P\u0001\u0007CB\f7\r[3\u000b\u0003y\n1a\u001c:h'\r\u0001\u0001I\u0012\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%K\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005-C%a\u0002'pO\u001eLgnZ\u0001\u0005G>tgm\u0001\u0001\u0011\u0005=\u0003V\"A\u001d\n\u0005EK$!C*qCJ\\7i\u001c8g\u0003!!'/\u001b<fe&#W#\u0001+\u0011\u0005UcfB\u0001,[!\t9&)D\u0001Y\u0015\tIV*\u0001\u0004=e>|GOP\u0005\u00037\n\u000ba\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111LQ\u0001\nIJLg/\u001a:JI\u0002\nqa^8sW\u0012K'/F\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0002j_*\tq-\u0001\u0003kCZ\f\u0017BA5e\u0005\u00111\u0015\u000e\\3\u0002\u0011]|'o\u001b#je\u0002\n\u0011b\u001d9be.Du.\\3\u0002\u0015M\u0004\u0018M]6I_6,\u0007%\u0001\u0006ee&4XM\u001d#fg\u000e,\u0012a\u001c\t\u0003aFl\u0011aN\u0005\u0003e^\u0012\u0011\u0003\u0012:jm\u0016\u0014H)Z:de&\u0004H/[8o\u0003-!'/\u001b<fe\u0012+7o\u0019\u0011\u0016\u0003U\u0004\"A^=\u000e\u0003]T!\u0001_\u001d\u0002\u0007I\u00048-\u0003\u0002{o\nq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0017aB<pe.,'\u000fI\u0001\no>\u00148.\u001a:Ve2\f!b^8sW\u0016\u0014XK\u001d7!\u0003=\u0019XmY;sSRLX*\u00198bO\u0016\u0014XCAA\u0001!\ry\u00151A\u0005\u0004\u0003\u000bI$aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0002!M,7-\u001e:jifl\u0015M\\1hKJ\u0004\u0013!\u0003:fg>,(oY3t+\t\ti\u0001\u0005\u0004V\u0003\u001f!\u00161C\u0005\u0004\u0003#q&aA'baB!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001ae\n\u0001B]3t_V\u00148-Z\u0005\u0005\u0003;\t9BA\nSKN|WO]2f\u0013:4wN]7bi&|g.\u0001\u0006sKN|WO]2fg\u0002\na\u0001P5oSRtD\u0003FA\u0013\u0003S\tY#!\f\u00020\u0005E\u00121GA\u001b\u0003o\tI\u0004E\u0002\u0002(\u0001i\u0011!\u000e\u0005\u0006\u0019J\u0001\rA\u0014\u0005\u0006%J\u0001\r\u0001\u0016\u0005\u0006AJ\u0001\rA\u0019\u0005\u0006WJ\u0001\rA\u0019\u0005\u0006[J\u0001\ra\u001c\u0005\u0006mI\u0001\r!\u001e\u0005\u0006yJ\u0001\r\u0001\u0016\u0005\u0007}J\u0001\r!!\u0001\t\u0013\u0005%!\u0003%AA\u0002\u00055\u0011a\u00029s_\u000e,7o]\u000b\u0003\u0003\u007f\u0001R!QA!\u0003\u000bJ1!a\u0011C\u0005\u0019y\u0005\u000f^5p]B!\u0011qIA'\u001b\t\tIEC\u0002\u0002L\u0019\fA\u0001\\1oO&!\u0011qJA%\u0005\u001d\u0001&o\\2fgN\f1\u0002\u001d:pG\u0016\u001c8o\u0018\u0013fcR!\u0011QKA.!\r\t\u0015qK\u0005\u0004\u00033\u0012%\u0001B+oSRD\u0011\"!\u0018\u0015\u0003\u0003\u0005\r!a\u0010\u0002\u0007a$\u0013'\u0001\u0005qe>\u001cWm]:!Q\r)\u00121\r\t\u0004\u0003\u0006\u0015\u0014bAA4\u0005\nAao\u001c7bi&dW-\u0001\u0004lS2dW\rZ\u000b\u0003\u0003[\u00022!QA8\u0013\r\t\tH\u0011\u0002\b\u0005>|G.Z1o\u0003)Y\u0017\u000e\u001c7fI~#S-\u001d\u000b\u0005\u0003+\n9\bC\u0005\u0002^]\t\t\u00111\u0001\u0002n\u000591.\u001b7mK\u0012\u0004\u0003f\u0001\r\u0002d\u0005Qa-\u001b8bYN#\u0018\r^3\u0016\u0005\u0005\u0005\u0005#B!\u0002B\u0005\r\u0005\u0003BAC\u0003GsA!a\"\u0002\u001e:!\u0011\u0011RAM\u001d\u0011\tY)a&\u000f\t\u00055\u0015Q\u0013\b\u0005\u0003\u001f\u000b\u0019JD\u0002X\u0003#K\u0011AP\u0005\u0003yuJ!AO\u001e\n\u0005aJ\u0014bAANo\u00051Q.Y:uKJLA!a(\u0002\"\u0006YAI]5wKJ\u001cF/\u0019;f\u0015\r\tYjN\u0005\u0005\u0003K\u000b9KA\u0006Ee&4XM]*uCR,'\u0002BAP\u0003C\u000baBZ5oC2\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002V\u00055\u0006\"CA/5\u0005\u0005\t\u0019AAA\u0003-1\u0017N\\1m'R\fG/\u001a\u0011)\u0007m\t\u0019'\u0001\bgS:\fG.\u0012=dKB$\u0018n\u001c8\u0016\u0005\u0005]\u0006#B!\u0002B\u0005e\u0006\u0003BA^\u0003\u000btA!!0\u0002B:\u0019q+a0\n\u0003\rK1!a1C\u0003\u001d\u0001\u0018mY6bO\u0016LA!a2\u0002J\nIQ\t_2faRLwN\u001c\u0006\u0004\u0003\u0007\u0014\u0015A\u00054j]\u0006dW\t_2faRLwN\\0%KF$B!!\u0016\u0002P\"I\u0011QL\u000f\u0002\u0002\u0003\u0007\u0011qW\u0001\u0010M&t\u0017\r\\#yG\u0016\u0004H/[8oA!\u001aa$a\u0019\u00021\u0011\u0014\u0018N^3s)\u0016\u0014X.\u001b8bi\u0016$\u0016.\\3pkRl5/\u0006\u0002\u0002ZB\u0019\u0011)a7\n\u0007\u0005u'I\u0001\u0003M_:<\u0017!\u00073sSZ,'\u000fV3s[&t\u0017\r^3US6,w.\u001e;Ng\u0002\n\u0001b]3u\u00072|7m\u001b\u000b\u0005\u0003+\n)\u000fC\u0004\u0002h\u0006\u0002\r!!;\u0002\r}\u001bGn\\2l!\u0011\tY/!=\u000e\u0005\u00055(bAAxs\u0005!Q\u000f^5m\u0013\u0011\t\u00190!<\u0003\u000b\rcwnY6\u0002\u0015M,Go\u00157fKB,'\u000f\u0006\u0003\u0002V\u0005e\bbBA~E\u0001\u0007\u0011Q`\u0001\t?NdW-\u001a9feB!\u0011qEA\u0000\u0013\r\u0011\t!\u000e\u0002\b'2,W\r]3s\u0003\u0015\u0019Gn\\2l+\t\tI/A\u0005dY>\u001c7n\u0018\u0013fcR!\u0011Q\u000bB\u0006\u0011%\ti\u0006JA\u0001\u0002\u0004\tI/\u0001\u0004dY>\u001c7\u000eI\u0001\bg2,W\r]3s+\t\u0011\u0019BE\u0003\u0003\u0016\u0001\u000biP\u0002\u0004\u0003\u0018!\u0002!1\u0003\u0002\ryI,g-\u001b8f[\u0016tGOP\u0001\tg2,W\r]3sA\u0005Y1\u000f\\3fa\u0016\u0014x\fJ3r)\u0011\t)Fa\b\t\u0013\u0005us%!AA\u0002\tM\u0011!B:uCJ$HCAA+\u0003\u0011Y\u0017\u000e\u001c7\u0002-\r\u0014X-\u0019;f/>\u00148.\u001b8h\t&\u0014Xm\u0019;pef$\u0012AY\u0001\u0010I><h\u000e\\8bIV\u001bXM\u001d&beR\u0019AKa\f\t\r\tEB\u00061\u0001c\u0003%!'/\u001b<fe\u0012K'/A\nqe\u0016\u0004\u0018M]3B]\u0012\u0014VO\u001c#sSZ,'\u000f\u0006\u0002\u00038A\u0019\u0011I!\u000f\n\u0007\tm\"IA\u0002J]R\f\u0011B];o\tJLg/\u001a:\u0015\u0011\t]\"\u0011\tB&\u0005\u001fBqAa\u0011/\u0001\u0004\u0011)%A\u0004ck&dG-\u001a:\u0011\t\u0005\u001d#qI\u0005\u0005\u0005\u0013\nIE\u0001\bQe>\u001cWm]:Ck&dG-\u001a:\t\r\t5c\u00061\u0001c\u0003\u001d\u0011\u0017m]3ESJDqA!\u0015/\u0001\u0004\ti'A\u0005tkB,'O^5tK\u0006\u0019\"/\u001e8D_6l\u0017M\u001c3XSRD'+\u001a;ssRA!q\u0007B,\u0005C\u0012Y\u0007C\u0004\u0003Z=\u0002\rAa\u0017\u0002\u000f\r|W.\\1oIB!\u0011q\u0005B/\u0013\r\u0011y&\u000e\u0002\u0013!J|7-Z:t\u0005VLG\u000eZ3s\u0019&\\W\rC\u0004\u0003d=\u0002\rA!\u001a\u0002\u0015%t\u0017\u000e^5bY&TX\rE\u0004B\u0005O\n)%!\u0016\n\u0007\t%$IA\u0005Gk:\u001cG/[8oc!9!\u0011K\u0018A\u0002\u00055\u0014\u0001\u0004#sSZ,'OU;o]\u0016\u0014\bcAA\u0014cM\u0011\u0011\u0007\u0011\u000b\u0003\u0005_\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012JTC\u0001B=U\u0011\tiAa\u001f,\u0005\tu\u0004\u0003\u0002B@\u0005\u0013k!A!!\u000b\t\t\r%QQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\"C\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0017\u0013\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DriverRunner
implements Logging {
    private final SparkConf conf;
    private final String driverId;
    private final File workDir;
    private final File sparkHome;
    private final DriverDescription driverDesc;
    private final RpcEndpointRef worker;
    private final String workerUrl;
    private final SecurityManager securityManager;
    private final scala.collection.immutable.Map<String, ResourceInformation> resources;
    private volatile Option<Process> process;
    private volatile boolean org$apache$spark$deploy$worker$DriverRunner$$killed;
    private volatile Option<Enumeration.Value> finalState;
    private volatile Option<Exception> finalException;
    private final long driverTerminateTimeoutMs;
    private Clock clock;
    private Sleeper sleeper;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static scala.collection.immutable.Map<String, ResourceInformation> $lessinit$greater$default$9() {
        return DriverRunner$.MODULE$.$lessinit$greater$default$9();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String driverId() {
        return this.driverId;
    }

    public File workDir() {
        return this.workDir;
    }

    public File sparkHome() {
        return this.sparkHome;
    }

    public DriverDescription driverDesc() {
        return this.driverDesc;
    }

    public RpcEndpointRef worker() {
        return this.worker;
    }

    public String workerUrl() {
        return this.workerUrl;
    }

    public SecurityManager securityManager() {
        return this.securityManager;
    }

    public scala.collection.immutable.Map<String, ResourceInformation> resources() {
        return this.resources;
    }

    private Option<Process> process() {
        return this.process;
    }

    private void process_$eq(Option<Process> x$1) {
        this.process = x$1;
    }

    public boolean org$apache$spark$deploy$worker$DriverRunner$$killed() {
        return this.org$apache$spark$deploy$worker$DriverRunner$$killed;
    }

    private void org$apache$spark$deploy$worker$DriverRunner$$killed_$eq(boolean x$1) {
        this.org$apache$spark$deploy$worker$DriverRunner$$killed = x$1;
    }

    public Option<Enumeration.Value> finalState() {
        return this.finalState;
    }

    public void finalState_$eq(Option<Enumeration.Value> x$1) {
        this.finalState = x$1;
    }

    public Option<Exception> finalException() {
        return this.finalException;
    }

    public void finalException_$eq(Option<Exception> x$1) {
        this.finalException = x$1;
    }

    private long driverTerminateTimeoutMs() {
        return this.driverTerminateTimeoutMs;
    }

    public void setClock(Clock _clock) {
        this.clock_$eq(_clock);
    }

    public void setSleeper(Sleeper _sleeper) {
        this.sleeper_$eq(_sleeper);
    }

    private Clock clock() {
        return this.clock;
    }

    private void clock_$eq(Clock x$1) {
        this.clock = x$1;
    }

    private Sleeper sleeper() {
        return this.sleeper;
    }

    private void sleeper_$eq(Sleeper x$1) {
        this.sleeper = x$1;
    }

    public void start() {
        new Thread(this){
            private final /* synthetic */ DriverRunner $outer;

            public void run() {
                Object shutdownHook = null;
                try {
                    try {
                        shutdownHook = ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Worker shutting down, killing driver ").append($this.$outer.driverId()).toString());
                            $this.$outer.kill();
                        });
                        int exitCode = this.$outer.prepareAndRunDriver();
                        this.$outer.finalState_$eq((Option<Enumeration.Value>)(exitCode == 0 ? new Some((Object)DriverState$.MODULE$.FINISHED()) : (this.$outer.org$apache$spark$deploy$worker$DriverRunner$$killed() ? new Some((Object)DriverState$.MODULE$.KILLED()) : new Some((Object)DriverState$.MODULE$.FAILED()))));
                    }
                    catch (Exception e) {
                        this.$outer.kill();
                        this.$outer.finalState_$eq((Option<Enumeration.Value>)new Some((Object)DriverState$.MODULE$.ERROR()));
                        this.$outer.finalException_$eq((Option<Exception>)new Some((Object)e));
                    }
                }
                finally {
                    if (shutdownHook != null) {
                        ShutdownHookManager$.MODULE$.removeShutdownHook(shutdownHook);
                    }
                }
                this.$outer.worker().send(new DeployMessages.DriverStateChanged(this.$outer.driverId(), (Enumeration.Value)this.$outer.finalState().get(), this.$outer.finalException()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder(17).append("DriverRunner for ").append($outer.driverId()).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.deploy.worker.DriverRunner$$anon$2 ), $anonfun$run$2(org.apache.spark.deploy.worker.DriverRunner$$anon$2 )}, serializedLambda);
            }
        }.start();
    }

    public void kill() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Killing driver process!");
        this.org$apache$spark$deploy$worker$DriverRunner$$killed_$eq(true);
        DriverRunner driverRunner = this;
        synchronized (driverRunner) {
            this.process().foreach((Function1 & Serializable & scala.Serializable)p -> {
                DriverRunner.$anonfun$kill$2(this, p);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private File createWorkingDirectory() {
        void var1_1;
        File driverDir = new File(this.workDir(), this.driverId());
        if (!driverDir.exists() && !driverDir.mkdirs()) {
            throw new IOException(new StringBuilder(27).append("Failed to create directory ").append(driverDir).toString());
        }
        return var1_1;
    }

    private String downloadUserJar(File driverDir) {
        String jarFileName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new URI(this.driverDesc().jarUrl()).getPath().split("/"))).last();
        File localJarFile = new File(driverDir, jarFileName);
        if (!localJarFile.exists()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Copying user jar ").append(this.driverDesc().jarUrl()).append(" to ").append(localJarFile).toString());
            Utils$.MODULE$.fetchFile(this.driverDesc().jarUrl(), driverDir, this.conf, this.securityManager(), SparkHadoopUtil$.MODULE$.get().newConfiguration(this.conf), System.currentTimeMillis(), false);
            if (!localJarFile.exists()) {
                throw new IOException(new StringBuilder(60).append("Can not find expected jar ").append(jarFileName).append(" which should have been loaded in ").append(driverDir).toString());
            }
        }
        return localJarFile.getAbsolutePath();
    }

    public int prepareAndRunDriver() {
        Seq javaOpts;
        File driverDir = this.createWorkingDirectory();
        String localJarFilename = this.downloadUserJar(driverDir);
        Option<File> resourceFileOpt = StandaloneResourceUtils$.MODULE$.prepareResourcesFile(package$.MODULE$.SPARK_DRIVER_PREFIX(), this.resources(), driverDir);
        Seq x$1 = javaOpts = (Seq)this.driverDesc().command().javaOpts().$plus$plus((GenTraversableOnce)resourceFileOpt.map((Function1 & Serializable & scala.Serializable)f -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("-D").append(package$.MODULE$.DRIVER_RESOURCES_FILE().key()).append("=").append(f.getAbsolutePath()).toString()}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom());
        String x$2 = this.driverDesc().command().copy$default$1();
        Seq<String> x$3 = this.driverDesc().command().copy$default$2();
        Map<String, String> x$4 = this.driverDesc().command().copy$default$3();
        Seq<String> x$5 = this.driverDesc().command().copy$default$4();
        Seq<String> x$6 = this.driverDesc().command().copy$default$5();
        ProcessBuilder builder = CommandUtils$.MODULE$.buildProcessBuilder(this.driverDesc().command().copy(x$2, x$3, x$4, x$5, x$6, (Seq<String>)x$1), this.securityManager(), this.driverDesc().mem(), this.sparkHome().getAbsolutePath(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)argument -> this.substituteVariables$1((String)argument, localJarFilename), CommandUtils$.MODULE$.buildProcessBuilder$default$6(), CommandUtils$.MODULE$.buildProcessBuilder$default$7());
        return this.runDriver(builder, driverDir, this.driverDesc().supervise());
    }

    private int runDriver(ProcessBuilder builder, File baseDir, boolean supervise) {
        builder.directory(baseDir);
        return this.runCommandWithRetry(ProcessBuilderLike$.MODULE$.apply(builder), (Function1<Process, BoxedUnit>)(Function1 & Serializable & scala.Serializable)process -> {
            this.initialize$1(process, baseDir, builder);
            return BoxedUnit.UNIT;
        }, supervise);
    }

    public int runCommandWithRetry(ProcessBuilderLike command, Function1<Process, BoxedUnit> initialize, boolean supervise) {
        IntRef exitCode = IntRef.create((int)-1);
        IntRef waitSeconds = IntRef.create((int)1);
        int successfulRunDuration = 5;
        boolean keepTrying = !this.org$apache$spark$deploy$worker$DriverRunner$$killed();
        String redactedCommand = Utils$.MODULE$.redactCommandLineArgs(this.conf, command.command()).mkString("\"", "\" \"", "\"");
        while (keepTrying) {
            block7: {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Launch Command: ").append(redactedCommand).toString());
                DriverRunner driverRunner = this;
                synchronized (driverRunner) {
                    int n;
                    block6: {
                        if (this.org$apache$spark$deploy$worker$DriverRunner$$killed()) {
                            n = exitCode.elem;
                            break block6;
                        }
                        this.process_$eq((Option<Process>)new Some((Object)command.start()));
                        initialize.apply(this.process().get());
                        break block7;
                    }
                    return n;
                }
            }
            long processStart = this.clock().getTimeMillis();
            exitCode.elem = ((Process)this.process().get()).waitFor();
            keepTrying = supervise && exitCode.elem != 0 && !this.org$apache$spark$deploy$worker$DriverRunner$$killed();
            if (!keepTrying) continue;
            if (this.clock().getTimeMillis() - processStart > (long)successfulRunDuration * 1000L) {
                waitSeconds.elem = 1;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Command exited with status ").append(exitCode$1.elem).append(", re-launching after ").append(waitSeconds$1.elem).append(" s.").toString());
            this.sleeper().sleep(waitSeconds.elem);
            waitSeconds.elem *= 2;
        }
        return exitCode.elem;
    }

    public static final /* synthetic */ void $anonfun$kill$2(DriverRunner $this, Process p) {
        block0: {
            Option<Object> exitCode = Utils$.MODULE$.terminateProcess(p, $this.driverTerminateTimeoutMs());
            if (!exitCode.isEmpty()) break block0;
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to terminate driver process: ").append(p).append(". This process will likely be orphaned.").toString());
        }
    }

    private final String substituteVariables$1(String argument, String localJarFilename$1) {
        String string = argument;
        String string2 = "{{WORKER_URL}}".equals(string) ? this.workerUrl() : ("{{USER_JAR}}".equals(string) ? localJarFilename$1 : string);
        return string2;
    }

    private final void initialize$1(Process process, File baseDir$1, ProcessBuilder builder$1) {
        File stdout = new File(baseDir$1, "stdout");
        CommandUtils$.MODULE$.redirectStream(process.getInputStream(), stdout);
        File stderr = new File(baseDir$1, "stderr");
        String redactedCommand = Utils$.MODULE$.redactCommandLineArgs(this.conf, (Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(builder$1.command()).asScala())).mkString("\"", "\" \"", "\"");
        String header = new StringOps(Predef$.MODULE$.augmentString("Launch Command: %s\n%s\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{redactedCommand, new StringOps(Predef$.MODULE$.augmentString("=")).$times(40)}));
        Files.append((CharSequence)header, (File)stderr, (Charset)StandardCharsets.UTF_8);
        CommandUtils$.MODULE$.redirectStream(process.getErrorStream(), stderr);
    }

    public DriverRunner(SparkConf conf, String driverId, File workDir, File sparkHome, DriverDescription driverDesc, RpcEndpointRef worker, String workerUrl, SecurityManager securityManager, scala.collection.immutable.Map<String, ResourceInformation> resources) {
        this.conf = conf;
        this.driverId = driverId;
        this.workDir = workDir;
        this.sparkHome = sparkHome;
        this.driverDesc = driverDesc;
        this.worker = worker;
        this.workerUrl = workerUrl;
        this.securityManager = securityManager;
        this.resources = resources;
        Logging.$init$(this);
        this.process = None$.MODULE$;
        this.org$apache$spark$deploy$worker$DriverRunner$$killed = false;
        this.finalState = None$.MODULE$;
        this.finalException = None$.MODULE$;
        this.driverTerminateTimeoutMs = BoxesRunTime.unboxToLong((Object)conf.get(Worker$.MODULE$.WORKER_DRIVER_TERMINATE_TIMEOUT()));
        this.clock = new SystemClock();
        this.sleeper = new Sleeper(this){
            private final /* synthetic */ DriverRunner $outer;

            public void sleep(int seconds) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), seconds).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> {
                    Thread.sleep(1000L);
                    return !$this.$outer.org$apache$spark$deploy$worker$DriverRunner$$killed();
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$sleep$1(org.apache.spark.deploy.worker.DriverRunner$$anon$1 int )}, serializedLambda);
            }
        };
    }
}

