/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.history.EventLogFileReader;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import org.apache.spark.deploy.history.RollingEventLogFilesWriter$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.NumericRange;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\n\u0014\u0001yA\u0011b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0016\t\u00135\u0002!\u0011!Q\u0001\n9\n\u0004\"B\u001a\u0001\t\u0003!\u0004\u0002\u0003\u001d\u0001\u0011\u000b\u0007I\u0011B\u001d\t\u0011-\u0003\u0001R1A\u0005\n1C\u0001\"\u0014\u0001\t\u0006\u0004%I!\u000f\u0005\u0006\u001d\u0002!\te\u0014\u0005\u0006/\u0002!\t\u0005\u0017\u0005\u00063\u0002!\tE\u0017\u0005\u0006=\u0002!\te\u0014\u0005\u0006?\u0002!\t\u0005\u0017\u0005\u0006A\u0002!\t%\u0019\u0005\u0006c\u0002!\t%\u000f\u0005\u0006e\u0002!\te\u001d\u0005\u0006{\u0002!\t\u0005\u0017\u0005\u0006}\u0002!I\u0001\u0014\u0005\u0007\u007f\u0002!I!!\u0001\u0003=I{G\u000e\\5oO\u00163XM\u001c;M_\u001e4\u0015\u000e\\3t\r&dWMU3bI\u0016\u0014(B\u0001\u000b\u0016\u0003\u001dA\u0017n\u001d;pefT!AF\f\u0002\r\u0011,\u0007\u000f\\8z\u0015\tA\u0012$A\u0003ta\u0006\u00148N\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<7\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0011\u000e\u0003MI!AI\n\u0003%\u00153XM\u001c;M_\u001e4\u0015\u000e\\3SK\u0006$WM]\u0001\u0003MN\u0004\"!J\u0015\u000e\u0003\u0019R!aI\u0014\u000b\u0005!J\u0012A\u00025bI>|\u0007/\u0003\u0002+M\tQa)\u001b7f'f\u001cH/Z7\n\u00051\n\u0013A\u00034jY\u0016\u001c\u0016p\u001d;f[\u0006!\u0001/\u0019;i!\t)s&\u0003\u00021M\t!\u0001+\u0019;i\u0013\t\u0011\u0014%\u0001\u0005s_>$\b+\u0019;i\u0003\u0019a\u0014N\\5u}Q\u0019QGN\u001c\u0011\u0005\u0001\u0002\u0001\"B\u0012\u0004\u0001\u0004!\u0003\"B\u0017\u0004\u0001\u0004q\u0013!\u00024jY\u0016\u001cX#\u0001\u001e\u0011\u0007m*\u0005J\u0004\u0002=\u0005:\u0011Q\bQ\u0007\u0002})\u0011q(H\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005\u000bQa]2bY\u0006L!a\u0011#\u0002\u000fA\f7m[1hK*\t\u0011)\u0003\u0002G\u000f\n\u00191+Z9\u000b\u0005\r#\u0005CA\u0013J\u0013\tQeE\u0001\u0006GS2,7\u000b^1ukN\fQ\"\u00199q'R\fG/^:GS2,W#\u0001%\u0002\u001b\u00154XM\u001c;M_\u001e4\u0015\u000e\\3t\u0003%a\u0017m\u001d;J]\u0012,\u00070F\u0001Q!\r\t&\u000bV\u0007\u0002\t&\u00111\u000b\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005E+\u0016B\u0001,E\u0005\u0011auN\\4\u0002)\u0019LG.Z*ju\u00164uN\u001d'bgRLe\u000eZ3y+\u0005!\u0016!C2p[BdW\r^3e+\u0005Y\u0006CA)]\u0013\tiFIA\u0004C_>dW-\u00198\u00025\u0019LG.Z*ju\u00164uN\u001d'bgRLe\u000eZ3y\r>\u0014HIR*\u0002!5|G-\u001b4jG\u0006$\u0018n\u001c8US6,\u0017\u0001\u0005>ja\u00163XM\u001c;M_\u001e4\u0015\u000e\\3t)\t\u0011W\r\u0005\u0002RG&\u0011A\r\u0012\u0002\u0005+:LG\u000fC\u0003g\u0019\u0001\u0007q-A\u0005{SB\u001cFO]3b[B\u0011\u0001n\\\u0007\u0002S*\u0011!n[\u0001\u0004u&\u0004(B\u00017n\u0003\u0011)H/\u001b7\u000b\u00039\fAA[1wC&\u0011\u0001/\u001b\u0002\u00105&\u0004x*\u001e;qkR\u001cFO]3b[\u0006\tB.[:u\u000bZ,g\u000e\u001e'pO\u001aKG.Z:\u0002!\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cW#\u0001;\u0011\u0007E\u0013V\u000f\u0005\u0002wu:\u0011q\u000f\u001f\t\u0003{\u0011K!!\u001f#\u0002\rA\u0013X\rZ3g\u0013\tYHP\u0001\u0004TiJLgn\u001a\u0006\u0003s\u0012\u000b\u0011\u0002^8uC2\u001c\u0016N_3\u0002!1\f7\u000f^#wK:$Hj\\4GS2,\u0017!\u00073s_B\u0014UMZ8sK2\u000b7\u000f^\"p[B\f7\r\u001e$jY\u0016$2AOA\u0002\u0011\u0015i\u0015\u00031\u0001;\u0001")
public class RollingEventLogFilesFileReader
extends EventLogFileReader {
    private Seq<FileStatus> files;
    private FileStatus appStatusFile;
    private Seq<FileStatus> eventLogFiles;
    private volatile byte bitmap$0;

    /*
     * WARNING - void declaration
     */
    private Seq<FileStatus> files$lzycompute() {
        RollingEventLogFilesFileReader rollingEventLogFilesFileReader = this;
        synchronized (rollingEventLogFilesFileReader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                Seq ret = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])super.fileSystem().listStatus(this.rootPath()))).toSeq();
                Predef$.MODULE$.require(ret.exists((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isEventLogFile(status))), (Function0 & Serializable & scala.Serializable)() -> "Log directory must contain at least one event log file!");
                Predef$.MODULE$.require(ret.exists((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isAppStatusFile(status))), (Function0 & Serializable & scala.Serializable)() -> "Log directory must contain an appstatus file!");
                this.files = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.files;
    }

    private Seq<FileStatus> files() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.files$lzycompute() : this.files;
    }

    private FileStatus appStatusFile$lzycompute() {
        RollingEventLogFilesFileReader rollingEventLogFilesFileReader = this;
        synchronized (rollingEventLogFilesFileReader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.appStatusFile = (FileStatus)this.files().find((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isAppStatusFile(status))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.appStatusFile;
    }

    private FileStatus appStatusFile() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.appStatusFile$lzycompute() : this.appStatusFile;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<FileStatus> eventLogFiles$lzycompute() {
        RollingEventLogFilesFileReader rollingEventLogFilesFileReader = this;
        synchronized (rollingEventLogFilesFileReader) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var3_3;
                Seq eventLogFiles = (Seq)((SeqLike)this.files().filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isEventLogFile(status)))).sortBy((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToDouble((double)RollingEventLogFilesFileReader.$anonfun$eventLogFiles$2(status)), (Ordering)Ordering.Double$.MODULE$);
                Seq<FileStatus> filesToRead = this.dropBeforeLastCompactFile((Seq<FileStatus>)eventLogFiles);
                Seq indices = (Seq)filesToRead.map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)RollingEventLogFilesWriter$.MODULE$.getEventLogFileIndex(file.getPath().getName())), Seq$.MODULE$.canBuildFrom());
                NumericRange.Inclusive inclusive = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)indices.head()))).to(indices.last());
                Seq seq = indices;
                Predef$.MODULE$.require(!(inclusive != null ? !inclusive.equals(seq) : seq != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Found missing event log file, expected").append(" indices: ").append(new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)indices.head()))).to(indices.last())).append(", actual: ").append(indices).toString());
                this.eventLogFiles = var3_3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.eventLogFiles;
    }

    private Seq<FileStatus> eventLogFiles() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.eventLogFiles$lzycompute() : this.eventLogFiles;
    }

    @Override
    public Option<Object> lastIndex() {
        return new Some((Object)BoxesRunTime.boxToLong((long)RollingEventLogFilesWriter$.MODULE$.getEventLogFileIndex(this.lastEventLogFile().getPath().getName())));
    }

    @Override
    public long fileSizeForLastIndex() {
        return this.lastEventLogFile().getLen();
    }

    @Override
    public boolean completed() {
        return !this.appStatusFile().getPath().getName().endsWith(EventLogFileWriter$.MODULE$.IN_PROGRESS());
    }

    @Override
    public Option<Object> fileSizeForLastIndexForDFS() {
        return this.completed() ? new Some((Object)BoxesRunTime.boxToLong((long)this.fileSizeForLastIndex())) : this.fileSizeForDFS(this.lastEventLogFile().getPath());
    }

    @Override
    public long modificationTime() {
        return this.lastEventLogFile().getModificationTime();
    }

    @Override
    public void zipEventLogFiles(ZipOutputStream zipStream) {
        String dirEntryName = new StringBuilder(1).append(this.rootPath().getName()).append("/").toString();
        zipStream.putNextEntry(new ZipEntry(dirEntryName));
        this.files().foreach((Function1 & Serializable & scala.Serializable)file -> {
            this.addFileAsZipEntry(zipStream, file.getPath(), new StringBuilder(0).append(dirEntryName).append(file.getPath().getName()).toString());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<FileStatus> listEventLogFiles() {
        return this.eventLogFiles();
    }

    @Override
    public Option<String> compressionCodec() {
        return EventLogFileWriter$.MODULE$.codecName(((FileStatus)this.eventLogFiles().head()).getPath());
    }

    @Override
    public long totalSize() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.eventLogFiles().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getLen()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private FileStatus lastEventLogFile() {
        return (FileStatus)this.eventLogFiles().last();
    }

    private Seq<FileStatus> dropBeforeLastCompactFile(Seq<FileStatus> eventLogFiles) {
        int lastCompactedFileIdx = eventLogFiles.lastIndexWhere((Function1 & Serializable & scala.Serializable)fs -> BoxesRunTime.boxToBoolean((boolean)EventLogFileWriter$.MODULE$.isCompacted(fs.getPath())));
        return (Seq)eventLogFiles.drop(lastCompactedFileIdx);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double $anonfun$eventLogFiles$2(FileStatus status) {
        void var2_2;
        block0: {
            Path filePath = status.getPath();
            double idx = RollingEventLogFilesWriter$.MODULE$.getEventLogFileIndex(filePath.getName());
            if (!EventLogFileWriter$.MODULE$.isCompacted(filePath)) break block0;
            idx += 0.1;
        }
        return (double)var2_2;
    }

    public RollingEventLogFilesFileReader(FileSystem fs, Path path) {
        super(fs, path);
    }
}

