/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.EventLogFileReader;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import org.apache.spark.deploy.history.RollingEventLogFilesFileReader;
import org.apache.spark.deploy.history.RollingEventLogFilesWriter$;
import org.apache.spark.deploy.history.SingleFileEventLogFileReader;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

public final class EventLogFileReader$ {
    public static EventLogFileReader$ MODULE$;
    private final ConcurrentHashMap<String, CompressionCodec> codecMap;

    static {
        new EventLogFileReader$();
    }

    private ConcurrentHashMap<String, CompressionCodec> codecMap() {
        return this.codecMap;
    }

    public EventLogFileReader apply(FileSystem fs, Path path, Option<Object> lastIndex) {
        EventLogFileReader eventLogFileReader;
        Option<Object> option = lastIndex;
        if (option instanceof Some) {
            eventLogFileReader = new RollingEventLogFilesFileReader(fs, path);
        } else if (None$.MODULE$.equals(option)) {
            eventLogFileReader = new SingleFileEventLogFileReader(fs, path);
        } else {
            throw new MatchError(option);
        }
        return eventLogFileReader;
    }

    public Option<EventLogFileReader> apply(FileSystem fs, Path path) {
        return this.apply(fs, fs.getFileStatus(path));
    }

    public Option<EventLogFileReader> apply(FileSystem fs, FileStatus status) {
        return this.isSingleEventLog(status) ? new Some((Object)new SingleFileEventLogFileReader(fs, status.getPath())) : (this.isRollingEventLogs(status) ? new Some((Object)new RollingEventLogFilesFileReader(fs, status.getPath())) : None$.MODULE$);
    }

    public InputStream openEventLog(Path log, FileSystem fs) {
        InputStream inputStream;
        BufferedInputStream in = new BufferedInputStream((InputStream)fs.open(log));
        try {
            Option codec = EventLogFileWriter$.MODULE$.codecName(log).map((Function1 & Serializable & scala.Serializable)c -> MODULE$.codecMap().computeIfAbsent((String)c, x$1 -> CompressionCodec$.MODULE$.createCodec(new SparkConf(), (String)x$1)));
            inputStream = (InputStream)codec.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.compressedContinuousInputStream(in)).getOrElse((Function0 & Serializable & scala.Serializable)() -> in);
        }
        catch (Throwable e) {
            in.close();
            throw e;
        }
        return inputStream;
    }

    private boolean isSingleEventLog(FileStatus status) {
        return !status.isDirectory() && !status.getPath().getName().startsWith(".");
    }

    private boolean isRollingEventLogs(FileStatus status) {
        return RollingEventLogFilesWriter$.MODULE$.isEventLogDir(status);
    }

    private EventLogFileReader$() {
        MODULE$ = this;
        this.codecMap = new ConcurrentHashMap();
    }
}

