/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.log4j.PropertyConfigurator;
import org.apache.spark.SparkContext;
import org.apache.spark.SpillListener;
import org.apache.spark.TestUtils;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.sparkproject.guava.io.ByteStreams;
import org.sparkproject.guava.io.Files;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger$;
import scala.util.Try;
import scala.util.Try$;

public final class TestUtils$ {
    public static TestUtils$ MODULE$;
    private final JavaFileObject.Kind org$apache$spark$TestUtils$$SOURCE;

    static {
        new TestUtils$();
    }

    public URL createJarWithClasses(Seq<String> classNames, String toStringValue, Seq<Tuple2<String, String>> classNamesWithBase, Seq<URL> classpathUrls) {
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        Seq files1 = (Seq)classNames.map((Function1 & Serializable & scala.Serializable)name -> {
            String x$1 = name;
            File x$2 = tempDir;
            String x$3 = toStringValue;
            Seq x$4 = classpathUrls;
            String x$5 = MODULE$.createCompiledClass$default$4();
            Seq<String> x$6 = MODULE$.createCompiledClass$default$6();
            String x$7 = MODULE$.createCompiledClass$default$7();
            return MODULE$.createCompiledClass(x$1, x$2, x$3, x$5, (Seq<URL>)x$4, x$6, x$7);
        }, Seq$.MODULE$.canBuildFrom());
        Seq files2 = (Seq)classNamesWithBase.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createJarWithClasses$2(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String childName = (String)tuple2._1();
            String baseName = (String)tuple2._2();
            File file = MODULE$.createCompiledClass(childName, tempDir, toStringValue, baseName, classpathUrls, MODULE$.createCompiledClass$default$6(), MODULE$.createCompiledClass$default$7());
            return file;
        }, Seq$.MODULE$.canBuildFrom());
        File jarFile = new File(tempDir, new StringOps(Predef$.MODULE$.augmentString("testJar-%s.jar")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis())})));
        return this.createJar((Seq<File>)((Seq)files1.$plus$plus((GenTraversableOnce)files2, Seq$.MODULE$.canBuildFrom())), jarFile, this.createJar$default$3(), this.createJar$default$4());
    }

    public URL createJarWithFiles(Map<String, String> files, File dir) {
        File tempDir = (File)Option$.MODULE$.apply((Object)dir).getOrElse((Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        File jarFile = File.createTempFile("testJar", ".jar", tempDir);
        JarOutputStream jarStream = new JarOutputStream(new FileOutputStream(jarFile));
        files.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)TestUtils$.$anonfun$createJarWithFiles$2(jarStream, x0$1)));
        jarStream.close();
        return jarFile.toURI().toURL();
    }

    public URL createJar(Seq<File> files, File jarFile, Option<String> directoryPrefix, Option<String> mainClass) {
        Manifest manifest;
        Option<String> option = mainClass;
        if (option instanceof Some) {
            Some some = (Some)option;
            String mc = (String)some.value();
            Manifest m = new Manifest();
            m.getMainAttributes().putValue("Manifest-Version", "1.0");
            m.getMainAttributes().putValue("Main-Class", mc);
            manifest = m;
        } else if (None$.MODULE$.equals(option)) {
            manifest = new Manifest();
        } else {
            throw new MatchError(option);
        }
        Manifest manifest2 = manifest;
        FileOutputStream jarFileStream = new FileOutputStream(jarFile);
        JarOutputStream jarStream = new JarOutputStream((OutputStream)jarFileStream, manifest2);
        files.foreach((Function1 & Serializable & scala.Serializable)file -> {
            TestUtils$.$anonfun$createJar$1(directoryPrefix, jarStream, file);
            return BoxedUnit.UNIT;
        });
        jarStream.close();
        jarFileStream.close();
        return jarFile.toURI().toURL();
    }

    public String createJarWithClasses$default$2() {
        return "";
    }

    public Seq<Tuple2<String, String>> createJarWithClasses$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Seq<URL> createJarWithClasses$default$4() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public File createJarWithFiles$default$2() {
        return null;
    }

    public Option<String> createJar$default$3() {
        return None$.MODULE$;
    }

    public Option<String> createJar$default$4() {
        return None$.MODULE$;
    }

    public JavaFileObject.Kind org$apache$spark$TestUtils$$SOURCE() {
        return this.org$apache$spark$TestUtils$$SOURCE;
    }

    public URI org$apache$spark$TestUtils$$createURI(String name) {
        return URI.create(new StringBuilder(10).append("string:///").append(name.replace(".", "/")).append(this.org$apache$spark$TestUtils$$SOURCE().extension).toString());
    }

    public File createCompiledClass(String className, File destDir, TestUtils.JavaSourceFromString sourceFile, Seq<URL> classpathUrls) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        Seq options = classpathUrls.nonEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-classpath", ((TraversableOnce)classpathUrls.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getFile(), Seq$.MODULE$.canBuildFrom())).mkString(File.pathSeparator)})) : (Seq)Seq$.MODULE$.empty();
        compiler.getTask(null, null, null, (Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(options).asJava(), null, Arrays.asList((Object[])new TestUtils.JavaSourceFromString[]{sourceFile})).call();
        String fileName = new StringBuilder(6).append(className).append(".class").toString();
        File result = new File(fileName);
        Predef$.MODULE$.assert(result.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Compiled file not found: ").append(result.getAbsolutePath()).toString());
        File out = new File(destDir, fileName);
        Files.move((File)result, (File)out);
        Predef$.MODULE$.assert(out.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Destination file not moved: ").append(out.getAbsolutePath()).toString());
        return out;
    }

    public File createCompiledClass(String className, File destDir, String toStringValue, String baseClass, Seq<URL> classpathUrls, Seq<String> implementsClasses, String extraCodeBody) {
        String extendsText = (String)Option$.MODULE$.apply((Object)baseClass).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(9).append(" extends ").append((String)c).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String implementsText = new StringBuilder(11).append("implements ").append(((TraversableOnce)implementsClasses.$colon$plus((Object)"java.io.Serializable", Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString();
        TestUtils.JavaSourceFromString sourceFile = new TestUtils.JavaSourceFromString(className, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n         |public class ").append(className).append(" ").append(extendsText).append(" ").append(implementsText).append(" {\n         |  @Override public String toString() { return \"").append(toStringValue).append("\"; }\n         |\n         |  ").append(extraCodeBody).append("\n         |}\n        ").toString())).stripMargin());
        return this.createCompiledClass(className, destDir, sourceFile, classpathUrls);
    }

    public String createCompiledClass$default$3() {
        return "";
    }

    public String createCompiledClass$default$4() {
        return null;
    }

    public Seq<URL> createCompiledClass$default$5() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Seq<String> createCompiledClass$default$6() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public String createCompiledClass$default$7() {
        return "";
    }

    public void assertSpilled(SparkContext sc, String identifier, Function0<BoxedUnit> body2) {
        SpillListener listener = new SpillListener();
        this.withListener(sc, listener, (Function1 & Serializable & scala.Serializable)x$3 -> {
            body2.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(listener.numSpilledStages() > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("expected ").append(identifier).append(" to spill, but did not").toString());
    }

    public void assertNotSpilled(SparkContext sc, String identifier, Function0<BoxedUnit> body2) {
        SpillListener listener = new SpillListener();
        this.withListener(sc, listener, (Function1 & Serializable & scala.Serializable)x$4 -> {
            body2.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(listener.numSpilledStages() == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("expected ").append(identifier).append(" to not spill, but did").toString());
    }

    public void assertExceptionMsg(Throwable exception, String msg, boolean ignoreCase) {
        Throwable e = exception;
        boolean contains = TestUtils$.contain$1(e.getMessage(), msg, ignoreCase);
        while (e.getCause() != null && !contains) {
            e = e.getCause();
            contains = TestUtils$.contain$1(e.getMessage(), msg, ignoreCase);
        }
        Predef$.MODULE$.assert(contains, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Exception tree doesn't contain the expected message: ").append(msg).toString());
    }

    public boolean assertExceptionMsg$default$3() {
        return false;
    }

    public boolean testCommandAvailable(String command) {
        Try attempt = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Process$.MODULE$.apply(command).run(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$5 -> {
            TestUtils$.$anonfun$testCommandAvailable$2(x$5);
            return BoxedUnit.UNIT;
        })).exitValue());
        return attempt.isSuccess() && BoxesRunTime.unboxToInt((Object)attempt.get()) == 0;
    }

    public int httpResponseCode(URL url, String method, Seq<Tuple2<String, String>> headers) {
        return BoxesRunTime.unboxToInt(this.withHttpConnection(url, method, headers, (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)connection.getResponseCode())));
    }

    public String httpResponseCode$default$2() {
        return "GET";
    }

    public Seq<Tuple2<String, String>> httpResponseCode$default$3() {
        return Nil$.MODULE$;
    }

    public <T> T withHttpConnection(URL url, String method, Seq<Tuple2<String, String>> headers, Function1<HttpURLConnection, T> fn) {
        Object object;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        headers.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestUtils$.$anonfun$withHttpConnection$1(connection, x0$1);
            return BoxedUnit.UNIT;
        });
        if (connection instanceof HttpsURLConnection) {
            SSLContext sslCtx = SSLContext.getInstance("SSL");
            X509TrustManager trustManager = new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                }
            };
            HostnameVerifier verifier = new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            sslCtx.init(null, (TrustManager[])((Object[])new TrustManager[]{trustManager}), new SecureRandom());
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslCtx.getSocketFactory());
            ((HttpsURLConnection)connection).setHostnameVerifier(verifier);
        }
        try {
            connection.connect();
            object = fn.apply((Object)connection);
        }
        finally {
            connection.disconnect();
        }
        return (T)object;
    }

    public <T> String withHttpConnection$default$2() {
        return "GET";
    }

    public <T> Seq<Tuple2<String, String>> withHttpConnection$default$3() {
        return Nil$.MODULE$;
    }

    public <L extends SparkListener> void withListener(SparkContext sc, L listener, Function1<L, BoxedUnit> body2) {
        sc.addSparkListener(listener);
        try {
            body2.apply(listener);
        }
        finally {
            sc.listenerBus().waitUntilEmpty();
            sc.listenerBus().removeListener(listener);
        }
    }

    public void waitUntilExecutorsUp(SparkContext sc, int numExecutors, long timeout) {
        long finishTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        while (System.nanoTime() < finishTime) {
            if (sc.statusTracker().getExecutorInfos().length > numExecutors) {
                return;
            }
            Thread.sleep(10L);
        }
        throw new TimeoutException(new StringBuilder(50).append("Can't find ").append(numExecutors).append(" executors before ").append(timeout).append(" milliseconds elapsed").toString());
    }

    public void configTestLog4j(String level) {
        Properties pro = new Properties();
        pro.put("log4j.rootLogger", new StringBuilder(9).append(level).append(", console").toString());
        pro.put("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
        pro.put("log4j.appender.console.target", "System.err");
        pro.put("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
        pro.put("log4j.appender.console.layout.ConversionPattern", "%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n");
        PropertyConfigurator.configure((Properties)pro);
    }

    public File[] recursiveList(File f2) {
        Predef$.MODULE$.require(f2.isDirectory());
        File[] current = f2.listFiles();
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])current)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])current)).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDirectory())))).flatMap((Function1 & Serializable & scala.Serializable)f -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TestUtils$.MODULE$.recursiveList(f))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    public String createTempJsonFile(File dir, String prefix, JsonAST.JValue jsonValue) {
        File file = File.createTempFile(prefix, ".json", dir);
        JsonAST.JValue x$1 = jsonValue;
        Formats x$2 = JsonMethods$.MODULE$.render$default$2(x$1);
        java.nio.file.Files.write(file.toPath(), JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$1, x$2)).getBytes(), new OpenOption[0]);
        return file.getPath();
    }

    public String createTempScriptWithExpectedOutput(File dir, String prefix, String output) {
        File file = File.createTempFile(prefix, ".sh", dir);
        String script = new StringBuilder(15).append("cat <<EOF\n").append(output).append("\nEOF\n").toString();
        Files.write((CharSequence)script, (File)file, (Charset)StandardCharsets.UTF_8);
        java.nio.file.Files.setPosixFilePermissions(file.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE));
        return file.getPath();
    }

    public static final /* synthetic */ boolean $anonfun$createJarWithClasses$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$createJarWithFiles$2(JarOutputStream jarStream$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        JarEntry entry = new JarEntry(k);
        jarStream$1.putNextEntry(entry);
        long l = ByteStreams.copy((InputStream)new ByteArrayInputStream(v.getBytes(StandardCharsets.UTF_8)), (OutputStream)jarStream$1);
        return l;
    }

    public static final /* synthetic */ void $anonfun$createJar$1(Option directoryPrefix$1, JarOutputStream jarStream$2, File file) {
        String prefix = (String)directoryPrefix$1.map((Function1 & Serializable & scala.Serializable)d -> new StringBuilder(1).append((String)d).append("/").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        JarEntry jarEntry = new JarEntry(new StringBuilder(0).append(prefix).append(file.getName()).toString());
        jarStream$2.putNextEntry(jarEntry);
        FileInputStream in = new FileInputStream(file);
        ByteStreams.copy((InputStream)in, (OutputStream)jarStream$2);
        in.close();
    }

    private static final boolean contain$1(String msg1, String msg2, boolean ignoreCase$1) {
        return ignoreCase$1 ? msg1.toLowerCase(Locale.ROOT).contains(msg2.toLowerCase(Locale.ROOT)) : msg1.contains(msg2);
    }

    public static final /* synthetic */ void $anonfun$testCommandAvailable$2(String x$5) {
    }

    public static final /* synthetic */ void $anonfun$withHttpConnection$1(HttpURLConnection connection$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        connection$1.setRequestProperty(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private TestUtils$() {
        MODULE$ = this;
        this.org$apache$spark$TestUtils$$SOURCE = JavaFileObject.Kind.SOURCE;
    }
}

