/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapOutputTracker$;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.MapOutputTrackerMasterEndpoint;
import org.apache.spark.MapOutputTrackerWorker;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.UnifiedMemoryManager;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.metrics.MetricsSystemInstances$;
import org.apache.spark.network.netty.NettyBlockTransferService;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.shuffle.ExternalBlockStoreClient;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnv$;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerInfo;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMasterEndpoint;
import org.apache.spark.storage.BlockManagerMasterHeartbeatEndpoint;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;

public final class SparkEnv$
implements Logging {
    public static SparkEnv$ MODULE$;
    private volatile SparkEnv env;
    private final String driverSystemName;
    private final String executorSystemName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkEnv$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkEnv env() {
        return this.env;
    }

    private void env_$eq(SparkEnv x$1) {
        this.env = x$1;
    }

    public String driverSystemName() {
        return this.driverSystemName;
    }

    public String executorSystemName() {
        return this.executorSystemName;
    }

    public void set(SparkEnv e) {
        this.env_$eq(e);
    }

    public SparkEnv get() {
        return this.env();
    }

    public SparkEnv createDriverEnv(SparkConf conf, boolean isLocal, LiveListenerBus listenerBus, int numCores, Option<OutputCommitCoordinator> mockOutputCommitCoordinator) {
        Predef$.MODULE$.assert(conf.contains(package$.MODULE$.DRIVER_HOST_ADDRESS()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(package$.MODULE$.DRIVER_HOST_ADDRESS().key()).append(" is not set on the driver!").toString());
        Predef$.MODULE$.assert(conf.contains(package$.MODULE$.DRIVER_PORT()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(package$.MODULE$.DRIVER_PORT().key()).append(" is not set on the driver!").toString());
        String bindAddress = conf.get(package$.MODULE$.DRIVER_BIND_ADDRESS());
        String advertiseAddress = conf.get(package$.MODULE$.DRIVER_HOST_ADDRESS());
        int port = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DRIVER_PORT()));
        None$ ioEncryptionKey = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.IO_ENCRYPTION_ENABLED())) ? new Some((Object)CryptoStreamUtils$.MODULE$.createKey(conf)) : None$.MODULE$;
        return this.create(conf, SparkContext$.MODULE$.DRIVER_IDENTIFIER(), bindAddress, advertiseAddress, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)port)), isLocal, numCores, (Option<byte[]>)ioEncryptionKey, listenerBus, mockOutputCommitCoordinator);
    }

    public SparkEnv createExecutorEnv(SparkConf conf, String executorId, String bindAddress, String hostname, int numCores, Option<byte[]> ioEncryptionKey, boolean isLocal) {
        SparkEnv env = this.create(conf, executorId, bindAddress, hostname, (Option<Object>)None$.MODULE$, isLocal, numCores, ioEncryptionKey, this.create$default$9(), this.create$default$10());
        this.set(env);
        return env;
    }

    public SparkEnv createExecutorEnv(SparkConf conf, String executorId, String hostname, int numCores, Option<byte[]> ioEncryptionKey, boolean isLocal) {
        return this.createExecutorEnv(conf, executorId, hostname, hostname, numCores, ioEncryptionKey, isLocal);
    }

    private SparkEnv create(SparkConf conf, String executorId, String bindAddress, String advertiseAddress, Option<Object> port, boolean isLocal, int numUsableCores, Option<byte[]> ioEncryptionKey, LiveListenerBus listenerBus, Option<OutputCommitCoordinator> mockOutputCommitCoordinator) {
        SparkEnv envInstance;
        block6: {
            MetricsSystem metricsSystem;
            None$ none$;
            int blockManagerPort;
            boolean isDriver;
            String string = executorId;
            String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (isDriver = false);
            if (isDriver) {
                Predef$.MODULE$.assert(listenerBus != null, (Function0 & Serializable & scala.Serializable)() -> "Attempted to create driver SparkEnv with null listener bus!");
            }
            ConfigEntry<Option<String>> authSecretFileConf = isDriver ? package$.MODULE$.AUTH_SECRET_FILE_DRIVER() : package$.MODULE$.AUTH_SECRET_FILE_EXECUTOR();
            SecurityManager securityManager = new SecurityManager(conf, ioEncryptionKey, authSecretFileConf);
            if (isDriver) {
                securityManager.initializeAuth();
            }
            ioEncryptionKey.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                SparkEnv$.$anonfun$create$2(securityManager, x$4);
                return BoxedUnit.UNIT;
            });
            String systemName = isDriver ? this.driverSystemName() : this.executorSystemName();
            RpcEnv rpcEnv = RpcEnv$.MODULE$.create(systemName, bindAddress, advertiseAddress, BoxesRunTime.unboxToInt((Object)port.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), conf, securityManager, numUsableCores, !isDriver);
            Object object = isDriver ? conf.set(package$.MODULE$.DRIVER_PORT(), BoxesRunTime.boxToInteger((int)rpcEnv.address().port())) : BoxedUnit.UNIT;
            Serializer serializer = (Serializer)SparkEnv$.instantiateClassFromConf$1(package$.MODULE$.SERIALIZER(), conf, isDriver);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Using serializer: ").append(serializer.getClass()).toString());
            SerializerManager serializerManager = new SerializerManager(serializer, conf, ioEncryptionKey);
            JavaSerializer closureSerializer = new JavaSerializer(conf);
            BroadcastManager broadcastManager = new BroadcastManager(isDriver, conf, securityManager);
            MapOutputTracker mapOutputTracker = isDriver ? new MapOutputTrackerMaster(conf, broadcastManager, isLocal) : new MapOutputTrackerWorker(conf);
            mapOutputTracker.trackerEndpoint_$eq(this.registerOrLookupEndpoint$1(MapOutputTracker$.MODULE$.ENDPOINT_NAME(), (Function0 & Serializable & scala.Serializable)() -> new MapOutputTrackerMasterEndpoint(rpcEnv, (MapOutputTrackerMaster)mapOutputTracker, conf), isDriver, rpcEnv, conf));
            Map shortShuffleMgrNames = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sort"), (Object)SortShuffleManager.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tungsten-sort"), (Object)SortShuffleManager.class.getName())}));
            String shuffleMgrName = conf.get(package$.MODULE$.SHUFFLE_MANAGER());
            String shuffleMgrClass = (String)shortShuffleMgrNames.getOrElse((Object)shuffleMgrName.toLowerCase(Locale.ROOT), (Function0 & Serializable & scala.Serializable)() -> shuffleMgrName);
            ShuffleManager shuffleManager = (ShuffleManager)SparkEnv$.instantiateClass$1(shuffleMgrClass, conf, isDriver);
            UnifiedMemoryManager memoryManager = UnifiedMemoryManager$.MODULE$.apply(conf, numUsableCores);
            int n = blockManagerPort = isDriver ? BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT())) : BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.BLOCK_MANAGER_PORT()));
            if (BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) {
                TransportConf transConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", numUsableCores, SparkTransportConf$.MODULE$.fromSparkConf$default$4());
                none$ = new Some((Object)new ExternalBlockStoreClient(transConf, (SecretKeyHolder)securityManager, securityManager.isAuthenticationEnabled(), BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.SHUFFLE_REGISTRATION_TIMEOUT()))));
            } else {
                none$ = None$.MODULE$;
            }
            None$ externalShuffleClient = none$;
            TrieMap blockManagerInfo = new TrieMap();
            BlockManagerMaster blockManagerMaster = new BlockManagerMaster(this.registerOrLookupEndpoint$1(BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME(), () -> SparkEnv$.$anonfun$create$9(rpcEnv, isLocal, conf, listenerBus, (Option)externalShuffleClient, blockManagerInfo), isDriver, rpcEnv, conf), this.registerOrLookupEndpoint$1(BlockManagerMaster$.MODULE$.DRIVER_HEARTBEAT_ENDPOINT_NAME(), (Function0 & Serializable & scala.Serializable)() -> new BlockManagerMasterHeartbeatEndpoint(rpcEnv, isLocal, (scala.collection.mutable.Map<BlockManagerId, BlockManagerInfo>)blockManagerInfo), isDriver, rpcEnv, conf), conf, isDriver);
            NettyBlockTransferService blockTransferService = new NettyBlockTransferService(conf, securityManager, bindAddress, advertiseAddress, blockManagerPort, numUsableCores, blockManagerMaster.driverEndpoint());
            BlockManager blockManager = new BlockManager(executorId, rpcEnv, blockManagerMaster, serializerManager, conf, memoryManager, mapOutputTracker, shuffleManager, blockTransferService, securityManager, (Option<ExternalBlockStoreClient>)externalShuffleClient);
            if (isDriver) {
                metricsSystem = MetricsSystem$.MODULE$.createMetricsSystem(MetricsSystemInstances$.MODULE$.DRIVER(), conf, securityManager);
            } else {
                conf.set(package$.MODULE$.EXECUTOR_ID(), executorId);
                MetricsSystem ms = MetricsSystem$.MODULE$.createMetricsSystem(MetricsSystemInstances$.MODULE$.EXECUTOR(), conf, securityManager);
                ms.start(BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.METRICS_STATIC_SOURCES_ENABLED())));
                metricsSystem = ms;
            }
            MetricsSystem metricsSystem2 = metricsSystem;
            OutputCommitCoordinator outputCommitCoordinator = (OutputCommitCoordinator)mockOutputCommitCoordinator.getOrElse((Function0 & Serializable & scala.Serializable)() -> new OutputCommitCoordinator(conf, isDriver));
            RpcEndpointRef outputCommitCoordinatorRef = this.registerOrLookupEndpoint$1("OutputCommitCoordinator", (Function0 & Serializable & scala.Serializable)() -> new OutputCommitCoordinator.OutputCommitCoordinatorEndpoint(rpcEnv, outputCommitCoordinator), isDriver, rpcEnv, conf);
            outputCommitCoordinator.coordinatorRef_$eq((Option<RpcEndpointRef>)new Some((Object)outputCommitCoordinatorRef));
            envInstance = new SparkEnv(executorId, rpcEnv, serializer, closureSerializer, serializerManager, mapOutputTracker, shuffleManager, broadcastManager, blockManager, securityManager, metricsSystem2, memoryManager, outputCommitCoordinator, conf);
            if (!isDriver) break block6;
            String sparkFilesDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.getLocalDir(conf), "userFiles").getAbsolutePath();
            envInstance.driverTmpDir_$eq((Option<String>)new Some((Object)sparkFilesDir));
        }
        return envInstance;
    }

    public Option<OutputCommitCoordinator> createDriverEnv$default$5() {
        return None$.MODULE$;
    }

    private LiveListenerBus create$default$9() {
        return null;
    }

    private Option<OutputCommitCoordinator> create$default$10() {
        return None$.MODULE$;
    }

    public Map<String, Seq<Tuple2<String, String>>> environmentDetails(SparkConf conf, Configuration hadoopConf, String schedulingMode, Seq<String> addedJars, Seq<String> addedFiles) {
        Seq jvmInformation = (Seq)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Java Version", (Object)new StringBuilder(3).append(Properties$.MODULE$.javaVersion()).append(" (").append(Properties$.MODULE$.javaVendor()).append(")").toString()), new Tuple2((Object)"Java Home", (Object)Properties$.MODULE$.javaHome()), new Tuple2((Object)"Scala Version", (Object)Properties$.MODULE$.versionString())}))).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        Seq schedulerMode = !conf.contains(package$.MODULE$.SCHEDULER_MODE()) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package$.MODULE$.SCHEDULER_MODE().key(), (Object)schedulingMode)})) : (Seq)Seq$.MODULE$.empty();
        Tuple2[] sparkProperties = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).$plus$plus((GenTraversableOnce)schedulerMode, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        Seq systemProperties = Utils$.MODULE$.getSystemProperties().toSeq();
        Seq otherProperties = (Seq)((SeqLike)systemProperties.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkEnv$.$anonfun$environmentDetails$1(x0$1)))).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        Tuple2[] classPathEntries = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Properties$.MODULE$.javaClassPath().split(File.pathSeparator))).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty())))).map((Function1 & Serializable & scala.Serializable)x$6 -> new Tuple2(x$6, (Object)"System Classpath"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Seq addedJarsAndFiles = (Seq)((TraversableLike)addedJars.$plus$plus(addedFiles, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> new Tuple2(x$7, (Object)"Added By User"), Seq$.MODULE$.canBuildFrom());
        Seq classPaths = (Seq)((SeqLike)addedJarsAndFiles.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classPathEntries)), Seq$.MODULE$.canBuildFrom())).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        Seq hadoopProperties = (Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)hadoopConf).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2(entry.getKey(), entry.getValue()), Iterable$.MODULE$.canBuildFrom())).toSeq().sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$));
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JVM Information"), (Object)jvmInformation), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Spark Properties"), (Object)Predef$.MODULE$.wrapRefArray((Object[])sparkProperties)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Hadoop Properties"), (Object)hadoopProperties), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"System Properties"), (Object)otherProperties), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Classpath Entries"), (Object)classPaths)}));
    }

    public static final /* synthetic */ void $anonfun$create$2(SecurityManager securityManager$1, byte[] x$4) {
        block0: {
            if (securityManager$1.isEncryptionEnabled()) break block0;
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "I/O encryption enabled without RPC encryption: keys will be visible on the wire.");
        }
    }

    private static final Object instantiateClass$1(String className, SparkConf conf$1, boolean isDriver$1) {
        Object c;
        Class cls = Utils$.MODULE$.classForName(className, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        try {
            c = cls.getConstructor(SparkConf.class, Boolean.TYPE).newInstance(conf$1, isDriver$1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                c = cls.getConstructor(SparkConf.class).newInstance(conf$1);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                c = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        return c;
    }

    private static final Object instantiateClassFromConf$1(ConfigEntry propertyName, SparkConf conf$1, boolean isDriver$1) {
        return SparkEnv$.instantiateClass$1((String)conf$1.get(propertyName), conf$1, isDriver$1);
    }

    private final RpcEndpointRef registerOrLookupEndpoint$1(String name, Function0 endpointCreator, boolean isDriver$1, RpcEnv rpcEnv$1, SparkConf conf$1) {
        RpcEndpointRef rpcEndpointRef;
        if (isDriver$1) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Registering ").append(name).toString());
            rpcEndpointRef = rpcEnv$1.setupEndpoint(name, (RpcEndpoint)endpointCreator.apply());
        } else {
            rpcEndpointRef = RpcUtils$.MODULE$.makeDriverRef(name, conf$1, rpcEnv$1);
        }
        return rpcEndpointRef;
    }

    public static final /* synthetic */ BlockManagerMasterEndpoint $anonfun$create$9(RpcEnv rpcEnv$1, boolean isLocal$1, SparkConf conf$1, LiveListenerBus listenerBus$1, Option externalShuffleClient$1, TrieMap blockManagerInfo$1) {
        return new BlockManagerMasterEndpoint(rpcEnv$1, isLocal$1, conf$1, listenerBus$1, (Option<ExternalBlockStoreClient>)(BoxesRunTime.unboxToBoolean((Object)conf$1.get(package$.MODULE$.SHUFFLE_SERVICE_FETCH_RDD_ENABLED())) ? externalShuffleClient$1 : None$.MODULE$), (scala.collection.mutable.Map<BlockManagerId, BlockManagerInfo>)blockManagerInfo$1);
    }

    public static final /* synthetic */ boolean $anonfun$environmentDetails$1(Tuple2 x0$1) {
        String k;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = k = (String)tuple2._1();
        String string2 = "java.class.path";
        boolean bl = (string == null ? string2 != null : !string.equals(string2)) && !k.startsWith("spark.");
        return bl;
    }

    private SparkEnv$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.driverSystemName = "sparkDriver";
        this.executorSystemName = "sparkExecutor";
    }
}

