/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.CleanAccum;
import org.apache.spark.CleanBroadcast;
import org.apache.spark.CleanCheckpoint;
import org.apache.spark.CleanRDD;
import org.apache.spark.CleanShuffle;
import org.apache.spark.CleanerListener;
import org.apache.spark.CleanupTask;
import org.apache.spark.CleanupTaskWeakReference;
import org.apache.spark.ContextCleaner$;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ReliableRDDCheckpointData$;
import org.apache.spark.shuffle.api.ShuffleDriverComponents;
import org.apache.spark.util.AccumulatorContext$;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tuc!B\u0017/\u00019\"\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011\u001d\u0003!\u0011!Q\u0001\n!CQ\u0001\u0015\u0001\u0005\u0002ECq!\u0016\u0001C\u0002\u0013%a\u000b\u0003\u0004c\u0001\u0001\u0006Ia\u0016\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019i\u0007\u0001)A\u0005K\"9a\u000e\u0001b\u0001\n\u0013y\u0007BB=\u0001A\u0003%\u0001\u000fC\u0004{\u0001\t\u0007I\u0011B>\t\u000f\u0005\u0005\u0001\u0001)A\u0005y\"I\u00111\u0001\u0001C\u0002\u0013%\u0011Q\u0001\u0005\t\u0003\u001b\u0001\u0001\u0015!\u0003\u0002\b!I\u0011q\u0002\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0014!I\u00111\u0004\u0001C\u0002\u0013%\u0011Q\u0004\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002 !I\u0011q\u0005\u0001C\u0002\u0013%\u0011Q\u0004\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002 !I\u00111\u0006\u0001A\u0002\u0013%\u0011Q\u0004\u0005\n\u0003[\u0001\u0001\u0019!C\u0005\u0003_A\u0001\"a\u000f\u0001A\u0003&\u0011q\u0004\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!!\u0015\u0001\t\u0003\ty\u0005C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\t9\u0010\u0001C\u0005\u0003sDqA!\u0003\u0001\t\u0013\ty\u0005C\u0004\u0003\f\u0001!\tA!\u0004\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002b\u0002B\u0016\u0001\u0011\u0005!Q\u0006\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{AqA!\u0012\u0001\t\u0013\u00119eB\u0004\u0003P9BIA!\u0015\u0007\r5r\u0003\u0012\u0002B*\u0011\u0019\u0001\u0016\u0006\"\u0001\u0003V!I!qK\u0015C\u0002\u0013%!\u0011\f\u0005\t\u00057J\u0003\u0015!\u0003\u0002p\nq1i\u001c8uKb$8\t\\3b]\u0016\u0014(BA\u00181\u0003\u0015\u0019\b/\u0019:l\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\u0014\u0007\u0001)4\b\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VM\u001a\t\u0003y}j\u0011!\u0010\u0006\u0003}9\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0001v\u0012q\u0001T8hO&tw-\u0001\u0002tG\u000e\u0001\u0001C\u0001#F\u001b\u0005q\u0013B\u0001$/\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003]\u0019\b.\u001e4gY\u0016$%/\u001b<fe\u000e{W\u000e]8oK:$8\u000f\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006\u0019\u0011\r]5\u000b\u00055s\u0013aB:ik\u001a4G.Z\u0005\u0003\u001f*\u0013qc\u00155vM\u001adW\r\u0012:jm\u0016\u00148i\\7q_:,g\u000e^:\u0002\rqJg.\u001b;?)\r\u00116\u000b\u0016\t\u0003\t\u0002AQ!Q\u0002A\u0002\rCQaR\u0002A\u0002!\u000bqB]3gKJ,gnY3Ck\u001a4WM]\u000b\u0002/B\u0019\u0001,X0\u000e\u0003eS!AW.\u0002\tU$\u0018\u000e\u001c\u0006\u00029\u0006!!.\u0019<b\u0013\tq\u0016LA\u0002TKR\u0004\"\u0001\u00121\n\u0005\u0005t#\u0001G\"mK\u0006tW\u000f\u001d+bg.<V-Y6SK\u001a,'/\u001a8dK\u0006\u0001\"/\u001a4fe\u0016t7-\u001a\"vM\u001a,'\u000fI\u0001\u000fe\u00164WM]3oG\u0016\fV/Z;f+\u0005)\u0007c\u00014lk5\tqM\u0003\u0002iS\u0006\u0019!/\u001a4\u000b\u0005)\\\u0016\u0001\u00027b]\u001eL!\u0001\\4\u0003\u001dI+g-\u001a:f]\u000e,\u0017+^3vK\u0006y!/\u001a4fe\u0016t7-Z)vKV,\u0007%A\u0005mSN$XM\\3sgV\t\u0001\u000fE\u0002riZl\u0011A\u001d\u0006\u0003gf\u000b!bY8oGV\u0014(/\u001a8u\u0013\t)(OA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\u0005\u0011;\u0018B\u0001=/\u0005=\u0019E.Z1oKJd\u0015n\u001d;f]\u0016\u0014\u0018A\u00037jgR,g.\u001a:tA\u0005q1\r\\3b]&tw\r\u00165sK\u0006$W#\u0001?\u0011\u0005utX\"A5\n\u0005}L'A\u0002+ie\u0016\fG-A\bdY\u0016\fg.\u001b8h)\"\u0014X-\u00193!\u0003E\u0001XM]5pI&\u001cwiQ*feZL7-Z\u000b\u0003\u0003\u000f\u00012!]A\u0005\u0013\r\tYA\u001d\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u00059fe&|G-[2H\u0007N+'O^5dK\u0002\n!\u0003]3sS>$\u0017nY$D\u0013:$XM\u001d<bYV\u0011\u00111\u0003\t\u0004m\u0005U\u0011bAA\fo\t!Aj\u001c8h\u0003M\u0001XM]5pI&\u001cwiQ%oi\u0016\u0014h/\u00197!\u0003M\u0011Gn\\2l\u001f:\u001cE.Z1okB$\u0016m]6t+\t\ty\u0002E\u00027\u0003CI1!a\t8\u0005\u001d\u0011un\u001c7fC:\fAC\u00197pG.|en\u00117fC:,\b\u000fV1tWN\u0004\u0013A\u00072m_\u000e\\wJ\\*ik\u001a4G.Z\"mK\u0006tW\u000f\u001d+bg.\u001c\u0018a\u00072m_\u000e\\wJ\\*ik\u001a4G.Z\"mK\u0006tW\u000f\u001d+bg.\u001c\b%A\u0004ti>\u0004\b/\u001a3\u0002\u0017M$x\u000e\u001d9fI~#S-\u001d\u000b\u0005\u0003c\t9\u0004E\u00027\u0003gI1!!\u000e8\u0005\u0011)f.\u001b;\t\u0013\u0005eR#!AA\u0002\u0005}\u0011a\u0001=%c\u0005A1\u000f^8qa\u0016$\u0007\u0005K\u0002\u0017\u0003\u007f\u00012ANA!\u0013\r\t\u0019e\u000e\u0002\tm>d\u0017\r^5mK\u0006q\u0011\r\u001e;bG\"d\u0015n\u001d;f]\u0016\u0014H\u0003BA\u0019\u0003\u0013Ba!a\u0013\u0018\u0001\u00041\u0018\u0001\u00037jgR,g.\u001a:\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005E\u0012\u0001B:u_B\fQC]3hSN$XM\u001d*E\t\u001a{'o\u00117fC:,\b\u000f\u0006\u0003\u00022\u0005]\u0003bBA-5\u0001\u0007\u00111L\u0001\u0004e\u0012$\u0007\u0007BA/\u0003W\u0002b!a\u0018\u0002d\u0005\u001dTBAA1\u0015\r\tIFL\u0005\u0005\u0003K\n\tGA\u0002S\t\u0012\u0003B!!\u001b\u0002l1\u0001A\u0001DA7\u0003/\n\t\u0011!A\u0003\u0002\u0005=$aA0%cE!\u0011\u0011OA<!\r1\u00141O\u0005\u0004\u0003k:$a\u0002(pi\"Lgn\u001a\t\u0004m\u0005e\u0014bAA>o\t\u0019\u0011I\\=\u0002;I,w-[:uKJ\f5mY;nk2\fGo\u001c:G_J\u001cE.Z1okB$B!!\r\u0002\u0002\"9\u00111Q\u000eA\u0002\u0005\u0015\u0015!A11\r\u0005\u001d\u00151SAM!!\tI)!$\u0002\u0012\u0006]UBAAF\u0015\tQf&\u0003\u0003\u0002\u0010\u0006-%!D!dGVlW\u000f\\1u_J4&\u0007\u0005\u0003\u0002j\u0005ME\u0001DAK\u0003\u0003\u000b\t\u0011!A\u0003\u0002\u0005=$aA0%eA!\u0011\u0011NAM\t1\tY*!!\u0002\u0002\u0003\u0005)\u0011AA8\u0005\ryFeM\u0001\u001ae\u0016<\u0017n\u001d;feNCWO\u001a4mK\u001a{'o\u00117fC:,\b\u000f\u0006\u0003\u00022\u0005\u0005\u0006bBAR9\u0001\u0007\u0011QU\u0001\u0012g\",hM\u001a7f\t\u0016\u0004XM\u001c3f]\u000eL\b\u0007CAT\u0003_\u000b),a/\u0011\u0013\u0011\u000bI+!,\u00024\u0006e\u0016bAAV]\t\t2\u000b[;gM2,G)\u001a9f]\u0012,gnY=\u0011\t\u0005%\u0014q\u0016\u0003\r\u0003c\u000b\t+!A\u0001\u0002\u000b\u0005\u0011q\u000e\u0002\u0004?\u0012\"\u0004\u0003BA5\u0003k#A\"a.\u0002\"\u0006\u0005\t\u0011!B\u0001\u0003_\u00121a\u0018\u00136!\u0011\tI'a/\u0005\u0019\u0005u\u0016\u0011UA\u0001\u0002\u0003\u0015\t!a\u001c\u0003\u0007}#c'A\u000esK\u001eL7\u000f^3s\u0005J|\u0017\rZ2bgR4uN]\"mK\u0006tW\u000f]\u000b\u0005\u0003\u0007\f)\u000e\u0006\u0003\u00022\u0005\u0015\u0007bBAd;\u0001\u0007\u0011\u0011Z\u0001\nEJ|\u0017\rZ2bgR\u0004b!a3\u0002P\u0006MWBAAg\u0015\r\t9ML\u0005\u0005\u0003#\fiMA\u0005Ce>\fGmY1tiB!\u0011\u0011NAk\t\u001d\t9.\bb\u0001\u0003_\u0012\u0011\u0001V\u0001$e\u0016<\u0017n\u001d;feJ#Ei\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018MR8s\u00072,\u0017M\\;q+\u0011\ti.!>\u0015\r\u0005E\u0012q\\Av\u0011\u001d\tIF\ba\u0001\u0003C\u0004D!a9\u0002hB1\u0011qLA2\u0003K\u0004B!!\u001b\u0002h\u0012a\u0011\u0011^Ap\u0003\u0003\u0005\tQ!\u0001\u0002p\t\u0019q\fJ\u001c\t\u000f\u00055h\u00041\u0001\u0002p\u0006A\u0001/\u0019:f]RLE\rE\u00027\u0003cL1!a=8\u0005\rIe\u000e\u001e\u0003\b\u0003/t\"\u0019AA8\u0003I\u0011XmZ5ti\u0016\u0014hi\u001c:DY\u0016\fg.\u001e9\u0015\r\u0005E\u00121`A\u0000\u0011\u0019\tip\ba\u0001k\u0005\u0001rN\u00196fGR4uN]\"mK\u0006tW\u000f\u001d\u0005\b\u0005\u0003y\u0002\u0019\u0001B\u0002\u0003\u0011!\u0018m]6\u0011\u0007\u0011\u0013)!C\u0002\u0003\b9\u00121b\u00117fC:,\b\u000fV1tW\u0006a1.Z3q\u00072,\u0017M\\5oO\u0006aAm\\\"mK\u0006tW\u000f\u001d*E\tR1\u0011\u0011\u0007B\b\u0005'AqA!\u0005\"\u0001\u0004\ty/A\u0003sI\u0012LE\rC\u0004\u0003\u0016\u0005\u0002\r!a\b\u0002\u0011\tdwnY6j]\u001e\f\u0001\u0003Z8DY\u0016\fg.\u001e9TQV4g\r\\3\u0015\r\u0005E\"1\u0004B\u0010\u0011\u001d\u0011iB\ta\u0001\u0003_\f\u0011b\u001d5vM\u001adW-\u00133\t\u000f\tU!\u00051\u0001\u0002 \u0005\u0011Bm\\\"mK\u0006tW\u000f\u001d\"s_\u0006$7-Y:u)\u0019\t\tD!\n\u0003*!9!qE\u0012A\u0002\u0005M\u0011a\u00032s_\u0006$7-Y:u\u0013\u0012DqA!\u0006$\u0001\u0004\ty\"\u0001\be_\u000ecW-\u00198va\u0006\u001b7-^7\u0015\r\u0005E\"q\u0006B\u001a\u0011\u001d\u0011\t\u0004\na\u0001\u0003'\tQ!Y2d\u0013\u0012DqA!\u0006%\u0001\u0004\ty\"A\te_\u000ecW-\u00198DQ\u0016\u001c7\u000e]8j]R$B!!\r\u0003:!9!\u0011C\u0013A\u0002\u0005=\u0018\u0001\u00052s_\u0006$7-Y:u\u001b\u0006t\u0017mZ3s+\t\u0011y\u0004\u0005\u0003\u0002L\n\u0005\u0013\u0002\u0002B\"\u0003\u001b\u0014\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;NC:\fw-\u001a:\u0002-5\f\u0007oT;uaV$HK]1dW\u0016\u0014X*Y:uKJ,\"A!\u0013\u0011\u0007\u0011\u0013Y%C\u0002\u0003N9\u0012a#T1q\u001fV$\b/\u001e;Ue\u0006\u001c7.\u001a:NCN$XM]\u0001\u000f\u0007>tG/\u001a=u\u00072,\u0017M\\3s!\t!\u0015f\u0005\u0002*kQ\u0011!\u0011K\u0001\u0017%\u00163u,U+F+\u0016{\u0006k\u0014'M?RKU*R(V)V\u0011\u0011q^\u0001\u0018%\u00163u,U+F+\u0016{\u0006k\u0014'M?RKU*R(V)\u0002\u0002")
public class ContextCleaner
implements Logging {
    private final SparkContext sc;
    private final ShuffleDriverComponents shuffleDriverComponents;
    private final Set<CleanupTaskWeakReference> referenceBuffer;
    private final ReferenceQueue<Object> referenceQueue;
    private final ConcurrentLinkedQueue<CleanerListener> listeners;
    private final Thread cleaningThread;
    private final ScheduledExecutorService periodicGCService;
    private final long periodicGCInterval;
    private final boolean blockOnCleanupTasks;
    private final boolean blockOnShuffleCleanupTasks;
    private volatile boolean stopped;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Set<CleanupTaskWeakReference> referenceBuffer() {
        return this.referenceBuffer;
    }

    private ReferenceQueue<Object> referenceQueue() {
        return this.referenceQueue;
    }

    private ConcurrentLinkedQueue<CleanerListener> listeners() {
        return this.listeners;
    }

    private Thread cleaningThread() {
        return this.cleaningThread;
    }

    private ScheduledExecutorService periodicGCService() {
        return this.periodicGCService;
    }

    private long periodicGCInterval() {
        return this.periodicGCInterval;
    }

    private boolean blockOnCleanupTasks() {
        return this.blockOnCleanupTasks;
    }

    private boolean blockOnShuffleCleanupTasks() {
        return this.blockOnShuffleCleanupTasks;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public void attachListener(CleanerListener listener) {
        this.listeners().add(listener);
    }

    public void start() {
        this.cleaningThread().setDaemon(true);
        this.cleaningThread().setName("Spark Context Cleaner");
        this.cleaningThread().start();
        this.periodicGCService().scheduleAtFixedRate(() -> System.gc(), this.periodicGCInterval(), this.periodicGCInterval(), TimeUnit.SECONDS);
    }

    public void stop() {
        this.stopped_$eq(true);
        ContextCleaner contextCleaner = this;
        synchronized (contextCleaner) {
            this.cleaningThread().interrupt();
        }
        this.cleaningThread().join();
        this.periodicGCService().shutdown();
    }

    public void registerRDDForCleanup(RDD<?> rdd) {
        this.registerForCleanup(rdd, new CleanRDD(rdd.id()));
    }

    public void registerAccumulatorForCleanup(AccumulatorV2<?, ?> a) {
        this.registerForCleanup(a, new CleanAccum(a.id()));
    }

    public void registerShuffleForCleanup(ShuffleDependency<?, ?, ?> shuffleDependency) {
        this.registerForCleanup(shuffleDependency, new CleanShuffle(shuffleDependency.shuffleId()));
    }

    public <T> void registerBroadcastForCleanup(Broadcast<T> broadcast) {
        this.registerForCleanup(broadcast, new CleanBroadcast(broadcast.id()));
    }

    public <T> void registerRDDCheckpointDataForCleanup(RDD<?> rdd, int parentId) {
        this.registerForCleanup(rdd, new CleanCheckpoint(parentId));
    }

    private void registerForCleanup(Object objectForCleanup, CleanupTask task) {
        this.referenceBuffer().add(new CleanupTaskWeakReference(task, objectForCleanup, this.referenceQueue()));
    }

    public void org$apache$spark$ContextCleaner$$keepCleaning() {
        Utils$.MODULE$.tryOrStopSparkContext(this.sc, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (!this.stopped()) {
                try {
                    Option reference = Option$.MODULE$.apply(this.referenceQueue().remove(ContextCleaner$.MODULE$.org$apache$spark$ContextCleaner$$REF_QUEUE_POLL_TIMEOUT())).map((Function1 & Serializable & scala.Serializable)x$1 -> (CleanupTaskWeakReference)x$1);
                    ContextCleaner contextCleaner = this;
                    synchronized (contextCleaner) {
                        reference.foreach((Function1 & Serializable & scala.Serializable)ref -> {
                            ContextCleaner.$anonfun$keepCleaning$3(this, ref);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InterruptedException && this.stopped()) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (throwable2 instanceof Exception) {
                        Exception exception = (Exception)throwable2;
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error in cleaning thread", exception);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    throw throwable;
                }
            }
        });
    }

    public void doCleanupRDD(int rddId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Cleaning RDD ").append(rddId).toString());
            this.sc.unpersistRDD(rddId, blocking);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.rddCleaned(rddId);
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Cleaned RDD ").append(rddId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Error cleaning RDD ").append(rddId).toString(), e);
        }
    }

    public void doCleanupShuffle(int shuffleId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Cleaning shuffle ").append(shuffleId).toString());
            this.mapOutputTrackerMaster().unregisterShuffle(shuffleId);
            this.shuffleDriverComponents.removeShuffle(shuffleId, blocking);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.shuffleCleaned(shuffleId);
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Cleaned shuffle ").append(shuffleId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Error cleaning shuffle ").append(shuffleId).toString(), e);
        }
    }

    public void doCleanupBroadcast(long broadcastId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Cleaning broadcast ").append(broadcastId).toString());
            this.broadcastManager().unbroadcast(broadcastId, true, blocking);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.broadcastCleaned(broadcastId);
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Cleaned broadcast ").append(broadcastId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Error cleaning broadcast ").append(broadcastId).toString(), e);
        }
    }

    public void doCleanupAccum(long accId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Cleaning accumulator ").append(accId).toString());
            AccumulatorContext$.MODULE$.remove(accId);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.accumCleaned(accId);
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Cleaned accumulator ").append(accId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error cleaning accumulator ").append(accId).toString(), e);
        }
    }

    public void doCleanCheckpoint(int rddId) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Cleaning rdd checkpoint data ").append(rddId).toString());
            ReliableRDDCheckpointData$.MODULE$.cleanCheckpoint(this.sc, rddId);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.checkpointCleaned(rddId);
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Cleaned rdd checkpoint data ").append(rddId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error cleaning rdd checkpoint data ").append(rddId).toString(), e);
        }
    }

    private BroadcastManager broadcastManager() {
        return this.sc.env().broadcastManager();
    }

    private MapOutputTrackerMaster mapOutputTrackerMaster() {
        return (MapOutputTrackerMaster)this.sc.env().mapOutputTracker();
    }

    public static final /* synthetic */ void $anonfun$keepCleaning$3(ContextCleaner $this, CleanupTaskWeakReference ref) {
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Got cleaning task ").append(ref.task()).toString());
        $this.referenceBuffer().remove(ref);
        CleanupTask cleanupTask = ref.task();
        if (cleanupTask instanceof CleanRDD) {
            CleanRDD cleanRDD = (CleanRDD)cleanupTask;
            int rddId = cleanRDD.rddId();
            $this.doCleanupRDD(rddId, $this.blockOnCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanShuffle) {
            CleanShuffle cleanShuffle = (CleanShuffle)cleanupTask;
            int shuffleId = cleanShuffle.shuffleId();
            $this.doCleanupShuffle(shuffleId, $this.blockOnShuffleCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanBroadcast) {
            CleanBroadcast cleanBroadcast = (CleanBroadcast)cleanupTask;
            long broadcastId = cleanBroadcast.broadcastId();
            $this.doCleanupBroadcast(broadcastId, $this.blockOnCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanAccum) {
            CleanAccum cleanAccum = (CleanAccum)cleanupTask;
            long accId = cleanAccum.accId();
            $this.doCleanupAccum(accId, $this.blockOnCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanCheckpoint) {
            CleanCheckpoint cleanCheckpoint = (CleanCheckpoint)cleanupTask;
            int rddId = cleanCheckpoint.rddId();
            $this.doCleanCheckpoint(rddId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)cleanupTask);
        }
    }

    public ContextCleaner(SparkContext sc, ShuffleDriverComponents shuffleDriverComponents) {
        this.sc = sc;
        this.shuffleDriverComponents = shuffleDriverComponents;
        Logging.$init$(this);
        this.referenceBuffer = Collections.newSetFromMap(new ConcurrentHashMap());
        this.referenceQueue = new ReferenceQueue();
        this.listeners = new ConcurrentLinkedQueue();
        this.cleaningThread = new Thread(this){
            private final /* synthetic */ ContextCleaner $outer;

            public void run() {
                this.$outer.org$apache$spark$ContextCleaner$$keepCleaning();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.periodicGCService = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("context-cleaner-periodic-gc");
        this.periodicGCInterval = BoxesRunTime.unboxToLong((Object)sc.conf().get(package$.MODULE$.CLEANER_PERIODIC_GC_INTERVAL()));
        this.blockOnCleanupTasks = BoxesRunTime.unboxToBoolean((Object)sc.conf().get(package$.MODULE$.CLEANER_REFERENCE_TRACKING_BLOCKING()));
        this.blockOnShuffleCleanupTasks = BoxesRunTime.unboxToBoolean((Object)sc.conf().get(package$.MODULE$.CLEANER_REFERENCE_TRACKING_BLOCKING_SHUFFLE()));
        this.stopped = false;
    }
}

