/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.input;

import com.splunk.mr.input.BaseSplunkRecordReader;
import com.splunk.mr.input.SplunkRecordReader;
import com.splunk.mr.input.VixInputSplit;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SplunkRecordReaderWrapper
extends BaseSplunkRecordReader {
    private RecordReader rr;
    private SplunkRecordReader srr;
    protected Pattern _regex = null;
    protected Text _key = new Text();
    protected Text _val = new Text();

    public SplunkRecordReaderWrapper(RecordReader rr) {
        this.rr = rr;
        if (rr instanceof SplunkRecordReader) {
            this.srr = (SplunkRecordReader)rr;
        }
    }

    public void setFilePattern(Pattern regex) {
        this._regex = regex;
    }

    @Override
    public String getName() {
        return this.srr == null ? this.rr.getClass().getSimpleName() : this.srr.getName();
    }

    @Override
    public Pattern getFilePattern() {
        return this.srr == null ? this._regex : this.srr.getFilePattern();
    }

    @Override
    public void vixInitialize(VixInputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.srr != null) {
            this.srr.vixInitialize(split, context);
        } else {
            this.rr.initialize(split.getSplit(), context);
        }
    }

    @Override
    public String getOutputDataFormat() {
        return this.srr == null ? "" : this.srr.getOutputDataFormat();
    }

    @Override
    public void close() throws IOException {
        this.rr.close();
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.rr.getProgress();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.rr.nextKeyValue();
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        this._key.set(String.valueOf(this.rr.getCurrentKey()));
        return this._key;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        this._val.set(String.valueOf(this.rr.getCurrentValue()));
        return this._val;
    }
}

