/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr;

import com.splunk.fs.FSUtil;
import com.splunk.io.SearchOutputStream;
import com.splunk.mr.CommandHandler;
import com.splunk.mr.PrivilegedCommandHandlerAction;
import com.splunk.mr.SetupCommandHandler;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.RegexPathFilter;
import com.splunk.mr.packaging.CountingTempFileProvider;
import com.splunk.mr.packaging.IncrementFileCountWhenFileIsStale;
import com.splunk.mr.packaging.SynchronizedExecuter;
import com.splunk.util.AbstractComparator;
import com.splunk.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

public class BundleReplicationCommandHandler
implements CommandHandler {
    private static Logger gLogger = Logger.getLogger(BundleReplicationCommandHandler.class);
    private static Random RANDOM = new Random();
    public static String BUNDLE_SUFFIX = ".bundle";
    public static String INSTALLED_SUFFIX = ".installed";
    public static String DELETE_SUFFIX = ".delete";
    static final Pattern BUNDLE_DIR_PATTERN = Pattern.compile(".*\\-[0-9]{10}$");

    public static Path getHDFSBundleDir(Configuration conf) {
        return new Path(SplunkMR.getHDFSSplunkHome(conf), "bundles");
    }

    public static File getDNBundleHome(Configuration conf) {
        File splunk_home = SplunkMR.getDNSplunkHome(conf);
        return FileUtils.getFile((File)splunk_home, (String[])new String[]{"var", "run", "searchpeers"});
    }

    private static File getRandomDeleteName(File f) {
        return new File(f.getParentFile(), f.getName() + "." + RANDOM.nextInt(123456) + DELETE_SUFFIX);
    }

    public static String getDNBundlePath(Configuration conf) {
        String bundlePath = conf.get(SplunkMR.CONF_BUNDLE_PATH, null);
        if (bundlePath == null) {
            return "$SPLUNK_HOME/etc";
        }
        File bundleHome = BundleReplicationCommandHandler.getDNBundleHome(conf);
        String bundleFileName = new File(bundlePath).getName();
        return new File(bundleHome, BundleReplicationCommandHandler.getBundleDirName(bundleFileName)).getAbsolutePath().toString();
    }

    public static String getBundleDirName(String bundleName) {
        if (!bundleName.endsWith(BUNDLE_SUFFIX)) {
            throw new IllegalArgumentException("Invalid bundle name=" + bundleName + ", bundle name must end with suffix=" + BUNDLE_SUFFIX + ".");
        }
        return bundleName.substring(0, bundleName.length() - BUNDLE_SUFFIX.length());
    }

    @Override
    public void execute(Configuration conf, Map<String, Object> args, SearchOutputStream out) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        File localFile = null;
        localFile = args.containsKey(SplunkMR.CONF_BUNDLE_PATH) ? new File(args.get(SplunkMR.CONF_BUNDLE_PATH).toString()) : new File(conf.get(SplunkMR.CONF_BUNDLE_PATH));
        Path remoteDir = BundleReplicationCommandHandler.getHDFSBundleDir(conf);
        Path remoteFile = fs.makeQualified(new Path(remoteDir, localFile.getName()));
        SetupCommandHandler.copyLocalFileToHdfsWithFailureMessage(conf, localFile, remoteFile, out, "Bundle replication failed to copy bundles to HDFS.");
        String replication = conf.get(SplunkMR.CONF_BUNDLE_REPLICATION);
        if (replication != null) {
            fs.setReplication(remoteFile, Short.parseShort(replication));
        }
    }

    public static void handleSetupOnSearch(Configuration conf, Map<String, Object> args) throws IOException, InterruptedException {
        if (!StrUtil.parseBoolean(conf.get(SplunkMR.CONF_SETUP_ONSEARCH), false)) {
            return;
        }
        String bundlePath = conf.get(SplunkMR.CONF_BUNDLE_PATH);
        if (bundlePath == null || bundlePath.isEmpty()) {
            gLogger.info((Object)("Cannot do bundle replication without the following conf arg specified: " + SplunkMR.CONF_BUNDLE_PATH));
            return;
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path hdfsBundlesHome = BundleReplicationCommandHandler.getHDFSBundleDir(conf);
        File localBundle = new File(bundlePath);
        if (!localBundle.exists()) {
            throw new IOException(String.format("Local bundle path=%s, does not exist.", localBundle));
        }
        Path hdfsBundle = new Path(hdfsBundlesHome, localBundle.getName());
        if (fs.exists(hdfsBundle)) {
            return;
        }
        BundleReplicationCommandHandler bch = new BundleReplicationCommandHandler();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        SearchOutputStream out = new SearchOutputStream(buf);
        gLogger.info((Object)"running bundle setup ...");
        if (SplunkMR.useProxy(conf)) {
            UserGroupInformation realUser = UserGroupInformation.getCurrentUser().getRealUser();
            realUser.doAs((PrivilegedExceptionAction)new PrivilegedCommandHandlerAction(bch, conf, args, out));
            gLogger.info((Object)"running bundle setup ... done");
            realUser.doAs((PrivilegedExceptionAction)new PrivilegedCommandHandlerAction(conf, PrivilegedCommandHandlerAction.REAP_HDFS_BUNDLES));
        } else {
            bch.execute(conf, args, out);
            gLogger.info((Object)"running bundle setup ... done");
            BundleReplicationCommandHandler.reapHDFSBundles(conf);
        }
    }

    private static SynchronizedExecuter.AcquiredHandler<File> runBundleInstallOnAcquiredTempFile(final Configuration conf, final File bundlePath) {
        return new SynchronizedExecuter.AcquiredHandler<File>(){

            @Override
            public void onAcquired(File acquired) {
                try {
                    gLogger.info((Object)("Installing bundle, acquired=" + acquired.getName() + ", bundlePath=" + bundlePath));
                    BundleReplicationCommandHandler.dnBundleInstall(conf, acquired, bundlePath);
                }
                catch (Exception e) {
                    gLogger.warn((Object)("Got exception when installing bundle, acquired=" + acquired.getName() + ", bundlePath=" + bundlePath + ", ex=" + e));
                    FileUtils.deleteQuietly((File)acquired);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static void setupBundle(Configuration conf) throws IOException, InterruptedException {
        if (conf.get(SplunkMR.CONF_BUNDLE_PATH, null) == null) {
            return;
        }
        String bundleFileName = new File(conf.get(SplunkMR.CONF_BUNDLE_PATH)).getName();
        File bundleHome = BundleReplicationCommandHandler.getDNBundleHome(conf);
        File bundlePath = new File(bundleHome, bundleFileName);
        File bundleInstalled = new File(bundleHome, bundleFileName + INSTALLED_SUFFIX);
        int maxTempFiles = 5;
        int maxInactivityWaitInSecs = conf.getInt(SplunkMR.CONF_BUNDLE_MAX_INACTIVE_WAIT, 5);
        long bundleSetupTimeLimit = conf.getLong(SplunkMR.CONF_BUNDLE_SETUP_TIME_LIMIT, 20000L);
        long startTime = System.currentTimeMillis();
        long pollInterval = conf.getLong(SplunkMR.CONF_BUNDLE_POLL_INTERVAL, 100L);
        bundlePath.getParentFile().mkdirs();
        gLogger.info((Object)("Will download and install bundle from hdfs to " + bundleHome.getName()));
        CountingTempFileProvider tempBundleFileProvider = new CountingTempFileProvider(bundlePath, maxTempFiles, new IncrementFileCountWhenFileIsStale(maxInactivityWaitInSecs));
        SynchronizedExecuter.executeOnAcquired(tempBundleFileProvider, BundleReplicationCommandHandler.runBundleInstallOnAcquiredTempFile(conf, bundlePath), SynchronizedExecuter.ifInstalledExistsOrExceedsTimeLimit(bundleInstalled, bundleSetupTimeLimit, startTime), SynchronizedExecuter.createFileAtomically(), pollInterval);
        gLogger.info((Object)"Removing temporary bundle files");
        CountingTempFileProvider.reapAllProvidedFiles(bundlePath, maxTempFiles);
        if (!bundleInstalled.exists()) {
            throw new IOException("Timed out while waiting for bundle=" + bundlePath + " to be installed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dnBundleInstall(Configuration conf, File acquired, File bundlePath) throws IOException, InterruptedException {
        File bundleInstalled = new File(bundlePath.getParentFile(), bundlePath.getName() + INSTALLED_SUFFIX);
        if (bundleInstalled.exists()) {
            gLogger.info((Object)("bundle is already installed, bundle_install_file=" + bundleInstalled.getAbsolutePath()));
            return;
        }
        gLogger.info((Object)("attempt install of bundle=" + bundlePath + " using temp bundle file=" + acquired));
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path hdfsBundlesHome = BundleReplicationCommandHandler.getHDFSBundleDir(conf);
            Path remoteBundle = new Path(hdfsBundlesHome, bundlePath.getName());
            if (!fs.exists(remoteBundle)) {
                throw new IOException("Bundle does not exist in HDFS, path=" + remoteBundle.toUri() + ".");
            }
            gLogger.info((Object)("copying src=" + remoteBundle.toUri() + ", dst=" + acquired));
            FSUtil.verifiedCopy(fs, remoteBundle, acquired, false, conf);
            gLogger.info((Object)("installing bundle=" + acquired));
            File extractToDir = new File(acquired.getParent(), acquired.getName().replaceFirst(BUNDLE_SUFFIX, ""));
            extractToDir.mkdirs();
            gLogger.info((Object)("attempt to extract to dir=" + extractToDir));
            ProcessBuilder pb = new ProcessBuilder("tar", "-C", extractToDir.getName(), "-xf", acquired.toString());
            pb.directory(extractToDir.getParentFile());
            Process p = pb.start();
            int rv = p.waitFor();
            if (rv != 0) {
                throw new IOException("Failed to install bundle, rv=" + rv + ".");
            }
            File bundleDir = new File(bundlePath.getParent(), BundleReplicationCommandHandler.getBundleDirName(bundlePath.getName()));
            gLogger.info((Object)("rename temp bundle directory src" + extractToDir + " to dst=" + bundleDir));
            if (!extractToDir.renameTo(bundleDir) && bundleDir.exists()) {
                bundleDir.renameTo(BundleReplicationCommandHandler.getRandomDeleteName(bundleDir));
                if (!extractToDir.renameTo(bundleDir)) {
                    throw new IOException("Failed to rename src=" + extractToDir + " to dst=" + bundleDir + ".");
                }
            }
            bundleInstalled.createNewFile();
        }
        finally {
            FileUtils.deleteQuietly((File)acquired);
        }
        gLogger.info((Object)("finished copying and installing bundle=" + bundlePath));
        BundleReplicationCommandHandler.reapDNBundles(conf);
    }

    private static boolean deleteAll(File file) throws IOException {
        if (!file.exists()) {
            return true;
        }
        boolean deleted = true;
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                deleted = BundleReplicationCommandHandler.deleteAll(f) && deleted;
            }
        }
        return file.delete() && deleted;
    }

    public static void reapDNBundles(Configuration conf) throws IOException, InterruptedException {
        int maxBundles = 5;
        File bundleHome = BundleReplicationCommandHandler.getDNBundleHome(conf);
        if (!bundleHome.isDirectory()) {
            return;
        }
        gLogger.info((Object)("running bundle reaping in dir=" + bundleHome));
        File[] files = bundleHome.listFiles(new BundleDirFilter());
        if (files == null || files.length < maxBundles) {
            return;
        }
        Arrays.sort(files, new AbstractComparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long m2;
                long m1 = o1.lastModified();
                if (m1 < (m2 = o2.lastModified())) {
                    return 1;
                }
                if (m2 < m1) {
                    return -1;
                }
                return 0;
            }
        });
        gLogger.info((Object)("found bundle dir count=" + files.length));
        long reap_time = SplunkMR.getBundleReapTimelimit(conf);
        gLogger.debug((Object)("Setting the bundle reap timelimit to " + reap_time));
        for (int i = maxBundles - 1; i < files.length; ++i) {
            try {
                File f = files[i];
                gLogger.info((Object)("considering reap candidate dir=" + f));
                if (f.lastModified() < reap_time || f.getName().endsWith(DELETE_SUFFIX)) {
                    if (BundleReplicationCommandHandler.deleteAll(new File(f, "alive_tokens"))) {
                        File toDelete = f;
                        File installFile = null;
                        if (BUNDLE_DIR_PATTERN.matcher(f.getName()).matches()) {
                            installFile = new File(f.getParentFile(), f.getName() + BUNDLE_SUFFIX + INSTALLED_SUFFIX);
                            gLogger.info((Object)(f.getName() + " matches and install file is " + installFile.getName()));
                        }
                        if (installFile != null) {
                            toDelete = BundleReplicationCommandHandler.getRandomDeleteName(f);
                            if (!f.renameTo(toDelete)) {
                                throw new IOException("Could not rename bundle to tmp dir: src=" + f + ", dst=" + toDelete);
                            }
                            if (!installFile.delete()) {
                                throw new IOException("Could not delete file=" + installFile);
                            }
                        }
                        if (!BundleReplicationCommandHandler.deleteAll(toDelete)) {
                            throw new IOException("Could not delete bundle dir, path=" + toDelete);
                        }
                        gLogger.info((Object)("Deleted bundle, path=" + f));
                        continue;
                    }
                    gLogger.info((Object)("Could not cleanup alive_tokens, bundle dir is most likely still in use, path=" + f));
                    continue;
                }
                gLogger.info((Object)("reap candidate does not match modtime criteria, dir=" + f + ", mtime=" + f.lastModified()));
                continue;
            }
            catch (Exception ignore) {
                gLogger.error((Object)"deleting bundle directory failed", (Throwable)ignore);
            }
        }
    }

    public static void reapHDFSBundles(Configuration conf) throws IOException, InterruptedException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path hdfsBundlesHome = BundleReplicationCommandHandler.getHDFSBundleDir(conf);
        FileStatus[] bundles = fs.listStatus(hdfsBundlesHome, (PathFilter)new RegexPathFilter("\\.bundle$"));
        int maxBundles = SplunkMR.getHDFSBundleMaxLimit(conf);
        gLogger.debug((Object)("Setting the max bundle reap limit to " + maxBundles));
        if (bundles == null || bundles.length < maxBundles) {
            return;
        }
        Arrays.sort(bundles, new AbstractComparator<FileStatus>(){

            @Override
            public int compare(FileStatus o1, FileStatus o2) {
                long m2;
                long m1 = o1.getModificationTime();
                if (m1 < (m2 = o2.getModificationTime())) {
                    return 1;
                }
                if (m2 < m1) {
                    return -1;
                }
                return 0;
            }
        });
        for (int i = maxBundles - 1; i < bundles.length; ++i) {
            try {
                FileStatus f = bundles[i];
                fs.delete(f.getPath(), false);
                gLogger.info((Object)("Deleted HDFS bundle=" + f.getPath()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BundleReplicationCommandHandler.reapHDFSTmpBundles(conf);
    }

    public static void reapHDFSTmpBundles(Configuration conf) throws IOException, InterruptedException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path hdfsBundlesHome = BundleReplicationCommandHandler.getHDFSBundleDir(conf);
        FileStatus[] bundles = fs.listStatus(hdfsBundlesHome, (PathFilter)new RegexPathFilter("\\.tmp$"));
        gLogger.info((Object)"Removing Temp Bundle files in hdfs bundle directory");
        Long yestedaytimeinmillis = System.currentTimeMillis() - 86400000L;
        for (int i = 0; i < bundles.length; ++i) {
            try {
                FileStatus f = bundles[i];
                long filemodtime = f.getModificationTime();
                if (filemodtime >= yestedaytimeinmillis) continue;
                fs.delete(f.getPath(), false);
                gLogger.info((Object)("Deleted HDFS Temp bundle=" + f.getPath()));
                continue;
            }
            catch (Exception ignore) {
                gLogger.error((Object)"Error while deleting hdfs temp file");
                gLogger.error((Object)ignore.getMessage(), (Throwable)ignore);
            }
        }
    }

    private static class BundleDirFilter
    implements FileFilter {
        private BundleDirFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

