/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.fs;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Logger;

public class FSUtil {
    private static Logger gLogger = Logger.getLogger(FSUtil.class);

    private static Path checkDest(String srcName, FileSystem dstFS, Path dst, boolean overwrite) throws IOException {
        if (dstFS.exists(dst)) {
            FileStatus sdst = dstFS.getFileStatus(dst);
            if (sdst.isDir()) {
                if (null == srcName) {
                    throw new IOException("Target " + dst + " is a directory");
                }
                return FSUtil.checkDest(null, dstFS, new Path(dst, srcName), overwrite);
            }
            if (!overwrite) {
                throw new IOException("Target " + dst + " already exists");
            }
        }
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, FileSystem dstFS, Path dst, Configuration conf, boolean silent) throws IOException {
        block13: {
            block15: {
                block14: {
                    try {
                        dst = FSUtil.checkDest(src.getName(), dstFS, dst, false);
                    }
                    catch (IOException ex) {
                        if (!silent) {
                            throw ex;
                        }
                        return;
                    }
                    if (!src.isDirectory()) break block14;
                    if (!dstFS.mkdirs(dst)) {
                        if (!silent) {
                            throw new IOException("Failed to create dir: " + dst.makeQualified(dstFS));
                        }
                        return;
                    }
                    for (File f : src.listFiles()) {
                        FSUtil.copy(f, dstFS, new Path(dst, f.getName()), conf, silent);
                    }
                    break block13;
                }
                if (!src.isFile()) break block15;
                FileInputStream in = null;
                FSDataOutputStream out = null;
                try {
                    in = new FileInputStream(src);
                    out = dstFS.create(dst);
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf);
                    IOUtils.closeStream((Closeable)out);
                }
                catch (IOException e) {
                    if (!silent) {
                        throw e;
                    }
                    break block13;
                }
                finally {
                    IOUtils.closeStream(out);
                    IOUtils.closeStream((Closeable)in);
                }
                IOUtils.closeStream((Closeable)in);
                break block13;
            }
            if (!silent) {
                throw new IOException(src.toString() + ": No such file or directory");
            }
        }
    }

    public static void verifiedCopy(FileSystem srcFs, Path src, File dst, boolean deleteSource, Configuration conf) throws IOException {
        FileUtil.copy((FileSystem)srcFs, (Path)src, (File)dst, (boolean)deleteSource, (Configuration)conf);
        try {
            FSUtil.verify(srcFs, src, dst);
        }
        catch (IOException e) {
            gLogger.warn((Object)("Retrying copy from src=" + src.toString() + " to dst=" + dst.getPath()));
            FileUtil.copy((FileSystem)srcFs, (Path)src, (File)dst, (boolean)deleteSource, (Configuration)conf);
            FSUtil.verify(srcFs, src, dst);
        }
    }

    public static void verify(FileSystem srcFs, Path remote, File local) throws IOException {
        FileStatus fstat = srcFs.getFileStatus(remote);
        if (fstat.getLen() != local.length()) {
            throw new IOException("File sizes differ, remote=" + remote.toString() + ", local=" + local.getPath());
        }
    }

    public static MatchResult checkSumsMatch(FileSystem fs, Path file1, Path file2) throws IOException {
        Path qpath1 = fs.makeQualified(file1);
        FileChecksum chksum1 = fs.getFileChecksum(qpath1);
        if (chksum1 == null) {
            gLogger.debug((Object)"File checksum is null, No checksum algorithm is implemented for this FileSystem");
            return MatchResult.NO_CHECKSUM;
        }
        Path qpath2 = fs.makeQualified(file2);
        FileChecksum chksum2 = fs.getFileChecksum(qpath2);
        if (chksum1 == chksum2) {
            return MatchResult.TRUE;
        }
        return MatchResult.FALSE;
    }

    public static enum MatchResult {
        TRUE,
        FALSE,
        NO_CHECKSUM;

    }
}

