/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SupportedProductConfig
implements Serializable,
Cloneable {
    private String name;
    private ListWithAutoConstructFlag<String> args;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SupportedProductConfig withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getArgs() {
        if (this.args == null) {
            this.args = new ListWithAutoConstructFlag();
            this.args.setAutoConstruct(true);
        }
        return this.args;
    }

    public void setArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
            return;
        }
        ListWithAutoConstructFlag argsCopy = new ListWithAutoConstructFlag(args.size());
        argsCopy.addAll(args);
        this.args = argsCopy;
    }

    public SupportedProductConfig withArgs(String ... args) {
        if (this.getArgs() == null) {
            this.setArgs(new ArrayList<String>(args.length));
        }
        for (String value : args) {
            this.getArgs().add(value);
        }
        return this;
    }

    public SupportedProductConfig withArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
        } else {
            ListWithAutoConstructFlag argsCopy = new ListWithAutoConstructFlag(args.size());
            argsCopy.addAll(args);
            this.args = argsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getArgs() != null) {
            sb.append("Args: " + this.getArgs());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArgs() == null ? 0 : this.getArgs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedProductConfig)) {
            return false;
        }
        SupportedProductConfig other = (SupportedProductConfig)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArgs() == null ^ this.getArgs() == null) {
            return false;
        }
        return other.getArgs() == null || other.getArgs().equals(this.getArgs());
    }

    public SupportedProductConfig clone() {
        try {
            return (SupportedProductConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

