/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProjectionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class GlobalSecondaryIndexJsonMarshaller {
    private static GlobalSecondaryIndexJsonMarshaller instance;

    public void marshall(GlobalSecondaryIndex globalSecondaryIndex, JSONWriter jsonWriter) {
        if (globalSecondaryIndex == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<KeySchemaElement> keySchemaList;
            jsonWriter.object();
            if (globalSecondaryIndex.getIndexName() != null) {
                jsonWriter.key("IndexName").value(globalSecondaryIndex.getIndexName());
            }
            if ((keySchemaList = globalSecondaryIndex.getKeySchema()) != null) {
                jsonWriter.key("KeySchema");
                jsonWriter.array();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (globalSecondaryIndex.getProjection() != null) {
                jsonWriter.key("Projection");
                ProjectionJsonMarshaller.getInstance().marshall(globalSecondaryIndex.getProjection(), jsonWriter);
            }
            if (globalSecondaryIndex.getProvisionedThroughput() != null) {
                jsonWriter.key("ProvisionedThroughput");
                ProvisionedThroughputJsonMarshaller.getInstance().marshall(globalSecondaryIndex.getProvisionedThroughput(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GlobalSecondaryIndexJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GlobalSecondaryIndexJsonMarshaller();
        }
        return instance;
    }
}

