/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LazySeq<T>
implements Iterable<T> {
    private final LinkedList<T> seq;
    private final Generator<T> generator;
    private T head;
    private boolean inited = false;

    public LazySeq(Generator<T> generator) {
        this.generator = generator;
        this.seq = new LinkedList();
        this.head = null;
    }

    public T getHead() {
        if (!this.inited) {
            this.hasMoreUnchecked();
        }
        return this.head;
    }

    public boolean hasMore() throws IOException {
        List<T> generated;
        this.inited = true;
        if (this.seq.isEmpty() && (generated = this.generator.generate()) != null && !generated.isEmpty()) {
            this.seq.addAll(generated);
        }
        this.head = !this.seq.isEmpty() ? this.seq.removeFirst() : null;
        return this.head != null;
    }

    public boolean hasMoreUnchecked() {
        try {
            return this.hasMore();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            boolean shouldFindNext = true;

            @Override
            public boolean hasNext() {
                this.ensureNext();
                return LazySeq.this.getHead() != null;
            }

            private void ensureNext() {
                try {
                    if (this.shouldFindNext) {
                        LazySeq.this.hasMore();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.shouldFindNext = false;
                }
            }

            @Override
            public T next() {
                this.ensureNext();
                Object next = LazySeq.this.getHead();
                this.shouldFindNext = true;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class Once<T>
    extends LazySeq<T> {
        public Once(final List<T> ts) {
            super(new GenerateOnce<T>(){

                @Override
                protected List<T> generateOnce() throws IOException {
                    return ts;
                }
            });
        }
    }

    public static abstract class GenerateOnce<T>
    implements Generator<T> {
        private boolean generated = false;

        @Override
        public List<T> generate() throws IOException {
            try {
                if (!this.generated) {
                    List<T> list = this.generateOnce();
                    return list;
                }
                List list = Collections.emptyList();
                return list;
            }
            finally {
                this.generated = true;
            }
        }

        protected abstract List<T> generateOnce() throws IOException;
    }

    public static interface Generator<T> {
        public List<T> generate() throws IOException;
    }
}

