/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.RollReceipt;
import com.splunk.roll.RollTransfer;
import com.splunk.roll.Transactor;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class RollValidator {
    private static final Logger gLogger = Logger.getLogger(RollValidator.class);
    public static final String VALIDATED_FILENAME = "archive.valid";
    private final Configuration conf;
    private final RollReceipt rollReceipt;

    public RollValidator(Configuration conf, RollReceipt rollReceipt) {
        this.conf = conf;
        this.rollReceipt = rollReceipt;
    }

    public void writeReceipt(Path remoteBucketPath, List<RollTransfer> transferredPaths) throws IOException {
        this.rollReceipt.writeReceipt(remoteBucketPath, this.rollReceipt.createReceipt(remoteBucketPath, transferredPaths));
    }

    public boolean isRollValid(Path remoteBucketPath, boolean deleteInvalidReceipts) throws IOException {
        Path validationFile;
        FileSystem fs = remoteBucketPath.getFileSystem(this.conf);
        if (fs.exists(validationFile = new Path(remoteBucketPath, VALIDATED_FILENAME))) {
            return true;
        }
        this.removeEventualTransactionGarbage(remoteBucketPath);
        if (this.rollReceipt.validatePath(remoteBucketPath, deleteInvalidReceipts)) {
            boolean created = false;
            try {
                created = fs.createNewFile(validationFile);
            }
            catch (IOException ex) {
                if (fs.exists(validationFile)) {
                    gLogger.info((Object)"Validation file created simultaneously by other archiving process.");
                    return true;
                }
                throw ex;
            }
            if (!created) {
                gLogger.warn((Object)"Could not create validation file. Archive still valid, since it passed validation. Hopefully the validation is either created or will be created at some other point in time.");
            }
            return true;
        }
        gLogger.info((Object)("Path had data, but validation of the receipt failed. remote_path=" + remoteBucketPath));
        return false;
    }

    private void removeEventualTransactionGarbage(Path remoteBucketPath) throws IOException {
        for (FileStatus f : Transactor.listRemoteTempFilesIn(remoteBucketPath, this.conf)) {
            Path path = f.getPath();
            gLogger.info((Object)("Found garbage in remote bucket path. Removing path=" + path));
            try {
                path.getFileSystem(this.conf).delete(path, true);
            }
            catch (IOException e) {
                gLogger.warn((Object)("Exception when deleting transaction garbage. Ignoring. exception=" + e + " transaction_garbage_path=" + path + " remote_bucket_path=" + remoteBucketPath));
            }
        }
    }

    public static RollValidator create(Configuration conf) {
        return new RollValidator(conf, new RollReceipt(conf));
    }
}

