/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.merge;

import com.splunk.mr.cache.CacheIndexer;
import com.splunk.mr.cache.CacheMerger;
import com.splunk.mr.cache.CacheReference;
import com.splunk.mr.cache.CompactionMetadata;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.log4j.Logger;

public class Merger {
    private static final Logger gLogger = Logger.getLogger(Merger.class);
    private final FileSystem fs;
    private final CacheReference cacheReference;
    private final Path compactionDir;
    private final CacheReference.CacheUpdate.PathType pathType;

    public Merger(FileSystem fs, CacheReference cacheReference, Path resultDir, CacheReference.CacheUpdate.PathType pathType) {
        this.fs = fs;
        this.cacheReference = cacheReference;
        this.compactionDir = resultDir;
        this.pathType = pathType;
    }

    public boolean merge(Set<CacheMerger.Mergee> merge) throws IOException {
        try {
            this.doMerge(new ArrayList<CacheMerger.Mergee>(merge));
            return true;
        }
        catch (Exception e) {
            gLogger.debug((Object)("Exception when merging compactions: " + e));
            if (this.compactionDir != null) {
                this.fs.delete(this.compactionDir, true);
            }
            return false;
        }
    }

    private void doMerge(List<CacheMerger.Mergee> merge) throws IOException {
        if (this.pathType.equals((Object)CacheReference.CacheUpdate.PathType.DELETE)) {
            HashMap<CacheMerger.Mergee, Long> mergeOffsets = new HashMap<CacheMerger.Mergee, Long>();
            for (CacheMerger.Mergee m : merge) {
                mergeOffsets.put(m, 0L);
            }
            this.updateCacheReference(mergeOffsets);
        } else {
            Map<CacheMerger.Mergee, Long> mergeOffsets = this.mergeDataFiles(merge);
            this.writeMetadata(merge);
            this.updateCacheReference(mergeOffsets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CacheMerger.Mergee, Long> mergeDataFiles(List<CacheMerger.Mergee> merge) throws IOException {
        gLogger.debug((Object)("Merging paths: " + merge.size()));
        HashMap<CacheMerger.Mergee, Long> mergeOffsets = new HashMap<CacheMerger.Mergee, Long>();
        Path resultFile = CacheIndexer.getResultFile(this.compactionDir);
        Path resultPointersFile = CacheIndexer.getResultPointersFile(this.compactionDir);
        SequenceFile.Writer pointersOut = null;
        FSDataOutputStream resultsOut = null;
        try {
            pointersOut = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.fs.getConf(), (Path)resultPointersFile, CacheIndexer.KEY_CLASS, CacheIndexer.VALUE_CLASS);
            resultsOut = this.fs.create(resultFile, true);
            this.writeMergeesFilesToThisCompaction(merge, mergeOffsets, resultsOut, pointersOut);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pointersOut);
            IOUtils.closeQuietly(resultsOut);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)pointersOut);
        IOUtils.closeQuietly((OutputStream)resultsOut);
        Logger.getLogger(this.getClass()).info((Object)("merged to: " + resultFile));
        return mergeOffsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMergeesFilesToThisCompaction(List<CacheMerger.Mergee> merge, Map<CacheMerger.Mergee, Long> mergeOffsets, FSDataOutputStream resultsOut, SequenceFile.Writer pointerOut) throws IOException {
        long offset = 0L;
        for (CacheMerger.Mergee m : merge) {
            mergeOffsets.put(m, offset);
            SequenceFile.Reader pointerIn = null;
            FSDataInputStream resultsIn = null;
            try {
                pointerIn = new SequenceFile.Reader(this.fs, CacheIndexer.getResultPointersFile(m.path), this.fs.getConf());
                resultsIn = this.fs.open(CacheIndexer.getResultFile(m.path));
                long bytesWritten = this.copyResultsAndPointers(resultsOut, pointerOut, offset, pointerIn, resultsIn);
                offset += bytesWritten;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pointerIn);
                IOUtils.closeQuietly(resultsIn);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)pointerIn);
            IOUtils.closeQuietly((InputStream)resultsIn);
        }
    }

    private long copyResultsAndPointers(FSDataOutputStream resultsOut, SequenceFile.Writer pointerOut, long offset, SequenceFile.Reader pointerIn, FSDataInputStream resultsIn) throws IOException {
        MD5Hash key = (MD5Hash)ReflectionUtils.newInstance(CacheIndexer.KEY_CLASS, (Configuration)this.fs.getConf());
        TreeMap<MD5Hash, CacheIndexer.ResultPointer> values = new TreeMap<MD5Hash, CacheIndexer.ResultPointer>();
        while (pointerIn.next((Writable)key)) {
            MD5Hash hash = new MD5Hash();
            CacheIndexer.ResultPointer resultPointer = new CacheIndexer.ResultPointer();
            hash.set(key);
            pointerIn.getCurrentValue((Writable)resultPointer);
            values.put(hash, resultPointer);
        }
        for (Map.Entry e : values.entrySet()) {
            pointerOut.append((Writable)e.getKey(), (Writable)((CacheIndexer.ResultPointer)e.getValue()).withOffset(offset));
        }
        return IOUtils.copyLarge((InputStream)resultsIn, (OutputStream)resultsOut);
    }

    private void writeMetadata(List<CacheMerger.Mergee> merge) throws IOException {
        CompactionMetadata ret = new CompactionMetadata.Zero();
        for (CacheMerger.Mergee m : merge) {
            ret = ret.mergeWith(CompactionMetadata.getMetadata(this.fs, m.path));
        }
        CompactionMetadata.writeCompactionMetadata(this.fs, this.compactionDir, ret);
    }

    private void updateCacheReference(final Map<CacheMerger.Mergee, Long> mergeOffsets) throws IOException {
        this.cacheReference.update(new CacheReference.CacheUpdate(){

            @Override
            public Map.Entry<CacheReference.CacheUpdate.PathType, String> getAddedPath() {
                if (Merger.this.pathType.equals((Object)CacheReference.CacheUpdate.PathType.DELETE)) {
                    return this.toEntry(Merger.this.pathType, "deleted");
                }
                return this.toEntry(Merger.this.pathType, Merger.this.compactionDir.toUri().getPath());
            }

            @Override
            public Map<String, Long> getMergedPaths() {
                HashMap<String, Long> offsets = new HashMap<String, Long>();
                for (Map.Entry m : mergeOffsets.entrySet()) {
                    offsets.put(((CacheMerger.Mergee)m.getKey()).path.toUri().getPath(), (Long)m.getValue());
                }
                return offsets;
            }
        });
    }
}

