/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.mr.cache.CacheIndexer;
import com.splunk.mr.cache.CacheReference;
import com.splunk.mr.cache.PathAndPointer;
import com.splunk.mr.cache.reader.CachePathsReader;
import com.splunk.mr.cache.reader.GetsTransitionedPath;
import com.splunk.util.Lazy;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MD5Hash;

public class CacheIndex {
    private CachePathsReader cachePathsReader;
    private FileSystem fs;
    private GetsTransitionedPath getsTransitionedPath;

    private CacheIndex(CachePathsReader cachePathsReader, FileSystem fs, GetsTransitionedPath getsTransitionedPath) {
        this.cachePathsReader = cachePathsReader;
        this.fs = fs;
        this.getsTransitionedPath = getsTransitionedPath;
    }

    public Lazy<InputStream> getResult(final MD5Hash hash) throws IOException {
        if (!this.cachePathsReader.readCachePaths().containsKey(hash)) {
            return null;
        }
        return new Lazy<InputStream>(){

            @Override
            public InputStream get() throws IOException {
                Path thePath;
                PathAndPointer pnp = CacheIndex.this.cachePathsReader.readCachePaths().get(hash);
                Path pnpPath = pnp.getPath();
                long theOffset = pnp.pointer.getOffset();
                if (CacheIndex.this.fs.exists(pnpPath)) {
                    thePath = pnpPath;
                } else {
                    GetsTransitionedPath.Transition t = CacheIndex.this.getsTransitionedPath.getTransition(pnpPath);
                    thePath = t.getPath();
                    theOffset += t.getOffset();
                }
                FSDataInputStream open = CacheIndex.this.fs.open(CacheIndexer.getResultFile(thePath));
                open.seek(theOffset);
                return new BoundedInputStream((InputStream)open, pnp.pointer.getLength());
            }
        };
    }

    public static CacheIndex create(FileSystem fs, CacheReference cacheRef, CachePathsReader cachePathsReader) {
        return new CacheIndex(cachePathsReader, fs, new GetsTransitionedPath(cacheRef));
    }
}

